% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_stats.R
\name{ss_stat}
\alias{ss_stat}
\title{Sum-sum (SS) test statistic to identify dragon kings (DKs)}
\usage{
ss_stat(vals, r)
}
\arguments{
\item{vals}{numeric vector with at least 3 elements}

\item{r}{integer indicating number of DKs in \code{vals}}
}
\value{
SS test statistic
}
\description{
\code{ss_stat} calculates the SS test statistic to determine whether
there is significant support for the existence of \code{r} DKs in
\code{vals}. This test is susceptible to swamping.
}
\examples{
# generate a numeric vector with DKs
temp <- c(rexp(100),   # exponentially distributed RV
          15, 15, 15)  # DK elements

# calculate test statistic for DKs
ss_stat(temp, r = 3)
}
\references{
Wheatley S, Sornette D (2015). Multiple outlier detection in samples with exponential & pareto tails: Redeeming the inward approach & detecting dragon kings. Swiss Finance Institute Research Paper Series No. 15-28. <doi:10.2139/ssrn.2645709>

Balakrishnan K (1996). Exponential distribution: Theory, methods and applications. \emph{CRC Press}. pp. 228-30. ISBN: 9782884491921

Chikkagoudar MS, Kunchur SH (1983). Distributions of test statistics for multiple outliers in exponential samples. \emph{Commun Stat Theory Methods}, \strong{12}: 2127-42. <doi:10.1080/03610928308828596>

Lewis T, Fieller NRJ (1979). A recursive algorithm for null distributions for outliers: I gamma samples. \emph{Technometrics}, \strong{21}(3): 371-6. <doi:10.2307/1267762>
}
