% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verb-flip.R, R/verb-invert.R,
%   R/verb-multiply.R, R/verb-shift.R
\name{flip}
\alias{flip}
\alias{invert}
\alias{multiply}
\alias{shift}
\title{Linear and Reciprocal Transformations}
\usage{
flip(distribution)

invert(distribution)

multiply(distribution, constant)

shift(distribution, constant)
}
\arguments{
\item{distribution}{A probability distribution.}

\item{constant}{A numeric value for shifting or scaling.}
}
\value{
A transformed distribution.
}
\description{
Transform distributions using location shifts, scaling, negation, and
reciprocals. If \code{X} is a random variable following a distribution, these
functions return the distribution of the transformed variable.
}
\section{Functions vs Operators}{

These transformations can be applied using named functions or arithmetic
operators:
\itemize{
\item \code{shift(d, a)} or \code{d + a} - Returns distribution of \code{X + a}
\item \code{multiply(d, a)} or \code{d * a} - Returns distribution of \code{X * a}
\item \code{flip(d)} or \code{-d} - Returns distribution of \code{-X}
\item \code{invert(d)} or \code{1 / d} - Returns distribution of \code{1 / X}
}

For complete documentation of operator usage, see \code{\link[=Ops.dst]{Ops.dst()}}.
}

\section{Special Cases}{

\strong{Negation in multiplication}: When \code{multiply()} receives a negative
constant, it internally calls \code{flip()} on the result of multiplying by
the absolute value.

\strong{Inversion constraint}: \code{invert()} requires that the distribution has no
mass at zero (i.e., \code{P(X = 0) = 0}). An error is returned if this
condition is violated.
}

\section{Simplifications}{

These functions apply automatic simplifications when possible. For example:
\itemize{
\item Shifting a Normal distribution returns another Normal distribution
\item Multiplying a Uniform distribution returns another Uniform distribution
\item Flipping a symmetric distribution may preserve its form
}

More simplifications will be added in future versions of distplyr.
}

\examples{
d_pois <- distionary::dst_pois(1.1)
d_norm <- distionary::dst_norm(4, 1)
d_unif <- distionary::dst_unif(0, 1)

# Shifting
shift(d_pois, 1)
d_pois + 1           # Equivalent using operator

# Scaling
multiply(d_unif, 2)
d_unif * 2           # Equivalent using operator

# Negation
flip(d_norm)
-d_norm              # Equivalent using operator

# Inversion
d_positive <- distionary::dst_unif(1, 2)
invert(d_positive)
1 / d_positive       # Equivalent using operator

# Combine multiple operations
4 - 2 * d_pois
multiply(flip(multiply(d_pois, 2)), -1) + 4  # Equivalent

}
\seealso{
\code{\link[=Ops.dst]{Ops.dst()}} for arithmetic operators including \code{+}, \code{-}, \code{*}, \code{/}.
}
