% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/with_config.R
\name{with_config}
\alias{with_config}
\title{Run code using a temporary config file.}
\usage{
with_config(
  config_yml,
  code,
  .active_config = c(R_CONFIG_ACTIVE = "default"),
  .extra_env_vars = NULL
)
}
\arguments{
\item{config_yml}{Either the path to a config file, or a character string
representing a yaml configuration.}

\item{code}{Code to execute in a temporary environment.}

\item{.active_config}{Either a string representing a configuration, e.g.
\code{default}, or a named character representing an environment variable, e.g.
\code{c(R_CONFIG_ACTIVE = "default")}.}

\item{.extra_env_vars}{Additional environment variables to set.}
}
\value{
The result of running the \code{code}, after having temporarily set the
necessary environment variables.
}
\description{
This function takes inspiration from \code{\link[withr:with_envvar]{withr::with_envvar()}} and may be useful
for testing purposes.
}
\examples{

yaml <- '
default:
  db_name: dbase
  databases:
    db1: !expr paste0(db_name, "/one")
    db2: !expr paste0(db_name, "/two")

staging:
  staging_postfix: _staging
  db_name: dbase
  databases:
    db1: !expr paste0(db_name, staging_postfix, "/one")
    db2: !expr paste0(db_name, staging_postfix, "/two")
'

# Ensure that base::get() doesn't get masked, for tests on CRAN
get <- base::get

with_config(yaml, config::get() )
with_config(yaml, config::get("databases", config = "default") )
with_config(yaml, config::get("databases", config = "staging") )

config_file <- system.file("tests/testthat/config.yml", package = "config")
if (file.exists(config_file)) {
  with_config(config_file, config::get())
}
}
