% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ComputePermutation.R
\name{CORmat2vecPermu}
\alias{CORmat2vecPermu}
\title{Permuted Correlation Between Matrix and Vector}
\usage{
CORmat2vecPermu(
  mat,
  vec,
  cor_type = "pearson",
  bulkIdx = 0,
  permutationTimes = 1000,
  seedNum = 99999999
)
}
\arguments{
\item{mat}{A numeric matrix. For example, each row represents a gene and each column represents a sample.}

\item{vec}{A numeric vector, with length equal to the number of columns in `mat`.}

\item{cor_type}{Type of correlation to calculate: "Pearson", "Kendall", or "Spearman". Default is "Pearson".}

\item{bulkIdx}{Index to divide the task when processing many permutations. Default is 0.}

\item{permutationTimes}{Number of permutations for sampling. Default is 1000.}

\item{seedNum}{Seed for random number generation. Default is 99999999.}
}
\value{
A numeric vector of correlation values for each permutation.
}
\description{
Computes the correlation between a randomly sampled vector from a matrix and a given vector.
The sampling is done multiple times to generate a distribution.
}
\examples{
mat <- matrix(rnorm(10000), nrow = 100, ncol = 100)
vec <- rnorm(100)
CORmat2vecPermu(mat, vec)

}
