% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cli_table.R
\name{cli_table}
\alias{cli_table}
\title{generates a text table}
\usage{
cli_table(
  mat,
  header = TRUE,
  header_style = NULL,
  border_style = "single",
  heatmap_columns = NULL,
  heatmap_colorspace = c("green", "red"),
  hilite_rows = NULL,
  hilite_style = "bgRed",
  NA_style = NULL,
  ...
)
}
\arguments{
\item{mat}{the table content to print, can be a data.frame or a matrix}

\item{header}{whether to use the row names as  table headers}

\item{header_style}{the (crayon) style to use to print the headers (cf \code{\link[crayon:style]{crayon::style()}}}

\item{border_style}{the style to use for the table borders, one of single, double, single-double, double-single, classic}

\item{heatmap_columns}{the columns that should be displayed as heatmaps, as a vector of column indices, names
or logicals}

\item{heatmap_colorspace}{the colorspace to use for the heatmaps, to be passed to \code{\link[grDevices:colorRamp]{grDevices::colorRamp()}}}

\item{hilite_rows}{the rows to highlight, as a vector of column indices, names or logicals}

\item{hilite_style}{the (crayon) style to use to highlight the rows (cf \code{\link[crayon:style]{crayon::style()}}}

\item{NA_style}{the (crayon) style to use to highlight the NA values (cf \code{\link[crayon:style]{crayon::style()}}}

\item{...}{
  Arguments passed on to \code{\link[=scale_numeric]{scale_numeric}}
  \describe{
    \item{\code{x}}{the numeric vector to scale}
    \item{\code{xmin}}{the minimum value used for the scaling. all all x < xmin are set to 0}
    \item{\code{xmax}}{the maximum value used for the scaling. all x > xmax set to 1}
  }}
}
\value{
the lines of the text table as an ansi_string vector
}
\description{
generates a text table
}
\examples{
  df <- head(datasets::penguins, 20)
  ct <- cli_table(df, header_style = "bold",
    NA_style = "strikethrough",
    heatmap_columns = list("flipper_len"), xmin = 180, xmax = 200,
    hilite_rows = !is.na(df$sex) & df$sex == "female" & df$bill_dep >= 19, 
    hilite_style = "bgGreen"
  )
  cat(ct, sep = "\n")
}
