% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interactions.R
\name{interaction_plot}
\alias{interaction_plot}
\title{Plot interactions}
\usage{
interaction_plot(
  data,
  y,
  predictor,
  group_var,
  time = NULL,
  time2 = NULL,
  covars = NULL,
  cluster = NULL,
  group_colors = NULL,
  save_plot = FALSE,
  filename = NULL,
  height = 4,
  width = 4,
  xlab = predictor,
  ylab = NULL,
  show_n = TRUE,
  group_title = group_var,
  ...
)
}
\arguments{
\item{data}{A data frame.}

\item{y}{A character string of the outcome variable.}

\item{predictor}{A character string of the predictor variable.}

\item{group_var}{A character string of the group variable. The variable should be categorical. If a
numeric variable is provided, it will be split by the median value.}

\item{time}{A character string of the time variable. If \code{NULL}, logistic regression is used.
Otherwise, Cox proportional hazards regression is used.}

\item{time2}{A character string of the ending time of the interval for interval censored or counting process
data only.}

\item{covars}{A character vector of covariate names.}

\item{cluster}{A character string of the cluster variable. If set, correct for heteroscedasticity and for
correlated responses from cluster samples using \code{rms::robcov()}.}

\item{group_colors}{A character vector of colors for the plot. If \code{NULL}, the default colors are used.}

\item{save_plot}{A logical value indicating whether to save the plot.}

\item{filename}{The name of the file to save the plot. Support both \code{.png} and \code{.pdf} formats.}

\item{height}{The height of the saved plot.}

\item{width}{The width of the saved plot.}

\item{xlab}{The label of the x-axis.}

\item{ylab}{The label of the y-axis.}

\item{show_n}{A logical value indicating whether to show the number of observations in the plot.}

\item{group_title}{The title of the group variable.}

\item{...}{Additional arguments passed to the \code{ggplot} function.}
}
\value{
A \code{ggplot} object.
}
\description{
Plot interactions between variables. Both logistic and Cox proportional hazards regression models
are supported. The predictor variables in the model are can be used both in linear form or in restricted cubic
spline form.
}
\examples{
data(cancer, package = "survival")
interaction_plot(cancer,
  y = "status", time = "time", predictor = "age", group_var = "sex",
  save_plot = FALSE
)
interaction_plot(cancer,
  y = "status", predictor = "age", group_var = "sex",
  save_plot = FALSE
)
interaction_plot(cancer,
  y = "wt.loss", predictor = "age", group_var = "sex",
  save_plot = FALSE
)
}
