% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_report.R
\name{unnest_report}
\alias{unnest_report}
\title{Unnest an element of the data cleaning report}
\usage{
unnest_report(report, what, ...)
}
\arguments{
\item{report}{An object of type \code{<list>}}

\item{what}{A \code{<character>} with the name of the specific data cleaning
report which would be displayed. The possible values are:
\describe{
\item{\code{incorrect_date_sequence}}{To display rows with the incorrect date
sequences}
\item{\code{colnames}}{To display the column names before and after
cleaning}
\item{\code{converted_into_numeric}}{To display the names of the columns that
that have been converted into numeric}
\item{\code{date_standardization}}{To display rows in the cleaned data with
date values that are outside of the specified time frame, and rows
with date values that comply with multiple formats}
\item{\code{misspelled_values}}{To display the detected misspelled values}
\item{\code{removed_duplicates}}{To display the duplicated rows that have
been removed}
\item{\code{found_duplicates}}{To display the duplicated rows}
\item{\code{constant_data}}{To display the constant data i.e. constant
columns, empty rows and columns}
\item{\code{missing_values_replaced_at}}{To display the names of the columns
where the missing value strings have been replaced with NA}
\item{\code{incorrect_subject_id}}{To display the missing, duplicated and
invalid subject subject IDs}
\item{\code{scanning_result}}{To display the output of the scan_data()
function}
}}

\item{...}{Any other extra argument}
}
\value{
The input object where the specified element has been unnested and
removed.
}
\description{
Unnest an element of the data cleaning report
}
\keyword{internal}
