% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vision4R.R
\name{vision4R}
\alias{vision4R}
\title{Vision API Function using OpenAI's Vision API}
\usage{
vision4R(
  image_path,
  user_prompt = "What is depicted in this image?",
  Model = "gpt-4o-mini",
  temperature = 1,
  api_key = Sys.getenv("OPENAI_API_KEY")
)
}
\arguments{
\item{image_path}{A string specifying the path to the image file. The image format should be png or jpeg.}

\item{user_prompt}{A string containing the text prompt. Default: "What is in this image?".}

\item{Model}{The model to use. Defaults to "gpt-4-turbo". Allowed values: "gpt-4-turbo", "gpt-4o-mini".}

\item{temperature}{A numeric value controlling the randomness of the output (default: 1).}

\item{api_key}{Your OpenAI API key. Default: environment variable `OPENAI_API_KEY`.}
}
\value{
A data frame containing the model's response.
}
\description{
This function sends a local image along with a text prompt to OpenAI's GPT-4 Vision API.
  The function encodes the image in Base64 format and constructs a JSON payload where the user's
  message contains both text and an image URL (data URI). This structure mimics the provided Python code.
}
\examples{
\dontrun{
  # Example usage of the function
  api_key <- "YOUR_OPENAI_API_KEY"
  file_path <- "path/to/your/text_file.txt"
  vision4R(image_path = file_path, api_key = api_key)
}

}
\author{
Satoshi Kume
}
