% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkErrorDet_JP.R
\name{checkErrorDet_JP}
\alias{checkErrorDet_JP}
\title{Check Error Details in Japanese}
\usage{
checkErrorDet_JP(
  Summary_nch = 100,
  Model = "gpt-4o-mini",
  verbose = TRUE,
  SlowTone = FALSE
)
}
\arguments{
\item{Summary_nch}{An integer specifying the maximum number of characters for the summary.}

\item{Model}{A string specifying the model to be used, default is "gpt-4-0314".
Currently, "gpt-4", "gpt-4-0314" and "gpt-4o-mini" can be selected as gpt-4 models.
Execution with GPT-4 is recommended.}

\item{verbose}{A logical value to control the verbosity of the output, default is TRUE.}

\item{SlowTone}{A logical value to control the printing speed of the output, default is FALSE.}
}
\value{
The function prints the guidance on how to fix the error message in Japanese. If verbose is FALSE, it returns the guidance as a string.
}
\description{
A function to analyze and provide guidance on how to fix an error message copied from the R console.
}
\details{
Check Error Details in Japanese via RStudio API

This function provides a way to check error details in R. It reads the error message from the clipboard,
executes the function, and shows how to fix the error in Japanese.
}
\examples{
\dontrun{
  # Analyzing error message from the clipboard
  checkErrorDet_JP(Summary_nch = 100, Model = "gpt-4o-mini", verbose = TRUE, SlowTone = FALSE)
}
}
\author{
Satoshi Kume
}
