% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cgmguru-functions-docs.R
\name{find_new_maxima}
\alias{find_new_maxima}
\title{Find New Maxima Around Grid Points}
\usage{
find_new_maxima(df, mod_grid_max_point_df, local_maxima_df)
}
\arguments{
\item{df}{A dataframe containing continuous glucose monitoring (CGM) data.
Must include columns:
\itemize{
  \item \code{id}: Subject identifier (string or factor)
  \item \code{time}: Time of measurement (POSIXct)
  \item \code{gl}: Glucose value (integer or numeric, mg/dL)
}}

\item{mod_grid_max_point_df}{A dataframe with column \code{indices} (candidate maxima indices)}

\item{local_maxima_df}{A dataframe with column \code{local_maxima} (indices of local peaks)}
}
\value{
A tibble with updated maxima information containing columns (\code{id}, \code{time}, \code{gl}, \code{indices})
The \code{indices} column contains R-based (1-indexed) row number(s) in \code{df}; thus, \code{time == df$time[indices]} and \code{gl == df$gl[indices]}.
}
\description{
Identifies new maxima in the vicinity of previously identified grid points,
useful for refining maxima detection in GRID analysis. This function helps
improve the accuracy of peak detection by searching around known event points.
}
\examples{
# Load sample data
library(iglu)
data(example_data_5_subject)
data(example_data_hall)

# First, get grid points and local maxima
grid_result <- grid(example_data_5_subject, gap = 15, threshold = 130)
maxima_result <- find_local_maxima(example_data_5_subject)

# Create modified grid points (simplified for example)
mod_grid_indices <- data.frame(indices = grid_result$episode_start$indices[1:10])

# Find new maxima around grid points
new_maxima <- find_new_maxima(example_data_5_subject, 
                              mod_grid_indices, 
                              maxima_result$local_maxima_vector)
print(paste("Found", nrow(new_maxima), "new maxima"))

# Analysis on larger dataset
large_grid <- grid(example_data_hall, gap = 15, threshold = 130)
large_maxima <- find_local_maxima(example_data_hall)
large_mod_grid <- data.frame(indices = large_grid$episode_start$indices[1:20])
large_new_maxima <- find_new_maxima(example_data_hall, 
                                    large_mod_grid, 
                                    large_maxima$local_maxima_vector)
print(paste("Found", nrow(large_new_maxima), "new maxima in larger dataset"))
}
\seealso{
\link{find_local_maxima}, \link{find_max_after_hours}, \link{transform_df}

Other GRID pipeline: 
\code{\link{detect_between_maxima}()},
\code{\link{find_local_maxima}()},
\code{\link{find_max_after_hours}()},
\code{\link{find_max_before_hours}()},
\code{\link{find_min_after_hours}()},
\code{\link{find_min_before_hours}()},
\code{\link{grid}()},
\code{\link{maxima_grid}()},
\code{\link{mod_grid}()},
\code{\link{start_finder}()},
\code{\link{transform_df}()}
}
\concept{GRID pipeline}
