% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{gen_rotation}
\alias{gen_rotation}
\title{Generate Rotations}
\usage{
gen_rotation(p = 4, planes_angles)
}
\arguments{
\item{p}{A numeric value (default: 4) representing the number of dimensions.}

\item{planes_angles}{A numeric list which contains plane and the corresponding angle along that plane.}
}
\value{
A matrix containing the rotations.
}
\description{
This function generates a rotation matrix.
}
\examples{
set.seed(20240412)
rotations_4d <- list(
  list(plane = c(1, 2), angle = 60), # Rotation in the (1, 2) plane
  list(plane = c(3, 4), angle = 90)  # Rotation in the (3, 4) plane
)
gen_rotation(p = 4, planes_angles = rotations_4d)

}
