% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feed_author_feed.R
\name{bs_get_author_feed}
\alias{bs_get_author_feed}
\title{Retrieve posts on an actor's feed}
\usage{
bs_get_author_feed(
  actor,
  cursor = NULL,
  limit = NULL,
  user = get_bluesky_user(),
  pass = get_bluesky_pass(),
  auth = bs_auth(user, pass),
  clean = TRUE
)
}
\arguments{
\item{actor}{Character, length 1. name of 1 actor, such as \code{'chriskenny.bsky.social'}}

\item{cursor}{Character, length 1. A cursor property from a prior response. Default: \code{NULL}.}

\item{limit}{Integer. Number of records to request. If over \code{100}, multiple requests are made.}

\item{user}{Character. User name to log in with. Defaults to \code{get_bluesky_user()}.}

\item{pass}{Character. App password to log in with. Defaults to \code{get_bluesky_pass()}.}

\item{auth}{Authentication information. Defaults to \code{bs_auth(user, pass)}.}

\item{clean}{Logical. Should output be cleaned into a \code{tibble}? Default: \code{TRUE}.}
}
\value{
a \link[tibble:tibble]{tibble::tibble} of posts
}
\description{
Retrieve posts on an actor's feed
}
\section{Lexicon references}{

\href{https://github.com/bluesky-social/atproto/blob/main/lexicons/app/bsky/feed/getAuthorFeed.json}{feed/getAuthorFeed.json (2023-10-01)}
}

\section{Function introduced}{

\code{v0.0.1} (2023-10-01)
}

\examples{
\dontshow{if (has_bluesky_pass() && has_bluesky_user()) withAutoprint(\{ # examplesIf}
bs_get_author_feed('chriskenny.bsky.social')
\dontshow{\}) # examplesIf}
}
\concept{feed}
