% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_value.R
\name{p_value}
\alias{p_value}
\title{Calculate the p-value for an attenuated correlation coefficient.}
\usage{
p_value(rho, r, N, method = "corr", k = NULL)
}
\arguments{
\item{rho}{Numeric vector in [-1,1]. The correlation under the null
hypothesis.}

\item{r}{Numeric vector of three elements in [-1,1]. \code{r[1]} is the
correlation between the noisy measures X' and Y', \code{r[2]} is the
correlation between the noisy X' and the true X, while \code{r[3]} is
the correlation between the noisy Y' and the true Y. They are the
square root of the reliabilities. Must be positive
method to \code{"corr"} and \code{"cronbach"}.}

\item{N}{Numeric vector of three positive integers. \code{N[i]} is the
sample size for \code{r[i]}.}

\item{method}{The type of p-value. Can be \code{"corr"}, \code{"cronbach"},
\code{"HS"} or \code{"free"}. See the details.}

\item{k}{Numeric vector of two positive integers. \code{k[i]} is the number
of testlets for the for \code{r[i+1]}. Only needed for method
\code{"cronbach"}.}
}
\value{
Numeric in [0, 1]. The p-value under the null-hypothesis that the
    true correlation is rho.
}
\description{
This function calculates four types of p-values for correlations coefficients
    corrected for attenuation, chosen in "method". The different p-values
    are described in Moss (2019). \code{"corr"} is the correlation based
    p-value, \code{"cronbach"} is the Cronbach alpha based p-value,
    \code{"HS"} is the Hunter-Schmidt p-value, while \code{"free"} is the
    correlation based p-value without positive constraints.
}
\examples{
    r = c(0.20, sqrt(0.45), sqrt(0.55))
    N = c(100, 100, 100)
    p_value(rho = 0, r, N) # Tests rho = 0.
}
