% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitMET.R
\name{met_analysis}
\alias{met_analysis}
\title{Multi-Environmental Trial Analysis}
\usage{
met_analysis(
  sma_output = NULL,
  h2_filter = 0.2,
  workspace = "1gb",
  vcov = NULL,
  filter_traits = NULL,
  remove_trials = NULL,
  progress = TRUE
)
}
\arguments{
\item{sma_output}{Object of class \code{smaAgri} resulting of executing
\code{single_trial_analysis()} function.}

\item{h2_filter}{Numeric value to filter trials with poor heritability.
0.2 by default.}

\item{workspace}{Sets the workspace for the core \code{REML} routines in the
form of a number optionally followed directly by a valid measurement unit.
"128mb" by default.}

\item{vcov}{A character string specifying the Variance-Covariance structure
to be fitted. Can be "fa2", "fa1", "us", "corh" or "corv". If \code{NULL} the
function will try to fit an "us" Variance-Covariance and if it fails, it will
try with "fa2" and then with "fa1".}

\item{filter_traits}{A character vector with traits to filter. \code{NULL} by
default.}

\item{remove_trials}{A character vector with trials to remove. \code{NULL} by
default.}

\item{progress}{Should the progress of the modeling be printed.
If \code{TRUE}, for every trait a line is output indicating that the model is
being fitted.}
}
\value{
An object of class \code{metAgri}, with a list of:
\item{trial_effects}{A data.frame containing Trial BLUEs.}
\item{overall_BLUPs}{A data.frame containing Genotypic BLUPs across trials,
by trait.}
\item{BLUPs_GxE}{A data.frame containing Genotypic BLUPs by trial/trait.}
\item{VCOV}{A list by trait contanining the variance-covariance fitted.}
\item{stability}{A data.frame containing several Stability coefficients
resulting of executing the function \code{stability()}.}
\item{heritability}{A data.frame containing overall heritabilities by trait.}
\item{met_models}{A list by trait containing the fitted models.}
}
\description{
The results of the \code{single_trial_analysis()} function are
used in \code{met_analysis()} to fit multi-environmental trial models.
Returns an object of class \code{metAgri}, with a list of trial effects,
BLUPs, heritability, variance components, stability and the models fitted.
}
\examples{
\dontrun{
library(agridat)
library(agriutilities)
data(besag.met)
dat <- besag.met
results <- check_design_met(
  data = dat,
  genotype = "gen",
  trial = "county",
  traits = c("yield"),
  rep = "rep",
  block = "block",
  col = "col",
  row = "row"
)
out <- single_trial_analysis(results, progress = FALSE)
met_results <- met_analysis(out, progress = FALSE)
print(met_results)
covcor_heat(matrix = met_results$VCOV$yield$CORR)
}
}
