% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/object.R
\docType{class}
\name{VT.object}
\alias{VT.object}
\title{VT.object}
\description{
A Reference Class to deal with RCT dataset
}
\details{
Currently working with binary response only. Continous will come, one day. 
Two-levels treatment only as well.

\code{data} field should be as described, however if virtual twins won't used
interactions, there is no need to transform factors. See
\link{formatRCTDataset} for more details.
}
\section{Fields}{

\describe{
\item{\code{data}}{Data.frame with format: \eqn{Y,T,X_{1}, \ldots, X_{p}}. Y must be
two levels factor if type is binary. T must be numeric or integer.}

\item{\code{screening}}{Logical, set to \code{FALSE} Set to \code{TRUE} to use
\code{varimp} in trees computation.}

\item{\code{varimp}}{Character vector of important variables to use in trees 
computation.}

\item{\code{delta}}{Numeric representing the difference of incidence between 
treatments.}

\item{\code{type}}{Character : binary or continous. Only binary is currently 
available.}
}}

\section{Methods}{

\describe{
\item{\code{computeDelta()}}{Compute delta value.}

\item{\code{getData(interactions = F)}}{Return dataset. If interactions is set to T, return data with treatement interactions}

\item{\code{getFormula()}}{Return formula : Y~T+X1+...+Xp. Usefull for cforest function.}

\item{\code{getIncidences(rule = NULL)}}{Return incidence table of data if rule set to NULL. Otherwise return incidence for the rule.}

\item{\code{getX(interactions = T, trt = NULL)}}{Return predictors (T,X,X*T,X*(1-T)). Or (T,X) if interactions is FALSE.
If trt is not NULL, return predictors for T = trt}

\item{\code{getXwithInt()}}{Return predictors with interactions. Use VT.object::getX(interactions = T) instead.}

\item{\code{getY(trt = NULL)}}{Return outcome. If trt is not NULL, return outcome for T = trt.}

\item{\code{switchTreatment()}}{Switch treatment value.}
}}

\examples{
\dontrun{
# Default use :
vt.o <- VT.object$new(data = my.rct.dataset)

# Getting data
head(vt.o$data)

# or getting predictor with interactions
vt.o$getX(interactions = T)

# or getting X|T = 1
vt.o$getX(trt = 1)

# or getting Y|T = 0
vt.o$getY(0)

# Print incidences
vt.o$getIncidences()
}

}
\seealso{
\code{\link{VT.difft}}
}
