% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.R
\name{gp}
\alias{gp}
\title{Gaussian Process Model Specification}
\usage{
gp(..., kappa = 0.5, nugget = 0)
}
\arguments{
\item{...}{Variables representing the spatial coordinates or covariates for the GP model.}

\item{kappa}{The smoothness parameter \eqn{\kappa}. Default is 0.5.}

\item{nugget}{The nugget effect, which represents the variance of the measurement error. Default is 0. A positive numeric value must be provided if not using the default.}
}
\value{
A list of class \code{gp.spec} containing the following elements:
\item{term}{A character vector of the specified terms.}
\item{kappa}{The smoothness parameter \eqn{\kappa}.}
\item{nugget}{The nugget effect.}
\item{dim}{The number of specified terms.}
\item{label}{A character string representing the full call for the GP model.}
}
\description{
Specifies the terms, smoothness, and nugget effect for a Gaussian Process (GP) model.
}
\details{
The function constructs a list that includes the specified terms (spatial coordinates or covariates), the smoothness parameter \eqn{\kappa}, and the nugget effect. This list can be used as a specification for a Gaussian Process model.
}
\note{
The nugget effect must be a positive real number if specified.
}
\author{
Emanuele Giorgi \email{e.giorgi@lancaster.ac.uk}

Claudio Fronterre \email{c.fronterr@lancaster.ac.uk}
}
