% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collocationScoreQuery.R
\name{collocationScoreQuery,KorAPConnection-method}
\alias{collocationScoreQuery,KorAPConnection-method}
\alias{collocationScoreQuery}
\title{Query frequencies of a node and a collocate and calculate collocation association scores}
\usage{
\S4method{collocationScoreQuery}{KorAPConnection}(
  kco,
  node,
  collocate,
  vc = "",
  lemmatizeNodeQuery = FALSE,
  lemmatizeCollocateQuery = FALSE,
  leftContextSize = 5,
  rightContextSize = 5,
  scoreFunctions = defaultAssociationScoreFunctions(),
  smoothingConstant = 0.5,
  observed = NA,
  ignoreCollocateCase = FALSE,
  withinSpan = "base/s=s"
)
}
\arguments{
\item{kco}{\code{\link[=KorAPConnection]{KorAPConnection()}} object (obtained e.g. from \code{KorAPConnection()}}

\item{node}{target word}

\item{collocate}{collocate of target word}

\item{vc}{string describing the virtual corpus in which the query should be performed. An empty string (default) means the whole corpus, as far as it is license-wise accessible.}

\item{lemmatizeNodeQuery}{logical, set to TRUE if node query should be lemmatized, i.e. \verb{x -> [tt/l=x]}}

\item{lemmatizeCollocateQuery}{logical, set to TRUE if collocate query should be lemmatized, i.e. \verb{x -> [tt/l=x]}}

\item{leftContextSize}{size of the left context window}

\item{rightContextSize}{size of the right context window}

\item{scoreFunctions}{named list of score functions of the form function(O1, O2, O, N, E, window_size), see e.g. \link{pmi}}

\item{smoothingConstant}{smoothing constant will be added to all observed values}

\item{observed}{if collocation frequencies are already known (or estimated from a sample) they can be passed as a vector here, otherwise: NA}

\item{ignoreCollocateCase}{logical, set to TRUE if collocate case should be ignored}

\item{withinSpan}{KorAP span specification (see \url{https://korap.ids-mannheim.de/doc/ql/poliqarp-plus?embedded=true#spans}) for collocations to be searched within. Defaults to \code{base/s=s}.}
}
\value{
tibble with query KorAP web request URL, all observed values and association scores
}
\description{
Computes various collocation association scores
based on \code{\link[=frequencyQuery]{frequencyQuery()}}s for a target word and a collocate.
}
\examples{
\dontrun{

KorAPConnection(verbose = TRUE) |>
  collocationScoreQuery("Grund", "triftiger")
}

\dontrun{

KorAPConnection(verbose = TRUE) |>
collocationScoreQuery("Grund", c("guter", "triftiger"),
   scoreFunctions = list(localMI = function(O1, O2, O, N, E, window_size) { O * log2(O/E) }) )
}

\dontrun{

library(highcharter)
library(tidyr)
KorAPConnection(verbose = TRUE) |>
  collocationScoreQuery("Team", "agil", vc = paste("pubDate in", c(2014:2018)),
                        lemmatizeNodeQuery = TRUE, lemmatizeCollocateQuery = TRUE) |>
                         pivot_longer(14:last_col(), names_to = "measure", values_to = "score") |>
  hchart(type="spline", hcaes(label, score, group=measure)) |>
  hc_add_onclick_korap_search()
}

}
\seealso{
Other collocation analysis functions: 
\code{\link{association-score-functions}},
\code{\link{collocationAnalysis,KorAPConnection-method}},
\code{\link{synsemanticStopwords}()}
}
\concept{collocation analysis functions}
