% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pspaceMethods.R
\docType{methods}
\name{vertexSignal,PathwaySpace-method}
\alias{vertexSignal,PathwaySpace-method}
\alias{vertexSignal}
\alias{vertexSignal<-}
\alias{vertexDecay}
\alias{vertexDecay<-}
\alias{vertexSignal<-,PathwaySpace-method}
\alias{vertexDecay,PathwaySpace-method}
\alias{vertexDecay<-,PathwaySpace-method}
\title{Accessor Functions for PathwaySpace Objects}
\usage{
\S4method{vertexSignal}{PathwaySpace}(x)

\S4method{vertexSignal}{PathwaySpace}(x) <- value

\S4method{vertexDecay}{PathwaySpace}(x)

\S4method{vertexDecay}{PathwaySpace}(x) <- value
}
\arguments{
\item{x}{A \linkS4class{PathwaySpace} class object.}

\item{value}{The new value of the attribute.}
}
\value{
Updated \linkS4class{PathwaySpace} object.
}
\description{
Get or set 'signal' and 'decay' functions in a 
\linkS4class{PathwaySpace} class object.
}
\examples{
data('gtoy1', package = 'RGraphSpace')
ps <- buildPathwaySpace(gtoy1, nrc = 100)

# Check vertex names
names(ps)

# Access signal values from all vertices
vertexSignal(ps)

# Modify signal value of a specific vertex
vertexSignal(ps)[1] <- 1

# Modify signal value of specific vertices
vertexSignal(ps)[c("n2","n3")] <- 1

# Set '1s' to all vertices
vertexSignal(ps) <- 1

#----

# Access decay function of a specific vertex
vertexDecay(ps)[["n3"]]

# Modify decay function of a specific vertex
vertexDecay(ps)[["n3"]] <- linearDecay()

# Modify decay functions of two vertices
vertexDecay(ps)[c("n1","n3")] <- list( weibullDecay() )

# Modify decay functions of all vertices
vertexDecay(ps) <- weibullDecay(shape = 2)

}
