% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/A02-estimator-cox.R
\name{surv_cox}
\alias{surv_cox}
\title{Survival Effect Estimation with Cox Censoring Scores}
\usage{
surv_cox(
  data,
  time_var,
  event_var,
  treatment_var,
  eval_times = NULL,
  weight_result,
  censoring_formula,
  censoring_control = list(),
  ties = "efron"
)
}
\arguments{
\item{data}{Data frame.}

\item{time_var}{Name of time variable.}

\item{event_var}{Name of event indicator (1 = event, 0 = censored).}

\item{treatment_var}{Name of treatment variable.}

\item{eval_times}{Numeric vector of time points. If NULL, uses all unique event times.}

\item{weight_result}{Output from \code{estimate_weights()}.}

\item{censoring_formula}{Formula for censoring score model.}

\item{censoring_control}{Control parameters for \code{coxph()}.
Default \code{list()}.}

\item{ties}{Tie handling method for Cox model. Default "efron".}
}
\value{
List containing:
  \item{survival_matrix}{Matrix [time x J] of survival function estimates S^(j)(t).}
  \item{eval_times}{Time points evaluated.}
  \item{treatment_levels}{Treatment level values.}
  \item{n_levels}{Number of treatment levels.}
  \item{weights_by_group}{List of weight vectors by treatment group.}
  \item{censoring_scores_by_group}{List of censoring score vectors by group.}
  \item{method, estimand}{Weighting method and target estimand.}
  \item{censoring_result, ps_result, weight_result}{Input objects.}
  \item{Z_matrix}{Binary indicator matrix [n x J] for treatment groups.}
  \item{time_vec, event_vec}{Original time and event vectors.}
}
\description{
Implements Estimator I (AJE 2022, Eq. 2) combining propensity score weighting
and inverse probability of censoring weighting to estimate counterfactual
survival functions and treatment effects. Variance estimation uses bootstrap only.
Estimate Counterfactual Survival Functions Using Cox Censoring Scores
}
\details{
Estimates counterfactual survival function for each treatment group j:
\deqn{S^{(j)}_w(t) = 1 - \frac{\sum_i w_i I(A_i=j) \delta_i I(T_i \leq t) / K_c^{(j)}(T_i, X_i)}{\sum_i w_i I(A_i=j)}}

Censoring scores are estimated using Cox proportional hazards models fit separately
within each treatment group. Variance estimation for Cox-based survival functions
is performed using bootstrap only (no analytical variance available).
}
\keyword{internal}
