% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{cerebellar_age_df}
\alias{cerebellar_age_df}
\title{Repeated Measurements of Age and Cerebellar Volume}
\format{
A data frame with 144 observations and 4 variables:
\describe{
  \item{Participant}{Participant ID (integer)}
  \item{Time}{Measurement occasion (integer)}
  \item{Age}{Age of the participant (numeric)}
  \item{Volume}{Adjusted cerebellar hemisphere volume (numeric)}
}
}
\source{
Data taken from the rmcorr package version 0.7.0
}
\usage{
data(cerebellar_age_df)
}
\description{
This dataset, cerebellar_age_df, is a data frame containing repeated measurements of age and adjusted
volume of cerebellar hemispheres from 72 participants. Each participant was measured on two occasions
(Time), resulting in a total of 144 observations. The measurements were captured from Figure 8,
Cerebellar Hemispheres (lower right) of Raz et al. (2005). The dataset includes participant identifiers,
measurement time, age, and cerebellar hemisphere volume. Some observations may contain missing values.
}
\details{
The dataset name has been kept as cerebellar_age_df to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
NeuroDataSets package and assists users in identifying its specific characteristics.
The suffix df indicates that the dataset is a data frame. The original content has not been modified
in any way.
}
