% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mds.R
\name{plot.pcmap}
\alias{plot.pcmap}
\title{Diagnostic plots for the map estimation using calc.maps.pc with 2 dimensions.}
\usage{
\method{plot}{pcmap}(x, D1lim = NULL, D2lim = NULL, displaytext = TRUE, ...)
}
\arguments{
\item{x}{Map object from \code{\link[=calc.maps.pc]{calc.maps.pc()}} with 2 dimensions.}

\item{D1lim}{Numeric vector specifying the limits of the horizontal axis.}

\item{D2lim}{Numeric vector specifying the limits of the vertical axis.}

\item{displaytext}{Logical argument determining how markers should be labelled 
in the wMDS configuration plot. If TRUE then marker names are used. If FALSE 
then numbers are used.}

\item{...}{Further arguments are ignored. (accepted for compatibility with generic plot)}
}
\description{
Diagnostic plots for the map estimation using calc.maps.pc with 2 dimensions.
}
\details{
Plots 2 panels:

Panel 1 the final MDS configuration and the fitted principal curve from the 
\code{\link[=calc.maps.pc]{calc.maps.pc()}} in 2 dimensions. If D1lim or D2lim 
is not specified, then limits are defined by \code{\link[smacof]{plot.smacof}}. 

Panel 2 the pointwise nearest neighbour fits in order of the position in the 
estimated map.

Markers are assigned numbers according to the order in which they occur in 
the input file. The locikey output of the map object is a data frame 
associating marker names with their numbers. This can be accessed using 
\code{pcmap$locikey}. If \code{displaytext=FALSE} then markers will be labelled 
by these numbers. By default displaytext=TRUE and markers are labelled by 
marker name.
}
\examples{
map<-calc.maps.pc(system.file("extdata", "lgI.txt", package="MDSMap"),
ndim=2,weightfn='lod',mapfn='haldane')
plot(map)
}
\references{
\cite{de Leeuw J, Mair P (2009) Multidimensional scaling using majorization: SMACOF in R. J Stat Softw 31: 1-30} \url{https://www.jstatsoft.org/v31/i03/}
}
\seealso{
\code{\link{plot.pcmap3d}}, \code{\link{plot.spheremap}},\code{\link[smacof]{plot.smacof}}, \code{\link{calc.maps.pc}}
}
