% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KbSkewness.R
\name{MardiaMvtSkew}
\alias{MardiaMvtSkew}
\title{Mardia's Multivariate Skewness}
\usage{
MardiaMvtSkew(x)
}
\arguments{
\item{x}{a matrix of original observations.}
}
\value{
\code{MardiaMvtSkew} gives the sample Mardia's multivairate skewness.
}
\description{
Compute Mardia's Multivariate Skewness.
}
\details{
Given a \eqn{p}-dimensional multivariate random vector with mean vector \eqn{\boldsymbol{\mu}} and positive definite variance-covariance matrix \eqn{\boldsymbol{\Sigma}}, Mardia's multivariate skewness is defined as
\deqn{\beta_{1,p} = E[(\boldsymbol{X}_1 - \boldsymbol{\mu})' \boldsymbol{\Sigma}^{-1} (\boldsymbol{X}_2 - \boldsymbol{\mu})]^3,}
where \eqn{\boldsymbol{X}_1} and \eqn{\boldsymbol{X}_2} are independently and identically distributed copies of \eqn{\boldsymbol{X}}. For a multivariate random sample of size \eqn{n}, \eqn{\boldsymbol{x}_1, \boldsymbol{x}_1, \ldots, \boldsymbol{x}_n}, its sample version is defined as
\deqn{\hat{\beta}_{1,p} = \frac{1}{n^2} \sum_{i=1}^{n} \sum_{j=1}^{n} [(\boldsymbol{x}_i - \bar{\boldsymbol{x}})'\boldsymbol{S}^{-1} (\boldsymbol{x}_j - \bar{\boldsymbol{x}})]^3,}
where the sample mean \eqn{\bar{\boldsymbol{x}} = \frac{1}{n}\sum_{i=1}^{n} \boldsymbol{x}_i} and the sample variance-covariance matrix \eqn{\boldsymbol{S} = \frac{1}{n} \sum_{i=1}^{n} (\boldsymbol{x}_i - \bar{\boldsymbol{x}}) (\boldsymbol{x}_i - \bar{\boldsymbol{x}})'}. It is assumed that \eqn{n \ge p}.
}
\examples{
# Compute Mardia's multivairate skewness

data(OlymWomen)
MardiaMvtSkew(OlymWomen[, c("m800","m1500","m3000","marathon")])

}
\references{
Mardia, K.V. (1970). Measures of multivariate skewness and kurtosis with applications. \emph{Biometrika}, 57(3), 519–530.
}
