% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance_thinning.R
\name{compute_neighbors_brute}
\alias{compute_neighbors_brute}
\title{Compute Neighbors Using Brute-Force}
\usage{
compute_neighbors_brute(
  coordinates,
  thin_dist,
  distance = c("haversine", "euclidean"),
  R = 6371
)
}
\arguments{
\item{coordinates}{A matrix of coordinates to thin, with two columns representing longitude and latitude.}

\item{thin_dist}{A positive numeric value representing the thinning distance in kilometers.}

\item{distance}{A character string specifying the distance metric to use `c("haversine", "euclidean")`.}

\item{R}{A numeric value representing the radius of the Earth in kilometers. The default is 6371 km.}
}
\value{
A list where each element corresponds to a point and contains the indices of its neighbors.
}
\description{
Computes neighbors for each point in a set of coordinates using a greedy
approach. All pairwise distances are calculated to identify neighbors within
a specified distance threshold.
}
\examples{
set.seed(123)
coords <- matrix(runif(20, min = -180, max = 180), ncol = 2)

# Compute neighbors using brute fore
neighbors <- compute_neighbors_brute(coords, thin_dist = 10,)

}
