% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GIFT_traits_meta.R
\name{GIFT_traits_meta}
\alias{GIFT_traits_meta}
\title{Trait metadata}
\usage{
GIFT_traits_meta(
  api = "https://gift.uni-goettingen.de/api/extended/",
  GIFT_version = "latest"
)
}
\arguments{
\item{api}{Character string corresponding to the API.}

\item{GIFT_version}{character string defining the version of the GIFT
database to use. The function retrieves by default the most up-to-date
version.}
}
\value{
A data frame with 10 columns.
}
\description{
Retrieve metadata of the functional traits coming from GIFT.
}
\details{
Here is what each column refers to:

\emph{Lvl1} - First level of the trait classification\cr
\emph{Category} - Name of the first level of classification\cr
\emph{Lvl2} - Second level of the trait classification\cr
\emph{Trait1} - Name of the second level of classification\cr
\emph{Lvl3} - Identification number of the trait\cr
\emph{Trait2} - Trait name\cr
\emph{Units} - Trait unit\cr
\emph{type} - Trait type\cr
\emph{comment} - Comment\cr
\emph{count} - How many entries for that traits are in the database
}
\examples{
\donttest{
ex <- GIFT_traits_meta()
}

}
\references{
\if{html}{\out{<div class="sourceCode">}}\preformatted{ Denelle, P., Weigelt, P., & Kreft, H. (2023). GIFT—An R package to
 access the Global Inventory of Floras and Traits. Methods in Ecology
 and Evolution, 14, 2738-2748.
 https://doi.org/10.1111/2041-210X.14213

 Weigelt, P, König, C, Kreft, H. GIFT – A Global Inventory of Floras and
 Traits for macroecology and biogeography. J Biogeogr. 2020; 47: 16– 43.
 https://doi.org/10.1111/jbi.13623
}\if{html}{\out{</div>}}
}
\seealso{
\code{\link[=GIFT_traits]{GIFT_traits()}}
}
