% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MPI_create.R
\name{create_MPI}
\alias{create_MPI}
\title{Create Measurement Period Information}
\usage{
create_MPI(binfile, binfile_path, output_folder, out_rds = TRUE)
}
\arguments{
\item{binfile}{Text lines read from an open connection to a bin file.}

\item{binfile_path}{Path to the bin file to be processed.}

\item{output_folder}{Folder to write MPI file in.}

\item{out_rds}{Allows RDS output to be saved during MPI creation.}
}
\value{
List of measurement period information.
}
\description{
Create Measurement Period Information
}
\details{
Function to create measurement period information (MPI) from a GENEActiv bin file
}
\examples{
binfile_path <- system.file("extdata/20Hz_file.bin", package = "GENEAcore")
con <- file(binfile_path, "r")
binfile <- readLines(con, skipNul = TRUE)
close(con)
output_folder <- tempdir()
MPI <- create_MPI(binfile, binfile_path, output_folder, out_rds = FALSE)
}
