% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fars_methods.R
\name{get_rq_model.fars}
\alias{get_rq_model.fars}
\title{Extract a Specific \code{rq} Object from a \code{fars} Object}
\usage{
\method{get_rq_model}{fars}(x, tau, ...)
}
\arguments{
\item{x}{An object of class \code{mldfm_subsample}.}

\item{tau}{Numeric scalar in (0, 1) indicating the desired quantile.}

\item{...}{Additional arguments (ignored).}
}
\value{
A single \code{rq} object.
}
\description{
Returns the \code{rq} fit stored inside a \code{fars} object at the requested quantile.
}
\examples{
fars_result <- compute_fars(dep_variable = rnorm(100), 
                            factors = matrix(rnorm(100 * 3), ncol = 3))
get_rq_model(fars_result, tau = 0.05)  

}
