% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EVT_utils.R
\name{predict_GPD_semiconditional}
\alias{predict_GPD_semiconditional}
\title{Predict semi-conditional extreme quantiles using peaks over threshold}
\usage{
predict_GPD_semiconditional(
  Y,
  interm_lvl,
  thresh_quantiles,
  interm_quantiles_test = thresh_quantiles,
  prob_lvls_predict = c(0.99)
)
}
\arguments{
\item{Y}{Vector of ("training") observations.}

\item{interm_lvl}{Probability level at which the empirical quantile should be used as the intermediate threshold.}

\item{thresh_quantiles}{Numerical vector of the same length as \code{Y}
representing the varying intermediate threshold on the train set.}

\item{interm_quantiles_test}{Numerical vector of the same length as \code{Y}
representing the varying intermediate threshold used for prediction on the test set.}

\item{prob_lvls_predict}{Probability levels at which to predict the extreme semi-conditional quantiles.}
}
\value{
Named list containing:
\item{predictions}{matrix of dimension \code{length(interm_quantiles_test)} times \code{length(prob_lvls_predict)}
containing the estimated extreme quantile at levels \code{quantile}, for each \code{interm_quantiles_test},}
\item{pars}{matrix of dimension \code{ntest} times \code{2}
containing the two GPD parameter MLEs, repeated \code{length(interm_quantiles_test)} times.}
}
\description{
Predict semi-conditional extreme quantiles using peaks over threshold
}
