% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/errorrate.R
\name{errorrate}
\alias{errorrate}
\title{Error rate of the Bayes rule for two-class Gaussian homoscedastic model}
\usage{
errorrate(beta0, beta, pi, mu, sigma)
}
\arguments{
\item{beta0}{An \eqn{n\times p} matrix where each row represents an individual observation}

\item{beta}{Number of observations.}

\item{pi}{A g-dimensional vector for the initial values of the mixing proportions.}

\item{mu}{A \eqn{p \times g} matrix for the initial values of the location parameters.}

\item{sigma}{A \eqn{p\times p} covariance matrix if \code{ncov=1}, or a list of g covariance matrices with dimension \eqn{p\times p \times g} if \code{ncov=2}.}
}
\value{
\item{errval}{A vector of error rate.}
}
\description{
The optimal error rate of Bayes rule for two-class Gaussian homoscedastic model
}
\details{
The optimal error rate of Bayes rule for two-class Gaussian homoscedastic model can be expressed as
\deqn{
err(y_j;\theta)=\pi_1\phi\{-\frac{\beta_0+\beta_1^T\mu_1}{(\beta_1^T\Sigma\beta_1)^{\frac{1}{2}}}\}+\pi_2\phi\{\frac{\beta_0+\beta_1^T\mu_2}{(\beta_1^T\Sigma\beta_1)^{\frac{1}{2}}}\}
}
where \eqn{\phi} is a normal probability function with mean \eqn{\mu_i} and covariance matrix \eqn{\Sigma_i}.
}
