% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/totalCorMat.R
\name{totalCorMat}
\alias{totalCorMat}
\title{Total Correlation Matrix}
\usage{
totalCorMat(data, base = 2.718282, normalized = FALSE)
}
\arguments{
\item{data}{Matrix or data frame.
Should consist only of variables to be used in the analysis}

\item{base}{Numeric (length = 1).
Base to use for entropy.
Defaults to \code{exp(1)} or \code{2.718282}}

\item{normalized}{Boolean (length = 1).
Should the normalized total correlation be computed?
Defaults to \code{FALSE}}
}
\value{
Returns a symmetric matrix with pairwise total correlations
}
\description{
Computes the pairwise total correlation
(\code{\link[EGAnet]{totalCor}}) for a dataset
}
\examples{
# Compute total correlation matrix
totalCorMat(wmt2[,7:24])

}
\references{
\strong{Formalization of total correlation} \cr
Watanabe, S. (1960).
Information theoretical analysis of multivariate correlation.
\emph{IBM Journal of Research and Development} \emph{4}, 66-82.

\strong{Applied implementation} \cr
Felix, L. M., Mansur-Alves, M., Teles, M., Jamison, L., & Golino, H. (2021).
Longitudinal impact and effects of booster sessions in a cognitive training program for healthy older adults.
\emph{Archives of Gerontology and Geriatrics}, \emph{94}, 104337.
}
\author{
Hudson F. Golino <hfg9s at virginia.edu>
}
