% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/information.R
\name{information}
\alias{information}
\title{Information Theory Metrics}
\usage{
information(
  data,
  base = 2.718282,
  bins = floor(sqrt(nrow(data)/5)),
  statistic = c("entropy", "joint.entropy", "conditional.entropy", "total.correlation",
    "dual.total.correlation", "o.information")
)
}
\arguments{
\item{data}{Matrix or data frame.
Should consist only of variables to be used in the analysis}

\item{base}{Numeric (length = 1).
Base of logarithm to use for entropy.
Common options include:

\itemize{

\item \code{2} --- bits

\item \code{2.718282} --- nats

\item \code{10} --- bans

}

Defaults to \code{exp(1)} or \code{2.718282}}

\item{bins}{Numeric (length = 1).
Number of bins if data are not discrete.
Defaults to \code{floor(sqrt(nrow(data) / 5))}}

\item{statistic}{Character.
Information theory statistics to compute.
Available options:

\itemize{

\item \code{"entropy"} --- Shannon's entropy (Shannon, 1948) for each variable in \code{data}.
Values range from \code{0} to \code{log(k)} where \code{k} is the number of categories for the variable

\item \code{"joint.entropy"} --- shared uncertainty over all variables in \code{data}.
Values range from the maximum of the individual entropies to the sum of individual entropies

\item \code{"conditional.entropy"} --- uncertainty remaining after considering all other
variables in \code{data}. Values range from \code{0} to the individual entropy of the
conditioned variable

\item \code{"total.correlation"} --- generalization of mutual information to more than
two variables (Watanabe, 1960). Quantifies the redundancy of information in \code{data}.
Values range from \code{0} to the sum of individual entropies minus the maximum of the
individual entropies

\item \code{"dual.total.correlation"} --- "shared randomness" or total uncertainty remaining in
the \code{data} (Han, 1978). Values range from \code{0} to joint entropy

\item \code{"o.information"} --- quantifies the extent to which the \code{data} is represented
by lower-order (\code{> 0}; redundancy) or higher-order (\code{< 0}; synergy) constraint
(Crutchfield, 1994)

}

By default, all statistics are computed}
}
\value{
Returns list containing \emph{only} requested \code{statistic}
}
\description{
A general function to compute several different information theory metrics
}
\examples{
# All measures
information(wmt2[,7:24])

# One measures
information(wmt2[,7:24], statistic = "joint.entropy")

}
\references{
\strong{Shannon's entropy} \cr
Shannon, C. E. (1948). A mathematical theory of communication.
\emph{The Bell System Technical Journal}, \emph{27}(3), 379-423.

\strong{Formalization of total correlation} \cr
Watanabe, S. (1960).
Information theoretical analysis of multivariate correlation.
\emph{IBM Journal of Research and Development} \emph{4}, 66-82.

\strong{Applied implementation of total correlation} \cr
Felix, L. M., Mansur-Alves, M., Teles, M., Jamison, L., & Golino, H. (2021).
Longitudinal impact and effects of booster sessions in a cognitive training program for healthy older adults.
\emph{Archives of Gerontology and Geriatrics}, \emph{94}, 104337.

\strong{Formalization of dual total correlation} \cr
Te Sun, H. (1978).
Nonnegative entropy measures of multivariate symmetric correlations.
\emph{Information and Control}, \emph{36}, 133-156.

\strong{Formalization of O-information} \cr
Crutchfield, J. P. (1994). The calculi of emergence: Computation, dynamics and induction.
\emph{Physica D: Nonlinear Phenomena}, \emph{75}(1-3), 11-54.

\strong{Applied implementation of O-information} \cr
Marinazzo, D., Van Roozendaal, J., Rosas, F. E., Stella, M., Comolatti, R., Colenbier, N., Stramaglia, S., & Rosseel, Y. (2024).
An information-theoretic approach to build hypergraphs in psychometrics.
\emph{Behavior Research Methods}, 1-23.
}
\author{
Hudson F. Golino <hfg9s at virginia.edu> and Alexander P. Christensen <alexpaulchristensen@gmail.com>
}
