% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/az_kubernetes_service.R
\name{agent_pool}
\alias{agent_pool}
\title{Utility function for specifying Kubernetes agent pools}
\usage{
agent_pool(name, count, size = "Standard_DS2_v2", os = "Linux",
  disksize = 0, use_scaleset = TRUE, low_priority = FALSE,
  autoscale_nodes = FALSE, ...)
}
\arguments{
\item{name}{The name(s) of the pool(s).}

\item{count}{The number of nodes per pool.}

\item{size}{The VM type (size) to use for the pool. To see a list of available VM sizes, use the \link{list_vm_sizes} method for the resource group or subscription classes.}

\item{os}{The operating system to use for the pool. Can be "Linux" or "Windows".}

\item{disksize}{The OS disk size in gigabytes for each node in the pool. A value of 0 means to use the default disk size for the VM type.}

\item{use_scaleset}{Whether to use a VM scaleset instead of individual VMs for this pool. A scaleset offers greater flexibility than individual VMs, and is the recommended method of creating an agent pool.}

\item{low_priority}{If this pool uses a scaleset, whether it should be made up of spot (low-priority) VMs. A spot VM pool is cheaper, but is subject to being evicted to make room for other, higher-priority workloads. Ignored if \code{use_scaleset=FALSE}.}

\item{autoscale_nodes}{The cluster autoscaling parameters for the pool. To enable autoscaling, set this to a vector of 2 numbers giving the minimum and maximum size of the agent pool. Ignored if \code{use_scaleset=FALSE}.}

\item{...}{Other named arguments, to be used as parameters for the agent pool.}
}
\value{
An object of class \code{agent_pool}, suitable for passing to the \code{create_aks} constructor method.
}
\description{
Utility function for specifying Kubernetes agent pools
}
\details{
\code{agent_pool} is a convenience function to simplify the task of specifying the agent pool for a Kubernetes cluster.
}
\examples{
# pool of 5 Linux GPU-enabled VMs
agent_pool("pool1", 5, size="Standard_NC6s_v3")

# pool of 3 Windows Server VMs, 500GB disk size each
agent_pool("pool1", 3, os="Windows", disksize=500)

# enable cluster autoscaling, with a minimum of 1 and maximum of 10 nodes
agent_pool("pool1", 5, autoscale_nodes=c(1, 10))

# use individual VMs rather than scaleset
agent_pool("vmpool1", 3, use_scaleset=FALSE)

}
\seealso{
\link{create_aks}, \link{list_vm_sizes}

\href{https://learn.microsoft.com/en-us/rest/api/aks/managedclusters/createorupdate#managedclusteragentpoolprofile}{Agent pool parameters on Microsoft Docs}
}
