% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores_su_sui_tlfb.R
\docType{data}
\name{tlfb_substances}
\alias{tlfb_substances}
\alias{compute_tlfb_abst}
\title{Compute TLFB length of abstinence}
\format{
\code{tlfb_substances} is a character vector of all substances that can be
reported in the TLFB.
}
\usage{
tlfb_substances

compute_tlfb_abst(
  data,
  name,
  substance = NULL,
  period = NULL,
  days = NULL,
  binge = NULL
)
}
\arguments{
\item{data}{tibble. A data frame containing the TLFB raw data.}

\item{name}{character. The name of the output column for the computed score.}

\item{substance}{character (vector). The substance(s) to compute the score
for. Must be one or several of the following values:
\itemize{
\item \code{"'Fake' Marijuana or Synthetics"}
\item \code{"Alcohol"}
\item \code{"Anabolic Steroids"}
\item \code{"Any Other Drug They Used to Get High"}
\item \code{"Blunts or Combined Tobacco and Marijuana in Joints"}
\item \code{"CBD (Non-Medical Use)"}
\item \code{"Cathinones such as Bath Salts, Drone, or Meph"}
\item \code{"Cigars, Little Cigars, or Cigarillos"}
\item \code{"Cocaine or Crack Cocaine"}
\item \code{"Concentrated Marijuana Tinctures"}
\item \code{"Ecstasy, Molly, or MDMA"}
\item \code{"Electronic Nicotine or Vaping Products"}
\item \code{"GHB, Liquid G, or Georgia Homeboy"}
\item \code{"Hallucinogen Drugs including LSD, PCP, Peyote, Mescaline, DMT, AMT, or Foxy"}
\item \code{"Heroin, Opium, Junk, Smack, or Dope"}
\item \code{"Hookah with Tobacco"}
\item \code{"Inhalants"}
\item \code{"Ketamine or Special K"}
\item \code{"Marijuana Edibles"}
\item \code{"Marijuana Infused Alcohol Drinks"}
\item \code{"Methamphetamine, Meth, or Crystal Meth"}
\item \code{"Nicotine Replacements"}
\item \code{"OTC Cough or Cold Medicine, DXM, 'Lean', or 'Purple Drank'"}
\item \code{"Prescription Anxiolytics, Tranquilizers, or Sedatives"}
\item \code{"Prescription Pain Relievers or Opioids"}
\item \code{"Prescription Stimulants"}
\item \code{"Psilocybin, Magic Mushrooms, or Shrooms"}
\item \code{"Salvia"}
\item \code{"Smokeless Tobacco, Chew, or Snus"}
\item \code{"Smoking Marijuana Flower"}
\item \code{"Smoking Marijuana Oils or Concentrates"}
\item \code{"Tobacco Cigarette"}
\item \code{"Tobacco in a Pipe"}
\item \code{"Vaped Marijuana Flower"}
\item \code{"Vaped Marijuana Oils or Concentrates"}
\item \code{"Marijuana (all forms)"}
\item \code{"Nicotine (all forms)"}
}

(Default: \code{NULL}, i.e., all substances are considered.)}

\item{period}{character (vector). The period for which the score is
computed for. Must be one of \code{"detailed"} (last year before date of TLFB
interview) or \code{"estimated"} (more than one year before date of TLFB).
(Default: \code{NULL}, i.e., all periods are considered). Cannot be used in
combination with \code{days}.}

\item{days}{integer. Number of days before the TLFB interview to consider.
(Default: \code{NULL}, i.e., all days are considered). Cannot be used in
combination with \code{period}.}

\item{binge}{(named list of) numeric. Binge threshold(s) for the
substance(s). If only one value is provided, it is used, independent of the
sex of the participant. If a list is provided, it must contain two named
elements: \code{"F"} (female) and \code{"M"} (male) with the respective sex-specific
binge thresholds. Only days where the the quantity of the substance(s)
exceeds the specified threshold(s) are considered. (Default: \code{NULL}, i.e.,
binge behavior is not considered).}
}
\value{
A tibble with the computed score for each participant/event.
}
\description{
Computes the length of abstinence in days for a given (set of)
substance(s). Optionally, allows to filter by period (detailed and/or
estimated); only considering a specified number of days before the TLFB
interview; and/or only binge use.
}
\examples{
\dontrun{
compute_tlfb_abst(
  data = data_tlfb,
  name = "su_y_tlfb__alc__cum_abst",
  substance = "Alcohol"
)
}
}
\keyword{datasets}
