/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.atomic;

import org.openscience.cdk.charges.Polarizability;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.qsar.AbstractAtomicDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IAtomicDescriptor;
import org.openscience.cdk.qsar.result.DoubleResult;
import org.openscience.cdk.qsar.result.IDescriptorResult;

public class EffectiveAtomPolarizabilityDescriptor
extends AbstractAtomicDescriptor
implements IAtomicDescriptor {
    private final Polarizability pol = new Polarizability();

    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#effectivePolarizability", ((Object)((Object)this)).getClass().getName(), "The Chemistry Development Kit");
    }

    public void setParameters(Object[] params) throws CDKException {
    }

    public Object[] getParameters() {
        return null;
    }

    public String[] getDescriptorNames() {
        return new String[]{"effAtomPol"};
    }

    public DescriptorValue calculate(IAtom atom, IAtomContainer ac) {
        try {
            String originalAtomtypeName = atom.getAtomTypeName();
            Integer originalNeighborCount = atom.getFormalNeighbourCount();
            Integer originalHCount = atom.getImplicitHydrogenCount();
            Integer originalValency = atom.getValency();
            IAtomType.Hybridization originalHybridization = atom.getHybridization();
            boolean originalFlag = atom.getFlag(16);
            Double originalBondOrderSum = atom.getBondOrderSum();
            IBond.Order originalMaxBondOrder = atom.getMaxBondOrder();
            double polarizability = this.pol.calculateGHEffectiveAtomPolarizability(ac, atom, 100, true);
            atom.setAtomTypeName(originalAtomtypeName);
            atom.setFormalNeighbourCount(originalNeighborCount);
            atom.setValency(originalValency);
            atom.setImplicitHydrogenCount(originalHCount);
            atom.setFlag(16, originalFlag);
            atom.setHybridization(originalHybridization);
            atom.setMaxBondOrder(originalMaxBondOrder);
            atom.setBondOrderSum(originalBondOrderSum);
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)new DoubleResult(polarizability), this.getDescriptorNames());
        }
        catch (Exception ex1) {
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)new DoubleResult(Double.NaN), this.getDescriptorNames(), ex1);
        }
    }

    public String[] getParameterNames() {
        return new String[0];
    }

    public Object getParameterType(String name) {
        return null;
    }
}

