/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.atomtype.mapper;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.openscience.cdk.config.atomtypes.OWLAtomTypeMappingReader;

public class AtomTypeMapper {
    private static final Map<String, AtomTypeMapper> mappers = new HashMap<String, AtomTypeMapper>();
    private final String mappingFile;
    private final Map<String, String> mappings;

    private AtomTypeMapper(String mappingFile) {
        this.mappingFile = mappingFile;
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream(mappingFile);
        OWLAtomTypeMappingReader reader = new OWLAtomTypeMappingReader(new InputStreamReader(stream));
        this.mappings = reader.readAtomTypeMappings();
    }

    private AtomTypeMapper(String mappingFile, InputStream stream) {
        this.mappingFile = mappingFile;
        OWLAtomTypeMappingReader reader = new OWLAtomTypeMappingReader(new InputStreamReader(stream));
        this.mappings = reader.readAtomTypeMappings();
    }

    public static AtomTypeMapper getInstance(String mappingFile) {
        if (!mappers.containsKey(mappingFile)) {
            mappers.put(mappingFile, new AtomTypeMapper(mappingFile));
        }
        return mappers.get(mappingFile);
    }

    public static AtomTypeMapper getInstance(String mappingFile, InputStream stream) {
        if (!mappers.containsKey(mappingFile)) {
            mappers.put(mappingFile, new AtomTypeMapper(mappingFile, stream));
        }
        return mappers.get(mappingFile);
    }

    public String mapAtomType(String type) {
        return this.mappings.get(type);
    }

    public String getMapping() {
        return this.mappingFile;
    }
}

