/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.rule;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.core.rule.ConditionalElement;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.Pattern;

public class Forall
extends ConditionalElement {
    private static final long serialVersionUID = 510L;
    private Pattern basePattern;
    private List<Pattern> remainingPatterns;
    private boolean emptyBetaConstraints;

    public Forall() {
        this(null, new ArrayList<Pattern>(1));
    }

    public Forall(Pattern basePattern) {
        this(basePattern, new ArrayList<Pattern>(1));
    }

    public Forall(Pattern basePattern, List<Pattern> remainingPatterns) {
        this.basePattern = basePattern;
        this.remainingPatterns = remainingPatterns;
        this.emptyBetaConstraints = false;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.basePattern = (Pattern)in.readObject();
        this.remainingPatterns = (List)in.readObject();
        this.emptyBetaConstraints = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.basePattern);
        out.writeObject(this.remainingPatterns);
        out.writeBoolean(this.emptyBetaConstraints);
    }

    @Override
    public Forall clone() {
        return new Forall(this.basePattern, new ArrayList<Pattern>(this.remainingPatterns));
    }

    @Override
    public Map<String, Declaration> getInnerDeclarations() {
        HashMap<String, Declaration> inner = new HashMap<String, Declaration>(this.basePattern.getOuterDeclarations());
        for (Pattern pattern : this.remainingPatterns) {
            inner.putAll(pattern.getOuterDeclarations());
        }
        return inner;
    }

    @Override
    public Map<String, Declaration> getOuterDeclarations() {
        return Collections.EMPTY_MAP;
    }

    @Override
    public Declaration resolveDeclaration(String identifier) {
        return this.getInnerDeclarations().get(identifier);
    }

    public Pattern getBasePattern() {
        return this.basePattern;
    }

    public void setBasePattern(Pattern basePattern) {
        this.basePattern = basePattern;
    }

    public List<Pattern> getRemainingPatterns() {
        return this.remainingPatterns;
    }

    public void setRemainingPatterns(List<Pattern> remainingPatterns) {
        this.remainingPatterns = remainingPatterns;
    }

    public void addRemainingPattern(Pattern pattern) {
        this.remainingPatterns.add(pattern);
    }

    public List<Pattern> getNestedElements() {
        ArrayList<Pattern> elements = new ArrayList<Pattern>(1 + this.remainingPatterns.size());
        elements.add(this.basePattern);
        elements.addAll(this.remainingPatterns);
        return elements;
    }

    @Override
    public boolean isPatternScopeDelimiter() {
        return true;
    }

    public boolean isEmptyBetaConstraints() {
        return this.emptyBetaConstraints;
    }

    public void setEmptyBetaConstraints(boolean emptyBetaConstraints) {
        this.emptyBetaConstraints = emptyBetaConstraints;
    }

    public String toString() {
        return "forall( " + this.basePattern + " " + this.remainingPatterns + " )";
    }
}

