/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.rules.ZeroR;
import weka.core.Capabilities;
import weka.core.Option;
import weka.core.Utils;

public abstract class SingleClassifierEnhancer
extends Classifier {
    private static final long serialVersionUID = -3665885256363525164L;
    protected Classifier m_Classifier = new ZeroR();

    protected String defaultClassifierString() {
        return "weka.classifiers.rules.ZeroR";
    }

    @Override
    public Enumeration listOptions() {
        Vector newVector = new Vector(3);
        Enumeration enu = super.listOptions();
        while (enu.hasMoreElements()) {
            newVector.addElement(enu.nextElement());
        }
        newVector.addElement(new Option("\tFull name of base classifier.\n\t(default: " + this.defaultClassifierString() + ")", "W", 1, "-W"));
        newVector.addElement(new Option("", "", 0, "\nOptions specific to classifier " + this.m_Classifier.getClass().getName() + ":"));
        enu = this.m_Classifier.listOptions();
        while (enu.hasMoreElements()) {
            newVector.addElement(enu.nextElement());
        }
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        super.setOptions(options);
        String classifierName = Utils.getOption('W', options);
        if (classifierName.length() > 0) {
            this.setClassifier(Classifier.forName(classifierName, null));
            this.setClassifier(Classifier.forName(classifierName, Utils.partitionOptions(options)));
        } else {
            this.setClassifier(Classifier.forName(this.defaultClassifierString(), null));
            this.setClassifier(Classifier.forName(this.defaultClassifierString(), Utils.partitionOptions(options)));
        }
    }

    @Override
    public String[] getOptions() {
        String[] classifierOptions = this.m_Classifier.getOptions();
        int extraOptionsLength = classifierOptions.length;
        if (extraOptionsLength > 0) {
            ++extraOptionsLength;
        }
        String[] superOptions = super.getOptions();
        String[] options = new String[superOptions.length + extraOptionsLength + 2];
        int current = 0;
        options[current++] = "-W";
        options[current++] = this.getClassifier().getClass().getName();
        System.arraycopy(superOptions, 0, options, current, superOptions.length);
        current += superOptions.length;
        if (classifierOptions.length > 0) {
            options[current++] = "--";
            System.arraycopy(classifierOptions, 0, options, current, classifierOptions.length);
        }
        return options;
    }

    public String classifierTipText() {
        return "The base classifier to be used.";
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result;
        if (this.getClassifier() != null) {
            result = this.getClassifier().getCapabilities();
        } else {
            result = new Capabilities(this);
            result.disableAll();
        }
        Capabilities.Capability[] capabilityArray = Capabilities.Capability.values();
        int n = capabilityArray.length;
        int n2 = 0;
        while (n2 < n) {
            Capabilities.Capability cap = capabilityArray[n2];
            result.enableDependency(cap);
            ++n2;
        }
        result.setOwner(this);
        return result;
    }

    public void setClassifier(Classifier newClassifier) {
        this.m_Classifier = newClassifier;
    }

    public Classifier getClassifier() {
        return this.m_Classifier;
    }

    protected String getClassifierSpec() {
        Classifier c = this.getClassifier();
        return String.valueOf(c.getClass().getName()) + " " + Utils.joinOptions(c.getOptions());
    }
}

