#!/usr/bin/perl

use strict;
use warnings;

use Catmandu::Importer::MARC;
use MARC::File::USMARC;
use Test::Simple tests => 4;

my $data = join("",<DATA>);

my $importer = Catmandu::Importer::MARC->new(
    file => \$data,
    type => "ISO"
);
my $records = $importer->to_array();

ok( @$records == 10, 'got all records' );
ok( $records->[0]->{'_id'}             eq 'fol05731351 ', 'got _id' );
ok( $records->[0]->{'record'}->[1][-1] eq 'fol05731351 ', 'got subfield' );
ok( $records->[0]->{'_id'} eq $records->[0]->{'record'}->[1][-1],
    '_id matches record id' );

__DATA__
00755cam  22002414a 4500001001300000003000600013005001700019008004100036010001700077020004300094040001800137042000800155050002600163082001700189100003100206245005400237260004200291300007200333500003300405650003700438630002500475630001300500fol05731351 IMchF20000613133448.0000107s2000    nyua          001 0 eng    a   00020737   a0471383147 (paper/cd-rom : alk. paper)  aDLCcDLCdDLC  apcc00aQA76.73.P22bM33 200000a005.13/32211 aMartinsson, Tobias,d1976-10aActivePerl with ASP and ADO /cTobias Martinsson.  aNew York :bJohn Wiley & Sons,c2000.  axxi, 289 p. :bill. ;c23 cm. +e1 computer  laser disc (4 3/4 in.)  a"Wiley Computer Publishing." 0aPerl (Computer program language)00aActive server pages.00aActiveX.00647pam  2200241 a 4500001001300000003000600013005001700019008004100036010001700077020001500094040001800109042000800127050002600135082001500161100002600176245006700202260003800269263000900307300001100316650003700327650002500364700001600389fol05754809 IMchF20000601115601.0000203s2000    mau           001 0 eng    a   00022023   a1565926994  aDLCcDLCdDLC  apcc00aQA76.73.P22bD47 200000a005.742211 aDescartes, Alligator.10aProgramming the Perl DBI /cAlligator Descartes and Tim Bunce.  aCmabridge, MA :bO'Reilly,c2000.  a1111  ap. cm. 0aPerl (Computer program language) 0aDatabase management.1 aBunce, Tim.00605cam  22002054a 4500001001300000003000600013005001700019008004100036010001700077040001800094042000800112050002700120082001700147100002100164245005500185260004500240300002600285504005100311650003700362fol05843555 IMchF20000525142739.0000318s1999    cau      b    001 0 eng    a   00501349   aDLCcDLCdDLC  apcc00aQA76.73.P22bB763 199900a005.13/32211 aBrown, Martin C.10aPerl :bprogrammer's reference /cMartin C. Brown.  aBerkeley :bOsborne/McGraw-Hill,cc1999.  axix, 380 p. ;c22 cm.  aIncludes bibliographical references and index. 0aPerl (Computer program language)00579cam  22002054a 4500001001300000003000600013005001700019008004100036010001700077020001500094040001800109042000800127050002700135082001700162100002100179245005500200260004500255300003600300650003700336fol05843579 IMchF20000525142716.0000318s1999    caua          001 0 eng    a   00502116   a0072120002  aDLCcDLCdDLC  apcc00aQA76.73.P22bB762 199900a005.13/32211 aBrown, Martin C.10aPerl :bthe complete reference /cMartin C. Brown.  aBerkeley :bOsborne/McGraw-Hill,cc1999.  axxxv, 1179 p. :bill. ;c24 cm. 0aPerl (Computer program language)00801nam  22002778a 4500001001300000003000600013005001700019008004100036010001700077020001500094040001300109042000800122050002600130082001800156100002000174245008800194250003200282260004100314263000900355300001100364650003700375650003600412650002600448700002500474700002400499fol05848297 IMchF20000524125727.0000518s2000    mau           001 0 eng    a   00041664   a1565924193  aDLCcDLC  apcc00aQA76.73.P22bG84 200000a005.2/7622211 aGuelich, Scott.10aCGI programming with Perl /cScott Guelich, Shishir Gundavaram & Gunther Birznieks.  a2nd ed., expanded & updated  aCambridge, Mass. :bO'Reilly,c2000.  a0006  ap. cm. 0aPerl (Computer program language) 0aCGI (Computer network protocol) 0aInternet programming.1 aGundavaram, Shishir.1 aBirznieks, Gunther.00665nam  22002298a 4500001001300000003000600013005001700019008004100036010001700077020001500094040001300109042000800122050002700130082001700157111005200174245008600226250001200312260004100324263000900365300001100374650005000385fol05865950 IMchF20000615103017.0000612s2000    mau           100 0 eng    a   00055759   a0596000138  aDLCcDLC  apcc00aQA76.73.P22bP475 200000a005.13/32212 aPerl Conference 4.0d(2000 :cMonterey, Calif.)10aProceedings of the Perl Conference 4.0 :bJuly 17-20, 2000, Monterey, California.  a1st ed.  aCambridge, Mass. :bO'Reilly,c2000.  a0006  ap. cm. 0aPerl (Computer program language)vCongresses.00579nam  22002178a 4500001001300000003000600013005001700019008004100036010001700077020001500094040001300109042000800122050002600130082001700156100002800173245006200201260004100263263000900304300001100313650003700324fol05865956 IMchF20000615102948.0000612s2000    mau           000 0 eng    a   00055770   a1565926099  aDLCcDLC  apcc00aQA76.73.P22bB43 200000a005.13/32211 aBlank-Edelman, David N.10aPerl for system administration /cDavid N. Blank-Edelman.  aCambridge, Mass. :bO'Reilly,c2000.  a0006  ap. cm. 0aPerl (Computer program language)00661nam  22002538a 4500001001300000003000600013005001700019008004100036010001700077020001500094040001300109042000800122050002600130082001700156100001700173245006700190250001200257260004100269263000900310300001100319650003700330700002300367700001700390fol05865967 IMchF20000615102611.0000614s2000    mau           000 0 eng    a   00055799   a0596000278  aDLCcDLC  apcc00aQA76.73.P22bW35 200000a005.13/32211 aWall, Larry.10aProgramming Perl /cLarry Wall, Tom Christiansen & Jon Orwant.  a3rd ed.  aCambridge, Mass. :bO'Reilly,c2000.  a0007  ap. cm. 0aPerl (Computer program language)1 aChristiansen, Tom.1 aOrwant, Jon.00603cam  22002054a 4500001001300000003000600013005001700019008004100036010001700077020001500094040001800109042000800127050002600135082001700161100003200178245006000210260005700270300003300327650003700360fol05872355 IMchF20000706095105.0000315s1999    njua          001 0 eng    a   00500678   a013020868X  aDLCcDLCdDLC  apcc00aQA76.73.P22bL69 199900a005.13/32211 aLowe, Vincentq(Vincent D.)10aPerl programmer's interactive workbook /cVincent Lowe.  aUpper Saddle River, NJ :bPrentice Hall PTP,cc1999.  axx, 633 p. :bill. ;c23 cm. 0aPerl (Computer program language)00696nam  22002538a 4500001001300000003000600013005001700019008004100036010001700077020002800094040001300122042000800135050002600143082001700169100002600186245004400212260005100256263000900307300001100316500002000327650003700347650001700384650004100401fol05882032 IMchF20000707091904.0000630s2000    cau           001 0 eng    a   00058174   a0764547291 (alk. paper)  aDLCcDLC  apcc00aQA76.73.P22bF64 200000a005.13/32212 aFoster-Johnson, Eric.10aCross-platform Perl /cEric F. Johnson.  aFoster City, CA :bIDG Books Worldwide,c2000.  a0009  ap. cm.  aIncludes index. 0aPerl (Computer program language) 0aWeb servers. 0aCross-platform software development.
