package HashData::Color::CMYK::ToutesLesCouleursCom::Blue;

use strict;
use Role::Tiny::With;
with 'HashDataRole::Source::LinesInDATA';
#with 'Role::TinyCommons::Collection::FindItem::Iterator';         # add find_item() (has_item already added above)
#with 'Role::TinyCommons::Collection::PickItems::RandomSeekLines'; # add pick_items() that uses binary search

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2024-05-06'; # DATE
our $DIST = 'HashData-Color-CMYK-ToutesLesCouleursCom'; # DIST
our $VERSION = '0.001'; # VERSION

# STATS

1;
# ABSTRACT: Blue CMYK color names (from ToutesLesCouleursCom)

=pod

=encoding UTF-8

=head1 NAME

HashData::Color::CMYK::ToutesLesCouleursCom::Blue - Blue CMYK color names (from ToutesLesCouleursCom)

=head1 VERSION

This document describes version 0.001 of HashData::Color::CMYK::ToutesLesCouleursCom::Blue (from Perl distribution HashData-Color-CMYK-ToutesLesCouleursCom), released on 2024-05-06.

=head1 DESCRIPTION

CMKY value are in this format: I<C>,I<M>,I<Y>,I<K>. Where each C/M/Y/K value is
an integer from 0 to 100.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/HashData-Color-CMYK-ToutesLesCouleursCom>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-HashData-Color-CMYK-ToutesLesCouleursCom>.

=head1 SEE ALSO

Source: L<https://www.toutes-les-couleurs.com/en/CMYK-color-code.php>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2024 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=HashData-Color-CMYK-ToutesLesCouleursCom>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut

__DATA__
blue:100,100,0,0
aquamarine:51,0,0,3
blue:100,50,0,0
blue:85,37,0,20
clear blue:52,14,0,5
azurin:33,52,0,0
steel blue:69,24,0,27
slate blue:26,21,0,45
cornflower blue:52,34,0,32
blue cornflower:52,34,0,32
blue jumped:100,18,0,29
heavenly blue:84,17,0,7
cerulean:94,32,0,9
cerulean blue:71,33,0,28
blue wagon:28,18,0,22
wheelwright blue:82,19,0,51
wheelwright blue:28,18,0,22
blue sky:53,29,0,0
cobalt blue:73,47,0,51
berlin blue:61,26,0,64
bleu de france:79,39,0,9
midnight blue:100,50,0,60
prussian blue:61,26,0,64
denim blue:96,56,0,0
blue south sea:100,0,0,20
lozenge blue:13,5,0,0
egyptian blue:90,69,0,35
electric blue:83,54,0,0
blue woad:44,25,0,40
blue horizon:23,14,0,35
majorelle blue:56,64,0,14
navy:96,55,0,70
maya blue:54,23,0,2
mineral blue:61,26,0,64
midnight blue:86,95,0,58
ultramarine:100,100,2,3
ultramarine:72,100,0,40
peacock:96,17,0,44
persian blue:60,100,0,0
oil blue:64,11,0,68
royal blue:79,39,0,9
sapphire blue:99,73,0,29
teal:100,0,0,44
smalt blue:100,67,0,40
tiffany blue:74,5,38,0
turquin blue:52,34,0,46
caeruleum:84,17,0,7
duck:97,10,0,40
cerulean:52,14,0,5
cyan:52,0,13,0
cyan:83,0,0,2
fumes:17,7,0,12
frosted:38,0,0,18
indigo:51,89,0,3
indigo:57,100,0,58
indigo web:42,100,0,49
klein 1:100,87,0,0
klein 2:74,82,0,51
lapis lazuli:76,38,0,39
lavender:36,44,0,7
pastel:44,25,0,40
pervenche:20,20,0,0
turquoise:85,0,8,1
