package Graphics::ColorNamesCMYK::ToutesLesCouleursCom::Green;

use strict;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2024-05-06'; # DATE
our $DIST = 'Graphics-ColorNamesCMYK-ToutesLesCouleursCom'; # DIST
our $VERSION = '0.001'; # VERSION

our $NAMES_CMYK_TABLE = {
  'green' => 0x64006400, # 100,0,100,0
  'aquamarine' => 0x33000003, # 51,0,0,3
  'asparagus' => 0x17002b25, # 23,0,43,37
  'teal' => 0x6400002c, # 100,0,0,44
  'duck' => 0x610a0028, # 97,10,0,40
  'celadon' => 0x15000923, # 21,0,9,35
  'frosted' => 0x26000012, # 38,0,0,18
  'murky' => 0x23000c27, # 35,0,12,39
  'hooker' => 0x42005a45, # 66,0,90,69
  'jade' => 0x2a002609, # 42,0,38,9
  'khaki' => 0x000d472a, # 0,13,71,42
  'peppermint' => 0x58003a1c, # 88,0,58,28
  'water mint' => 0x42002b02, # 66,0,43,2
  'sinople' => 0x5600562a, # 86,0,86,42
  'turquoise' => 0x55000801, # 85,0,8,1
  'vert absinthe' => 0x2b00420d, # 43,0,66,13
  'green almond' => 0x22002d17, # 34,0,45,23
  'english green' => 0x3a002f4e, # 58,0,47,78
  'anise green' => 0x25005c00, # 37,0,92,0
  'green lawyer' => 0x22006231, # 34,0,98,49
  'green bottle' => 0x5c005c3a, # 92,0,92,58
  'green chartreuse' => 0x15005003, # 21,0,80,3
  'lime' => 0x64006400, # 100,0,100,0
  'chrome green' => 0x3a002f4e, # 58,0,47,78
  'verdigris' => 0x0a000a23, # 10,0,10,35
  'sap green' => 0x48005835, # 72,0,88,53
  'green water' => 0x1b001905, # 27,0,25,5
  'emerald green' => 0x64003b10, # 100,0,59,16
  'green empire' => 0x64004542, # 100,0,69,66
  'green spinach' => 0x29000045, # 41,0,0,69
  'green grass' => 0x3f004e26, # 63,0,78,38
  'green imperial' => 0x64004542, # 100,0,69,66
  'green khaki' => 0x0c003f2e, # 12,0,63,46
  'lichen green' => 0x1f002318, # 31,0,35,24
  'lime green' => 0x26004e01, # 38,0,78,1
  'malachite green' => 0x51002f25, # 81,0,47,37
  'larch green' => 0x32002338, # 50,0,35,56
  'military green' => 0x0d00223c, # 13,0,34,60
  'moss' => 0x23002b26, # 35,0,43,38
  'olive' => 0x15004b2d, # 21,0,75,45
  'green opaline' => 0x20000b0d, # 32,0,11,13
  'green parrot' => 0x4c004505, # 76,0,69,5
  'pine green' => 0x63000835, # 99,0,8,53
  'pistachio green' => 0x16003504, # 22,0,53,4
  'green leek' => 0x36002423, # 54,0,36,35
  'apple green' => 0x4a005215, # 74,0,82,21
  'green meadow' => 0x3b004810, # 59,0,72,16
  'green prasin' => 0x36002423, # 54,0,36,35
  'spring green' => 0x64003200, # 100,0,50,0
  'forest green' => 0x59003344, # 89,0,51,68
  'sage green' => 0x22001c26, # 34,0,28,38
  'green smaragdin' => 0x64003b10, # 100,0,59,16
  'green lime' => 0x15003d12, # 21,0,61,18
  'veronese green' => 0x15003b38, # 21,0,59,56
  'viride green' => 0x33001031, # 51,0,16,49
};


1;
# ABSTRACT: CMYK colors from http://toutes-les-couleurs.com/ (green)

__END__

=pod

=encoding UTF-8

=head1 NAME

Graphics::ColorNamesCMYK::ToutesLesCouleursCom::Green - CMYK colors from http://toutes-les-couleurs.com/ (green)

=head1 VERSION

This document describes version 0.001 of Graphics::ColorNamesCMYK::ToutesLesCouleursCom::Green (from Perl distribution Graphics-ColorNamesCMYK-ToutesLesCouleursCom), released on 2024-05-06.

=head1 DESCRIPTION

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Graphics-ColorNamesCMYK-ToutesLesCouleursCom>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Graphics-ColorNamesCMYK-ToutesLesCouleursCom>.

=head1 SEE ALSO

Other C<Graphics::ColorNamesCMYK::ToutesLesCoulersCom::*> modules.

Other C<Graphics::ColorNamesCMYK::*> modules.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2024 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Graphics-ColorNamesCMYK-ToutesLesCouleursCom>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
