# Generated by default/object.tt
package Paws::PersonalizeEvents::User;
  use Moose;
  has Properties => (is => 'ro', isa => 'Str', request_name => 'properties', traits => ['NameInRequest']);
  has UserId => (is => 'ro', isa => 'Str', request_name => 'userId', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::PersonalizeEvents::User

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::PersonalizeEvents::User object:

  $service_obj->Method(Att1 => { Properties => $value, ..., UserId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::PersonalizeEvents::User object:

  $result = $service_obj->Method(...);
  $result->Att1->Properties

=head1 DESCRIPTION

Represents user metadata added to a Users dataset using the C<PutUsers>
API. For more information see Importing Users Incrementally
(https://docs.aws.amazon.com/personalize/latest/dg/importing-users.html).

=head1 ATTRIBUTES


=head2 Properties => Str

A string map of user-specific metadata. Each element in the map
consists of a key-value pair. For example, C<{"numberOfVideosWatched":
"45"}>.

The keys use camel case names that match the fields in the schema for
the Users dataset. In the previous example, the
C<numberOfVideosWatched> matches the 'NUMBER_OF_VIDEOS_WATCHED' field
defined in the Users schema. For categorical string data, to include
multiple categories for a single user, separate each category with a
pipe separator (C<|>). For example, C<\"Member|Frequent shopper\">.


=head2 B<REQUIRED> UserId => Str

The ID associated with the user.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::PersonalizeEvents>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

