package App::InteractivePerlTutorial::Chapter::IO::STDOUT;

use 5.014000;
use strict;
use warnings;
our $VERSION = '0.000_001';

use constant TEXT => 'Standard Output';

1;
__DATA__

=encoding utf-8

=head1 Writing to the standard output

Let's analyse the outcome of using the print operator on an array.

E<bull> C<< @array = qw/one two three/ >>.

C<print @array> will print C<onetwothree>

C<print "@array"> will print C<one two three>

E<bull> C<< @array = ("one\n", "two\n", "three\n")

C<print @array> will print

  one
  two
  three

C<print "@array">

  one
   two
   three

Since print is looking for a list of strings to print, it evaluates its arguments in list context. Since the diamond operator (as a special kind of line-input operator) returns a list of lines in a list context, these can work well together:

print <>;         # source code for 'cat'

print sort <>;    # source code for 'sort'

B<Remember> If used with parentheses print acts like a B<function call> (besides printing the result it will also return 1 or 0). Otherwise print is a list operator, printing all of the items in the following list.


=cut
