package Acme::CPANAuthors::CPAN::Streaks::MonthlyReleases;

use strict;
use warnings;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2023-11-25'; # DATE
our $DIST = 'Acme-CPANAuthorsBundle-CPAN-Streaks'; # DIST
our $VERSION = '20231120.0'; # VERSION

use Acme::CPANAuthors::Register (
    'BINGOS' => '',
    'ETHER' => '',
    'LEEJO' => '',
    'IVANWILLS' => '',
    'PERLANCAR' => '',
    'PEVANS' => '',
    'UTASHIRO' => '',
    'OALDERS' => '',
    'KIMOTO' => '',
    'OLIVER' => '',
    'SKIM' => '',
    'DERF' => '',
    'JDEGUEST' => '',
    'LEONT' => '',
    'NHORNE' => '',
    'KUERBIS' => '',
    'BDFOY' => '',
    'HMBRAND' => '',
    'JIMAVERA' => '',
    'ASPOSE' => '',
    'DJERIUS' => '',
    'JAVONET' => '',
    'DDUMONT' => '',
    'DRCLAW' => '',
    'JV' => '',
    'VVELOX' => '',
    'DAVECROSS' => '',
    'HANJE' => '',
    'AJNN' => '',
    'DCANTRELL' => '',
    'PROCH' => '',
    'TIMLEGGE' => '',
    'TURNERJW' => '',
    'CORION' => '',
    'MARKOV' => '',
    'SISYPHUS' => '',
    'DDICK' => '',
    'LICHTKIND' => '',
    'NERDVANA' => '',
    'RAWLEYFOW' => '',
    'ABALAMA' => '',
    'BODOLFO' => '',
    'CADE' => '',
    'GARU' => '',
    'KHEDIN' => '',
    'SHLOMIF' => '',
    'SKAJI' => '',
    'WATERKIP' => '',
    'BLIAKO' => '',
    'BURAK' => '',
    'CUKEBOT' => '',
    'DROLSKY' => '',
    'GRYPHON' => '',
    'LNATION' => '',
    'NLNETLABS' => '',
    'TEAM' => '',
    'YANICK' => '',
    'ABRAXXA' => '',
    'DKECHAG' => '',
    'EXODIST' => '',
    'MLEHMANN' => '',
    'PREACTION' => '',
    'TORBIAK' => '',
    'WYANT' => '',
    'BPS' => '',
    'DART' => '',
    'FASTLY' => '',
    'JKEENAN' => '',
    'PJACKLAM' => '',
    'PRBRENAN' => '',
    'RKAPL' => '',
    'SRI' => '',
    'BIGPRESH' => '',
    'DEPESZ' => '',
    'FKENTO' => '',
    'HIROSE' => '',
    'JCRISTY' => '',
    'KARASIK' => '',
    'LANODAN' => '',
    'MBRADSHAW' => '',
    'MERKYS' => '',
    'MRUEDA' => '',
    'RJET' => '',
    'SANKO' => '',
    'SCHROEDER' => '',
    'SLAFFAN' => '',
    'TEODESIAN' => '',
    'ZHMYLOVE' => '',
    'ABELTJE' => '',
    'BIGFOOT' => '',
    'BRAINBUZ' => '',
    'CCELSO' => '',
    'DUMB' => '',
    'EINHVERFR' => '',
    'GENE' => '',
    'GIBUS' => '',
    'HOCHSTEN' => '',
    'JGNI' => '',
    'JJATRIA' => '',
    'JRM' => '',
    'KAZEBURO' => '',
    'LION' => '',
    'NALOBIN' => '',
    'NKH' => '',
    'REFECO' => '',
    'RKELSCH' => '',
    'RRWO' => '',
    'SREZIC' => '',
    'SUKRIA' => '',
    'TANIGUCHI' => '',
    'TRIZEN' => '',
    'YANGAK' => '',
    'ZMUGHAL' => '',
    'AAHAZRED' => '',
    'AKHUETTEL' => '',
    'BAKERSCOT' => '',
    'BAYASHI' => '',
    'BINARY' => '',
    'BOGDRO' => '',
    'BRTASTIC' => '',
    'CHEVALIER' => '',
    'CONKLIN' => '',
    'CROMEDOME' => '',
    'DAKKAR' => '',
    'DAM' => '',
    'DBOOK' => '',
    'DVEEDEN' => '',
    'GBROWN' => '',
    'GEEKRUTH' => '',
    'GSG' => '',
    'GUGOD' => '',
    'GUILLEM' => '',
    'HAARG' => '',
    'JHTHORSEN' => '',
    'JJNAPIORK' => '',
    'JLOUDER' => '',
    'JMATES' => '',
    'JSF' => '',
    'JUERD' => '',
    'LEMBARK' => '',
    'LITTLEFOX' => '',
    'LSTEVENS' => '',
    'LSTROUS' => '',
    'MAROS' => '',
    'MAXMIND' => '',
    'MICKEY' => '',
    'MIK' => '',
    'MPOURASG' => '',
    'NEILB' => '',
    'NICOMEN' => '',
    'OETIKER' => '',
    'PATJOL' => '',
    'PERLSRVDE' => '',
    'PETDANCE' => '',
    'REEDFISH' => '',
    'REICHERT' => '',
    'RENEEB' => '',
    'RSAVAGE' => '',
    'RWSTAUNER' => '',
    'SCHUBIGER' => '',
    'SCOTTH' => '',
    'SHAY' => '',
    'SIMBABQUE' => '',
    'SPRAGL' => '',
    'SUMAN' => '',
    'TODDR' => '',
    'VOLKENING' => '',
    'WIEGEROP' => '',
    'YTURTLE' => '',
    'ATKACH' => '',
    'BORISD' => '',
    'BORISV' => '',
    'CGPAN' => '',
    'CRORAA' => '',
    'DAMI' => '',
    'DANBERR' => '',
    'DANKOGAI' => '',
    'DCHURCH' => '',
    'DCONWAY' => '',
    'DERIV' => '',
    'DORNER' => '',
    'DTUCKWELL' => '',
    'EHUELS' => '',
    'ETJ' => '',
    'EXIFTOOL' => '',
    'FSEITZ' => '',
    'GAHAYES' => '',
    'GDT' => '',
    'GNUSTAVO' => '',
    'GRAY' => '',
    'GWILLIAMS' => '',
    'JMASLAK' => '',
    'JOYREX' => '',
    'LANCEW' => '',
    'LSKATZ' => '',
    'MAMAWE' => '',
    'MBARBON' => '',
    'MDOOTSON' => '',
    'MIKKOI' => '',
    'OODLER' => '',
    'PLAIN' => '',
    'PMB' => '',
    'RBAIRWELL' => '',
    'ROBM' => '',
    'RSCHUPP' => '',
    'RWF' => '',
    'RWI' => '',
    'SGRAY' => '',
    'SHOGO' => '',
    'SIMCOP' => '',
    'STRAKA' => '',
    'SULLR' => '',
    'SVW' => '',
    'TINITA' => '',
    'TONYC' => '',
    'TOSHIOITO' => '',
    'TROTH' => '',
    'VOEGELAS' => '',
    'WHOM' => '',
    'WOUTER' => '',
    'XAVIERH' => '',
);

1;
# ABSTRACT: Authors with ongoing monthly releases streak (do a release every month)

__END__

=pod

=encoding UTF-8

=head1 NAME

Acme::CPANAuthors::CPAN::Streaks::MonthlyReleases - Authors with ongoing monthly releases streak (do a release every month)

=head1 VERSION

This document describes version 20231120.0 of Acme::CPANAuthors::CPAN::Streaks::MonthlyReleases (from Perl distribution Acme-CPANAuthorsBundle-CPAN-Streaks), released on 2023-11-25.

=head1 SYNOPSIS

=head1 DESCRIPTION

Current standings (as of 2023-11-20, produced by L<cpan-streaks>):

 % cpan-streaks calculate monthly-releases
 | author    | len | start_date | status      |
 |-----------+-----+------------+-------------|
 | BINGOS    | 212 | 2006-03    | might-break |
 | ETHER     | 141 | 2012-03    | ongoing     |
 | LEEJO     | 116 | 2014-04    | ongoing     |
 | IVANWILLS | 114 | 2014-05    | might-break |
 | PERLANCAR | 112 | 2014-08    | ongoing     |
 | PEVANS    |  66 | 2018-06    | ongoing     |
 | UTASHIRO  |  66 | 2018-06    | ongoing     |
 | OALDERS   |  51 | 2019-08    | might-break |
 | KIMOTO    |  24 | 2021-12    | ongoing     |
 | OLIVER    |  22 | 2022-02    | ongoing     |
 | SKIM      |  20 | 2022-04    | ongoing     |
 | DERF      |  18 | 2022-06    | ongoing     |
 | JDEGUEST  |  18 | 2022-06    | ongoing     |
 | LEONT     |  14 | 2022-10    | ongoing     |
 | NHORNE    |  12 | 2022-12    | ongoing     |
 | KUERBIS   |  11 | 2022-12    | might-break |
 | BDFOY     |  11 | 2023-01    | ongoing     |
 | HMBRAND   |  11 | 2023-01    | ongoing     |
 | JIMAVERA  |  11 | 2023-01    | ongoing     |
 | ASPOSE    |  10 | 2023-02    | ongoing     |
 | DJERIUS   |   9 | 2023-03    | ongoing     |
 | JAVONET   |   7 | 2023-04    | might-break |
 | DDUMONT   |   7 | 2023-05    | ongoing     |
 | DRCLAW    |   7 | 2023-05    | ongoing     |
 | JV        |   7 | 2023-05    | ongoing     |
 | VVELOX    |   7 | 2023-05    | ongoing     |
 | DAVECROSS |   6 | 2023-05    | might-break |
 | HANJE     |   6 | 2023-05    | might-break |
 | AJNN      |   6 | 2023-06    | ongoing     |
 | DCANTRELL |   6 | 2023-06    | ongoing     |
 | PROCH     |   6 | 2023-06    | ongoing     |
 | TIMLEGGE  |   6 | 2023-06    | ongoing     |
 | TURNERJW  |   6 | 2023-06    | ongoing     |
 | CORION    |   5 | 2023-06    | might-break |
 | MARKOV    |   5 | 2023-06    | might-break |
 | SISYPHUS  |   5 | 2023-06    | might-break |
 | DDICK     |   5 | 2023-07    | ongoing     |
 | LICHTKIND |   5 | 2023-07    | ongoing     |
 | NERDVANA  |   5 | 2023-07    | ongoing     |
 | RAWLEYFOW |   5 | 2023-07    | ongoing     |
 | ABALAMA   |   4 | 2023-07    | might-break |
 | BODOLFO   |   4 | 2023-07    | might-break |
 | CADE      |   4 | 2023-07    | might-break |
 | GARU      |   4 | 2023-07    | might-break |
 | KHEDIN    |   4 | 2023-07    | might-break |
 | SHLOMIF   |   4 | 2023-07    | might-break |
 | SKAJI     |   4 | 2023-07    | might-break |
 | WATERKIP  |   4 | 2023-07    | might-break |
 | BLIAKO    |   4 | 2023-08    | ongoing     |
 | BURAK     |   4 | 2023-08    | ongoing     |
 | CUKEBOT   |   4 | 2023-08    | ongoing     |
 | DROLSKY   |   4 | 2023-08    | ongoing     |
 | GRYPHON   |   4 | 2023-08    | ongoing     |
 | LNATION   |   4 | 2023-08    | ongoing     |
 | NLNETLABS |   4 | 2023-08    | ongoing     |
 | TEAM      |   4 | 2023-08    | ongoing     |
 | YANICK    |   4 | 2023-08    | ongoing     |
 | ABRAXXA   |   3 | 2023-08    | might-break |
 | DKECHAG   |   3 | 2023-08    | might-break |
 | EXODIST   |   3 | 2023-08    | might-break |
 | MLEHMANN  |   3 | 2023-08    | might-break |
 | PREACTION |   3 | 2023-08    | might-break |
 | TORBIAK   |   3 | 2023-08    | might-break |
 | WYANT     |   3 | 2023-08    | might-break |
 | BPS       |   3 | 2023-09    | ongoing     |
 | DART      |   3 | 2023-09    | ongoing     |
 | FASTLY    |   3 | 2023-09    | ongoing     |
 | JKEENAN   |   3 | 2023-09    | ongoing     |
 | PJACKLAM  |   3 | 2023-09    | ongoing     |
 | PRBRENAN  |   3 | 2023-09    | ongoing     |
 | RKAPL     |   3 | 2023-09    | ongoing     |
 | SRI       |   3 | 2023-09    | ongoing     |
 | BIGPRESH  |   2 | 2023-09    | might-break |
 | DEPESZ    |   2 | 2023-09    | might-break |
 | FKENTO    |   2 | 2023-09    | might-break |
 | HIROSE    |   2 | 2023-09    | might-break |
 | JCRISTY   |   2 | 2023-09    | might-break |
 | KARASIK   |   2 | 2023-09    | might-break |
 | LANODAN   |   2 | 2023-09    | might-break |
 | MBRADSHAW |   2 | 2023-09    | might-break |
 | MERKYS    |   2 | 2023-09    | might-break |
 | MRUEDA    |   2 | 2023-09    | might-break |
 | RJET      |   2 | 2023-09    | might-break |
 | SANKO     |   2 | 2023-09    | might-break |
 | SCHROEDER |   2 | 2023-09    | might-break |
 | SLAFFAN   |   2 | 2023-09    | might-break |
 | TEODESIAN |   2 | 2023-09    | might-break |
 | ZHMYLOVE  |   2 | 2023-09    | might-break |
 | ABELTJE   |   2 | 2023-10    | ongoing     |
 | BIGFOOT   |   2 | 2023-10    | ongoing     |
 | BRAINBUZ  |   2 | 2023-10    | ongoing     |
 | CCELSO    |   2 | 2023-10    | ongoing     |
 | DUMB      |   2 | 2023-10    | ongoing     |
 | EINHVERFR |   2 | 2023-10    | ongoing     |
 | GENE      |   2 | 2023-10    | ongoing     |
 | GIBUS     |   2 | 2023-10    | ongoing     |
 | HOCHSTEN  |   2 | 2023-10    | ongoing     |
 | JGNI      |   2 | 2023-10    | ongoing     |
 | JJATRIA   |   2 | 2023-10    | ongoing     |
 | JRM       |   2 | 2023-10    | ongoing     |
 | KAZEBURO  |   2 | 2023-10    | ongoing     |
 | LION      |   2 | 2023-10    | ongoing     |
 | NALOBIN   |   2 | 2023-10    | ongoing     |
 | NKH       |   2 | 2023-10    | ongoing     |
 | REFECO    |   2 | 2023-10    | ongoing     |
 | RKELSCH   |   2 | 2023-10    | ongoing     |
 | RRWO      |   2 | 2023-10    | ongoing     |
 | SREZIC    |   2 | 2023-10    | ongoing     |
 | SUKRIA    |   2 | 2023-10    | ongoing     |
 | TANIGUCHI |   2 | 2023-10    | ongoing     |
 | TRIZEN    |   2 | 2023-10    | ongoing     |
 | YANGAK    |   2 | 2023-10    | ongoing     |
 | ZMUGHAL   |   2 | 2023-10    | ongoing     |
 | AAHAZRED  |   1 | 2023-10    | might-break |
 | AKHUETTEL |   1 | 2023-10    | might-break |
 | BAKERSCOT |   1 | 2023-10    | might-break |
 | BAYASHI   |   1 | 2023-10    | might-break |
 | BINARY    |   1 | 2023-10    | might-break |
 | BOGDRO    |   1 | 2023-10    | might-break |
 | BRTASTIC  |   1 | 2023-10    | might-break |
 | CHEVALIER |   1 | 2023-10    | might-break |
 | CONKLIN   |   1 | 2023-10    | might-break |
 | CROMEDOME |   1 | 2023-10    | might-break |
 | DAKKAR    |   1 | 2023-10    | might-break |
 | DAM       |   1 | 2023-10    | might-break |
 | DBOOK     |   1 | 2023-10    | might-break |
 | DVEEDEN   |   1 | 2023-10    | might-break |
 | GBROWN    |   1 | 2023-10    | might-break |
 | GEEKRUTH  |   1 | 2023-10    | might-break |
 | GSG       |   1 | 2023-10    | might-break |
 | GUGOD     |   1 | 2023-10    | might-break |
 | GUILLEM   |   1 | 2023-10    | might-break |
 | HAARG     |   1 | 2023-10    | might-break |
 | JHTHORSEN |   1 | 2023-10    | might-break |
 | JJNAPIORK |   1 | 2023-10    | might-break |
 | JLOUDER   |   1 | 2023-10    | might-break |
 | JMATES    |   1 | 2023-10    | might-break |
 | JSF       |   1 | 2023-10    | might-break |
 | JUERD     |   1 | 2023-10    | might-break |
 | LEMBARK   |   1 | 2023-10    | might-break |
 | LITTLEFOX |   1 | 2023-10    | might-break |
 | LSTEVENS  |   1 | 2023-10    | might-break |
 | LSTROUS   |   1 | 2023-10    | might-break |
 | MAROS     |   1 | 2023-10    | might-break |
 | MAXMIND   |   1 | 2023-10    | might-break |
 | MICKEY    |   1 | 2023-10    | might-break |
 | MIK       |   1 | 2023-10    | might-break |
 | MPOURASG  |   1 | 2023-10    | might-break |
 | NEILB     |   1 | 2023-10    | might-break |
 | NICOMEN   |   1 | 2023-10    | might-break |
 | OETIKER   |   1 | 2023-10    | might-break |
 | PATJOL    |   1 | 2023-10    | might-break |
 | PERLSRVDE |   1 | 2023-10    | might-break |
 | PETDANCE  |   1 | 2023-10    | might-break |
 | REEDFISH  |   1 | 2023-10    | might-break |
 | REICHERT  |   1 | 2023-10    | might-break |
 | RENEEB    |   1 | 2023-10    | might-break |
 | RSAVAGE   |   1 | 2023-10    | might-break |
 | RWSTAUNER |   1 | 2023-10    | might-break |
 | SCHUBIGER |   1 | 2023-10    | might-break |
 | SCOTTH    |   1 | 2023-10    | might-break |
 | SHAY      |   1 | 2023-10    | might-break |
 | SIMBABQUE |   1 | 2023-10    | might-break |
 | SPRAGL    |   1 | 2023-10    | might-break |
 | SUMAN     |   1 | 2023-10    | might-break |
 | TODDR     |   1 | 2023-10    | might-break |
 | VOLKENING |   1 | 2023-10    | might-break |
 | WIEGEROP  |   1 | 2023-10    | might-break |
 | YTURTLE   |   1 | 2023-10    | might-break |
 | ATKACH    |   1 | 2023-11    | ongoing     |
 | BORISD    |   1 | 2023-11    | ongoing     |
 | BORISV    |   1 | 2023-11    | ongoing     |
 | CGPAN     |   1 | 2023-11    | ongoing     |
 | CRORAA    |   1 | 2023-11    | ongoing     |
 | DAMI      |   1 | 2023-11    | ongoing     |
 | DANBERR   |   1 | 2023-11    | ongoing     |
 | DANKOGAI  |   1 | 2023-11    | ongoing     |
 | DCHURCH   |   1 | 2023-11    | ongoing     |
 | DCONWAY   |   1 | 2023-11    | ongoing     |
 | DERIV     |   1 | 2023-11    | ongoing     |
 | DORNER    |   1 | 2023-11    | ongoing     |
 | DTUCKWELL |   1 | 2023-11    | ongoing     |
 | EHUELS    |   1 | 2023-11    | ongoing     |
 | ETJ       |   1 | 2023-11    | ongoing     |
 | EXIFTOOL  |   1 | 2023-11    | ongoing     |
 | FSEITZ    |   1 | 2023-11    | ongoing     |
 | GAHAYES   |   1 | 2023-11    | ongoing     |
 | GDT       |   1 | 2023-11    | ongoing     |
 | GNUSTAVO  |   1 | 2023-11    | ongoing     |
 | GRAY      |   1 | 2023-11    | ongoing     |
 | GWILLIAMS |   1 | 2023-11    | ongoing     |
 | JMASLAK   |   1 | 2023-11    | ongoing     |
 | JOYREX    |   1 | 2023-11    | ongoing     |
 | LANCEW    |   1 | 2023-11    | ongoing     |
 | LSKATZ    |   1 | 2023-11    | ongoing     |
 | MAMAWE    |   1 | 2023-11    | ongoing     |
 | MBARBON   |   1 | 2023-11    | ongoing     |
 | MDOOTSON  |   1 | 2023-11    | ongoing     |
 | MIKKOI    |   1 | 2023-11    | ongoing     |
 | OODLER    |   1 | 2023-11    | ongoing     |
 | PLAIN     |   1 | 2023-11    | ongoing     |
 | PMB       |   1 | 2023-11    | ongoing     |
 | RBAIRWELL |   1 | 2023-11    | ongoing     |
 | ROBM      |   1 | 2023-11    | ongoing     |
 | RSCHUPP   |   1 | 2023-11    | ongoing     |
 | RWF       |   1 | 2023-11    | ongoing     |
 | RWI       |   1 | 2023-11    | ongoing     |
 | SGRAY     |   1 | 2023-11    | ongoing     |
 | SHOGO     |   1 | 2023-11    | ongoing     |
 | SIMCOP    |   1 | 2023-11    | ongoing     |
 | STRAKA    |   1 | 2023-11    | ongoing     |
 | SULLR     |   1 | 2023-11    | ongoing     |
 | SVW       |   1 | 2023-11    | ongoing     |
 | TINITA    |   1 | 2023-11    | ongoing     |
 | TONYC     |   1 | 2023-11    | ongoing     |
 | TOSHIOITO |   1 | 2023-11    | ongoing     |
 | TROTH     |   1 | 2023-11    | ongoing     |
 | VOEGELAS  |   1 | 2023-11    | ongoing     |
 | WHOM      |   1 | 2023-11    | ongoing     |
 | WOUTER    |   1 | 2023-11    | ongoing     |
 | XAVIERH   |   1 | 2023-11    | ongoing     |

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Acme-CPANAuthorsBundle-CPAN-Streaks>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Acme-CPANAuthorsBundle-CPAN-Streaks>.

=head1 SEE ALSO

L<Acme::CPANAuthors>

CPAN Regulars Boards, L<http://cpan.io/board/once-a/>, which as of this writing,
has some input data missing and thus produces some incorrect results.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2023 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Acme-CPANAuthorsBundle-CPAN-Streaks>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
