#!/usr/bin/perl -w
#
#    dateFormatSymbols.pl
#
#    $Id: dateFormatSymbols.pl,v 1.2 2001/02/11 03:27:53 bstell Exp $
#
#    Copyright (c) 2000 Brian Stell
#
#    This package is free software and is provided ``as is'' without
#    express or implied warranty. It may be used, redistributed and/or
#    modified under the terms of the Perl Artistic License 
#    (see http://www.perl.com/perl/misc/Artistic.html)
#

require 5.6.0;
use strict;

use POSIX qw(locale_h errno strftime);
#use Time::Local;
use utf8;

use ExtUtils::testlib;
use ICU;
use ICU::DateFormatSymbols;
use ICU::Locale;

my $dfs = new ICU::DateFormatSymbols();
my $en_l = new ICU::Locale('en_US');
my $dfs_en = new ICU::DateFormatSymbols($en_l);
my $dfs_dup = new ICU::DateFormatSymbols($dfs);
$dfs_dup = undef;

print "<pre>\n";
show_dateFormatSymbols('en_US');
show_dateFormatSymbols('de_DE');
show_dateFormatSymbols('fr_FR');
show_dateFormatSymbols('ja_JP');

sub show_dateFormatSymbols {
    my ($locale_str) = @_;

    my $locale = new ICU::Locale($locale_str);
    my $dfs = new ICU::DateFormatSymbols($locale);

    # days
    my @Weekdays = $dfs->getWeekdays();
    my @shortWeekdays = $dfs->getShortWeekdays();
    print "$locale_str Weekdays (".scalar(@Weekdays).") :\n";
    for (my $i=0; $i<7; $i++) {
        print "    $Weekdays[$i] ($shortWeekdays[$i])\n";
    }

    # months
    my @months = $dfs->getMonths();
    my @shortmonths = $dfs->getShortMonths();
    print "$locale_str months (".scalar(@months).") :\n";
    for (my $i=0; $i<12; $i++) {
        print "    $months[$i] ($shortmonths[$i])\n";
    }

    # am/pm strings
    my @ampm_strs = $dfs->getAmPmStrings();
    print "$locale_str am/pm strings:\n";
    foreach my $ampm_str (@ampm_strs) {
        print "    $ampm_str\n";
    }

    # local pattern chars
    my $localPatternChars = $dfs->getLocalPatternChars();
    print "$locale_str local pattern chars: $localPatternChars\n";
}
print "done\n";
print "</pre>\n";

exit(0);
