=encoding utf8

=head1 NAME

Locale::CLDR::Locales::Kk::Arab - Package for language Kazakh

=cut

package Locale::CLDR::Locales::Kk::Arab;
# This file auto generated from Data\common\main\kk_Arab.xml
#	on Fri 17 Jan 12:03:31 pm GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.46.0');

use v5.12.0;
use mro 'c3';
use utf8;
use feature 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

extends('Locale::CLDR::Locales::Root');
has 'display_name_language' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		 sub {
			 my %languages = (
				'aa' => 'افار ءتىلى',
 				'ab' => 'ابحاز ءتىلى',
 				'af' => 'افريكاانس ءتىلى',
 				'agq' => 'اگەم ءتىلى',
 				'ak' => 'اكان ءتىلى',
 				'am' => 'امحار ءتىلى',
 				'an' => 'اراگون ءتىلى',
 				'ann' => 'وبولو ءتىلى',
 				'apc' => 'شامي ءتىلى',
 				'ar' => 'اراب ءتىلى',
 				'ar_001' => 'قازىرگى ستاندارتتى اراب ءتىلى',
 				'arn' => 'ماپۋچە ءتىلى',
 				'as' => 'اسسام ءتىلى',
 				'asa' => 'اسۋ ءتىلى',
 				'ast' => 'استرۋيا ءتىلى',
 				'az' => 'ءازىربايجان ءتىلى',
 				'ba' => 'باشقۇرت ءتىلى',
 				'bal' => 'بالۋچي ءتىلى',
 				'bas' => 'باسا ءتىلى',
 				'be' => 'بەلارۋس ءتىلى',
 				'bem' => 'بەمبا ءتىلى',
 				'bew' => 'بەياۋي ءتىلى',
 				'bez' => 'بەنا ءتىلى',
 				'bg' => 'بولگار ءتىلى',
 				'bgc' => 'حارياني ءتىلى',
 				'bgn' => 'باتىس بالۋچي ءتىلى',
 				'bho' => 'بحودجپۋري ءتىلى',
 				'blo' => 'اني ءتىلى',
 				'blt' => 'تاي دام ءتىلى',
 				'bm' => 'بامبارا ءتىلى',
 				'bn' => 'بەنگال ءتىلى',
 				'bo' => 'تيبەت ءتىلى',
 				'br' => 'برەتون ءتىلى',
 				'brx' => 'بودو ءتىلى',
 				'bs' => 'بوسنيا ءتىلى',
 				'bss' => 'اكوسە ءتىلى',
 				'byn' => 'بلين ءتىلى',
 				'ca' => 'كاتالان ءتىلى',
 				'cad' => 'كاددو ءتىلى',
 				'cch' => 'اتسام ءتىلى',
 				'ccp' => 'چاكما ءتىلى',
 				'ce' => 'شەشەن ءتىلى',
 				'ceb' => 'سەبۋانو ءتىلى',
 				'cgg' => 'كيگا ءتىلى',
 				'cho' => 'چوكتو ءتىلى',
 				'chr' => 'چەروكي ءتىلى',
 				'cic' => 'چيكاساۋ ءتىلى',
 				'ckb' => 'سوراني ءتىلى',
 				'co' => 'كورسيكا ءتىلى',
 				'cs' => 'چەح ءتىلى',
 				'csw' => 'باتپاقتى جەردىڭ كري ءتىلى',
 				'cu' => 'شىركەۋلىك سلاۆيان ءتىلى',
 				'cv' => 'چۋۆاش ءتىلى',
 				'cy' => 'ۆاللي ءتىلى',
 				'da' => 'دات ءتىلى',
 				'dav' => 'تايتا ءتىلى',
 				'de' => 'نەمىس ءتىلى',
 				'de_AT' => 'نەمىس ءتىلى (اۋستريا)',
 				'de_CH' => 'نەمىس ءتىلى (شۆەيساريا)',
 				'dje' => 'زارما ءتىلى',
 				'doi' => 'دوگري ءتىلى',
 				'dsb' => 'تومەنگى سوربيان ءتىلى',
 				'dua' => 'دۋالا ءتىلى',
 				'dv' => 'ديۆەحي ءتىلى',
 				'dyo' => 'ديولا ءتىلى',
 				'dz' => 'جوڭكا ءتىلى',
 				'ebu' => 'ەمبۋ ءتىلى',
 				'ee' => 'ەۆە ءتىلى',
 				'el' => 'گرەك ءتىلى',
 				'en' => 'اعىلشىن ءتىلى',
 				'en_AU' => 'اعىلشىن ءتىلى (اۋستراليا)',
 				'en_CA' => 'اعىلشىن ءتىلى (كانادا)',
 				'en_GB' => 'اعىلشىن ءتىلى (ۇلىبريتانيا)',
 				'en_US' => 'اعىلشىن ءتىلى (امەريكا قۇراما شتاتتارى)',
 				'en_US@alt=short' => 'اعىلشىن ءتىلى (امەريكا)',
 				'eo' => 'ەسپەرانتو ءتىلى',
 				'es' => 'يسپان ءتىلى',
 				'es_419' => 'يسپان ءتىلى (لاتىن امەريكا)',
 				'es_ES' => 'يسپان ءتىلى (يسپانيا)',
 				'es_MX' => 'يسپان ءتىلى (مەكسيكا)',
 				'et' => 'ەستون ءتىلى',
 				'eu' => 'باسك ءتىلى',
 				'ewo' => 'ەۆوندو ءتىلى',
 				'fa' => 'پارسى ءتىلى',
 				'fa_AF' => 'داري ءتىلى',
 				'ff' => 'فۋلا ءتىلى',
 				'fi' => 'فين ءتىلى',
 				'fil' => 'فيليپين ءتىلى',
 				'fo' => 'فارەر ءتىلى',
 				'fr' => 'فرانسۋز ءتىلى',
 				'fr_CA' => 'فرانسۋز ءتىلى (كانادا)',
 				'fr_CH' => 'فرانسۋز ءتىلى (شۆەيساريا)',
 				'frc' => 'كاجۋن ءتىلى',
 				'frr' => 'سولتۇستىك-شىعىس كري ءتىلى',
 				'fur' => 'فريۋل ءتىلى',
 				'fy' => 'باتىس فريز ءتىلى',
 				'ga' => 'يرلاند ءتىلى',
 				'gaa' => 'گا ءتىلى',
 				'gd' => 'شوتلانديالىق گەل ءتىلى',
 				'gez' => 'گەەز ءتىلى',
 				'gl' => 'گاليسيا ءتىلى',
 				'gn' => 'گۋاريني ءتىلى',
 				'gsw' => 'شۆەيساريالىق نەمىس ءتىلى',
 				'gu' => 'گۋجاراتي ءتىلى',
 				'guz' => 'گۋسي ءتىلى',
 				'gv' => 'مەن ءتىلى',
 				'ha' => 'حاۋسا ءتىلى',
 				'haw' => 'حاۋاي ءتىلى',
 				'he' => 'يۆريت ءتىلى',
 				'hi' => 'حيندي ءتىلى',
 				'hi_Latn' => 'حيندي ءتىلى (لاتىن جازۋى)',
 				'hi_Latn@alt=variant' => 'حينگليش',
 				'hnj' => 'حموڭ نيۋا ءتىلى',
 				'hr' => 'حورۆات ءتىلى',
 				'hsb' => 'جوعارعى سوربيان ءتىلى',
 				'hu' => 'ماجار ءتىلى',
 				'hy' => 'ارميان ءتىلى',
 				'ia' => 'ينتەرلينگۆا ءتىلى',
 				'id' => 'يندونەزيا ءتىلى',
 				'ie' => 'ينتەرلينگۆە ءتىلى',
 				'ig' => 'يگبو ءتىلى',
 				'ii' => 'سىچۋان ي ءتىلى',
 				'io' => 'يدو ءتىلى',
 				'is' => 'يسلاند ءتىلى',
 				'it' => 'يتاليان ءتىلى',
 				'iu' => 'ينۋكتيتۋت ءتىلى',
 				'ja' => 'جاپون ءتىلى',
 				'jbo' => 'لاجبان ءتىلى',
 				'jgo' => 'نگومبا ءتىلى',
 				'jmc' => 'ماچامە ءتىلى',
 				'jv' => 'ياۆا ءتىلى',
 				'ka' => 'گرۋزين ءتىلى',
 				'kaa' => 'قاراقالپاق ءتىلى',
 				'kab' => 'كابيل ءتىلى',
 				'kaj' => 'كاجي ءتىلى',
 				'kam' => 'كامبا ءتىلى',
 				'kcg' => 'تياپ ءتىلى',
 				'kde' => 'ماكوندە ءتىلى',
 				'kea' => 'كابۋۆەرديانۋ ءتىلى',
 				'ken' => 'كەنياڭ ءتىلى',
 				'kgp' => 'كاينگاڭ ءتىلى',
 				'khq' => 'كويرا چيني ءتىلى',
 				'ki' => 'كيكۋيۋ ءتىلى',
 				'kk' => 'قازاق ءتىلى',
 				'kk_Arab' => 'قازاق ءتىلى (توتە)',
 				'kkj' => 'كاكو ءتىلى',
 				'kl' => 'كالاليسۋت ءتىلى',
 				'kln' => 'كالەنجين ءتىلى',
 				'km' => 'كحمەر ءتىلى',
 				'kn' => 'كاننادا ءتىلى',
 				'ko' => 'كورەي ءتىلى',
 				'kok' => 'كونكاني ءتىلى',
 				'kpe' => 'كپەلە ءتىلى',
 				'ks' => 'كاشمير ءتىلى',
 				'ksb' => 'شامبالا ءتىلى',
 				'ksf' => 'بافيا ءتىلى',
 				'ksh' => 'كولونيان ءتىلى',
 				'ku' => 'كۇرد ءتىلى',
 				'kw' => 'كورن ءتىلى',
 				'kxv' => 'كۋۆي ءتىلى',
 				'ky' => 'قىرعىز ءتىلى',
 				'la' => 'لاتىن ءتىلى',
 				'lag' => 'لانگي ءتىلى',
 				'lb' => 'ليۋكسەمبۋرگ ءتىلى',
 				'lg' => 'گاندا ءتىلى',
 				'lij' => 'ليگۋر ءتىلى',
 				'lkt' => 'لاكوتا ءتىلى',
 				'lld' => 'لادينو ءتىلى',
 				'lmo' => 'لومبارد ءتىلى',
 				'ln' => 'لينگالا ءتىلى',
 				'lo' => 'لاوس ءتىلى',
 				'lou' => 'كىرەول ءتىلى',
 				'lrc' => 'سولتۇستىك فريز ءتىلى',
 				'lt' => 'ليتۆا ءتىلى',
 				'ltg' => 'لاتگاليان ءتىلى',
 				'lu' => 'لۋبا-كاتاڭا ءتىلى',
 				'luo' => 'لۋو ءتىلى',
 				'luy' => 'لۋحيا ءتىلى',
 				'lv' => 'لاتىش ءتىلى',
 				'mai' => 'مايتحيلي ءتىلى',
 				'mas' => 'ماساي ءتىلى',
 				'mdf' => 'موكشا ءتىلى',
 				'mer' => 'مەرۋ ءتىلى',
 				'mfe' => 'موريسيەن ءتىلى',
 				'mg' => 'مالاگاسي ءتىلى',
 				'mgh' => 'ماكۋا-مەتتو ءتىلى',
 				'mgo' => 'مەتا ءتىلى',
 				'mhn' => 'موكەنو ءتىلى',
 				'mi' => 'ماوري ءتىلى',
 				'mic' => 'ميكماۋ ءتىلى',
 				'mk' => 'ماكەدون ءتىلى',
 				'ml' => 'مالايالام ءتىلى',
 				'mn' => 'موڭعول ءتىلى',
 				'mni' => 'مانيپۋري ءتىلى',
 				'moh' => 'موحاۋك ءتىلى',
 				'mr' => 'ماراتحي ءتىلى',
 				'ms' => 'مالاي ءتىلى',
 				'mt' => 'مالتا ءتىلى',
 				'mua' => 'مۋنداڭ ءتىلى',
 				'mul' => 'بىرنەشە ءتىلى',
 				'mus' => 'كريك ءتىلى',
 				'my' => 'بيرما ءتىلى',
 				'myv' => 'ەرزيا ءتىلى',
 				'mzn' => 'مازاندەران ءتىلى',
 				'naq' => 'ناما ءتىلى',
 				'nb' => 'نورۆەگيالىق بۋكمول ءتىلى',
 				'nd' => 'سولتۇستىك ندەبەلە ءتىلى',
 				'nds' => 'تومەنگى نەمىس ءتىلى',
 				'nds_NL' => 'تومەنگى ساكسون ءتىلى',
 				'ne' => 'نەپال ءتىلى',
 				'nl' => 'نيدەرلاند ءتىلى',
 				'nl_BE' => 'فلاماند ءتىلى',
 				'nmg' => 'كۋاسيو ءتىلى',
 				'nn' => 'نورۆەگيالىق نيۋنورسك ءتىلى',
 				'nnh' => 'نگيەمبۋن ءتىلى',
 				'no' => 'نورۆەگ ءتىلى',
 				'nqo' => 'نكو ءتىلى',
 				'nr' => 'وڭتۇستىك ندەبەلە ءتىلى',
 				'nso' => 'سولتۇستىك سوتو ءتىلى',
 				'nus' => 'نۋەر ءتىلى',
 				'nv' => 'ناۆاحو ءتىلى',
 				'ny' => 'نيانجا ءتىلى',
 				'nyn' => 'نيانكولە ءتىلى',
 				'oc' => 'وكسيتان ءتىلى',
 				'om' => 'ورومو ءتىلى',
 				'or' => 'وريا ءتىلى',
 				'os' => 'وسەتين ءتىلى',
 				'osa' => 'وسەيج ءتىلى',
 				'pa' => 'پەنجاب ءتىلى',
 				'pap' => 'پاپيامەنتو ءتىلى',
 				'pcm' => 'نيگەريالىق پيدجين ءتىلى',
 				'pis' => 'پيجين ءتىلى',
 				'pl' => 'پولياك ءتىلى',
 				'prg' => 'پرۋسسيا ءتىلى',
 				'ps' => 'پۋشتۋ ءتىلى',
 				'pt' => 'پورتۋگال ءتىلى',
 				'pt_BR' => 'برازيليالىق پورتۋگال ءتىلى',
 				'pt_PT' => 'ەۋروپالىق پورتۋگال ءتىلى',
 				'qu' => 'كەچۋا ءتىلى',
 				'quc' => 'كيچە ءتىلى',
 				'raj' => 'راجاستاني ءتىلى',
 				'rhg' => 'روحينجا ءتىلى',
 				'rif' => 'ريفيان ءتىلى',
 				'rm' => 'رومانش ءتىلى',
 				'rn' => 'رۋندي ءتىلى',
 				'ro' => 'رۋمىن ءتىلى',
 				'ro_MD' => 'مولدوۆان ءتىلى',
 				'rof' => 'رومبو ءتىلى',
 				'ru' => 'ورىس ءتىلى',
 				'rw' => 'كينيارۋاندا ءتىلى',
 				'rwk' => 'رۋا ءتىلى',
 				'sa' => 'سانسكريت ءتىلى',
 				'sah' => 'ساحا ءتىلى',
 				'saq' => 'سامبۋرۋ ءتىلى',
 				'sat' => 'سانتالي ءتىلى',
 				'sbp' => 'ساڭۋ ءتىلى',
 				'sc' => 'ساردين ءتىلى',
 				'scn' => 'سيسيليا ءتىلى',
 				'sd' => 'سيندحي ءتىلى',
 				'sdh' => 'وڭتۇستىك كۇرد ءتىلى',
 				'se' => 'سولتۇستىك سامي ءتىلى',
 				'seh' => 'سەنا ءتىلى',
 				'ses' => 'كويرابورو سەنني ءتىلى',
 				'sg' => 'ساڭو ءتىلى',
 				'shi' => 'تاشەلحيت ءتىلى',
 				'shn' => 'شان ءتىلى',
 				'si' => 'سينگال ءتىلى',
 				'sid' => 'سيدامو ءتىلى',
 				'sk' => 'سلوۆاك ءتىلى',
 				'skr' => 'سارايكي ءتىلى',
 				'sl' => 'سلوۆەن ءتىلى',
 				'sma' => 'وڭتۇستىك سامي ءتىلى',
 				'smj' => 'لۋلە-سامي ءتىلى',
 				'smn' => 'يناري سامي ءتىلى',
 				'sms' => 'كولتا سامي ءتىلى',
 				'sn' => 'شونا ءتىلى',
 				'so' => 'سومالي ءتىلى',
 				'sq' => 'البان ءتىلى',
 				'sr' => 'سەرب ءتىلى',
 				'ss' => 'سۋاتي ءتىلى',
 				'ssy' => 'ساحو ءتىلى',
 				'st' => 'وڭتۇستىك سوتو ءتىلى',
 				'su' => 'سۋدان ءتىلى',
 				'sv' => 'شۆەد ءتىلى',
 				'sw' => 'سۋاحيلي ءتىلى',
 				'sw_CD' => 'كونگو سۋاحيلي ءتىلى',
 				'syr' => 'سيريا ءتىلى',
 				'szl' => 'سيلەز ءتىلى',
 				'ta' => 'تاميل ءتىلى',
 				'te' => 'تەلۋگۋ ءتىلى',
 				'teo' => 'تەسو ءتىلى',
 				'tg' => 'تاجىك ءتىلى',
 				'th' => 'تاي ءتىلى',
 				'ti' => 'تيگرينيا ءتىلى',
 				'tig' => 'تيگرە ءتىلى',
 				'tk' => 'تۇرىكمەن ءتىلى',
 				'tn' => 'سۋانا ءتىلى',
 				'to' => 'تونگان ءتىلى',
 				'tok' => 'توكي-پونا ءتىلى',
 				'tpi' => 'توك-پيسين ءتىلى',
 				'tr' => 'تۇرىك ءتىلى',
 				'trv' => 'تاروكو ءتىلى',
 				'trw' => 'توۋالي ءتىلى',
 				'ts' => 'سونگا ءتىلى',
 				'tt' => 'تاتار ءتىلى',
 				'twq' => 'تاساۋاك ءتىلى',
 				'tyv' => 'تۋۆين ءتىلى',
 				'tzm' => 'ورتالىق اتلاس تامازيگحت ءتىلى',
 				'ug' => 'ۇيعىر ءتىلى',
 				'uk' => 'ۋكراين ءتىلى',
 				'und' => 'بەلگىسىز ءتىل',
 				'ur' => 'ۋردۋ ءتىلى',
 				'uz' => 'وزبەك ءتىلى',
 				'vai' => 'ۆاي ءتىلى',
 				've' => 'ۆەندا ءتىلى',
 				'vec' => 'ۆەنەسيا ءتىلى',
 				'vi' => 'ۆيەتنام ءتىلى',
 				'vmw' => 'ماكۋا ءتىلى',
 				'vo' => 'ۆولاپيۋك ءتىلى',
 				'vun' => 'ۆۋنجو ءتىلى',
 				'wa' => 'ۋالون ءتىلى',
 				'wae' => 'ۋالسەر ءتىلى',
 				'wal' => 'ۋولايتا ءتىلى',
 				'wbp' => 'ۋالبيري ءتىلى',
 				'wo' => 'ۆولوف ءتىلى',
 				'xh' => 'كحوسا ءتىلى',
 				'xnr' => 'كاڭري ءتىلى',
 				'xog' => 'سوگا ءتىلى',
 				'yav' => 'ياڭبەن ءتىلى',
 				'yi' => 'يديش ءتىلى',
 				'yo' => 'يورۋبا ءتىلى',
 				'yrl' => 'نەنگاتۋ ءتىلى',
 				'yue' => 'گۋاڭدۇڭ ءتىلى',
 				'yue@alt=menu' => 'قىتاي ءتىلى (گۋاڭدۇڭ)',
 				'za' => 'جۋاڭ ءتىلى',
 				'zgh' => 'ماروككولىق ستاندارتتى تامازيگحت ءتىلى',
 				'zh' => 'قىتاي ءتىلى',
 				'zh@alt=menu' => 'قىتاي ءتىلى (پۋتۋڭحۋا)',
 				'zh_Hans' => 'جەڭىلدەتىلگەن قىتاي ءتىلى',
 				'zh_Hans@alt=long' => 'جەڭىلدەتىلگەن قىتاي ءتىلى (پۋتۋڭحۋا)',
 				'zh_Hant' => 'ءداستۇرلى قىتاي ءتىلى',
 				'zh_Hant@alt=long' => 'ءداستۇرلى قىتاي ءتىلى (پۋتۋڭحۋا)',
 				'zu' => 'زۋلۋ ءتىلى',
 				'zxx' => 'تىلدىك مازمۇنى جوق',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Adlm' => 'ادلام جازۋى',
 			'Aghb' => 'اگۆان جازۋى',
 			'Ahom' => 'احوم جازۋى',
 			'Arab' => 'اراب جازۋى',
 			'Aran' => 'ناستاليك جازۋى',
 			'Armi' => 'ارامەي جازۋى',
 			'Armn' => 'ارميان جازۋى',
 			'Avst' => 'اۆەستا جازۋى',
 			'Bali' => 'بالي جازۋى',
 			'Bamu' => 'بامۋم جازۋى',
 			'Bass' => 'باسسا جازۋى',
 			'Batk' => 'باتاك جازۋى',
 			'Beng' => 'بەنگال جازۋى',
 			'Bhks' => 'بحايسۋكى جازۋى',
 			'Bopo' => 'بوپوموفو جازۋى',
 			'Brah' => 'براحمي جازۋى',
 			'Brai' => 'برايل جازۋى',
 			'Bugi' => 'بۋگي جازۋى',
 			'Buhd' => 'بۋحيد جازۋى',
 			'Cakm' => 'چاكما جازۋى',
 			'Cans' => 'كانادالىق بۋىن جۇيەلى جازۋ',
 			'Cari' => 'كاري جازۋى',
 			'Cham' => 'چام جازۋى',
 			'Cher' => 'چەروكي جازۋى',
 			'Chrs' => 'حورەزم جازۋى',
 			'Copt' => 'كوپت جازۋى',
 			'Cpmn' => 'كيپر-مينوي جازۋى',
 			'Cprt' => 'كيپر جازۋى',
 			'Cyrl' => 'كيريل جازۋى',
 			'Cyrs' => 'كونە ورىس جازۋى',
 			'Deva' => 'دەۆاناگاري جازۋى',
 			'Diak' => 'ديۆەحي اكۋرۋ جازۋى',
 			'Dogr' => 'دوگرا جازۋى',
 			'Dsrt' => 'دەسەرەت جازۋى',
 			'Dupl' => 'دۋپلويە جازۋى',
 			'Egyp' => 'مىسىر جازۋى',
 			'Elba' => 'ەلباسان جازۋى',
 			'Elym' => 'ەليماي جازۋى',
 			'Ethi' => 'ەفيوپيالىق جازۋ',
 			'Gara' => 'گاراي جازۋى',
 			'Geor' => 'گرۋزين جازۋى',
 			'Glag' => 'گلاگول جازۋى',
 			'Gong' => 'گۋنجالا گوندي جازۋى',
 			'Gonm' => 'ماسارام گوندي جازۋى',
 			'Goth' => 'گوت جازۋى',
 			'Gran' => 'گرانتحا جازۋى',
 			'Grek' => 'گرەك جازۋى',
 			'Gujr' => 'گۋجاراتي جازۋى',
 			'Gukh' => 'گۋرۋڭ كحەما جازۋى',
 			'Guru' => 'گۋرمۋكحي جازۋى',
 			'Hanb' => 'حانب جازۋى',
 			'Hang' => 'حانگىل جازۋى',
 			'Hani' => 'قىتاي جازۋى',
 			'Hano' => 'حانۋنۋ جازۋى',
 			'Hans' => 'جەڭىلدەتىلگەن جازۋ',
 			'Hans@alt=stand-alone' => 'جەڭىلدەتىلگەن قىتاي جازۋى',
 			'Hant' => 'ءداستۇرلى جازۋ',
 			'Hant@alt=stand-alone' => 'ءداستۇرلى قىتاي جازۋى',
 			'Hatr' => 'حاترا جازۋى',
 			'Hebr' => 'يۆريت جازۋى',
 			'Hira' => 'حيراگانا جازۋى',
 			'Hluw' => 'انادولى جازۋى',
 			'Hmng' => 'پاحاۋ جازۋى',
 			'Hmnp' => 'نياكەڭ پۋاچۋە حموڭ جازۋى',
 			'Hrkt' => 'حيراگانا نەمەسە كاتاكانا',
 			'Hung' => 'ماجار رۋناسى',
 			'Ital' => 'ەسكى يتالياجازۋى',
 			'Jamo' => 'جامو جازۋى',
 			'Java' => 'ياۆا جازۋى',
 			'Jpan' => 'جاپون جازۋى',
 			'Kali' => 'كايا-لي جازۋى',
 			'Kana' => 'كاتاكانا جازۋى',
 			'Kawi' => 'كاۋي جازۋى',
 			'Khar' => 'كحاروشتحي جازۋى',
 			'Khmr' => 'كحمەر جازۋى',
 			'Khoj' => 'حوجيكي جازۋى',
 			'Kits' => 'شاعىن كيدان جازۋى',
 			'Knda' => 'كاننادا جازۋى',
 			'Kore' => 'كورەي جازۋى',
 			'Krai' => 'كيرات راي جازۋى',
 			'Kthi' => 'كايتحي جازۋى',
 			'Lana' => 'لاننا جازۋى',
 			'Laoo' => 'لاوس جازۋى',
 			'Latf' => 'فراكتۋر لاتىن جازۋى',
 			'Latg' => 'گاەل لاتىن جازۋى',
 			'Latn' => 'لاتىن جازۋى',
 			'Lepc' => 'لەپچا جازۋى',
 			'Limb' => 'ليمبۋ جازۋى',
 			'Lina' => 'سىزىقتىق A جازۋى',
 			'Linb' => 'سىزىقتىق B جازۋى',
 			'Lisu' => 'فرايسەر جازۋى',
 			'Lyci' => 'ليكي جازۋى',
 			'Lydi' => 'ليدي جازۋى',
 			'Mahj' => 'ماحاجاني جازۋى',
 			'Maka' => 'ماكاسار جازۋى',
 			'Mand' => 'ماندەي جازۋى',
 			'Mani' => 'مانيحەي جازۋى',
 			'Marc' => 'مارچەن جازۋى',
 			'Medf' => 'مەدەفايدرين جازۋى',
 			'Mend' => 'مەندە جازۋى',
 			'Merc' => 'مەرويت قيعاش جازۋى',
 			'Mero' => 'مەرويت جازۋى',
 			'Mlym' => 'مالايالام جازۋى',
 			'Modi' => 'مودي جازۋى',
 			'Mong' => 'موڭعول جازۋى',
 			'Mroo' => 'مرو جازۋى',
 			'Mtei' => 'مەيتەي جازۋى',
 			'Mult' => 'مۋلتاني جازۋى',
 			'Mymr' => 'ميانما جازۋى',
 			'Nagm' => 'ناگ مۋنداري جازۋى',
 			'Nand' => 'نانديناگاري جازۋى',
 			'Narb' => 'كونە سولتۇستىك اراب جازۋى',
 			'Nbat' => 'ناباتەي جازۋى',
 			'Newa' => 'نيۋا جازۋى',
 			'Nkoo' => 'نكو جازۋى',
 			'Nshu' => 'نيۋ-شۋ جازۋى',
 			'Ogam' => 'وگام جازۋى',
 			'Olck' => 'ول-چيكي جازۋى',
 			'Onao' => 'ول-ونال جازۋى',
 			'Orkh' => 'كونە تۇركى جازۋى',
 			'Orya' => 'وريا جازۋى',
 			'Osge' => 'وسەيج جازۋى',
 			'Osma' => 'يسمانيا جازۋى',
 			'Ougr' => 'كونە ۇيعىر جازۋى',
 			'Palm' => 'پالمير جازۋى',
 			'Pauc' => 'پاۋ سين حاۋ جازۋى',
 			'Perm' => 'كونە پەرم جازۋى',
 			'Phag' => 'تيبەر-موڭعول جازۋى',
 			'Phli' => 'جازبا پاحلاۆي',
 			'Phlp' => 'پاحلاۆي جازۋى',
 			'Phnx' => 'فينيكيا جازۋى',
 			'Plrd' => 'پوللارد فونەتيكالىق جازۋى',
 			'Prti' => 'جازبا پارفيا',
 			'Qaag' => 'زوجي جازۋى',
 			'Rjng' => 'رەجاڭ جازۋى',
 			'Rohg' => 'حانيفي جازۋى',
 			'Runr' => 'رۋنا',
 			'Samr' => 'ساماريا جازۋى',
 			'Sarb' => 'وڭتۇستىك اراب جازۋى',
 			'Saur' => 'ساۋراشترا جازۋى',
 			'Sgnw' => 'جازۋ',
 			'Shaw' => 'شوۋ جازۋى',
 			'Shrd' => 'شارادا جازۋى',
 			'Sidd' => 'سيدحام جازۋى',
 			'Sind' => 'كحۋداۋادي جازۋى',
 			'Sinh' => 'سينگال جازۋى',
 			'Sogd' => 'سوعدى جازۋى',
 			'Sogo' => 'كونە سوعدى جازۋى',
 			'Sora' => 'سورا سومپەڭ جازۋى',
 			'Soyo' => 'سويومبو جازۋى',
 			'Sund' => 'سۋند جازۋى',
 			'Sunu' => 'سۋنۋار جازۋى',
 			'Sylo' => 'سيلحەت ناگاري جازۋى',
 			'Syrc' => 'سيريا جازۋى',
 			'Syre' => 'ەسترانگەلو سيري جازۋى',
 			'Syrj' => 'باتىس سيري جازۋى',
 			'Syrn' => 'شىعىس سيري جازۋى',
 			'Tagb' => 'تاگبانۋا جازۋى',
 			'Takr' => 'تاكري جازۋى',
 			'Tale' => 'تاي لى جازۋى',
 			'Talu' => 'جاڭا تاي لى جازۋى',
 			'Taml' => 'تاميل جازۋى',
 			'Tang' => 'تانعۇت جازۋى',
 			'Tavt' => 'تاي ۆيەت جازۋى',
 			'Telu' => 'تەلۋگۋ جازۋى',
 			'Tfng' => 'تيفيناگ جازۋى',
 			'Tglg' => 'بايبايىن جازۋى',
 			'Thaa' => 'تانا جازۋى',
 			'Thai' => 'تاي جازۋى',
 			'Tibt' => 'تيبەت جازۋى',
 			'Tirh' => 'تيرحۋتا جازۋى',
 			'Tnsa' => 'تاڭسا جازۋى',
 			'Todr' => 'تودحري جازۋى',
 			'Toto' => 'توتو جازۋى',
 			'Tutg' => 'تۋلۋ-تيگالاري جازۋى',
 			'Ugar' => 'ۋگاريت جازۋى',
 			'Vaii' => 'ۆاي جازۋى',
 			'Vith' => 'ۆيتكۋتي جازۋى',
 			'Wara' => 'ۆاراڭ كشيتي جازۋى',
 			'Wcho' => 'ۋانچو جازۋى',
 			'Xpeo' => 'كونە پارسى جازۋو',
 			'Xsux' => 'شۋمەر-اككاد سىنا جازۋى',
 			'Yezi' => 'ەزيد جازۋى',
 			'Yiii' => 'ي جازۋى',
 			'Zanb' => 'زانابازار شارشى جازۋى',
 			'Zinh' => 'مۇرا ەتىلگەن',
 			'Zmth' => 'ماتەماتيكالىق جازۋ',
 			'Zsye' => 'ەموجي',
 			'Zsym' => 'تاڭبالار',
 			'Zxxx' => 'جازۋسىز',
 			'Zyyy' => 'جالپى',
 			'Zzzz' => 'بەلگىسىز جازۋ',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'001' => 'الەم',
 			'002' => 'افريكا',
 			'003' => 'سولتۇستىك امەريكا',
 			'005' => 'وڭتۇستىك امەريكا',
 			'009' => 'وكەانيا',
 			'011' => 'باتىس افريكا',
 			'013' => 'ورتالىق امەريكا',
 			'014' => 'شىعىس افريكا',
 			'015' => 'سولتۇستىك افريكا',
 			'017' => 'ورتالىق افريكا',
 			'018' => 'وڭتۇستىك افريكا ايماعى',
 			'019' => 'امەريكا',
 			'021' => 'سولتۇستىك امەريكا (ايماق)',
 			'029' => 'كاريب',
 			'030' => 'شىعىس ازيا',
 			'034' => 'وڭتۇستىك ازيا',
 			'035' => 'وڭتۇستىك-شىعىس ازيا',
 			'039' => 'وڭتۇستىك ەۋروپا',
 			'053' => 'اۋسترالازيا',
 			'054' => 'مەلانەزيا',
 			'057' => 'ميكرونەزيا ايماعى',
 			'061' => 'پولينەزىا',
 			'142' => 'ازيا',
 			'143' => 'ورتالىق ازيا',
 			'145' => 'باتىس ازيا',
 			'150' => 'ەۋروپا',
 			'151' => 'شىعىس ەۋروپا',
 			'154' => 'سولتۇستىك ەۋروپا',
 			'155' => 'باتىس ەۋروپا',
 			'202' => 'سۋبساحارالىق افريكا',
 			'419' => 'لاتىن امەريكا',
 			'AC' => 'اسكەنجىن ارالى',
 			'AD' => 'اندوررا',
 			'AE' => 'بىرىككەن اراب امىرلىكتەرى',
 			'AF' => 'اۋعانستان',
 			'AG' => 'انتيگۋا جانە باربۋدا',
 			'AI' => 'انگيليا',
 			'AL' => 'البانيا',
 			'AM' => 'ارمەنيا',
 			'AO' => 'انگولا',
 			'AQ' => 'انتاركتيدا',
 			'AR' => 'ارگەنتينا',
 			'AS' => 'امەريكالىق ساموا',
 			'AT' => 'اۋستريا',
 			'AU' => 'اۋستراليا',
 			'AW' => 'ارۋبا',
 			'AX' => 'الاند ارالدارى',
 			'AZ' => 'ءازىربايجان',
 			'BA' => 'بوسنيا جانە گەرتسەگوۆينا',
 			'BB' => 'باربادوس',
 			'BD' => 'بانگلادەش',
 			'BE' => 'بەلگيا',
 			'BF' => 'بۋركينا-فاسو',
 			'BG' => 'بولگاريا',
 			'BH' => 'باحرەين',
 			'BI' => 'بۋرۋندي',
 			'BJ' => 'بەنين',
 			'BL' => 'سان-بارتەمەلي',
 			'BM' => 'بەرمۋد ارالدارى',
 			'BN' => 'برۋنەي',
 			'BO' => 'بوليۆيا',
 			'BQ' => 'بونەير، سينت-ەستاتيۋس جانە سابا',
 			'BR' => 'برازيليا',
 			'BS' => 'باگام ارالدارى',
 			'BT' => 'بۋتان',
 			'BV' => 'بۋۆە ارالى',
 			'BW' => 'بوتسۆانا',
 			'BY' => 'بەلارۋس',
 			'BZ' => 'بەليز',
 			'CA' => 'كانادا',
 			'CC' => 'كوكوس (كيليڭ) ارالدارى',
 			'CD' => 'كونگو',
 			'CD@alt=variant' => 'كونگو دەموكراتيالىق رەسپۋبليكاسى',
 			'CF' => 'ورتالىق افريكا رەسپۋبليكاسى',
 			'CG' => 'كونگو-براززاۆيل رەسپۋبليكاسى',
 			'CG@alt=variant' => 'كونگو رەسپۋبليكاسى',
 			'CH' => 'شۆەيساريا',
 			'CI' => 'كوت-ديۆۋار',
 			'CK' => 'كۋك ارالدارى',
 			'CL' => 'چيلي',
 			'CM' => 'كامەرۋن',
 			'CN' => 'قىتاي',
 			'CO' => 'كولۋمبيا',
 			'CP' => 'كليپپەرتون ارالى',
 			'CQ' => 'سارك',
 			'CR' => 'كوستا-ريكا',
 			'CU' => 'كۋبا',
 			'CV' => 'كابو-ۆەردە',
 			'CW' => 'كيۋراساو',
 			'CX' => 'حريستماس ارالى',
 			'CY' => 'كيپر',
 			'CZ' => 'چەحيا',
 			'CZ@alt=variant' => 'چەح رەسپۋبليكاسى',
 			'DE' => 'گەرمانيا',
 			'DG' => 'ديەگو-گارسيا',
 			'DJ' => 'دجيبۋتي',
 			'DK' => 'دانيا',
 			'DM' => 'دومينيكا',
 			'DO' => 'دومينيكان رەسپۋبليكاسى',
 			'DZ' => 'الجىر',
 			'EA' => 'سەۋتا جانە مەليليا',
 			'EC' => 'ەكۆادور',
 			'EE' => 'ەستونيا',
 			'EG' => 'مىسىر',
 			'EH' => 'باتىس ساحارا',
 			'ER' => 'ەريترەيا',
 			'ES' => 'يسپانيا',
 			'ET' => 'ەفيوپيا',
 			'EU' => 'ەۋروپالىق وداق',
 			'EZ' => 'ەۋرو ايماق',
 			'FI' => 'فينليانديا',
 			'FJ' => 'فيجي',
 			'FK' => 'فولكلەند ارالدارى',
 			'FK@alt=variant' => 'فولكلەند ارالدارى (مالۆين ارالدارى)',
 			'FM' => 'ميكرونەزيا',
 			'FO' => 'فارەر ارالدارى',
 			'FR' => 'فرانسيا',
 			'GA' => 'گابون',
 			'GB' => 'ۇلىبريتانيا',
 			'GD' => 'گرەنادا',
 			'GE' => 'گرۋزيا',
 			'GF' => 'فرانسۋز گۆياناسى',
 			'GG' => 'گەرنسي',
 			'GH' => 'گانا',
 			'GI' => 'گيبرالتار',
 			'GL' => 'گرەنلانديا',
 			'GM' => 'گامبيا',
 			'GN' => 'گۆەنيا',
 			'GP' => 'گۆادەلۋپا',
 			'GQ' => 'ەكۆاتورلىق گۆينەيا',
 			'GR' => 'گرەكيا',
 			'GS' => 'وڭتۇستىك گەورگيا جانە وڭتۇستىك ساندۆيچ ارالدارى',
 			'GT' => 'گۆاتەمالا',
 			'GU' => 'گۋان',
 			'GW' => 'گۆەنيا-بيساۋ',
 			'GY' => 'گايانا',
 			'HK' => 'حوڭكوڭ',
 			'HM' => 'حەرد ارالى جانە ماكدونالد ارالدارى',
 			'HN' => 'گوندۋراس',
 			'HR' => 'حورۆاتيا',
 			'HT' => 'گايتي',
 			'HU' => 'ماجارستان',
 			'IC' => 'كانار ارالدارى',
 			'ID' => 'يندونەزيا',
 			'IE' => 'يرلانديا',
 			'IL' => 'يزرايل',
 			'IM' => 'مەن ارالى',
 			'IN' => 'ءۇندىستان',
 			'IO' => 'ءۇندى مۇحيتىنداعى بريتان ايماعى',
 			'IO@alt=chagos' => 'چاگوس ارحيپەلاگى',
 			'IQ' => 'يراك',
 			'IR' => 'يران',
 			'IS' => 'يسلانديا',
 			'IT' => 'يتاليا',
 			'JE' => 'جەرسي',
 			'JM' => 'يامايكا',
 			'JO' => 'يوردانيا',
 			'JP' => 'جاپونيا',
 			'KE' => 'كەنيا',
 			'KG' => 'قىرعىزستان',
 			'KH' => 'كامباجا',
 			'KI' => 'كيريباتي',
 			'KM' => 'كومور ارالدارى',
 			'KN' => 'سەنت-كيتس جانە نەۆيس',
 			'KP' => 'سولتۇستىك كورەيا',
 			'KR' => 'وڭتۇستىك كورەيا',
 			'KW' => 'كۋۆەيت',
 			'KY' => 'كايمان ارالدارى',
 			'KZ' => 'قازاق ەلى',
 			'LA' => 'لاوس',
 			'LB' => 'ليۆان',
 			'LC' => 'سەنت-ليۋسيا',
 			'LI' => 'ليحتەنشتەين',
 			'LK' => 'شري-لانكا',
 			'LR' => 'ليبەريا',
 			'LS' => 'لەسوتو',
 			'LT' => 'ليتۆا',
 			'LU' => 'ليۋكسەمبۋرگ',
 			'LV' => 'لاتۆيا',
 			'LY' => 'ليۆيا',
 			'MA' => 'ماروككو',
 			'MC' => 'موناكو',
 			'MD' => 'مولدوۆا',
 			'ME' => 'چەرنوگوريا',
 			'MF' => 'سەن-مارتەن',
 			'MG' => 'ماداگاسكار',
 			'MH' => 'مارشال ارالدارى',
 			'MK' => 'سولتۇستىك ماكەدونيا',
 			'ML' => 'مالي',
 			'MM' => 'ميانما (بيرما)',
 			'MN' => 'موڭعوليا',
 			'MO' => 'ماكاو',
 			'MP' => 'سولتۇستىك ماريانا ارالدارى',
 			'MQ' => 'مارتينيكا',
 			'MR' => 'ماۆريتانيا',
 			'MS' => 'مونتسەررات',
 			'MT' => 'مالتا',
 			'MU' => 'ماۆريكي',
 			'MV' => 'مالديۆ ارالدارى',
 			'MW' => 'مالاۆي',
 			'MX' => 'مەكسيكا',
 			'MY' => 'مالايزيا',
 			'MZ' => 'موزامبيك',
 			'NA' => 'ناميبيا',
 			'NC' => 'جاڭا كالەدونيا',
 			'NE' => 'نيگەر',
 			'NF' => 'نورفولك ارالى',
 			'NG' => 'نيگەريا',
 			'NI' => 'نيكاراگۋا',
 			'NL' => 'نيدەرلاند',
 			'NO' => 'نورۆەگيا',
 			'NP' => 'نەپال',
 			'NR' => 'ناۋرۋ',
 			'NU' => 'نيۋە',
 			'NZ' => 'جاڭا زەلانديا',
 			'NZ@alt=variant' => 'اوتەاروا، جاڭا زەلانديا',
 			'OM' => 'ومان',
 			'PA' => 'پاناما',
 			'PE' => 'پەرۋ',
 			'PF' => 'فرانتسۋز پولينەزياسى',
 			'PG' => 'پاپۋا — جاڭا گۆينەيا',
 			'PH' => 'فيليپين ارالدارى',
 			'PK' => 'پاكىستان',
 			'PL' => 'پولشا',
 			'PM' => 'سەن-پەر جانە ميكەلون',
 			'PN' => 'پيتكەرن ارالدارى',
 			'PR' => 'پۋەرتو-ريكو',
 			'PS' => 'پالەستينا ايماقتارى',
 			'PS@alt=short' => 'پالەستينا',
 			'PT' => 'پورتۋگاليا',
 			'PW' => 'پالاۋ',
 			'PY' => 'پاراگۆاي',
 			'QA' => 'كاتار',
 			'QO' => 'سىرتقى وكەانيا',
 			'RE' => 'رەيۋنيون',
 			'RO' => 'رۋمىنيا',
 			'RS' => 'سەربيا',
 			'RU' => 'حەسەي',
 			'RW' => 'رۋاندا',
 			'SA' => 'ساۋد ارابياسى',
 			'SB' => 'سولومون ارالدارى',
 			'SC' => 'سەيشەل ارالدارى',
 			'SD' => 'سۋدان',
 			'SE' => 'شۆەسيا',
 			'SG' => 'سينگاپۋر',
 			'SH' => 'اۋليە ەلەنا ارالى',
 			'SI' => 'سلوۆەنيا',
 			'SJ' => 'شپيتسبەرگەن جانە يان-مايەن',
 			'SK' => 'سلوۆاكيا',
 			'SL' => 'سەررا-لەونە',
 			'SM' => 'سان-مارينو',
 			'SN' => 'سەنەگال',
 			'SO' => 'سومالي',
 			'SR' => 'سۋرينام',
 			'SS' => 'وڭتۇستىك سۋدان',
 			'ST' => 'سان-تومە جانە پرينسيپي',
 			'SV' => 'سالۆادور',
 			'SX' => 'سينت-مارتەن',
 			'SY' => 'سيريا',
 			'SZ' => 'ەسۆاتيني',
 			'SZ@alt=variant' => 'سۆازيلەند',
 			'TA' => 'تريستان-دا-كۋنيا',
 			'TC' => 'تەركس جانە كايكوس ارالدارى',
 			'TD' => 'چاد',
 			'TF' => 'فرانتسيانىڭ وڭتۇستىك ايماقتارى',
 			'TG' => 'توگو',
 			'TH' => 'تايلاند',
 			'TJ' => 'تاجىكستان',
 			'TK' => 'توكەلاۋ',
 			'TL' => 'تيمور-لەستە',
 			'TL@alt=variant' => 'شىعىس تيمور',
 			'TM' => 'تۇرىكمەنستان',
 			'TN' => 'تۋنيس',
 			'TO' => 'تونگا',
 			'TR' => 'تۇركيا',
 			'TT' => 'ترينيداد جانە توباگو',
 			'TV' => 'تۋۆالۋ',
 			'TW' => 'تايۋان',
 			'TZ' => 'تانزانيا',
 			'UA' => 'ۋكراينا',
 			'UG' => 'ۋگاندا',
 			'UM' => 'ا ق ش-تىڭ سىرتقى كىشى ارالدارى',
 			'UN' => 'بىرىككەن ۇلتتار ۇيىمى',
 			'US' => 'امەريكا قۇراما شتاتتارى',
 			'US@alt=short' => 'ا ق ش',
 			'UY' => 'ۋرۋگۆاي',
 			'UZ' => 'وزبەكستان',
 			'VA' => 'ۆاتيكان',
 			'VC' => 'سەنت-ۆينسەنت جانە گرەنادين ارالدارى',
 			'VE' => 'ۆەنەسۋەلا',
 			'VG' => 'بريتاندىق ۆيرگين ارالدارى',
 			'VI' => 'ا ق ش-تىڭ ۆيرگين ارالدارى',
 			'VN' => 'ۆيەتنام',
 			'VU' => 'ۆانۋاتۋ',
 			'WF' => 'ۋولليس جانە فۋتۋنا',
 			'WS' => 'ساموا',
 			'XA' => 'جالعان اكسەنت',
 			'XB' => 'جالعان Bidi',
 			'XK' => 'كوسوۆو',
 			'YE' => 'يەمەن',
 			'YT' => 'مايوتتا',
 			'ZA' => 'وڭتۇستىك افريكا',
 			'ZM' => 'زامبيا',
 			'ZW' => 'زيمبابۆە',
 			'ZZ' => 'بەلگىسىز ايماق',

		}
	},
);

has 'display_name_variant' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'1901' => 'ءداستۇرلى نەمىس جازۋى',
 			'1994' => 'ستاندارتتى رەزيا جازۋى',
 			'1996' => '1996 جىلعا دەيىنگى نەمىس جازۋى',
 			'1606NICT' => '1606 جىلعا دەيىنگى بەرگى ورتا فرانتسۋز ءتىلى',
 			'1694ACAD' => 'ەرتە ورتا فرانتسۋز ءتىلى',
 			'1959ACAD' => 'اكادەميالىق',
 			'ABL1943' => '1943 جىلعى جازۋدىڭ قالىپتاسۋى',
 			'AKUAPEM' => 'اكۋاپەم',
 			'ALALC97' => 'ALA-LC رومانيزاتسياسى، 1997 جىلعى نۇسقا',
 			'ALUKU' => 'الۋكۋ ديالەكتىسى',
 			'ANPEZO' => 'انپەزو',
 			'AO1990' => 'پورتۋگال ءتىلىنىڭ 1990 جىلعى جازۋ كەلىسىمى',
 			'ARANES' => 'اران',
 			'ARKAIKA' => 'شىعىس ارميان',
 			'ASANTE' => 'باتىس ارميان',
 			'AUVERN' => 'وۆەرن',
 			'BAKU1926' => 'جالپى تۇركى ءالىپبيى',
 			'BALANKA' => 'انيي بالانكا ديالەكتىسى',
 			'BARLA' => 'كابۋۆەرديانۋ بارلاۆەنتو ديالەكت توبى',
 			'BASICENG' => 'بەيسيك-ەنگليش',
 			'BAUDDHA' => 'باددا',
 			'BCIAV' => 'بسياۆ',
 			'BCIZBL' => 'بسيزبل',
 			'BISCAYAN' => 'بيسكاي',
 			'BISKE' => 'سان-جورجو/ديلا ديالەكتىسى',
 			'BLASL' => 'بلاسل',
 			'BOHORIC' => 'بوحوريچا ءالىپبيى',
 			'BOONT' => 'بۋنتلينگ',
 			'BORNHOLM' => 'بورنحولم',
 			'CISAUP' => 'سيزاۋپ',
 			'COLB1945' => '1945 جىلعى برازيليالىق پورتۋگال ءتىلى كونۆەنتسياسى',
 			'CORNU' => 'كورنۋ',
 			'CREISS' => 'كرەيس',
 			'DAJNKO' => 'داينكو ءالىپبيى',
 			'EKAVSK' => 'سەرب ءتىلىنىڭ ەكاۆ ايتىلىمى',
 			'EMODENG' => 'ەرتە ورتا اعىلشىن ءتىلى',
 			'FASCIA' => 'فاسكيا',
 			'FODOM' => 'فودوم',
 			'FONIPA' => 'حالىقارالىق فونەتيكالىق ءالىپبي',
 			'FONKIRSH' => 'فونكيرش',
 			'FONNAPA' => 'فونناپا',
 			'FONUPA' => 'ورال فونەتيكالىق ءالىپبي',
 			'FONXSAMP' => 'فونكسامپ',
 			'GALLO' => 'گاللو',
 			'GASCON' => 'گاسكون',
 			'GHERD' => 'گحەرد',
 			'GRCLASS' => 'گ ر ك ل ا س س',
 			'GRITAL' => 'گريتال',
 			'GRMISTR' => 'گ ر م ي س ت ر',
 			'HEPBURN' => 'حەپبيورن جۇيەسى',
 			'HOGNORSK' => 'حەگنورسك',
 			'HSISTEMO' => 'ح جۇيەسى',
 			'IJEKAVSK' => 'سەرب ءتىلىنىڭ يەكاۆ ايتىلىمى',
 			'ITIHASA' => 'يتيحاسا',
 			'IVANCHOV' => 'يۆانچوۆ',
 			'JAUER' => 'ياۋەر',
 			'JYUTPING' => 'يۋتپيڭ',
 			'KKCOR' => 'جالپى جازۋ',
 			'KOCIEWIE' => 'كوچەۋە',
 			'KSCOR' => 'ستاندارتتى جازۋ',
 			'LAUKIKA' => 'لاۋكيكا',
 			'LEMOSIN' => 'ليمۋزەن',
 			'LENGADOC' => 'لانگەدوك',
 			'LIPAW' => 'رەزيا ءتىلىنىڭ ليپوۆاز ديالەكتىسى',
 			'LTG1929' => 'لتگ1929',
 			'LTG2007' => 'لتگ2007',
 			'LUNA1918' => 'لۋنا1998',
 			'METELKO' => 'مەتەلكو',
 			'MONOTON' => 'مونوتوندى',
 			'NDYUKA' => 'نديۋكا',
 			'NEDIS' => 'ناتيسون ديالەكتىسى',
 			'NEWFOUND' => 'نيۋفاۋند',
 			'NICARD' => 'نيكارد',
 			'NJIVA' => 'گنيۆا/نجيۆا ديالەكتىسى',
 			'NULIK' => 'زاماناۋي ۆولاپيۋك',
 			'OSOJS' => 'وسەاككو/وسوجانە ديالەكتىسى',
 			'OXENDICT' => 'اعىلشىن ءتىلىنىڭ وكسفورد سوزدىگىندەگى ەملەسى',
 			'PAHAWH2' => 'پاحاۋح2',
 			'PAHAWH3' => 'پاحاۋح3',
 			'PAHAWH4' => 'پاحاۋح4',
 			'PAMAKA' => 'پاماكا ديالەكتىسى',
 			'PEANO' => 'پەانو',
 			'PEHOEJI' => 'پەحوەيي',
 			'PETR1708' => 'پەتر1708',
 			'PINYIN' => 'پينين رومانيزاسياسى',
 			'POLYTON' => 'پوليتوندى',
 			'POSIX' => 'كومپيۋتەر',
 			'PROVENC' => 'پروۆانس',
 			'PUTER' => 'پۋتەر',
 			'REVISED' => 'قايتا قارالعان جازۋ',
 			'RIGIK' => 'كلاسسيكالىق ۆولاپيۋك',
 			'ROZAJ' => 'رەزيا',
 			'RUMGR' => 'رۋمگر',
 			'SAAHO' => 'ساحو',
 			'SCOTLAND' => 'شوتلانديانىڭ ستاندارتتى اعىلشىن ءتىلى',
 			'SCOUSE' => 'سكاۋس',
 			'SIMPLE' => 'قاراپايىم',
 			'SOLBA' => 'ستولۆيتسا/سولبيكا ديالەكتىسى',
 			'SOTAV' => 'كابۋۆەرديانۋدىڭ سوتاۆەنتو ديالەكت توبى',
 			'SPANGLIS' => 'سپانگليش',
 			'SURMIRAN' => 'سۋرميران',
 			'SURSILV' => 'سۋرسيلۆ',
 			'SUTSILV' => 'سۋتسيلۆ',
 			'SYNNEJYL' => 'سيننەجيل',
 			'TAILO' => 'تايلو',
 			'TARASK' => 'تاراشكەۆيتسا',
 			'TONGYONG' => 'توڭيوڭ',
 			'TUNUMIIT' => 'تۋنۋمييت',
 			'UCCOR' => 'بىرىڭعاي جازۋ',
 			'UCRCOR' => 'بىرىڭعاي قايتا قارالعان جازۋ',
 			'ULSTER' => 'ولستەر',
 			'UNIFON' => 'يۋنيفون فونەتيكالىق ءالىپبيى',
 			'VAIDIKA' => 'ۆايديكا',
 			'VALBADIA' => 'ۆالباديا',
 			'VALENCIA' => 'ۆالەنسيا',
 			'VALLADER' => 'ۆاللادەر',
 			'VECDRUKA' => 'ۆەچدرۋكا',
 			'VIVARAUP' => 'ۆيۆارو-ءالپى',
 			'WADEGILE' => 'ۋەيد-جايىلس جۇيەسى',
 			'XSISTEMO' => 'X جۇيەسى',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => 'كۇنتىزبە',
 			'cf' => 'اقشا ءپىشىمى',
 			'collation' => 'سۇرىپتاۋ رەتى',
 			'currency' => 'اقشا',
 			'hc' => 'ۋاقىت فورماتى (12 نە 24)',
 			'lb' => 'جولدى تاسىمالداۋ ءستيلى',
 			'ms' => 'ولشەمدەر جۇيەسى',
 			'numbers' => 'ساندار',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[Str]],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{بۋددا كۇنتىزبەسى},
 				'chinese' => q{قىتاي كۇنتىزبەسى},
 				'coptic' => q{كوپت كۇنتىزبەسى},
 				'dangi' => q{دانگي كۇنتىزبەسى},
 				'ethiopic' => q{ەفيوپيا كۇنتىزبەسى},
 				'ethiopic-amete-alem' => q{ەفيوپيانىڭ امەتە-الەم كۇنتىزبەسى},
 				'gregorian' => q{گرەگورياندىق كۇنتىزبە},
 				'hebrew' => q{كونە ەۆرەي كۇنتىزبەسى},
 				'indian' => q{ءۇندىستاننىڭ ۇلتتىق كۇنتىزبەسى},
 				'islamic' => q{يسلام كۇنتىزبەسى},
 				'islamic-civil' => q{يسلام كۇنتىزبەسى (كەستەلىك، ازاماتتىق ءداۋىر)},
 				'islamic-rgsa' => q{يسلام كۇنتىزبەسى (ساۋد ارابياسى، جاڭا اي)},
 				'islamic-tbla' => q{يسلام كۇنتىزبەسى (كەستەلىك، استرونوميالىق ءداۋىر)},
 				'islamic-umalqura' => q{يسلام كۇنتىزبەسى (ۋمم ءال-قۇرا)},
 				'iso8601' => q{ISO-8601 كۇنتىزبەسى},
 				'japanese' => q{جاپون كۇنتىزبەسى},
 				'persian' => q{پارسى كۇنتىزبەسى},
 				'roc' => q{مينگۋو كۇنتىزبەسى},
 			},
 			'cf' => {
 				'account' => q{ەسەپتىك اقشا ءپىشىمى},
 				'standard' => q{ستاندارتتى اقشا ءپىشىمى},
 			},
 			'collation' => {
 				'big5han' => q{ءداستۇرلى قىتاي ءتىلىنىڭ سۇرىپتاۋ رەتى - Big5},
 				'compat' => q{سايكەستىككە ارنالعان الدىڭعى سۇرىپتاۋ رەتى},
 				'dictionary' => q{سوزدىك بويىنشا سۇرىپتاۋ رەتى},
 				'ducet' => q{ادەپكى ۋنيكود سۇرىپتاۋ رەتى},
 				'emoji' => q{ەموجي سۇرىپتاۋ رەتى},
 				'eor' => q{ەۋروپالىق رەتتەۋ ەرەجەلەرى},
 				'gb2312han' => q{جەڭىلدەتىلگەن قىتاي ءتىلىنىڭ سۇرىپتاۋ رەتى - GB2312},
 				'phonebook' => q{تەلەفون كىتاپشاسىنىڭ سۇرىپتاۋ رەتى},
 				'pinyin' => q{پينين سۇرىپتاۋ رەتى},
 				'search' => q{جالپى ماقساتتاعى ىزدەۋ},
 				'searchjl' => q{كورەي ءتىلىنىڭ باستاپقى داۋىسسىزى بويىنشا ىزدەۋ},
 				'standard' => q{ستاندارتتى سۇرىپتاۋ رەتى},
 				'stroke' => q{يەروگليفتەر سىزىقتارىن سۇرىپتاۋ رەتى},
 				'traditional' => q{ءداستۇرلى سۇرىپتاۋ رەتى},
 				'unihan' => q{يەروگليفتەر سىزىقتارىن تۇبەگەيلى سۇرىپتاۋ رەتى},
 				'zhuyin' => q{جۋين سۇرىپتاۋ رەتى},
 			},
 			'hc' => {
 				'h11' => q{12 ساعاتتىق جۇيە (0–11)},
 				'h12' => q{12 ساعاتتىق جۇيە (0–12)},
 				'h23' => q{24 ساعاتتىق جۇيە (0–23)},
 				'h24' => q{24 ساعاتتىق جۇيە (0–24)},
 			},
 			'lb' => {
 				'loose' => q{جولدى تاسىمالداۋدىڭ ەركىن ءستيلى},
 				'normal' => q{جولدى تاسىمالداۋدىڭ قالىپتى ءستيلى},
 				'strict' => q{جولدى تاسىمالداۋدىڭ قاتاڭ ءستيلى},
 			},
 			'ms' => {
 				'metric' => q{مەترلىك جۇيە},
 				'uksystem' => q{بريتانيالىق ولشەمدەر جۇيەسى},
 				'ussystem' => q{امەريكالىق ولشەمدەر جۇيەسى},
 			},
 			'numbers' => {
 				'ahom' => q{احوم تسيفرلارى},
 				'arab' => q{ءۇندى-اراب ساندارى},
 				'arabext' => q{ءۇندى-اراب ساندارىنىڭ كەڭەيتىلگەن جۇيەسى},
 				'armn' => q{ارميان ساندارى},
 				'armnlow' => q{كىشى ارىپپەن بەرىلگەن ارميان ساندارى},
 				'bali' => q{بالي ساندارى},
 				'beng' => q{بەنگال ساندارى},
 				'brah' => q{براحمي ساندارى},
 				'cakm' => q{چاكما ساندارى},
 				'cham' => q{چام ساندارى},
 				'cyrl' => q{كيريل ساندارى},
 				'deva' => q{دەۆاناگاري ساندارى},
 				'diak' => q{دەۆيس اكۋرۋ ساندارى},
 				'ethi' => q{ەفيوپيا ساندارى},
 				'fullwide' => q{تولىق ەندى ساندار},
 				'gara' => q{گاراي ساندارى},
 				'geor' => q{گرۋزين ساندارى},
 				'gong' => q{گۋنجالا گوندي ساندارى},
 				'gonm' => q{ماساراما گوندي ساندارى},
 				'grek' => q{گرەك ساندارى},
 				'greklow' => q{كىشى ارىپپەن بەرىلگەن گرەك ساندارى},
 				'gujr' => q{گۋجاراتي ساندارى},
 				'gukh' => q{گۋرۋڭ حەما ساندارى},
 				'guru' => q{گۋرمۋكحي ساندارى},
 				'hanidec' => q{قىتاي وندىق ساندارى},
 				'hans' => q{جەڭىلدەتىلگەن قىتاي ساندارى},
 				'hansfin' => q{قارجى سالاسىنداعى جەڭىلدەتىلگەن قىتاي ساندارى},
 				'hant' => q{ءداستۇرلى قىتاي ساندارى},
 				'hantfin' => q{قارجى سالاسىنداعى ءداستۇرلى قىتاي ساندارى},
 				'hebr' => q{يۆريت ساندارى},
 				'hmng' => q{پاحاۋ ساندارى},
 				'hmnp' => q{نياكەڭ پۋاچۋە حموڭ ساندارى},
 				'java' => q{ياۆا ساندارى},
 				'jpan' => q{جاپون ساندارى},
 				'jpanfin' => q{قارجى سالاسىنداعى جاپون ساندارى},
 				'kali' => q{كاياح لي ساندارى},
 				'kawi' => q{كاۋي ساندارى},
 				'khmr' => q{كحمەر ساندارى},
 				'knda' => q{كاننادا ساندارى},
 				'krai' => q{كيرات راي ساندارى},
 				'lana' => q{تاي تحام حورا ساندارى},
 				'lanatham' => q{تاي تحام تحام ساندارى},
 				'laoo' => q{لاوس ساندارى},
 				'latn' => q{باتىس ساندارى},
 				'lepc' => q{لەپچا ساندارى},
 				'limb' => q{ليمبۋ ساندارى},
 				'mathbold' => q{ماتەماتيكالىق قالىڭ قارىپتى ساندار},
 				'mathdbl' => q{ماتەماتيكالىق قوس سىزىقتى ساندار},
 				'mathmono' => q{ەنى بەكىتىلگەن ماتەماتيكالىق ساندار},
 				'mathsanb' => q{ماتەماتيكالىق قالىڭ قارىپتى سانسەريف ساندار},
 				'mathsans' => q{ماتەماتيكالىق سانسەريف ساندار},
 				'mlym' => q{مالايالام ساندارى},
 				'modi' => q{مودي ساندارى},
 				'mong' => q{موڭعول ساندارى},
 				'mroo' => q{مرو ساندارى},
 				'mtei' => q{مەيتەي-مايەك ساندارى},
 				'mymr' => q{ميانمار ساندارى},
 				'mymrepka' => q{ميانمار شىعىس پحو كارەن ساندارى},
 				'mymrpao' => q{ميانمار پاو ساندارى},
 				'mymrshan' => q{ميانمار شان ساندارى},
 				'mymrtlng' => q{ميانمار تاي لايڭ ساندارى},
 				'nagm' => q{ناگ مۋنداري ساندارى},
 				'nkoo' => q{نكو ساندارى},
 				'olck' => q{ول-چيكي ساندارى},
 				'onao' => q{ول-ونال ساندارى},
 				'orya' => q{وريا ساندارى},
 				'osma' => q{يسمانيا ساندارى},
 				'outlined' => q{سىزىلعان ساندار},
 				'rohg' => q{حانيفي ساندارى},
 				'roman' => q{ريم ساندارى},
 				'romanlow' => q{كىشى ارىپپەن بەرىلگەن ريم ساندارى},
 				'saur' => q{ساۋراشترا ساندارى},
 				'shrd' => q{شارادا ساندارى},
 				'sind' => q{كحۋدابادي ساندارى},
 				'sinh' => q{سينگالا ليت ساندارى},
 				'sora' => q{سورا سومپەڭ ساندارى},
 				'sund' => q{سۋندا ساندارى},
 				'sunu' => q{سۋنۋار ساندارى},
 				'takr' => q{تاكري ساندارى},
 				'talu' => q{جاڭا لۋ جازۋىنىڭ ساندارى},
 				'taml' => q{ءداستۇرلى تاميل ساندارى},
 				'tamldec' => q{تاميل ساندارى},
 				'telu' => q{تەلۋگۋ ساندارى},
 				'thai' => q{تاي ساندارى},
 				'tibt' => q{تيبەر ساندارى},
 				'tirh' => q{تيرحۋتا ساندارى},
 				'tnsa' => q{تاڭسا ساندارى},
 				'vaii' => q{ۆاي ساندارى},
 				'wara' => q{ۋاراڭ سيتي ساندارى},
 				'wcho' => q{ۋانچو ساندارى},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'metric' => q{مەترلىك},
 			'UK' => q{اعىلشىن},
 			'US' => q{امەريكالىق},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'language' => 'ءتىل: {0}',
 			'script' => 'جازۋ: {0}',
 			'region' => 'ايماق: {0}',

		}
	},
);

has 'text_orientation' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { return {
			lines => 'top-to-bottom',
			characters => 'right-to-left',
		}}
);

has 'characters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			index => ['ء', 'ا', 'ە', 'ب', 'پ', 'ت', 'ج', 'چ', 'ح', 'د', 'ر', 'ز', 'س', 'ش', 'ع', 'ف', 'ق', 'ك', 'گ', 'ڭ', 'ل', 'م', 'ن', 'ھ', 'و', 'ۇ', 'ۆ', 'ۋ', 'ى', 'ي'],
			main => qr{[ء ا ە ب پ ت ج چ ح د ر ز س ش ع ف ق ك گ ڭ ل م ن ھ و ۇ ۆ ۋ ى ي]},
			punctuation => qr{[\- ‐‑ – — ، ؛ \: ! ؟ . … '‘’ "“” « » ( ) \[ \] \{ \} § @ * / \& #]},
		};
	},
EOT
: sub {
		return { index => ['ء', 'ا', 'ە', 'ب', 'پ', 'ت', 'ج', 'چ', 'ح', 'د', 'ر', 'ز', 'س', 'ش', 'ع', 'ف', 'ق', 'ك', 'گ', 'ڭ', 'ل', 'م', 'ن', 'ھ', 'و', 'ۇ', 'ۆ', 'ۋ', 'ى', 'ي'], };
},
);


has 'more_information' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{؟},
);

has 'quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{»},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{«},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{›},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{‹},
);

has 'units' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[HashRef[Str]]],
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					# Long Unit Identifier
					'' => {
						'name' => q(نەگىزگى باعىت),
					},
					# Core Unit Identifier
					'' => {
						'name' => q(نەگىزگى باعىت),
					},
					# Long Unit Identifier
					'1024p1' => {
						'1' => q(كيبي{0}),
					},
					# Core Unit Identifier
					'1024p1' => {
						'1' => q(كيبي{0}),
					},
					# Long Unit Identifier
					'1024p2' => {
						'1' => q(مەبي{0}),
					},
					# Core Unit Identifier
					'1024p2' => {
						'1' => q(مەبي{0}),
					},
					# Long Unit Identifier
					'1024p3' => {
						'1' => q(گيبي{0}),
					},
					# Core Unit Identifier
					'1024p3' => {
						'1' => q(گيبي{0}),
					},
					# Long Unit Identifier
					'1024p4' => {
						'1' => q(تەبي{0}),
					},
					# Core Unit Identifier
					'1024p4' => {
						'1' => q(تەبي{0}),
					},
					# Long Unit Identifier
					'1024p5' => {
						'1' => q(پەبي{0}),
					},
					# Core Unit Identifier
					'1024p5' => {
						'1' => q(پەبي{0}),
					},
					# Long Unit Identifier
					'1024p6' => {
						'1' => q(ەكسبي{0}),
					},
					# Core Unit Identifier
					'1024p6' => {
						'1' => q(ەكسبي{0}),
					},
					# Long Unit Identifier
					'1024p7' => {
						'1' => q(زەبي{0}),
					},
					# Core Unit Identifier
					'1024p7' => {
						'1' => q(زەبي{0}),
					},
					# Long Unit Identifier
					'1024p8' => {
						'1' => q(يوبي{0}),
					},
					# Core Unit Identifier
					'1024p8' => {
						'1' => q(يوبي{0}),
					},
					# Long Unit Identifier
					'10p-1' => {
						'1' => q(دەسي{0}),
					},
					# Core Unit Identifier
					'1' => {
						'1' => q(دەسي{0}),
					},
					# Long Unit Identifier
					'10p-12' => {
						'1' => q(پيكو{0}),
					},
					# Core Unit Identifier
					'12' => {
						'1' => q(پيكو{0}),
					},
					# Long Unit Identifier
					'10p-15' => {
						'1' => q(فەمتو{0}),
					},
					# Core Unit Identifier
					'15' => {
						'1' => q(فەمتو{0}),
					},
					# Long Unit Identifier
					'10p-18' => {
						'1' => q(اتتو{0}),
					},
					# Core Unit Identifier
					'18' => {
						'1' => q(اتتو{0}),
					},
					# Long Unit Identifier
					'10p-2' => {
						'1' => q(سانتي{0}),
					},
					# Core Unit Identifier
					'2' => {
						'1' => q(سانتي{0}),
					},
					# Long Unit Identifier
					'10p-21' => {
						'1' => q(زەپتو{0}),
					},
					# Core Unit Identifier
					'21' => {
						'1' => q(زەپتو{0}),
					},
					# Long Unit Identifier
					'10p-24' => {
						'1' => q(يوكتو{0}),
					},
					# Core Unit Identifier
					'24' => {
						'1' => q(يوكتو{0}),
					},
					# Long Unit Identifier
					'10p-27' => {
						'1' => q(رونتو{0}),
					},
					# Core Unit Identifier
					'27' => {
						'1' => q(رونتو{0}),
					},
					# Long Unit Identifier
					'10p-3' => {
						'1' => q(ميلي{0}),
					},
					# Core Unit Identifier
					'3' => {
						'1' => q(ميلي{0}),
					},
					# Long Unit Identifier
					'10p-30' => {
						'1' => q(كۆەكتو{0}),
					},
					# Core Unit Identifier
					'30' => {
						'1' => q(كۆەكتو{0}),
					},
					# Long Unit Identifier
					'10p-6' => {
						'1' => q(ميكرو{0}),
					},
					# Core Unit Identifier
					'6' => {
						'1' => q(ميكرو{0}),
					},
					# Long Unit Identifier
					'10p-9' => {
						'1' => q(نانو{0}),
					},
					# Core Unit Identifier
					'9' => {
						'1' => q(نانو{0}),
					},
					# Long Unit Identifier
					'10p1' => {
						'1' => q(دەكا{0}),
					},
					# Core Unit Identifier
					'10p1' => {
						'1' => q(دەكا{0}),
					},
					# Long Unit Identifier
					'10p12' => {
						'1' => q(تەرا{0}),
					},
					# Core Unit Identifier
					'10p12' => {
						'1' => q(تەرا{0}),
					},
					# Long Unit Identifier
					'10p15' => {
						'1' => q(پەتا{0}),
					},
					# Core Unit Identifier
					'10p15' => {
						'1' => q(پەتا{0}),
					},
					# Long Unit Identifier
					'10p18' => {
						'1' => q(ەكسا{0}),
					},
					# Core Unit Identifier
					'10p18' => {
						'1' => q(ەكسا{0}),
					},
					# Long Unit Identifier
					'10p2' => {
						'1' => q(گەكتو{0}),
					},
					# Core Unit Identifier
					'10p2' => {
						'1' => q(گەكتو{0}),
					},
					# Long Unit Identifier
					'10p21' => {
						'1' => q(زەتا{0}),
					},
					# Core Unit Identifier
					'10p21' => {
						'1' => q(زەتا{0}),
					},
					# Long Unit Identifier
					'10p24' => {
						'1' => q(يوتا{0}),
					},
					# Core Unit Identifier
					'10p24' => {
						'1' => q(يوتا{0}),
					},
					# Long Unit Identifier
					'10p27' => {
						'1' => q(رونا{0}),
					},
					# Core Unit Identifier
					'10p27' => {
						'1' => q(رونا{0}),
					},
					# Long Unit Identifier
					'10p3' => {
						'1' => q(كيلو{0}),
					},
					# Core Unit Identifier
					'10p3' => {
						'1' => q(كيلو{0}),
					},
					# Long Unit Identifier
					'10p30' => {
						'1' => q(كۋەتا{0}),
					},
					# Core Unit Identifier
					'10p30' => {
						'1' => q(كۋەتا{0}),
					},
					# Long Unit Identifier
					'10p6' => {
						'1' => q(مەگا{0}),
					},
					# Core Unit Identifier
					'10p6' => {
						'1' => q(مەگا{0}),
					},
					# Long Unit Identifier
					'10p9' => {
						'1' => q(گيگا{0}),
					},
					# Core Unit Identifier
					'10p9' => {
						'1' => q(گيگا{0}),
					},
					# Long Unit Identifier
					'acceleration-g-force' => {
						'name' => q(تارتىلىس كۇشى),
						'one' => q({0} تارتىلىس كۇشى),
						'other' => q({0} تارتىلىس كۇشى),
					},
					# Core Unit Identifier
					'g-force' => {
						'name' => q(تارتىلىس كۇشى),
						'one' => q({0} تارتىلىس كۇشى),
						'other' => q({0} تارتىلىس كۇشى),
					},
					# Long Unit Identifier
					'acceleration-meter-per-square-second' => {
						'name' => q(مەتىر/شارشى سەكۋند),
						'one' => q({0} مەتىر/شارشى سەكۋند),
						'other' => q({0} مەتىر/شارشى سەكۋند),
					},
					# Core Unit Identifier
					'meter-per-square-second' => {
						'name' => q(مەتىر/شارشى سەكۋند),
						'one' => q({0} مەتىر/شارشى سەكۋند),
						'other' => q({0} مەتىر/شارشى سەكۋند),
					},
					# Long Unit Identifier
					'angle-arc-minute' => {
						'name' => q(اركمينۋت),
						'one' => q({0} اركمينۋت),
						'other' => q({0} اركمينۋت),
					},
					# Core Unit Identifier
					'arc-minute' => {
						'name' => q(اركمينۋت),
						'one' => q({0} اركمينۋت),
						'other' => q({0} اركمينۋت),
					},
					# Long Unit Identifier
					'angle-arc-second' => {
						'name' => q(اركسەكۋند),
						'one' => q({0} اركسەكۋند),
						'other' => q({0} اركسەكۋند),
					},
					# Core Unit Identifier
					'arc-second' => {
						'name' => q(اركسەكۋند),
						'one' => q({0} اركسەكۋند),
						'other' => q({0} اركسەكۋند),
					},
					# Long Unit Identifier
					'angle-degree' => {
						'name' => q(گرادۋس),
						'one' => q({0} گرادۋس),
						'other' => q({0} گرادۋس),
					},
					# Core Unit Identifier
					'degree' => {
						'name' => q(گرادۋس),
						'one' => q({0} گرادۋس),
						'other' => q({0} گرادۋس),
					},
					# Long Unit Identifier
					'angle-radian' => {
						'name' => q(راديان),
						'one' => q({0} راديان),
						'other' => q({0} راديان),
					},
					# Core Unit Identifier
					'radian' => {
						'name' => q(راديان),
						'one' => q({0} راديان),
						'other' => q({0} راديان),
					},
					# Long Unit Identifier
					'angle-revolution' => {
						'name' => q(اينالىم),
						'one' => q({0} اينالىم),
						'other' => q({0} اينالىم),
					},
					# Core Unit Identifier
					'revolution' => {
						'name' => q(اينالىم),
						'one' => q({0} اينالىم),
						'other' => q({0} اينالىم),
					},
					# Long Unit Identifier
					'area-acre' => {
						'name' => q(اكر),
						'one' => q({0} اكر),
						'other' => q({0} اكر),
					},
					# Core Unit Identifier
					'acre' => {
						'name' => q(اكر),
						'one' => q({0} اكر),
						'other' => q({0} اكر),
					},
					# Long Unit Identifier
					'area-dunam' => {
						'name' => q(دۋنام),
						'one' => q({0} دۋنام),
						'other' => q({0} دۋنام),
					},
					# Core Unit Identifier
					'dunam' => {
						'name' => q(دۋنام),
						'one' => q({0} دۋنام),
						'other' => q({0} دۋنام),
					},
					# Long Unit Identifier
					'area-hectare' => {
						'name' => q(گەكتار),
						'one' => q({0} گەكتار),
						'other' => q({0} گەكتار),
					},
					# Core Unit Identifier
					'hectare' => {
						'name' => q(گەكتار),
						'one' => q({0} گەكتار),
						'other' => q({0} گەكتار),
					},
					# Long Unit Identifier
					'area-square-centimeter' => {
						'name' => q(شارشى سانتيمەتىر),
						'one' => q({0} شارشى سانتيمەتىر),
						'other' => q({0} شارشى سانتيمەتىر),
						'per' => q({0}/شارشى سانتيمەتىر),
					},
					# Core Unit Identifier
					'square-centimeter' => {
						'name' => q(شارشى سانتيمەتىر),
						'one' => q({0} شارشى سانتيمەتىر),
						'other' => q({0} شارشى سانتيمەتىر),
						'per' => q({0}/شارشى سانتيمەتىر),
					},
					# Long Unit Identifier
					'area-square-foot' => {
						'name' => q(شارشى فۋت),
						'one' => q({0} شارشى فۋت),
						'other' => q({0} شارشى فۋت),
					},
					# Core Unit Identifier
					'square-foot' => {
						'name' => q(شارشى فۋت),
						'one' => q({0} شارشى فۋت),
						'other' => q({0} شارشى فۋت),
					},
					# Long Unit Identifier
					'area-square-inch' => {
						'name' => q(شارشى ديۋيم),
						'one' => q({0} شارشى ديۋيم),
						'other' => q({0} شارشى ديۋيم),
						'per' => q({0} شارشى ديۋيم),
					},
					# Core Unit Identifier
					'square-inch' => {
						'name' => q(شارشى ديۋيم),
						'one' => q({0} شارشى ديۋيم),
						'other' => q({0} شارشى ديۋيم),
						'per' => q({0} شارشى ديۋيم),
					},
					# Long Unit Identifier
					'area-square-kilometer' => {
						'name' => q(شارشى كيلومەتىر),
						'one' => q({0}/شارشى كيلومەتىر),
						'other' => q({0}/شارشى كيلومەتىر),
						'per' => q({0}/شارشى كيلومەتىر),
					},
					# Core Unit Identifier
					'square-kilometer' => {
						'name' => q(شارشى كيلومەتىر),
						'one' => q({0}/شارشى كيلومەتىر),
						'other' => q({0}/شارشى كيلومەتىر),
						'per' => q({0}/شارشى كيلومەتىر),
					},
					# Long Unit Identifier
					'area-square-meter' => {
						'name' => q(شارشى مەتىر),
						'one' => q({0} شارشى مەتىر),
						'other' => q({0} شارشى مەتىر),
						'per' => q({0}/شارشى مەتىر),
					},
					# Core Unit Identifier
					'square-meter' => {
						'name' => q(شارشى مەتىر),
						'one' => q({0} شارشى مەتىر),
						'other' => q({0} شارشى مەتىر),
						'per' => q({0}/شارشى مەتىر),
					},
					# Long Unit Identifier
					'area-square-mile' => {
						'name' => q(شارشى ميل),
						'one' => q({0} شارشى ميل),
						'other' => q({0} شارشى ميل),
						'per' => q({0}/شارشى ميل),
					},
					# Core Unit Identifier
					'square-mile' => {
						'name' => q(شارشى ميل),
						'one' => q({0} شارشى ميل),
						'other' => q({0} شارشى ميل),
						'per' => q({0}/شارشى ميل),
					},
					# Long Unit Identifier
					'area-square-yard' => {
						'name' => q(شارشى يارد),
						'one' => q({0} شارشى يارد),
						'other' => q({0} شارشى يارد),
					},
					# Core Unit Identifier
					'square-yard' => {
						'name' => q(شارشى يارد),
						'one' => q({0} شارشى يارد),
						'other' => q({0} شارشى يارد),
					},
					# Long Unit Identifier
					'concentr-item' => {
						'name' => q(ەلەمەنت),
						'one' => q({0} ەلەمەنت),
						'other' => q({0} ەلەمەنت),
					},
					# Core Unit Identifier
					'item' => {
						'name' => q(ەلەمەنت),
						'one' => q({0} ەلەمەنت),
						'other' => q({0} ەلەمەنت),
					},
					# Long Unit Identifier
					'concentr-karat' => {
						'name' => q(كارات),
						'one' => q({0} كارات),
						'other' => q({0} كارات),
					},
					# Core Unit Identifier
					'karat' => {
						'name' => q(كارات),
						'one' => q({0} كارات),
						'other' => q({0} كارات),
					},
					# Long Unit Identifier
					'concentr-milligram-ofglucose-per-deciliter' => {
						'name' => q(ميليگرام/دەسيليتىر),
						'one' => q({0} ميليگرام/دەسيمەتىر),
						'other' => q({0} ميليگرام/دەسيمەتىر),
					},
					# Core Unit Identifier
					'milligram-ofglucose-per-deciliter' => {
						'name' => q(ميليگرام/دەسيليتىر),
						'one' => q({0} ميليگرام/دەسيمەتىر),
						'other' => q({0} ميليگرام/دەسيمەتىر),
					},
					# Long Unit Identifier
					'concentr-millimole-per-liter' => {
						'name' => q(ميليمول/ليتىر),
						'one' => q({0} ميليمول/ليتىر),
						'other' => q({0} ميليمول/ليتىر),
					},
					# Core Unit Identifier
					'millimole-per-liter' => {
						'name' => q(ميليمول/ليتىر),
						'one' => q({0} ميليمول/ليتىر),
						'other' => q({0} ميليمول/ليتىر),
					},
					# Long Unit Identifier
					'concentr-mole' => {
						'name' => q(مول),
						'one' => q({0} مول),
						'other' => q({0} مول),
					},
					# Core Unit Identifier
					'mole' => {
						'name' => q(مول),
						'one' => q({0} مول),
						'other' => q({0} مول),
					},
					# Long Unit Identifier
					'concentr-percent' => {
						'name' => q(پايىز),
						'one' => q({0} پايىز),
						'other' => q({0} پايىز),
					},
					# Core Unit Identifier
					'percent' => {
						'name' => q(پايىز),
						'one' => q({0} پايىز),
						'other' => q({0} پايىز),
					},
					# Long Unit Identifier
					'concentr-permille' => {
						'name' => q(پروميللە),
						'one' => q({0} پروميللە),
						'other' => q({0} پروميللە),
					},
					# Core Unit Identifier
					'permille' => {
						'name' => q(پروميللە),
						'one' => q({0} پروميللە),
						'other' => q({0} پروميللە),
					},
					# Long Unit Identifier
					'concentr-permillion' => {
						'name' => q(ميلليوندىق ۇلەس),
						'one' => q({0} ميلليوندىق ۇلەس),
						'other' => q({0} ميلليوندىق ۇلەس),
					},
					# Core Unit Identifier
					'permillion' => {
						'name' => q(ميلليوندىق ۇلەس),
						'one' => q({0} ميلليوندىق ۇلەس),
						'other' => q({0} ميلليوندىق ۇلەس),
					},
					# Long Unit Identifier
					'concentr-permyriad' => {
						'name' => q(پروميرياد),
						'one' => q({0} پروميرياد),
						'other' => q({0} پروميرياد),
					},
					# Core Unit Identifier
					'permyriad' => {
						'name' => q(پروميرياد),
						'one' => q({0} پروميرياد),
						'other' => q({0} پروميرياد),
					},
					# Long Unit Identifier
					'concentr-portion-per-1e9' => {
						'name' => q(ميللياردتىق ۇلەس),
						'one' => q({0} ميىللياردتىق ۇلەس),
						'other' => q({0} ميللياردتىق ۇلەس),
					},
					# Core Unit Identifier
					'portion-per-1e9' => {
						'name' => q(ميللياردتىق ۇلەس),
						'one' => q({0} ميىللياردتىق ۇلەس),
						'other' => q({0} ميللياردتىق ۇلەس),
					},
					# Long Unit Identifier
					'consumption-liter-per-100-kilometer' => {
						'name' => q(ليتىر/100 كيلومەتىر),
						'one' => q({0} ليتىر/100 كيلومەتىر),
						'other' => q({0} ليتىر/100 كيلومەتىر),
					},
					# Core Unit Identifier
					'liter-per-100-kilometer' => {
						'name' => q(ليتىر/100 كيلومەتىر),
						'one' => q({0} ليتىر/100 كيلومەتىر),
						'other' => q({0} ليتىر/100 كيلومەتىر),
					},
					# Long Unit Identifier
					'consumption-liter-per-kilometer' => {
						'name' => q(ليتىر/كيلومەتىر),
						'one' => q({0} ليتىر/كيلومەتىر),
						'other' => q({0} ليتىر/كيلومەتىر),
					},
					# Core Unit Identifier
					'liter-per-kilometer' => {
						'name' => q(ليتىر/كيلومەتىر),
						'one' => q({0} ليتىر/كيلومەتىر),
						'other' => q({0} ليتىر/كيلومەتىر),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon' => {
						'name' => q(ميل/گاللون),
						'one' => q({0} ميل/گاللون),
						'other' => q({0} ميل/گاللون),
					},
					# Core Unit Identifier
					'mile-per-gallon' => {
						'name' => q(ميل/گاللون),
						'one' => q({0} ميل/گاللون),
						'other' => q({0} ميل/گاللون),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon-imperial' => {
						'name' => q(ميل/يمپ گاللون),
						'one' => q({0} ميل/يمپ گاللون),
						'other' => q({0} ميل/يمپ گاللون),
					},
					# Core Unit Identifier
					'mile-per-gallon-imperial' => {
						'name' => q(ميل/يمپ گاللون),
						'one' => q({0} ميل/يمپ گاللون),
						'other' => q({0} ميل/يمپ گاللون),
					},
					# Long Unit Identifier
					'coordinate' => {
						'east' => q({0} شىعىس),
						'north' => q({0} سولتۇستىك),
						'south' => q({0} وڭتۇستىك),
						'west' => q({0} باتىس),
					},
					# Core Unit Identifier
					'coordinate' => {
						'east' => q({0} شىعىس),
						'north' => q({0} سولتۇستىك),
						'south' => q({0} وڭتۇستىك),
						'west' => q({0} باتىس),
					},
					# Long Unit Identifier
					'digital-bit' => {
						'name' => q(بيت),
						'one' => q({0} بيت),
						'other' => q({0} بيت),
					},
					# Core Unit Identifier
					'bit' => {
						'name' => q(بيت),
						'one' => q({0} بيت),
						'other' => q({0} بيت),
					},
					# Long Unit Identifier
					'digital-byte' => {
						'name' => q(بايت),
						'one' => q({0} بايت),
						'other' => q({0} بايت),
					},
					# Core Unit Identifier
					'byte' => {
						'name' => q(بايت),
						'one' => q({0} بايت),
						'other' => q({0} بايت),
					},
					# Long Unit Identifier
					'digital-gigabit' => {
						'name' => q(گيگابيت),
						'one' => q({0} گيگابيت),
						'other' => q({0} گيگابيت),
					},
					# Core Unit Identifier
					'gigabit' => {
						'name' => q(گيگابيت),
						'one' => q({0} گيگابيت),
						'other' => q({0} گيگابيت),
					},
					# Long Unit Identifier
					'digital-gigabyte' => {
						'name' => q(گيگابايت),
						'one' => q({0} گيگابايت),
						'other' => q({0} گيگابايت),
					},
					# Core Unit Identifier
					'gigabyte' => {
						'name' => q(گيگابايت),
						'one' => q({0} گيگابايت),
						'other' => q({0} گيگابايت),
					},
					# Long Unit Identifier
					'digital-kilobit' => {
						'name' => q(كيلوبيت),
						'one' => q({0} كيلوبيت),
						'other' => q({0} كيلوبيت),
					},
					# Core Unit Identifier
					'kilobit' => {
						'name' => q(كيلوبيت),
						'one' => q({0} كيلوبيت),
						'other' => q({0} كيلوبيت),
					},
					# Long Unit Identifier
					'digital-kilobyte' => {
						'name' => q(كيلوبايت),
						'one' => q({0} كيلوبايت),
						'other' => q({0} كيلوبايت),
					},
					# Core Unit Identifier
					'kilobyte' => {
						'name' => q(كيلوبايت),
						'one' => q({0} كيلوبايت),
						'other' => q({0} كيلوبايت),
					},
					# Long Unit Identifier
					'digital-megabit' => {
						'name' => q(مەگابيت),
						'one' => q({0} مەگابيت),
						'other' => q({0} مەگابيت),
					},
					# Core Unit Identifier
					'megabit' => {
						'name' => q(مەگابيت),
						'one' => q({0} مەگابيت),
						'other' => q({0} مەگابيت),
					},
					# Long Unit Identifier
					'digital-megabyte' => {
						'name' => q(مەگابايت),
						'one' => q({0} مەگابايت),
						'other' => q({0} مەگابايت),
					},
					# Core Unit Identifier
					'megabyte' => {
						'name' => q(مەگابايت),
						'one' => q({0} مەگابايت),
						'other' => q({0} مەگابايت),
					},
					# Long Unit Identifier
					'digital-petabyte' => {
						'name' => q(پەتابايت),
						'one' => q({0} پەتابايت),
						'other' => q({0} پەتابايت),
					},
					# Core Unit Identifier
					'petabyte' => {
						'name' => q(پەتابايت),
						'one' => q({0} پەتابايت),
						'other' => q({0} پەتابايت),
					},
					# Long Unit Identifier
					'digital-terabit' => {
						'name' => q(تەرابيت),
						'one' => q({0} تەرابيت),
						'other' => q({0} تەرابيت),
					},
					# Core Unit Identifier
					'terabit' => {
						'name' => q(تەرابيت),
						'one' => q({0} تەرابيت),
						'other' => q({0} تەرابيت),
					},
					# Long Unit Identifier
					'digital-terabyte' => {
						'name' => q(تەرابايت),
						'one' => q({0} تەرابايت),
						'other' => q({0} تەرابايت),
					},
					# Core Unit Identifier
					'terabyte' => {
						'name' => q(تەرابايت),
						'one' => q({0} تەرابايت),
						'other' => q({0} تەرابايت),
					},
					# Long Unit Identifier
					'duration-century' => {
						'name' => q(عاسىر),
						'one' => q({0} عاسىر),
						'other' => q({0} عاسىر),
					},
					# Core Unit Identifier
					'century' => {
						'name' => q(عاسىر),
						'one' => q({0} عاسىر),
						'other' => q({0} عاسىر),
					},
					# Long Unit Identifier
					'duration-day' => {
						'name' => q(كۇن),
						'one' => q({0} كۇن),
						'other' => q({0} كۇن),
						'per' => q(كۇنىنە {0}),
					},
					# Core Unit Identifier
					'day' => {
						'name' => q(كۇن),
						'one' => q({0} كۇن),
						'other' => q({0} كۇن),
						'per' => q(كۇنىنە {0}),
					},
					# Long Unit Identifier
					'duration-decade' => {
						'name' => q(ون جىلدىق),
						'one' => q({0} ون جىلدىق),
						'other' => q({0} ون جىلدىق),
					},
					# Core Unit Identifier
					'decade' => {
						'name' => q(ون جىلدىق),
						'one' => q({0} ون جىلدىق),
						'other' => q({0} ون جىلدىق),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'name' => q(ساعات),
						'one' => q({0} ساعات),
						'other' => q({0} ساعات),
						'per' => q(ساعاتىنا {0}),
					},
					# Core Unit Identifier
					'hour' => {
						'name' => q(ساعات),
						'one' => q({0} ساعات),
						'other' => q({0} ساعات),
						'per' => q(ساعاتىنا {0}),
					},
					# Long Unit Identifier
					'duration-microsecond' => {
						'name' => q(ميكروسەكۋند),
						'one' => q({0} ميكروسەكۋند),
						'other' => q({0} ميكروسەكۋند),
					},
					# Core Unit Identifier
					'microsecond' => {
						'name' => q(ميكروسەكۋند),
						'one' => q({0} ميكروسەكۋند),
						'other' => q({0} ميكروسەكۋند),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'name' => q(ميليسەكۋند),
						'one' => q({0} ميليسەكۋند),
						'other' => q({0} ميليسەكۋند),
					},
					# Core Unit Identifier
					'millisecond' => {
						'name' => q(ميليسەكۋند),
						'one' => q({0} ميليسەكۋند),
						'other' => q({0} ميليسەكۋند),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'name' => q(مينۋت),
						'one' => q({0} مينۋت),
						'other' => q({0} مينۋت),
						'per' => q(مينۋتىنا {0}),
					},
					# Core Unit Identifier
					'minute' => {
						'name' => q(مينۋت),
						'one' => q({0} مينۋت),
						'other' => q({0} مينۋت),
						'per' => q(مينۋتىنا {0}),
					},
					# Long Unit Identifier
					'duration-month' => {
						'name' => q(اي),
						'one' => q({0} اي),
						'other' => q({0} اي),
						'per' => q(ايىنا {0}),
					},
					# Core Unit Identifier
					'month' => {
						'name' => q(اي),
						'one' => q({0} اي),
						'other' => q({0} اي),
						'per' => q(ايىنا {0}),
					},
					# Long Unit Identifier
					'duration-nanosecond' => {
						'name' => q(نانوسەكۋند),
						'one' => q({0} نانوسەكۋند),
						'other' => q({0} نانوسەكۋند),
					},
					# Core Unit Identifier
					'nanosecond' => {
						'name' => q(نانوسەكۋند),
						'one' => q({0} نانوسەكۋند),
						'other' => q({0} نانوسەكۋند),
					},
					# Long Unit Identifier
					'duration-night' => {
						'name' => q(ءتۇن),
						'one' => q({0} ءتۇن),
						'other' => q({0} ءتۇن),
						'per' => q({0}/ءتۇن),
					},
					# Core Unit Identifier
					'night' => {
						'name' => q(ءتۇن),
						'one' => q({0} ءتۇن),
						'other' => q({0} ءتۇن),
						'per' => q({0}/ءتۇن),
					},
					# Long Unit Identifier
					'duration-quarter' => {
						'name' => q(توقسان),
						'one' => q({0} توقسان),
						'other' => q({0} توقسان),
						'per' => q({0}/توقسان),
					},
					# Core Unit Identifier
					'quarter' => {
						'name' => q(توقسان),
						'one' => q({0} توقسان),
						'other' => q({0} توقسان),
						'per' => q({0}/توقسان),
					},
					# Long Unit Identifier
					'duration-second' => {
						'name' => q(سەكۋند),
						'one' => q({0} سەكۋند),
						'other' => q({0} سەكۋند),
						'per' => q(سەكۋندىنا {0}),
					},
					# Core Unit Identifier
					'second' => {
						'name' => q(سەكۋند),
						'one' => q({0} سەكۋند),
						'other' => q({0} سەكۋند),
						'per' => q(سەكۋندىنا {0}),
					},
					# Long Unit Identifier
					'duration-week' => {
						'name' => q(اپتا),
						'one' => q({0} اپتا),
						'other' => q({0} اپتا),
						'per' => q(اپتاسىنا {0}),
					},
					# Core Unit Identifier
					'week' => {
						'name' => q(اپتا),
						'one' => q({0} اپتا),
						'other' => q({0} اپتا),
						'per' => q(اپتاسىنا {0}),
					},
					# Long Unit Identifier
					'duration-year' => {
						'name' => q(جىل),
						'one' => q({0} جىل),
						'other' => q({0} جىل),
						'per' => q(جىلىنا {0}),
					},
					# Core Unit Identifier
					'year' => {
						'name' => q(جىل),
						'one' => q({0} جىل),
						'other' => q({0} جىل),
						'per' => q(جىلىنا {0}),
					},
					# Long Unit Identifier
					'electric-ampere' => {
						'name' => q(امپەر),
						'one' => q({0} امپەر),
						'other' => q({0} امپەر),
					},
					# Core Unit Identifier
					'ampere' => {
						'name' => q(امپەر),
						'one' => q({0} امپەر),
						'other' => q({0} امپەر),
					},
					# Long Unit Identifier
					'electric-milliampere' => {
						'name' => q(ميليامپەر),
						'one' => q({0} ميليامپەر),
						'other' => q({0} ميليامپەر),
					},
					# Core Unit Identifier
					'milliampere' => {
						'name' => q(ميليامپەر),
						'one' => q({0} ميليامپەر),
						'other' => q({0} ميليامپەر),
					},
					# Long Unit Identifier
					'electric-ohm' => {
						'name' => q(وم),
						'one' => q({0} وم),
						'other' => q({0} وم),
					},
					# Core Unit Identifier
					'ohm' => {
						'name' => q(وم),
						'one' => q({0} وم),
						'other' => q({0} وم),
					},
					# Long Unit Identifier
					'electric-volt' => {
						'name' => q(ۆولت),
						'one' => q({0} ۆولت),
						'other' => q({0} ۆولت),
					},
					# Core Unit Identifier
					'volt' => {
						'name' => q(ۆولت),
						'one' => q({0} ۆولت),
						'other' => q({0} ۆولت),
					},
					# Long Unit Identifier
					'energy-british-thermal-unit' => {
						'name' => q(بريتاندىق جىلۋ بىرلىگى),
						'one' => q({0} بريتاندىق جىلۋ بىرلىگى),
						'other' => q({0} بريتاندىق جىلۋ بىرلىگى),
					},
					# Core Unit Identifier
					'british-thermal-unit' => {
						'name' => q(بريتاندىق جىلۋ بىرلىگى),
						'one' => q({0} بريتاندىق جىلۋ بىرلىگى),
						'other' => q({0} بريتاندىق جىلۋ بىرلىگى),
					},
					# Long Unit Identifier
					'energy-calorie' => {
						'name' => q(كالوريا),
						'one' => q({0} كالوريا),
						'other' => q({0} كالوريا),
					},
					# Core Unit Identifier
					'calorie' => {
						'name' => q(كالوريا),
						'one' => q({0} كالوريا),
						'other' => q({0} كالوريا),
					},
					# Long Unit Identifier
					'energy-electronvolt' => {
						'name' => q(ەلەكتونۆولت),
						'one' => q({0} ەلەكترونۆولت),
						'other' => q({0} ەلەكترونۆولت),
					},
					# Core Unit Identifier
					'electronvolt' => {
						'name' => q(ەلەكتونۆولت),
						'one' => q({0} ەلەكترونۆولت),
						'other' => q({0} ەلەكترونۆولت),
					},
					# Long Unit Identifier
					'energy-joule' => {
						'name' => q(جوۋل),
						'one' => q({0} جوۋل),
						'other' => q({0} جوۋل),
					},
					# Core Unit Identifier
					'joule' => {
						'name' => q(جوۋل),
						'one' => q({0} جوۋل),
						'other' => q({0} جوۋل),
					},
					# Long Unit Identifier
					'energy-kilocalorie' => {
						'name' => q(كيلوكالوريا),
						'one' => q({0} كيلوكالوريا),
						'other' => q({0} كيلوكالوريا),
					},
					# Core Unit Identifier
					'kilocalorie' => {
						'name' => q(كيلوكالوريا),
						'one' => q({0} كيلوكالوريا),
						'other' => q({0} كيلوكالوريا),
					},
					# Long Unit Identifier
					'energy-kilojoule' => {
						'name' => q(كيلوجوۋل),
						'one' => q({0} كىلوجوۋل),
						'other' => q({0} كىلوجوۋل),
					},
					# Core Unit Identifier
					'kilojoule' => {
						'name' => q(كيلوجوۋل),
						'one' => q({0} كىلوجوۋل),
						'other' => q({0} كىلوجوۋل),
					},
					# Long Unit Identifier
					'energy-kilowatt-hour' => {
						'name' => q(كيلوۆات-ساعات),
						'one' => q({0} كيلوۆات-ساعات),
						'other' => q({0} كيلوۆات-ساعات),
					},
					# Core Unit Identifier
					'kilowatt-hour' => {
						'name' => q(كيلوۆات-ساعات),
						'one' => q({0} كيلوۆات-ساعات),
						'other' => q({0} كيلوۆات-ساعات),
					},
					# Long Unit Identifier
					'energy-therm-us' => {
						'name' => q(ا ق ش تەرمى),
						'one' => q({0} ا ق ش تەرمى),
						'other' => q({0} ا ق ش تەرمى),
					},
					# Core Unit Identifier
					'therm-us' => {
						'name' => q(ا ق ش تەرمى),
						'one' => q({0} ا ق ش تەرمى),
						'other' => q({0} ا ق ش تەرمى),
					},
					# Long Unit Identifier
					'force-kilowatt-hour-per-100-kilometer' => {
						'name' => q(كيلوۆات-ساعات/100 كيلومەتىر),
						'one' => q({0} كيلوۆات-ساعات/100 كيلومەتىر),
						'other' => q({0} كيلوۆات-ساعات/100 كيلومەتىر),
					},
					# Core Unit Identifier
					'kilowatt-hour-per-100-kilometer' => {
						'name' => q(كيلوۆات-ساعات/100 كيلومەتىر),
						'one' => q({0} كيلوۆات-ساعات/100 كيلومەتىر),
						'other' => q({0} كيلوۆات-ساعات/100 كيلومەتىر),
					},
					# Long Unit Identifier
					'force-newton' => {
						'name' => q(نيۋتون),
						'one' => q({0} نيۋتون),
						'other' => q({0} نيۋتون),
					},
					# Core Unit Identifier
					'newton' => {
						'name' => q(نيۋتون),
						'one' => q({0} نيۋتون),
						'other' => q({0} نيۋتون),
					},
					# Long Unit Identifier
					'force-pound-force' => {
						'name' => q(فۋنت-كۇش),
						'one' => q({0} فۋنت-كۇش),
						'other' => q({0} فۋنت-كۇش),
					},
					# Core Unit Identifier
					'pound-force' => {
						'name' => q(فۋنت-كۇش),
						'one' => q({0} فۋنت-كۇش),
						'other' => q({0} فۋنت-كۇش),
					},
					# Long Unit Identifier
					'frequency-gigahertz' => {
						'name' => q(گيگاگەرس),
						'one' => q({0} گيگاگەرس),
						'other' => q({0} گيگاگەرس),
					},
					# Core Unit Identifier
					'gigahertz' => {
						'name' => q(گيگاگەرس),
						'one' => q({0} گيگاگەرس),
						'other' => q({0} گيگاگەرس),
					},
					# Long Unit Identifier
					'frequency-hertz' => {
						'name' => q(گەرس),
						'one' => q({0} گەرس),
						'other' => q({0} گەرس),
					},
					# Core Unit Identifier
					'hertz' => {
						'name' => q(گەرس),
						'one' => q({0} گەرس),
						'other' => q({0} گەرس),
					},
					# Long Unit Identifier
					'frequency-kilohertz' => {
						'name' => q(كيلوگەرس),
						'one' => q({0} كيلوگەرس),
						'other' => q({0} كيلوگەرس),
					},
					# Core Unit Identifier
					'kilohertz' => {
						'name' => q(كيلوگەرس),
						'one' => q({0} كيلوگەرس),
						'other' => q({0} كيلوگەرس),
					},
					# Long Unit Identifier
					'frequency-megahertz' => {
						'name' => q(مەگاگەرس),
						'one' => q({0} مەگاگەرس),
						'other' => q({0} مەگاگەرس),
					},
					# Core Unit Identifier
					'megahertz' => {
						'name' => q(مەگاگەرس),
						'one' => q({0} مەگاگەرس),
						'other' => q({0} مەگاگەرس),
					},
					# Long Unit Identifier
					'graphics-em' => {
						'name' => q(باسپالىق em),
					},
					# Core Unit Identifier
					'em' => {
						'name' => q(باسپالىق em),
					},
					# Long Unit Identifier
					'graphics-megapixel' => {
						'name' => q(مەگاپيكسەل),
					},
					# Core Unit Identifier
					'megapixel' => {
						'name' => q(مەگاپيكسەل),
					},
					# Long Unit Identifier
					'graphics-pixel' => {
						'name' => q(پيكسەل),
					},
					# Core Unit Identifier
					'pixel' => {
						'name' => q(پيكسەل),
					},
					# Long Unit Identifier
					'graphics-pixel-per-centimeter' => {
						'name' => q(پيكسەل/سانتيمەتىر),
					},
					# Core Unit Identifier
					'pixel-per-centimeter' => {
						'name' => q(پيكسەل/سانتيمەتىر),
					},
					# Long Unit Identifier
					'graphics-pixel-per-inch' => {
						'name' => q(پيكسەل/ديۋيم),
					},
					# Core Unit Identifier
					'pixel-per-inch' => {
						'name' => q(پيكسەل/ديۋيم),
					},
					# Long Unit Identifier
					'length-astronomical-unit' => {
						'name' => q(استرونوميالىق بىرلىك),
						'one' => q({0} استرونوميالىق بىرلىك),
						'other' => q({0} استرونوميالىق بىرلىك),
					},
					# Core Unit Identifier
					'astronomical-unit' => {
						'name' => q(استرونوميالىق بىرلىك),
						'one' => q({0} استرونوميالىق بىرلىك),
						'other' => q({0} استرونوميالىق بىرلىك),
					},
					# Long Unit Identifier
					'length-centimeter' => {
						'name' => q(سانتيمەتىر),
						'one' => q({0}/سانتيمەتىر),
						'other' => q({0}/سانتيمەتىر),
						'per' => q({0}/سانتيمەتىر),
					},
					# Core Unit Identifier
					'centimeter' => {
						'name' => q(سانتيمەتىر),
						'one' => q({0}/سانتيمەتىر),
						'other' => q({0}/سانتيمەتىر),
						'per' => q({0}/سانتيمەتىر),
					},
					# Long Unit Identifier
					'length-decimeter' => {
						'name' => q(دەسيمەتىر),
						'one' => q({0}/دەسيمەتىر),
						'other' => q({0}/دەسيمەتىر),
					},
					# Core Unit Identifier
					'decimeter' => {
						'name' => q(دەسيمەتىر),
						'one' => q({0}/دەسيمەتىر),
						'other' => q({0}/دەسيمەتىر),
					},
					# Long Unit Identifier
					'length-earth-radius' => {
						'name' => q(جەر راديۋسى),
						'one' => q({0} جەر راديۋسى),
						'other' => q({0} جەر راديۋسى),
					},
					# Core Unit Identifier
					'earth-radius' => {
						'name' => q(جەر راديۋسى),
						'one' => q({0} جەر راديۋسى),
						'other' => q({0} جەر راديۋسى),
					},
					# Long Unit Identifier
					'length-fathom' => {
						'name' => q(فاتوم),
						'one' => q({0} فاتوم),
						'other' => q({0} فاتوم),
					},
					# Core Unit Identifier
					'fathom' => {
						'name' => q(فاتوم),
						'one' => q({0} فاتوم),
						'other' => q({0} فاتوم),
					},
					# Long Unit Identifier
					'length-foot' => {
						'name' => q(فۋت),
						'one' => q({0}/فۋت),
						'other' => q({0}/فۋت),
						'per' => q({0}/فۋت),
					},
					# Core Unit Identifier
					'foot' => {
						'name' => q(فۋت),
						'one' => q({0}/فۋت),
						'other' => q({0}/فۋت),
						'per' => q({0}/فۋت),
					},
					# Long Unit Identifier
					'length-furlong' => {
						'name' => q(فۋرلوڭ),
						'one' => q({0} فۋرلوڭ),
						'other' => q({0} فۋرلوڭ),
					},
					# Core Unit Identifier
					'furlong' => {
						'name' => q(فۋرلوڭ),
						'one' => q({0} فۋرلوڭ),
						'other' => q({0} فۋرلوڭ),
					},
					# Long Unit Identifier
					'length-inch' => {
						'name' => q(ديۋيم),
						'one' => q({0} ديۋيم),
						'other' => q({0} ديۋيم),
						'per' => q({0}/ديۋيم),
					},
					# Core Unit Identifier
					'inch' => {
						'name' => q(ديۋيم),
						'one' => q({0} ديۋيم),
						'other' => q({0} ديۋيم),
						'per' => q({0}/ديۋيم),
					},
					# Long Unit Identifier
					'length-kilometer' => {
						'name' => q(كيلومەتىر),
						'one' => q({0} كيلومەتىر),
						'other' => q({0} كيلومەتىر),
						'per' => q({0}/كيلومەتىر),
					},
					# Core Unit Identifier
					'kilometer' => {
						'name' => q(كيلومەتىر),
						'one' => q({0} كيلومەتىر),
						'other' => q({0} كيلومەتىر),
						'per' => q({0}/كيلومەتىر),
					},
					# Long Unit Identifier
					'length-light-year' => {
						'name' => q(جارىق جىلى),
						'one' => q({0} جارىق جىلى),
						'other' => q({0} جارىق جىلى),
					},
					# Core Unit Identifier
					'light-year' => {
						'name' => q(جارىق جىلى),
						'one' => q({0} جارىق جىلى),
						'other' => q({0} جارىق جىلى),
					},
					# Long Unit Identifier
					'length-meter' => {
						'name' => q(مەتىر),
						'one' => q({0}/مەتىر),
						'other' => q({0}/مەتىر),
						'per' => q({0}/مەتىر),
					},
					# Core Unit Identifier
					'meter' => {
						'name' => q(مەتىر),
						'one' => q({0}/مەتىر),
						'other' => q({0}/مەتىر),
						'per' => q({0}/مەتىر),
					},
					# Long Unit Identifier
					'length-micrometer' => {
						'name' => q(ميكرومەتىر),
						'one' => q({0} ميكرومەتىر),
						'other' => q({0} ميكرومەتىر),
					},
					# Core Unit Identifier
					'micrometer' => {
						'name' => q(ميكرومەتىر),
						'one' => q({0} ميكرومەتىر),
						'other' => q({0} ميكرومەتىر),
					},
					# Long Unit Identifier
					'length-mile' => {
						'name' => q(ميل),
						'one' => q({0} ميل),
						'other' => q({0} ميل),
					},
					# Core Unit Identifier
					'mile' => {
						'name' => q(ميل),
						'one' => q({0} ميل),
						'other' => q({0} ميل),
					},
					# Long Unit Identifier
					'length-mile-scandinavian' => {
						'name' => q(سكانديناۆيالىق ميل),
						'one' => q({0} سكانديناۆيالىق ميلى),
						'other' => q({0} سكانديناۆيالىق ميلى),
					},
					# Core Unit Identifier
					'mile-scandinavian' => {
						'name' => q(سكانديناۆيالىق ميل),
						'one' => q({0} سكانديناۆيالىق ميلى),
						'other' => q({0} سكانديناۆيالىق ميلى),
					},
					# Long Unit Identifier
					'length-millimeter' => {
						'name' => q(ميليمەتىر),
						'one' => q({0} ميليمەتىر),
						'other' => q({0} ميليمەتىر),
					},
					# Core Unit Identifier
					'millimeter' => {
						'name' => q(ميليمەتىر),
						'one' => q({0} ميليمەتىر),
						'other' => q({0} ميليمەتىر),
					},
					# Long Unit Identifier
					'length-nanometer' => {
						'name' => q(نانومەتىر),
						'one' => q({0} نانومەتىر),
						'other' => q({0} نانومەتىر),
					},
					# Core Unit Identifier
					'nanometer' => {
						'name' => q(نانومەتىر),
						'one' => q({0} نانومەتىر),
						'other' => q({0} نانومەتىر),
					},
					# Long Unit Identifier
					'length-nautical-mile' => {
						'name' => q(تەڭىز ميلى),
						'one' => q({0} تەڭىز ميلى),
						'other' => q({0} تەڭىز ميلى),
					},
					# Core Unit Identifier
					'nautical-mile' => {
						'name' => q(تەڭىز ميلى),
						'one' => q({0} تەڭىز ميلى),
						'other' => q({0} تەڭىز ميلى),
					},
					# Long Unit Identifier
					'length-parsec' => {
						'name' => q(پارسەك),
						'one' => q({0} پارسەك),
						'other' => q({0} پارسەك),
					},
					# Core Unit Identifier
					'parsec' => {
						'name' => q(پارسەك),
						'one' => q({0} پارسەك),
						'other' => q({0} پارسەك),
					},
					# Long Unit Identifier
					'length-picometer' => {
						'name' => q(پيكومەتىر),
						'one' => q({0} پيكومەتىر),
						'other' => q({0} پيكومەتىر),
					},
					# Core Unit Identifier
					'picometer' => {
						'name' => q(پيكومەتىر),
						'one' => q({0} پيكومەتىر),
						'other' => q({0} پيكومەتىر),
					},
					# Long Unit Identifier
					'length-point' => {
						'name' => q(پۋنكت),
						'one' => q({0} پۋنكت),
						'other' => q({0} پۋنكت),
					},
					# Core Unit Identifier
					'point' => {
						'name' => q(پۋنكت),
						'one' => q({0} پۋنكت),
						'other' => q({0} پۋنكت),
					},
					# Long Unit Identifier
					'length-solar-radius' => {
						'name' => q(كۇن راديۋسى),
						'one' => q({0} كۇن راديۋسى),
						'other' => q({0} كۇن راديۋسى),
					},
					# Core Unit Identifier
					'solar-radius' => {
						'name' => q(كۇن راديۋسى),
						'one' => q({0} كۇن راديۋسى),
						'other' => q({0} كۇن راديۋسى),
					},
					# Long Unit Identifier
					'length-yard' => {
						'name' => q(يارد),
						'one' => q({0} يارد),
						'other' => q({0} يارد),
					},
					# Core Unit Identifier
					'yard' => {
						'name' => q(يارد),
						'one' => q({0} يارد),
						'other' => q({0} يارد),
					},
					# Long Unit Identifier
					'light-candela' => {
						'name' => q(كاندەلا),
						'one' => q({0} كاندەلا),
						'other' => q({0} كاندەلا),
					},
					# Core Unit Identifier
					'candela' => {
						'name' => q(كاندەلا),
						'one' => q({0} كاندەلا),
						'other' => q({0} كاندەلا),
					},
					# Long Unit Identifier
					'light-lumen' => {
						'name' => q(ليۋمەن),
						'one' => q({0} ليۋمەن),
						'other' => q({0} ليۋمەن),
					},
					# Core Unit Identifier
					'lumen' => {
						'name' => q(ليۋمەن),
						'one' => q({0} ليۋمەن),
						'other' => q({0} ليۋمەن),
					},
					# Long Unit Identifier
					'light-lux' => {
						'name' => q(ليۋكس),
						'one' => q({0} ليۋكس),
						'other' => q({0} ليۋكس),
					},
					# Core Unit Identifier
					'lux' => {
						'name' => q(ليۋكس),
						'one' => q({0} ليۋكس),
						'other' => q({0} ليۋكس),
					},
					# Long Unit Identifier
					'light-solar-luminosity' => {
						'name' => q(كۇن جارىقتىعى),
						'one' => q({0} كۇن جارىقتىعى),
						'other' => q({0} كۇن جارىقتىعى),
					},
					# Core Unit Identifier
					'solar-luminosity' => {
						'name' => q(كۇن جارىقتىعى),
						'one' => q({0} كۇن جارىقتىعى),
						'other' => q({0} كۇن جارىقتىعى),
					},
					# Long Unit Identifier
					'mass-carat' => {
						'name' => q(كارات),
						'one' => q({0} كارات),
						'other' => q({0} كارات),
					},
					# Core Unit Identifier
					'carat' => {
						'name' => q(كارات),
						'one' => q({0} كارات),
						'other' => q({0} كارات),
					},
					# Long Unit Identifier
					'mass-dalton' => {
						'name' => q(دالتون),
						'one' => q({0} دالتون),
						'other' => q({0} دالتون),
					},
					# Core Unit Identifier
					'dalton' => {
						'name' => q(دالتون),
						'one' => q({0} دالتون),
						'other' => q({0} دالتون),
					},
					# Long Unit Identifier
					'mass-earth-mass' => {
						'name' => q(جەر ماسساسى),
						'one' => q({0} جەر ماسساسى),
						'other' => q({0} جەر ماسساسى),
					},
					# Core Unit Identifier
					'earth-mass' => {
						'name' => q(جەر ماسساسى),
						'one' => q({0} جەر ماسساسى),
						'other' => q({0} جەر ماسساسى),
					},
					# Long Unit Identifier
					'mass-grain' => {
						'name' => q(گران),
						'one' => q({0} گران),
						'other' => q({0} گران),
					},
					# Core Unit Identifier
					'grain' => {
						'name' => q(گران),
						'one' => q({0} گران),
						'other' => q({0} گران),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'name' => q(گرام),
						'one' => q({0} گرام),
						'other' => q({0} گرام),
						'per' => q({0}/گرام),
					},
					# Core Unit Identifier
					'gram' => {
						'name' => q(گرام),
						'one' => q({0} گرام),
						'other' => q({0} گرام),
						'per' => q({0}/گرام),
					},
					# Long Unit Identifier
					'mass-kilogram' => {
						'name' => q(كيلوگرام),
						'one' => q({0} كيلوگرام),
						'other' => q({0} كيلوگرام),
						'per' => q({0}/كيلوگرام),
					},
					# Core Unit Identifier
					'kilogram' => {
						'name' => q(كيلوگرام),
						'one' => q({0} كيلوگرام),
						'other' => q({0} كيلوگرام),
						'per' => q({0}/كيلوگرام),
					},
					# Long Unit Identifier
					'mass-microgram' => {
						'name' => q(ميكروگرام),
						'one' => q({0} ميكروگرام),
						'other' => q({0} ميكروگرام),
					},
					# Core Unit Identifier
					'microgram' => {
						'name' => q(ميكروگرام),
						'one' => q({0} ميكروگرام),
						'other' => q({0} ميكروگرام),
					},
					# Long Unit Identifier
					'mass-milligram' => {
						'name' => q(ميليگرام),
						'one' => q({0} ميليگرام),
						'other' => q({0} ميليگرام),
					},
					# Core Unit Identifier
					'milligram' => {
						'name' => q(ميليگرام),
						'one' => q({0} ميليگرام),
						'other' => q({0} ميليگرام),
					},
					# Long Unit Identifier
					'mass-ounce' => {
						'name' => q(ۋنسيا),
						'one' => q({0} ۋنسيا),
						'other' => q({0} ۋنسيا),
						'per' => q({0}/ۋنسيا),
					},
					# Core Unit Identifier
					'ounce' => {
						'name' => q(ۋنسيا),
						'one' => q({0} ۋنسيا),
						'other' => q({0} ۋنسيا),
						'per' => q({0}/ۋنسيا),
					},
					# Long Unit Identifier
					'mass-ounce-troy' => {
						'name' => q(تروي ۋنسياسى),
						'one' => q({0} تروۋ ۋنسياسى),
						'other' => q({0} تروۋ ۋنسياسى),
					},
					# Core Unit Identifier
					'ounce-troy' => {
						'name' => q(تروي ۋنسياسى),
						'one' => q({0} تروۋ ۋنسياسى),
						'other' => q({0} تروۋ ۋنسياسى),
					},
					# Long Unit Identifier
					'mass-pound' => {
						'name' => q(فۋنت),
						'one' => q({0} فۋنت),
						'other' => q({0} فۋنت),
						'per' => q({0}/فۋنت),
					},
					# Core Unit Identifier
					'pound' => {
						'name' => q(فۋنت),
						'one' => q({0} فۋنت),
						'other' => q({0} فۋنت),
						'per' => q({0}/فۋنت),
					},
					# Long Unit Identifier
					'mass-solar-mass' => {
						'name' => q(كۇن ماسساسى),
						'one' => q({0} كۇن ماسساسى),
						'other' => q({0} كۇن ماسساسى),
					},
					# Core Unit Identifier
					'solar-mass' => {
						'name' => q(كۇن ماسساسى),
						'one' => q({0} كۇن ماسساسى),
						'other' => q({0} كۇن ماسساسى),
					},
					# Long Unit Identifier
					'mass-stone' => {
						'name' => q(ستوۋن),
						'one' => q({0} ستوۋن),
						'other' => q({0} ستوۋن),
					},
					# Core Unit Identifier
					'stone' => {
						'name' => q(ستوۋن),
						'one' => q({0} ستوۋن),
						'other' => q({0} ستوۋن),
					},
					# Long Unit Identifier
					'mass-ton' => {
						'name' => q(توننا),
						'one' => q({0} تن),
						'other' => q({0} تن),
					},
					# Core Unit Identifier
					'ton' => {
						'name' => q(توننا),
						'one' => q({0} تن),
						'other' => q({0} تن),
					},
					# Long Unit Identifier
					'mass-tonne' => {
						'name' => q(مەتىرلىك توننا),
						'one' => q({0} مەتىرلىك توننا),
						'other' => q({0} مەتىرلىك توننا),
					},
					# Core Unit Identifier
					'tonne' => {
						'name' => q(مەتىرلىك توننا),
						'one' => q({0} مەتىرلىك توننا),
						'other' => q({0} مەتىرلىك توننا),
					},
					# Long Unit Identifier
					'power-gigawatt' => {
						'name' => q(گيگاۆات),
						'one' => q({0} گيگاۆات),
						'other' => q({0} گيگاۆات),
					},
					# Core Unit Identifier
					'gigawatt' => {
						'name' => q(گيگاۆات),
						'one' => q({0} گيگاۆات),
						'other' => q({0} گيگاۆات),
					},
					# Long Unit Identifier
					'power-horsepower' => {
						'name' => q(ات كۇشى),
						'one' => q({0} ات كۇشى),
						'other' => q({0} ات كۇشى),
					},
					# Core Unit Identifier
					'horsepower' => {
						'name' => q(ات كۇشى),
						'one' => q({0} ات كۇشى),
						'other' => q({0} ات كۇشى),
					},
					# Long Unit Identifier
					'power-kilowatt' => {
						'name' => q(كيلوۆات),
						'one' => q({0} كيلوۆات),
						'other' => q({0} كيلوۆات),
					},
					# Core Unit Identifier
					'kilowatt' => {
						'name' => q(كيلوۆات),
						'one' => q({0} كيلوۆات),
						'other' => q({0} كيلوۆات),
					},
					# Long Unit Identifier
					'power-megawatt' => {
						'name' => q(مەگاۆات),
						'one' => q({0} مەگاۆات),
						'other' => q({0} مەگاۆات),
					},
					# Core Unit Identifier
					'megawatt' => {
						'name' => q(مەگاۆات),
						'one' => q({0} مەگاۆات),
						'other' => q({0} مەگاۆات),
					},
					# Long Unit Identifier
					'power-milliwatt' => {
						'name' => q(ميليۆات),
						'one' => q({0} ميليۆات),
						'other' => q({0} ميليۆات),
					},
					# Core Unit Identifier
					'milliwatt' => {
						'name' => q(ميليۆات),
						'one' => q({0} ميليۆات),
						'other' => q({0} ميليۆات),
					},
					# Long Unit Identifier
					'power-watt' => {
						'name' => q(ۆات),
						'one' => q({0} ۆات),
						'other' => q({0} ۆات),
					},
					# Core Unit Identifier
					'watt' => {
						'name' => q(ۆات),
						'one' => q({0} ۆات),
						'other' => q({0} ۆات),
					},
					# Long Unit Identifier
					'power2' => {
						'one' => q(شارشى {0}),
						'other' => q(شارشى {0}),
					},
					# Core Unit Identifier
					'power2' => {
						'one' => q(شارشى {0}),
						'other' => q(شارشى {0}),
					},
					# Long Unit Identifier
					'power3' => {
						'one' => q(تەكشە {0}),
						'other' => q(تەكشە {0}),
					},
					# Core Unit Identifier
					'power3' => {
						'one' => q(تەكشە {0}),
						'other' => q(تەكشە {0}),
					},
					# Long Unit Identifier
					'pressure-atmosphere' => {
						'name' => q(اتموسفەرا),
						'one' => q({0} اتموسفەرا),
						'other' => q({0} اتموسفەرا),
					},
					# Core Unit Identifier
					'atmosphere' => {
						'name' => q(اتموسفەرا),
						'one' => q({0} اتموسفەرا),
						'other' => q({0} اتموسفەرا),
					},
					# Long Unit Identifier
					'pressure-bar' => {
						'name' => q(بار),
						'one' => q({0} بار),
						'other' => q({0} بار),
					},
					# Core Unit Identifier
					'bar' => {
						'name' => q(بار),
						'one' => q({0} بار),
						'other' => q({0} بار),
					},
					# Long Unit Identifier
					'pressure-hectopascal' => {
						'name' => q(گەكتوپاسكال),
						'one' => q({0} گەكتوپاسكال),
						'other' => q({0} گەكتوپاسكال),
					},
					# Core Unit Identifier
					'hectopascal' => {
						'name' => q(گەكتوپاسكال),
						'one' => q({0} گەكتوپاسكال),
						'other' => q({0} گەكتوپاسكال),
					},
					# Long Unit Identifier
					'pressure-inch-ofhg' => {
						'name' => q(ديۋيم سىناپ باعاناسى),
						'one' => q({0} ديۋيم سىناپ باعاناسى),
						'other' => q({0} ديۋيم سىناپ باعاناسى),
					},
					# Core Unit Identifier
					'inch-ofhg' => {
						'name' => q(ديۋيم سىناپ باعاناسى),
						'one' => q({0} ديۋيم سىناپ باعاناسى),
						'other' => q({0} ديۋيم سىناپ باعاناسى),
					},
					# Long Unit Identifier
					'pressure-kilopascal' => {
						'name' => q(كيلوپاسكال),
						'one' => q({0} كيلوپاسكال),
						'other' => q({0} كيلوپاسكال),
					},
					# Core Unit Identifier
					'kilopascal' => {
						'name' => q(كيلوپاسكال),
						'one' => q({0} كيلوپاسكال),
						'other' => q({0} كيلوپاسكال),
					},
					# Long Unit Identifier
					'pressure-megapascal' => {
						'name' => q(مەگاپاسكال),
						'one' => q({0} مەگاپاسكال),
						'other' => q({0} مەگاپاسكال),
					},
					# Core Unit Identifier
					'megapascal' => {
						'name' => q(مەگاپاسكال),
						'one' => q({0} مەگاپاسكال),
						'other' => q({0} مەگاپاسكال),
					},
					# Long Unit Identifier
					'pressure-millibar' => {
						'name' => q(ميليبار),
						'one' => q({0} ميليبار),
						'other' => q({0} ميليبار),
					},
					# Core Unit Identifier
					'millibar' => {
						'name' => q(ميليبار),
						'one' => q({0} ميليبار),
						'other' => q({0} ميليبار),
					},
					# Long Unit Identifier
					'pressure-millimeter-ofhg' => {
						'name' => q(ميليمەتىر سىناپ باعاناسى),
						'one' => q({0} ميليمەتىر سىناپ باعاناسى),
						'other' => q({0} ميليمەتىر سىناپ باعاناسى),
					},
					# Core Unit Identifier
					'millimeter-ofhg' => {
						'name' => q(ميليمەتىر سىناپ باعاناسى),
						'one' => q({0} ميليمەتىر سىناپ باعاناسى),
						'other' => q({0} ميليمەتىر سىناپ باعاناسى),
					},
					# Long Unit Identifier
					'pressure-pascal' => {
						'name' => q(پاسكال),
						'one' => q({0} پاسكال),
						'other' => q({0} پاسكال),
					},
					# Core Unit Identifier
					'pascal' => {
						'name' => q(پاسكال),
						'one' => q({0} پاسكال),
						'other' => q({0} پاسكال),
					},
					# Long Unit Identifier
					'pressure-pound-force-per-square-inch' => {
						'name' => q(فۋنت-كۇش/شارشى ديۋيم),
						'one' => q({0} فۋنت-كۇش/شارشى ديۋيم),
						'other' => q({0} فۋنت-كۇش/شارشى ديۋيم),
					},
					# Core Unit Identifier
					'pound-force-per-square-inch' => {
						'name' => q(فۋنت-كۇش/شارشى ديۋيم),
						'one' => q({0} فۋنت-كۇش/شارشى ديۋيم),
						'other' => q({0} فۋنت-كۇش/شارشى ديۋيم),
					},
					# Long Unit Identifier
					'speed-beaufort' => {
						'name' => q(بوفورت),
						'one' => q({0} بوفورت),
						'other' => q({0} بوفورت),
					},
					# Core Unit Identifier
					'beaufort' => {
						'name' => q(بوفورت),
						'one' => q({0} بوفورت),
						'other' => q({0} بوفورت),
					},
					# Long Unit Identifier
					'speed-kilometer-per-hour' => {
						'name' => q(كيلومەتىر/ساعات),
						'one' => q({0} كيلومەتىر/ساعات),
						'other' => q({0} كيلومەتىر/ساعات),
					},
					# Core Unit Identifier
					'kilometer-per-hour' => {
						'name' => q(كيلومەتىر/ساعات),
						'one' => q({0} كيلومەتىر/ساعات),
						'other' => q({0} كيلومەتىر/ساعات),
					},
					# Long Unit Identifier
					'speed-knot' => {
						'name' => q(ءتۇيىن),
						'one' => q({0} ءتۇيىن),
						'other' => q({0} ءتۇيىن),
					},
					# Core Unit Identifier
					'knot' => {
						'name' => q(ءتۇيىن),
						'one' => q({0} ءتۇيىن),
						'other' => q({0} ءتۇيىن),
					},
					# Long Unit Identifier
					'speed-light-speed' => {
						'name' => q(جارىق),
						'one' => q({0} جارىق),
						'other' => q({0} جارىق),
					},
					# Core Unit Identifier
					'light-speed' => {
						'name' => q(جارىق),
						'one' => q({0} جارىق),
						'other' => q({0} جارىق),
					},
					# Long Unit Identifier
					'speed-meter-per-second' => {
						'name' => q(مەتىر/سەكۋند),
						'one' => q({0} مەتىر/سەكۋند),
						'other' => q({0} مەتىر/سەكۋند),
					},
					# Core Unit Identifier
					'meter-per-second' => {
						'name' => q(مەتىر/سەكۋند),
						'one' => q({0} مەتىر/سەكۋند),
						'other' => q({0} مەتىر/سەكۋند),
					},
					# Long Unit Identifier
					'speed-mile-per-hour' => {
						'name' => q(ميل/ساعات),
						'one' => q({0} ميل/ساعات),
						'other' => q({0} ميل/ساعات),
					},
					# Core Unit Identifier
					'mile-per-hour' => {
						'name' => q(ميل/ساعات),
						'one' => q({0} ميل/ساعات),
						'other' => q({0} ميل/ساعات),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'name' => q(سەلسي گرادۋسى),
						'one' => q({0} سەلسي گرادۋسى),
						'other' => q({0} سەلسي گرادۋسى),
					},
					# Core Unit Identifier
					'celsius' => {
						'name' => q(سەلسي گرادۋسى),
						'one' => q({0} سەلسي گرادۋسى),
						'other' => q({0} سەلسي گرادۋسى),
					},
					# Long Unit Identifier
					'temperature-fahrenheit' => {
						'name' => q(فارانگەيت گرادۋسى),
						'one' => q({0} فارانگەيت گرادۋسى),
						'other' => q({0} فارانگەيت گرادۋسى),
					},
					# Core Unit Identifier
					'fahrenheit' => {
						'name' => q(فارانگەيت گرادۋسى),
						'one' => q({0} فارانگەيت گرادۋسى),
						'other' => q({0} فارانگەيت گرادۋسى),
					},
					# Long Unit Identifier
					'temperature-generic' => {
						'name' => q(تەمپەراتۋرا گرادۋسى),
						'one' => q({0} گرادۋس),
						'other' => q({0} گرادۋس),
					},
					# Core Unit Identifier
					'generic' => {
						'name' => q(تەمپەراتۋرا گرادۋسى),
						'one' => q({0} گرادۋس),
						'other' => q({0} گرادۋس),
					},
					# Long Unit Identifier
					'temperature-kelvin' => {
						'name' => q(كەلۆين),
						'one' => q({0} كەلۆين),
						'other' => q({0} كەلۆين),
					},
					# Core Unit Identifier
					'kelvin' => {
						'name' => q(كەلۆين),
						'one' => q({0} كەلۆين),
						'other' => q({0} كەلۆين),
					},
					# Long Unit Identifier
					'torque-newton-meter' => {
						'name' => q(نيۋتون-مەتىر),
						'one' => q({0} نيۋتون-مەتىر),
						'other' => q({0} نيۋتون-مەتىر),
					},
					# Core Unit Identifier
					'newton-meter' => {
						'name' => q(نيۋتون-مەتىر),
						'one' => q({0} نيۋتون-مەتىر),
						'other' => q({0} نيۋتون-مەتىر),
					},
					# Long Unit Identifier
					'torque-pound-force-foot' => {
						'name' => q(فۋنت-كۇش-فۋت),
						'one' => q({0} فۋنت-كۇش-فۋت),
						'other' => q({0} فۋنت-كۇش-فۋت),
					},
					# Core Unit Identifier
					'pound-force-foot' => {
						'name' => q(فۋنت-كۇش-فۋت),
						'one' => q({0} فۋنت-كۇش-فۋت),
						'other' => q({0} فۋنت-كۇش-فۋت),
					},
					# Long Unit Identifier
					'volume-acre-foot' => {
						'name' => q(اكر-فۋت),
						'one' => q({0} اكر-فۋت),
						'other' => q({0} اكر-فۋت),
					},
					# Core Unit Identifier
					'acre-foot' => {
						'name' => q(اكر-فۋت),
						'one' => q({0} اكر-فۋت),
						'other' => q({0} اكر-فۋت),
					},
					# Long Unit Identifier
					'volume-barrel' => {
						'name' => q(باررەل),
						'one' => q({0} باررەل),
						'other' => q({0} باررەل),
					},
					# Core Unit Identifier
					'barrel' => {
						'name' => q(باررەل),
						'one' => q({0} باررەل),
						'other' => q({0} باررەل),
					},
					# Long Unit Identifier
					'volume-bushel' => {
						'name' => q(بۋشەل),
						'one' => q({0} بۋشەل),
						'other' => q({0} بۋشەل),
					},
					# Core Unit Identifier
					'bushel' => {
						'name' => q(بۋشەل),
						'one' => q({0} بۋشەل),
						'other' => q({0} بۋشەل),
					},
					# Long Unit Identifier
					'volume-centiliter' => {
						'name' => q(سانتيليتىر),
						'one' => q({0} سانتيليتىر),
						'other' => q({0} سانتيليتىر),
					},
					# Core Unit Identifier
					'centiliter' => {
						'name' => q(سانتيليتىر),
						'one' => q({0} سانتيليتىر),
						'other' => q({0} سانتيليتىر),
					},
					# Long Unit Identifier
					'volume-cubic-centimeter' => {
						'name' => q(تەكشە سانتيمەتىر),
						'one' => q({0} تەكشە سانتيمەتىر),
						'other' => q({0} تەكشە سانتيمەتىر),
						'per' => q({0}/تەكشە سانتيمەتىر),
					},
					# Core Unit Identifier
					'cubic-centimeter' => {
						'name' => q(تەكشە سانتيمەتىر),
						'one' => q({0} تەكشە سانتيمەتىر),
						'other' => q({0} تەكشە سانتيمەتىر),
						'per' => q({0}/تەكشە سانتيمەتىر),
					},
					# Long Unit Identifier
					'volume-cubic-foot' => {
						'name' => q(تەكشە فۋت),
						'one' => q({0} تەكشە فۋت),
						'other' => q({0} تەكشە فۋت),
					},
					# Core Unit Identifier
					'cubic-foot' => {
						'name' => q(تەكشە فۋت),
						'one' => q({0} تەكشە فۋت),
						'other' => q({0} تەكشە فۋت),
					},
					# Long Unit Identifier
					'volume-cubic-inch' => {
						'name' => q(تەكشە ديۋيم),
						'one' => q({0} تەكشە ديۋيم),
						'other' => q({0} تەكشە ديۋيم),
					},
					# Core Unit Identifier
					'cubic-inch' => {
						'name' => q(تەكشە ديۋيم),
						'one' => q({0} تەكشە ديۋيم),
						'other' => q({0} تەكشە ديۋيم),
					},
					# Long Unit Identifier
					'volume-cubic-kilometer' => {
						'name' => q(تەكشە كيلومەتىر),
						'one' => q({0} تەكشە كيلومەتىر),
						'other' => q({0} تەكشە كيلومەتىر),
					},
					# Core Unit Identifier
					'cubic-kilometer' => {
						'name' => q(تەكشە كيلومەتىر),
						'one' => q({0} تەكشە كيلومەتىر),
						'other' => q({0} تەكشە كيلومەتىر),
					},
					# Long Unit Identifier
					'volume-cubic-meter' => {
						'name' => q(تەكشە مەتىر),
						'one' => q({0} تەكشە مەتىر),
						'other' => q({0} تەكشە مەتىر),
						'per' => q({0}/تەكشە مەتىر),
					},
					# Core Unit Identifier
					'cubic-meter' => {
						'name' => q(تەكشە مەتىر),
						'one' => q({0} تەكشە مەتىر),
						'other' => q({0} تەكشە مەتىر),
						'per' => q({0}/تەكشە مەتىر),
					},
					# Long Unit Identifier
					'volume-cubic-mile' => {
						'name' => q(تەكشە ميل),
						'one' => q({0} تەكشە ميل),
						'other' => q({0} تەكشە ميل),
					},
					# Core Unit Identifier
					'cubic-mile' => {
						'name' => q(تەكشە ميل),
						'one' => q({0} تەكشە ميل),
						'other' => q({0} تەكشە ميل),
					},
					# Long Unit Identifier
					'volume-cubic-yard' => {
						'name' => q(تەكشە يارد),
						'one' => q({0} تەكشە يارد),
						'other' => q({0} تەكشە يارد),
					},
					# Core Unit Identifier
					'cubic-yard' => {
						'name' => q(تەكشە يارد),
						'one' => q({0} تەكشە يارد),
						'other' => q({0} تەكشە يارد),
					},
					# Long Unit Identifier
					'volume-cup' => {
						'name' => q(كەسە),
						'one' => q({0} كەسە),
						'other' => q({0} كەسە),
					},
					# Core Unit Identifier
					'cup' => {
						'name' => q(كەسە),
						'one' => q({0} كەسە),
						'other' => q({0} كەسە),
					},
					# Long Unit Identifier
					'volume-cup-metric' => {
						'name' => q(مەتىرلىك كەسە),
						'one' => q({0} مەتىرلىك كەسە),
						'other' => q({0} مەتىرلىك كەسە),
					},
					# Core Unit Identifier
					'cup-metric' => {
						'name' => q(مەتىرلىك كەسە),
						'one' => q({0} مەتىرلىك كەسە),
						'other' => q({0} مەتىرلىك كەسە),
					},
					# Long Unit Identifier
					'volume-deciliter' => {
						'name' => q(دەسيليتىر),
						'one' => q({0} دەسيليتىر),
						'other' => q({0} دەسيليتىر),
					},
					# Core Unit Identifier
					'deciliter' => {
						'name' => q(دەسيليتىر),
						'one' => q({0} دەسيليتىر),
						'other' => q({0} دەسيليتىر),
					},
					# Long Unit Identifier
					'volume-dessert-spoon' => {
						'name' => q(دەسەرت قاسىعى),
						'one' => q({0} دەسەرت قاسىعى),
						'other' => q({0} دەسەرت قاسىعى),
					},
					# Core Unit Identifier
					'dessert-spoon' => {
						'name' => q(دەسەرت قاسىعى),
						'one' => q({0} دەسەرت قاسىعى),
						'other' => q({0} دەسەرت قاسىعى),
					},
					# Long Unit Identifier
					'volume-dessert-spoon-imperial' => {
						'name' => q(يمپ دەسەرت قاسىعى),
						'one' => q({0} يمپ دەسەرت قاسىعى),
						'other' => q({0} يمپ دەسەرت قاسىعى),
					},
					# Core Unit Identifier
					'dessert-spoon-imperial' => {
						'name' => q(يمپ دەسەرت قاسىعى),
						'one' => q({0} يمپ دەسەرت قاسىعى),
						'other' => q({0} يمپ دەسەرت قاسىعى),
					},
					# Long Unit Identifier
					'volume-dram' => {
						'name' => q(دراحما),
						'one' => q({0} دراحما),
						'other' => q({0} دراحما),
					},
					# Core Unit Identifier
					'dram' => {
						'name' => q(دراحما),
						'one' => q({0} دراحما),
						'other' => q({0} دراحما),
					},
					# Long Unit Identifier
					'volume-drop' => {
						'name' => q(تامشى),
						'one' => q({0} تامشى),
						'other' => q({0} تامشى),
					},
					# Core Unit Identifier
					'drop' => {
						'name' => q(تامشى),
						'one' => q({0} تامشى),
						'other' => q({0} تامشى),
					},
					# Long Unit Identifier
					'volume-fluid-ounce' => {
						'name' => q(سۇيىق ۋنسيا),
						'one' => q({0} سۇيىق ۋنسيا),
						'other' => q({0} سۇيىق ۋنسيا),
					},
					# Core Unit Identifier
					'fluid-ounce' => {
						'name' => q(سۇيىق ۋنسيا),
						'one' => q({0} سۇيىق ۋنسيا),
						'other' => q({0} سۇيىق ۋنسيا),
					},
					# Long Unit Identifier
					'volume-fluid-ounce-imperial' => {
						'name' => q(يمپ سۇيىق ۋنسيا),
						'one' => q(يمپ سۇيىق ۋنسيا),
						'other' => q({0} يمپ سۇيىق ۋنسيا),
					},
					# Core Unit Identifier
					'fluid-ounce-imperial' => {
						'name' => q(يمپ سۇيىق ۋنسيا),
						'one' => q(يمپ سۇيىق ۋنسيا),
						'other' => q({0} يمپ سۇيىق ۋنسيا),
					},
					# Long Unit Identifier
					'volume-gallon' => {
						'name' => q(گاللون),
						'one' => q({0} گاللون),
						'other' => q({0} گاللون),
						'per' => q({0}/گاللون),
					},
					# Core Unit Identifier
					'gallon' => {
						'name' => q(گاللون),
						'one' => q({0} گاللون),
						'other' => q({0} گاللون),
						'per' => q({0}/گاللون),
					},
					# Long Unit Identifier
					'volume-gallon-imperial' => {
						'name' => q(يمپ گاللون),
						'one' => q({0} يمپ گاللون),
						'other' => q({0} يمپ گاللون),
						'per' => q({0} يمپ گاللون),
					},
					# Core Unit Identifier
					'gallon-imperial' => {
						'name' => q(يمپ گاللون),
						'one' => q({0} يمپ گاللون),
						'other' => q({0} يمپ گاللون),
						'per' => q({0} يمپ گاللون),
					},
					# Long Unit Identifier
					'volume-hectoliter' => {
						'name' => q(گەكتوليتىر),
						'one' => q({0} گەكتوليرىر),
						'other' => q({0} گەكتوليرىر),
					},
					# Core Unit Identifier
					'hectoliter' => {
						'name' => q(گەكتوليتىر),
						'one' => q({0} گەكتوليرىر),
						'other' => q({0} گەكتوليرىر),
					},
					# Long Unit Identifier
					'volume-jigger' => {
						'name' => q(جيگگەر),
						'one' => q({0} جيگگەر),
						'other' => q({0} جيگگەر),
					},
					# Core Unit Identifier
					'jigger' => {
						'name' => q(جيگگەر),
						'one' => q({0} جيگگەر),
						'other' => q({0} جيگگەر),
					},
					# Long Unit Identifier
					'volume-liter' => {
						'name' => q(ليتىر),
						'one' => q({0} ليتىر),
						'other' => q({0} ليتىر),
						'per' => q({0}/ليتىر),
					},
					# Core Unit Identifier
					'liter' => {
						'name' => q(ليتىر),
						'one' => q({0} ليتىر),
						'other' => q({0} ليتىر),
						'per' => q({0}/ليتىر),
					},
					# Long Unit Identifier
					'volume-megaliter' => {
						'name' => q(مەگاليتر),
						'one' => q({0} مەگاليتر),
						'other' => q({0} مەگاليتر),
					},
					# Core Unit Identifier
					'megaliter' => {
						'name' => q(مەگاليتر),
						'one' => q({0} مەگاليتر),
						'other' => q({0} مەگاليتر),
					},
					# Long Unit Identifier
					'volume-milliliter' => {
						'name' => q(ميليليتىر),
						'one' => q({0} ميليليتىر),
						'other' => q({0} ميليليتىر),
					},
					# Core Unit Identifier
					'milliliter' => {
						'name' => q(ميليليتىر),
						'one' => q({0} ميليليتىر),
						'other' => q({0} ميليليتىر),
					},
					# Long Unit Identifier
					'volume-pinch' => {
						'name' => q(شوكىم),
						'one' => q({0} شوكىم),
						'other' => q({0} شوكىم),
					},
					# Core Unit Identifier
					'pinch' => {
						'name' => q(شوكىم),
						'one' => q({0} شوكىم),
						'other' => q({0} شوكىم),
					},
					# Long Unit Identifier
					'volume-pint' => {
						'name' => q(پينتا),
						'one' => q({0} پينتا),
						'other' => q({0} پينتا),
					},
					# Core Unit Identifier
					'pint' => {
						'name' => q(پينتا),
						'one' => q({0} پينتا),
						'other' => q({0} پينتا),
					},
					# Long Unit Identifier
					'volume-pint-metric' => {
						'name' => q(مەتىرلىك پينتا),
						'one' => q({0} مەتىرلىك پينتا),
						'other' => q({0} مەتىرلىك پينتا),
					},
					# Core Unit Identifier
					'pint-metric' => {
						'name' => q(مەتىرلىك پينتا),
						'one' => q({0} مەتىرلىك پينتا),
						'other' => q({0} مەتىرلىك پينتا),
					},
					# Long Unit Identifier
					'volume-quart' => {
						'name' => q(كۆارتا),
						'one' => q({0} كۆارتا),
						'other' => q({0} كۆارتا),
					},
					# Core Unit Identifier
					'quart' => {
						'name' => q(كۆارتا),
						'one' => q({0} كۆارتا),
						'other' => q({0} كۆارتا),
					},
					# Long Unit Identifier
					'volume-quart-imperial' => {
						'name' => q(يمپ كۆارتا),
						'one' => q({0} يمپ كۆارتا),
						'other' => q({0} يمپ كۆارتا),
					},
					# Core Unit Identifier
					'quart-imperial' => {
						'name' => q(يمپ كۆارتا),
						'one' => q({0} يمپ كۆارتا),
						'other' => q({0} يمپ كۆارتا),
					},
					# Long Unit Identifier
					'volume-tablespoon' => {
						'name' => q(اس قاسىق),
						'one' => q({0} اس قاسىق),
						'other' => q({0} اس قاسىق),
					},
					# Core Unit Identifier
					'tablespoon' => {
						'name' => q(اس قاسىق),
						'one' => q({0} اس قاسىق),
						'other' => q({0} اس قاسىق),
					},
					# Long Unit Identifier
					'volume-teaspoon' => {
						'name' => q(شاي قاسىق),
						'one' => q({0} شاي قاسىق),
						'other' => q({0} شاي قاسىق),
					},
					# Core Unit Identifier
					'teaspoon' => {
						'name' => q(شاي قاسىق),
						'one' => q({0} شاي قاسىق),
						'other' => q({0} شاي قاسىق),
					},
				},
				'narrow' => {
					# Long Unit Identifier
					'' => {
						'name' => q(باعىت),
					},
					# Core Unit Identifier
					'' => {
						'name' => q(باعىت),
					},
					# Long Unit Identifier
					'1024p1' => {
						'1' => q(كي{0}),
					},
					# Core Unit Identifier
					'1024p1' => {
						'1' => q(كي{0}),
					},
					# Long Unit Identifier
					'1024p2' => {
						'1' => q(مب{0}),
					},
					# Core Unit Identifier
					'1024p2' => {
						'1' => q(مب{0}),
					},
					# Long Unit Identifier
					'1024p3' => {
						'1' => q(گي{0}),
					},
					# Core Unit Identifier
					'1024p3' => {
						'1' => q(گي{0}),
					},
					# Long Unit Identifier
					'1024p4' => {
						'1' => q(تب{0}),
					},
					# Core Unit Identifier
					'1024p4' => {
						'1' => q(تب{0}),
					},
					# Long Unit Identifier
					'1024p5' => {
						'1' => q(پب{0}),
					},
					# Core Unit Identifier
					'1024p5' => {
						'1' => q(پب{0}),
					},
					# Long Unit Identifier
					'1024p6' => {
						'1' => q(ەب{0}),
					},
					# Core Unit Identifier
					'1024p6' => {
						'1' => q(ەب{0}),
					},
					# Long Unit Identifier
					'1024p7' => {
						'1' => q(زب{0}),
					},
					# Core Unit Identifier
					'1024p7' => {
						'1' => q(زب{0}),
					},
					# Long Unit Identifier
					'1024p8' => {
						'1' => q(يب{0}),
					},
					# Core Unit Identifier
					'1024p8' => {
						'1' => q(يب{0}),
					},
					# Long Unit Identifier
					'10p-1' => {
						'1' => q(د{0}),
					},
					# Core Unit Identifier
					'1' => {
						'1' => q(د{0}),
					},
					# Long Unit Identifier
					'10p-12' => {
						'1' => q(پ{0}),
					},
					# Core Unit Identifier
					'12' => {
						'1' => q(پ{0}),
					},
					# Long Unit Identifier
					'10p-15' => {
						'1' => q(ف{0}),
					},
					# Core Unit Identifier
					'15' => {
						'1' => q(ف{0}),
					},
					# Long Unit Identifier
					'10p-18' => {
						'1' => q(ا{0}),
					},
					# Core Unit Identifier
					'18' => {
						'1' => q(ا{0}),
					},
					# Long Unit Identifier
					'10p-2' => {
						'1' => q(س{0}),
					},
					# Core Unit Identifier
					'2' => {
						'1' => q(س{0}),
					},
					# Long Unit Identifier
					'10p-21' => {
						'1' => q(ز{0}),
					},
					# Core Unit Identifier
					'21' => {
						'1' => q(ز{0}),
					},
					# Long Unit Identifier
					'10p-24' => {
						'1' => q(ي{0}),
					},
					# Core Unit Identifier
					'24' => {
						'1' => q(ي{0}),
					},
					# Long Unit Identifier
					'10p-27' => {
						'1' => q(ر{0}),
					},
					# Core Unit Identifier
					'27' => {
						'1' => q(ر{0}),
					},
					# Long Unit Identifier
					'10p-3' => {
						'1' => q(مل{0}),
					},
					# Core Unit Identifier
					'3' => {
						'1' => q(مل{0}),
					},
					# Long Unit Identifier
					'10p-30' => {
						'1' => q(ك{0}),
					},
					# Core Unit Identifier
					'30' => {
						'1' => q(ك{0}),
					},
					# Long Unit Identifier
					'10p-6' => {
						'1' => q(مك{0}),
					},
					# Core Unit Identifier
					'6' => {
						'1' => q(مك{0}),
					},
					# Long Unit Identifier
					'10p-9' => {
						'1' => q(ن{0}),
					},
					# Core Unit Identifier
					'9' => {
						'1' => q(ن{0}),
					},
					# Long Unit Identifier
					'10p1' => {
						'1' => q(دا{0}),
					},
					# Core Unit Identifier
					'10p1' => {
						'1' => q(دا{0}),
					},
					# Long Unit Identifier
					'10p12' => {
						'1' => q(ت{0}),
					},
					# Core Unit Identifier
					'10p12' => {
						'1' => q(ت{0}),
					},
					# Long Unit Identifier
					'10p15' => {
						'1' => q(پت{0}),
					},
					# Core Unit Identifier
					'10p15' => {
						'1' => q(پت{0}),
					},
					# Long Unit Identifier
					'10p18' => {
						'1' => q(ە{0}),
					},
					# Core Unit Identifier
					'10p18' => {
						'1' => q(ە{0}),
					},
					# Long Unit Identifier
					'10p2' => {
						'1' => q(گ{0}),
					},
					# Core Unit Identifier
					'10p2' => {
						'1' => q(گ{0}),
					},
					# Long Unit Identifier
					'10p21' => {
						'1' => q(زت{0}),
					},
					# Core Unit Identifier
					'10p21' => {
						'1' => q(زت{0}),
					},
					# Long Unit Identifier
					'10p24' => {
						'1' => q(يت{0}),
					},
					# Core Unit Identifier
					'10p24' => {
						'1' => q(يت{0}),
					},
					# Long Unit Identifier
					'10p27' => {
						'1' => q(رن{0}),
					},
					# Core Unit Identifier
					'10p27' => {
						'1' => q(رن{0}),
					},
					# Long Unit Identifier
					'10p3' => {
						'1' => q(كل{0}),
					},
					# Core Unit Identifier
					'10p3' => {
						'1' => q(كل{0}),
					},
					# Long Unit Identifier
					'10p30' => {
						'1' => q(كت{0}),
					},
					# Core Unit Identifier
					'10p30' => {
						'1' => q(كت{0}),
					},
					# Long Unit Identifier
					'10p6' => {
						'1' => q(مگ{0}),
					},
					# Core Unit Identifier
					'10p6' => {
						'1' => q(مگ{0}),
					},
					# Long Unit Identifier
					'10p9' => {
						'1' => q(گگ{0}),
					},
					# Core Unit Identifier
					'10p9' => {
						'1' => q(گگ{0}),
					},
					# Long Unit Identifier
					'acceleration-g-force' => {
						'name' => q(تارتىلىس كۇشى),
						'one' => q({0} تارتىلىس كۇشى),
						'other' => q({0} تارتىلىس كۇشى),
					},
					# Core Unit Identifier
					'g-force' => {
						'name' => q(تارتىلىس كۇشى),
						'one' => q({0} تارتىلىس كۇشى),
						'other' => q({0} تارتىلىس كۇشى),
					},
					# Long Unit Identifier
					'acceleration-meter-per-square-second' => {
						'name' => q(مەتىر/شارشى سەكۋند),
						'one' => q({0} مەتىر/شارشى سەكۋند),
						'other' => q({0} مەتىر/شارشى سەكۋند),
					},
					# Core Unit Identifier
					'meter-per-square-second' => {
						'name' => q(مەتىر/شارشى سەكۋند),
						'one' => q({0} مەتىر/شارشى سەكۋند),
						'other' => q({0} مەتىر/شارشى سەكۋند),
					},
					# Long Unit Identifier
					'angle-arc-minute' => {
						'name' => q(اركمينۋت),
					},
					# Core Unit Identifier
					'arc-minute' => {
						'name' => q(اركمينۋت),
					},
					# Long Unit Identifier
					'angle-arc-second' => {
						'name' => q(اركسەكۋند),
					},
					# Core Unit Identifier
					'arc-second' => {
						'name' => q(اركسەكۋند),
					},
					# Long Unit Identifier
					'angle-degree' => {
						'name' => q(گرادۋس),
					},
					# Core Unit Identifier
					'degree' => {
						'name' => q(گرادۋس),
					},
					# Long Unit Identifier
					'angle-radian' => {
						'name' => q(راديان),
						'one' => q({0} راديان),
						'other' => q({0} راديان),
					},
					# Core Unit Identifier
					'radian' => {
						'name' => q(راديان),
						'one' => q({0} راديان),
						'other' => q({0} راديان),
					},
					# Long Unit Identifier
					'angle-revolution' => {
						'name' => q(اينالىم),
						'one' => q({0} اينالىم),
						'other' => q({0} اينالىم),
					},
					# Core Unit Identifier
					'revolution' => {
						'name' => q(اينالىم),
						'one' => q({0} اينالىم),
						'other' => q({0} اينالىم),
					},
					# Long Unit Identifier
					'area-acre' => {
						'name' => q(اكر),
						'one' => q({0} اكر),
						'other' => q({0} اكر),
					},
					# Core Unit Identifier
					'acre' => {
						'name' => q(اكر),
						'one' => q({0} اكر),
						'other' => q({0} اكر),
					},
					# Long Unit Identifier
					'area-dunam' => {
						'name' => q(دۋنام),
						'one' => q({0} دۋنام),
						'other' => q({0} دۋنام),
					},
					# Core Unit Identifier
					'dunam' => {
						'name' => q(دۋنام),
						'one' => q({0} دۋنام),
						'other' => q({0} دۋنام),
					},
					# Long Unit Identifier
					'area-hectare' => {
						'name' => q(گەكتار),
						'one' => q({0} گەكتار),
						'other' => q({0} گەكتار),
					},
					# Core Unit Identifier
					'hectare' => {
						'name' => q(گەكتار),
						'one' => q({0} گەكتار),
						'other' => q({0} گەكتار),
					},
					# Long Unit Identifier
					'area-square-centimeter' => {
						'name' => q(شارشى سانتيمەتىر),
						'one' => q({0} شارشى سانتيمەتىر),
						'other' => q({0} شارشى سانتيمەتىر),
						'per' => q({0}/شارشى سانتيمەتىر),
					},
					# Core Unit Identifier
					'square-centimeter' => {
						'name' => q(شارشى سانتيمەتىر),
						'one' => q({0} شارشى سانتيمەتىر),
						'other' => q({0} شارشى سانتيمەتىر),
						'per' => q({0}/شارشى سانتيمەتىر),
					},
					# Long Unit Identifier
					'area-square-foot' => {
						'name' => q(شارشى فۋت),
						'one' => q({0} شارشى فۋت),
						'other' => q({0} شارشى فۋت),
					},
					# Core Unit Identifier
					'square-foot' => {
						'name' => q(شارشى فۋت),
						'one' => q({0} شارشى فۋت),
						'other' => q({0} شارشى فۋت),
					},
					# Long Unit Identifier
					'area-square-inch' => {
						'name' => q(شارشى ديۋيم),
						'one' => q({0} شارشى ديۋيم),
						'other' => q({0} شارشى ديۋيم),
						'per' => q({0} شارشى ديۋيم),
					},
					# Core Unit Identifier
					'square-inch' => {
						'name' => q(شارشى ديۋيم),
						'one' => q({0} شارشى ديۋيم),
						'other' => q({0} شارشى ديۋيم),
						'per' => q({0} شارشى ديۋيم),
					},
					# Long Unit Identifier
					'area-square-kilometer' => {
						'name' => q(شارشى كيلومەتىر),
						'one' => q({0}/شارشى كيلومەتىر),
						'other' => q({0}/شارشى كيلومەتىر),
						'per' => q({0}/شارشى كيلومەتىر),
					},
					# Core Unit Identifier
					'square-kilometer' => {
						'name' => q(شارشى كيلومەتىر),
						'one' => q({0}/شارشى كيلومەتىر),
						'other' => q({0}/شارشى كيلومەتىر),
						'per' => q({0}/شارشى كيلومەتىر),
					},
					# Long Unit Identifier
					'area-square-meter' => {
						'name' => q(شارشى مەتىر),
						'one' => q({0} شارشى مەتىر),
						'other' => q({0} شارشى مەتىر),
						'per' => q({0}/شارشى مەتىر),
					},
					# Core Unit Identifier
					'square-meter' => {
						'name' => q(شارشى مەتىر),
						'one' => q({0} شارشى مەتىر),
						'other' => q({0} شارشى مەتىر),
						'per' => q({0}/شارشى مەتىر),
					},
					# Long Unit Identifier
					'area-square-mile' => {
						'name' => q(شارشى ميل),
						'one' => q({0} شارشى ميل),
						'other' => q({0} شارشى ميل),
						'per' => q({0}/شارشى ميل),
					},
					# Core Unit Identifier
					'square-mile' => {
						'name' => q(شارشى ميل),
						'one' => q({0} شارشى ميل),
						'other' => q({0} شارشى ميل),
						'per' => q({0}/شارشى ميل),
					},
					# Long Unit Identifier
					'area-square-yard' => {
						'name' => q(شارشى يارد),
						'one' => q({0} شارشى يارد),
						'other' => q({0} شارشى يارد),
					},
					# Core Unit Identifier
					'square-yard' => {
						'name' => q(شارشى يارد),
						'one' => q({0} شارشى يارد),
						'other' => q({0} شارشى يارد),
					},
					# Long Unit Identifier
					'concentr-item' => {
						'name' => q(ەلەمەنت),
						'one' => q({0} ەلەمەنت),
						'other' => q({0} ەلەمەنت),
					},
					# Core Unit Identifier
					'item' => {
						'name' => q(ەلەمەنت),
						'one' => q({0} ەلەمەنت),
						'other' => q({0} ەلەمەنت),
					},
					# Long Unit Identifier
					'concentr-karat' => {
						'name' => q(كارات),
						'one' => q({0} كارات),
						'other' => q({0} كارات),
					},
					# Core Unit Identifier
					'karat' => {
						'name' => q(كارات),
						'one' => q({0} كارات),
						'other' => q({0} كارات),
					},
					# Long Unit Identifier
					'concentr-milligram-ofglucose-per-deciliter' => {
						'name' => q(ميليگرام/دەسيليتىر),
					},
					# Core Unit Identifier
					'milligram-ofglucose-per-deciliter' => {
						'name' => q(ميليگرام/دەسيليتىر),
					},
					# Long Unit Identifier
					'concentr-millimole-per-liter' => {
						'name' => q(ميليمول/ليتىر),
					},
					# Core Unit Identifier
					'millimole-per-liter' => {
						'name' => q(ميليمول/ليتىر),
					},
					# Long Unit Identifier
					'concentr-mole' => {
						'name' => q(مول),
						'one' => q({0} مول),
						'other' => q({0} مول),
					},
					# Core Unit Identifier
					'mole' => {
						'name' => q(مول),
						'one' => q({0} مول),
						'other' => q({0} مول),
					},
					# Long Unit Identifier
					'concentr-permillion' => {
						'name' => q(ميلليوندىق ۇلەس),
					},
					# Core Unit Identifier
					'permillion' => {
						'name' => q(ميلليوندىق ۇلەس),
					},
					# Long Unit Identifier
					'concentr-portion-per-1e9' => {
						'name' => q(ميللياردتىق ۇلەس),
					},
					# Core Unit Identifier
					'portion-per-1e9' => {
						'name' => q(ميللياردتىق ۇلەس),
					},
					# Long Unit Identifier
					'consumption-liter-per-100-kilometer' => {
						'name' => q(ليتىر/100 كيلومەتىر),
					},
					# Core Unit Identifier
					'liter-per-100-kilometer' => {
						'name' => q(ليتىر/100 كيلومەتىر),
					},
					# Long Unit Identifier
					'consumption-liter-per-kilometer' => {
						'name' => q(ليتىر/كيلومەتىر),
					},
					# Core Unit Identifier
					'liter-per-kilometer' => {
						'name' => q(ليتىر/كيلومەتىر),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon' => {
						'name' => q(ميل/گاللون),
						'one' => q({0} ميل/گاللون),
						'other' => q({0} ميل/گاللون),
					},
					# Core Unit Identifier
					'mile-per-gallon' => {
						'name' => q(ميل/گاللون),
						'one' => q({0} ميل/گاللون),
						'other' => q({0} ميل/گاللون),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon-imperial' => {
						'name' => q(ميل/يمپ گاللون),
						'one' => q({0} ميل/يمپ گاللون),
						'other' => q({0} ميل/يمپ گاللون),
					},
					# Core Unit Identifier
					'mile-per-gallon-imperial' => {
						'name' => q(ميل/يمپ گاللون),
						'one' => q({0} ميل/يمپ گاللون),
						'other' => q({0} ميل/يمپ گاللون),
					},
					# Long Unit Identifier
					'coordinate' => {
						'east' => q({0} ش),
						'north' => q({0} س),
						'south' => q({0} و),
						'west' => q({0} ب),
					},
					# Core Unit Identifier
					'coordinate' => {
						'east' => q({0} ش),
						'north' => q({0} س),
						'south' => q({0} و),
						'west' => q({0} ب),
					},
					# Long Unit Identifier
					'digital-byte' => {
						'name' => q(B),
					},
					# Core Unit Identifier
					'byte' => {
						'name' => q(B),
					},
					# Long Unit Identifier
					'duration-century' => {
						'name' => q(عاسىر),
						'one' => q({0} عاسىر),
						'other' => q({0} عاسىر),
					},
					# Core Unit Identifier
					'century' => {
						'name' => q(عاسىر),
						'one' => q({0} عاسىر),
						'other' => q({0} عاسىر),
					},
					# Long Unit Identifier
					'duration-day' => {
						'name' => q(كۇن),
						'one' => q({0} كۇن),
						'other' => q({0} كۇن),
						'per' => q({0}/كۇن),
					},
					# Core Unit Identifier
					'day' => {
						'name' => q(كۇن),
						'one' => q({0} كۇن),
						'other' => q({0} كۇن),
						'per' => q({0}/كۇن),
					},
					# Long Unit Identifier
					'duration-decade' => {
						'name' => q(ون جىلدىق),
						'one' => q({0} ون جىلدىق),
						'other' => q({0} ون جىلدىق),
					},
					# Core Unit Identifier
					'decade' => {
						'name' => q(ون جىلدىق),
						'one' => q({0} ون جىلدىق),
						'other' => q({0} ون جىلدىق),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'name' => q(ساعات),
						'one' => q({0} ساعات),
						'other' => q({0} ساعات),
						'per' => q({0}/ساعات),
					},
					# Core Unit Identifier
					'hour' => {
						'name' => q(ساعات),
						'one' => q({0} ساعات),
						'other' => q({0} ساعات),
						'per' => q({0}/ساعات),
					},
					# Long Unit Identifier
					'duration-microsecond' => {
						'name' => q(ميكروسەكۋند),
						'one' => q({0} ميكروسەكۋند),
						'other' => q({0} ميكروسەكۋند),
					},
					# Core Unit Identifier
					'microsecond' => {
						'name' => q(ميكروسەكۋند),
						'one' => q({0} ميكروسەكۋند),
						'other' => q({0} ميكروسەكۋند),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'name' => q(ميليسەكۋند),
						'one' => q({0} ميليسەكۋند),
						'other' => q({0} ميليسەكۋند),
					},
					# Core Unit Identifier
					'millisecond' => {
						'name' => q(ميليسەكۋند),
						'one' => q({0} ميليسەكۋند),
						'other' => q({0} ميليسەكۋند),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'name' => q(مينۋت),
						'one' => q({0} مينۋت),
						'other' => q({0} مينۋت),
						'per' => q({0}/مينۋت),
					},
					# Core Unit Identifier
					'minute' => {
						'name' => q(مينۋت),
						'one' => q({0} مينۋت),
						'other' => q({0} مينۋت),
						'per' => q({0}/مينۋت),
					},
					# Long Unit Identifier
					'duration-month' => {
						'name' => q(اي),
						'one' => q({0} اي),
						'other' => q({0} اي),
						'per' => q({0}/اي),
					},
					# Core Unit Identifier
					'month' => {
						'name' => q(اي),
						'one' => q({0} اي),
						'other' => q({0} اي),
						'per' => q({0}/اي),
					},
					# Long Unit Identifier
					'duration-nanosecond' => {
						'name' => q(نانوسەكۋند),
						'one' => q({0} نانوسەكۋند),
						'other' => q({0} نانوسەكۋند),
					},
					# Core Unit Identifier
					'nanosecond' => {
						'name' => q(نانوسەكۋند),
						'one' => q({0} نانوسەكۋند),
						'other' => q({0} نانوسەكۋند),
					},
					# Long Unit Identifier
					'duration-night' => {
						'name' => q(ءتۇن),
						'one' => q({0} ءتۇن),
						'other' => q({0} ءتۇن),
						'per' => q({0}/ءتۇن),
					},
					# Core Unit Identifier
					'night' => {
						'name' => q(ءتۇن),
						'one' => q({0} ءتۇن),
						'other' => q({0} ءتۇن),
						'per' => q({0}/ءتۇن),
					},
					# Long Unit Identifier
					'duration-quarter' => {
						'name' => q(توقسان),
						'one' => q({0} توقسان),
						'other' => q({0} توقسان),
						'per' => q({0}/توقسان),
					},
					# Core Unit Identifier
					'quarter' => {
						'name' => q(توقسان),
						'one' => q({0} توقسان),
						'other' => q({0} توقسان),
						'per' => q({0}/توقسان),
					},
					# Long Unit Identifier
					'duration-second' => {
						'name' => q(سەكۋند),
						'one' => q({0} سەكۋند),
						'other' => q({0} سەكۋند),
						'per' => q({0}/سەكۋند),
					},
					# Core Unit Identifier
					'second' => {
						'name' => q(سەكۋند),
						'one' => q({0} سەكۋند),
						'other' => q({0} سەكۋند),
						'per' => q({0}/سەكۋند),
					},
					# Long Unit Identifier
					'duration-week' => {
						'name' => q(اپتا),
						'one' => q({0} اپتا),
						'other' => q({0} اپتا),
						'per' => q({0}/اپتا),
					},
					# Core Unit Identifier
					'week' => {
						'name' => q(اپتا),
						'one' => q({0} اپتا),
						'other' => q({0} اپتا),
						'per' => q({0}/اپتا),
					},
					# Long Unit Identifier
					'duration-year' => {
						'name' => q(جىل),
						'one' => q({0} جىل),
						'other' => q({0} جىل),
						'per' => q(جىلىنا {0}),
					},
					# Core Unit Identifier
					'year' => {
						'name' => q(جىل),
						'one' => q({0} جىل),
						'other' => q({0} جىل),
						'per' => q(جىلىنا {0}),
					},
					# Long Unit Identifier
					'electric-ampere' => {
						'name' => q(امپەر),
						'one' => q({0} امپەر),
						'other' => q({0} امپەر),
					},
					# Core Unit Identifier
					'ampere' => {
						'name' => q(امپەر),
						'one' => q({0} امپەر),
						'other' => q({0} امپەر),
					},
					# Long Unit Identifier
					'electric-milliampere' => {
						'name' => q(ميليامپەر),
						'one' => q({0} ميليامپەر),
						'other' => q({0} ميليامپەر),
					},
					# Core Unit Identifier
					'milliampere' => {
						'name' => q(ميليامپەر),
						'one' => q({0} ميليامپەر),
						'other' => q({0} ميليامپەر),
					},
					# Long Unit Identifier
					'electric-ohm' => {
						'name' => q(وم),
						'one' => q({0} وم),
						'other' => q({0} وم),
					},
					# Core Unit Identifier
					'ohm' => {
						'name' => q(وم),
						'one' => q({0} وم),
						'other' => q({0} وم),
					},
					# Long Unit Identifier
					'electric-volt' => {
						'name' => q(ۆولت),
						'one' => q({0} ۆولت),
						'other' => q({0} ۆولت),
					},
					# Core Unit Identifier
					'volt' => {
						'name' => q(ۆولت),
						'one' => q({0} ۆولت),
						'other' => q({0} ۆولت),
					},
					# Long Unit Identifier
					'energy-british-thermal-unit' => {
						'name' => q(بريتاندىق جىلۋ بىرلىگى),
						'one' => q({0} بريتاندىق جىلۋ بىرلىگى),
						'other' => q({0} بريتاندىق جىلۋ بىرلىگى),
					},
					# Core Unit Identifier
					'british-thermal-unit' => {
						'name' => q(بريتاندىق جىلۋ بىرلىگى),
						'one' => q({0} بريتاندىق جىلۋ بىرلىگى),
						'other' => q({0} بريتاندىق جىلۋ بىرلىگى),
					},
					# Long Unit Identifier
					'energy-calorie' => {
						'name' => q(كالوريا),
						'one' => q({0} كالوريا),
						'other' => q({0} كالوريا),
					},
					# Core Unit Identifier
					'calorie' => {
						'name' => q(كالوريا),
						'one' => q({0} كالوريا),
						'other' => q({0} كالوريا),
					},
					# Long Unit Identifier
					'energy-electronvolt' => {
						'name' => q(ەلەكتونۆولت),
						'one' => q({0} ەلەكترونۆولت),
						'other' => q({0} ەلەكترونۆولت),
					},
					# Core Unit Identifier
					'electronvolt' => {
						'name' => q(ەلەكتونۆولت),
						'one' => q({0} ەلەكترونۆولت),
						'other' => q({0} ەلەكترونۆولت),
					},
					# Long Unit Identifier
					'energy-joule' => {
						'name' => q(جوۋل),
						'one' => q({0} جوۋل),
						'other' => q({0} جوۋل),
					},
					# Core Unit Identifier
					'joule' => {
						'name' => q(جوۋل),
						'one' => q({0} جوۋل),
						'other' => q({0} جوۋل),
					},
					# Long Unit Identifier
					'energy-kilocalorie' => {
						'name' => q(كيلوكالوريا),
						'one' => q({0} كيلوكالوريا),
						'other' => q({0} كيلوكالوريا),
					},
					# Core Unit Identifier
					'kilocalorie' => {
						'name' => q(كيلوكالوريا),
						'one' => q({0} كيلوكالوريا),
						'other' => q({0} كيلوكالوريا),
					},
					# Long Unit Identifier
					'energy-kilojoule' => {
						'name' => q(كيلوجوۋل),
						'one' => q({0} كىلوجوۋل),
						'other' => q({0} كىلوجوۋل),
					},
					# Core Unit Identifier
					'kilojoule' => {
						'name' => q(كيلوجوۋل),
						'one' => q({0} كىلوجوۋل),
						'other' => q({0} كىلوجوۋل),
					},
					# Long Unit Identifier
					'energy-kilowatt-hour' => {
						'name' => q(كيلوۆات-ساعات),
						'one' => q({0} كيلوۆات-ساعات),
						'other' => q({0} كيلوۆات-ساعات),
					},
					# Core Unit Identifier
					'kilowatt-hour' => {
						'name' => q(كيلوۆات-ساعات),
						'one' => q({0} كيلوۆات-ساعات),
						'other' => q({0} كيلوۆات-ساعات),
					},
					# Long Unit Identifier
					'energy-therm-us' => {
						'name' => q(ا ق ش تەرمى),
						'one' => q({0} ا ق ش تەرمى),
						'other' => q({0} ا ق ش تەرمى),
					},
					# Core Unit Identifier
					'therm-us' => {
						'name' => q(ا ق ش تەرمى),
						'one' => q({0} ا ق ش تەرمى),
						'other' => q({0} ا ق ش تەرمى),
					},
					# Long Unit Identifier
					'force-kilowatt-hour-per-100-kilometer' => {
						'name' => q(كيلوۆات-ساعات/100 كيلومەتىر),
					},
					# Core Unit Identifier
					'kilowatt-hour-per-100-kilometer' => {
						'name' => q(كيلوۆات-ساعات/100 كيلومەتىر),
					},
					# Long Unit Identifier
					'force-pound-force' => {
						'name' => q(فۋنت-كۇش),
						'one' => q({0} فۋنت-كۇش),
						'other' => q({0} فۋنت-كۇش),
					},
					# Core Unit Identifier
					'pound-force' => {
						'name' => q(فۋنت-كۇش),
						'one' => q({0} فۋنت-كۇش),
						'other' => q({0} فۋنت-كۇش),
					},
					# Long Unit Identifier
					'frequency-gigahertz' => {
						'name' => q(گيگاگەرس),
						'one' => q({0} گيگاگەرس),
						'other' => q({0} گيگاگەرس),
					},
					# Core Unit Identifier
					'gigahertz' => {
						'name' => q(گيگاگەرس),
						'one' => q({0} گيگاگەرس),
						'other' => q({0} گيگاگەرس),
					},
					# Long Unit Identifier
					'frequency-hertz' => {
						'name' => q(گەرس),
						'one' => q({0} گەرس),
						'other' => q({0} گەرس),
					},
					# Core Unit Identifier
					'hertz' => {
						'name' => q(گەرس),
						'one' => q({0} گەرس),
						'other' => q({0} گەرس),
					},
					# Long Unit Identifier
					'frequency-kilohertz' => {
						'name' => q(كيلوگەرس),
						'one' => q({0} كيلوگەرس),
						'other' => q({0} كيلوگەرس),
					},
					# Core Unit Identifier
					'kilohertz' => {
						'name' => q(كيلوگەرس),
						'one' => q({0} كيلوگەرس),
						'other' => q({0} كيلوگەرس),
					},
					# Long Unit Identifier
					'frequency-megahertz' => {
						'name' => q(مەگاگەرس),
						'one' => q({0} مەگاگەرس),
						'other' => q({0} مەگاگەرس),
					},
					# Core Unit Identifier
					'megahertz' => {
						'name' => q(مەگاگەرس),
						'one' => q({0} مەگاگەرس),
						'other' => q({0} مەگاگەرس),
					},
					# Long Unit Identifier
					'length-astronomical-unit' => {
						'name' => q(استرونوميالىق بىرلىك),
						'one' => q({0} استرونوميالىق بىرلىك),
						'other' => q({0} استرونوميالىق بىرلىك),
					},
					# Core Unit Identifier
					'astronomical-unit' => {
						'name' => q(استرونوميالىق بىرلىك),
						'one' => q({0} استرونوميالىق بىرلىك),
						'other' => q({0} استرونوميالىق بىرلىك),
					},
					# Long Unit Identifier
					'length-centimeter' => {
						'name' => q(سانتيمەتىر),
						'one' => q({0}/سانتيمەتىر),
						'other' => q({0}/سانتيمەتىر),
						'per' => q({0}/سانتيمەتىر),
					},
					# Core Unit Identifier
					'centimeter' => {
						'name' => q(سانتيمەتىر),
						'one' => q({0}/سانتيمەتىر),
						'other' => q({0}/سانتيمەتىر),
						'per' => q({0}/سانتيمەتىر),
					},
					# Long Unit Identifier
					'length-decimeter' => {
						'name' => q(دەسيمەتىر),
						'one' => q({0}/دەسيمەتىر),
						'other' => q({0}/دەسيمەتىر),
					},
					# Core Unit Identifier
					'decimeter' => {
						'name' => q(دەسيمەتىر),
						'one' => q({0}/دەسيمەتىر),
						'other' => q({0}/دەسيمەتىر),
					},
					# Long Unit Identifier
					'length-earth-radius' => {
						'name' => q(جەر راديۋسى),
						'one' => q({0} جەر راديۋسى),
						'other' => q({0} جەر راديۋسى),
					},
					# Core Unit Identifier
					'earth-radius' => {
						'name' => q(جەر راديۋسى),
						'one' => q({0} جەر راديۋسى),
						'other' => q({0} جەر راديۋسى),
					},
					# Long Unit Identifier
					'length-fathom' => {
						'name' => q(فاتوم),
						'one' => q({0} فاتوم),
						'other' => q({0} فاتوم),
					},
					# Core Unit Identifier
					'fathom' => {
						'name' => q(فاتوم),
						'one' => q({0} فاتوم),
						'other' => q({0} فاتوم),
					},
					# Long Unit Identifier
					'length-foot' => {
						'name' => q(فۋت),
						'one' => q({0}/فۋت),
						'other' => q({0}/فۋت),
						'per' => q({0}/فۋت),
					},
					# Core Unit Identifier
					'foot' => {
						'name' => q(فۋت),
						'one' => q({0}/فۋت),
						'other' => q({0}/فۋت),
						'per' => q({0}/فۋت),
					},
					# Long Unit Identifier
					'length-furlong' => {
						'name' => q(فۋرلوڭ),
						'one' => q({0} فۋرلوڭ),
						'other' => q({0} فۋرلوڭ),
					},
					# Core Unit Identifier
					'furlong' => {
						'name' => q(فۋرلوڭ),
						'one' => q({0} فۋرلوڭ),
						'other' => q({0} فۋرلوڭ),
					},
					# Long Unit Identifier
					'length-inch' => {
						'name' => q(ديۋيم),
						'one' => q({0} ديۋيم),
						'other' => q({0} ديۋيم),
						'per' => q({0}/ديۋيم),
					},
					# Core Unit Identifier
					'inch' => {
						'name' => q(ديۋيم),
						'one' => q({0} ديۋيم),
						'other' => q({0} ديۋيم),
						'per' => q({0}/ديۋيم),
					},
					# Long Unit Identifier
					'length-kilometer' => {
						'name' => q(كيلومەتىر),
						'one' => q({0} كيلومەتىر),
						'other' => q({0} كيلومەتىر),
						'per' => q({0}/كيلومەتىر),
					},
					# Core Unit Identifier
					'kilometer' => {
						'name' => q(كيلومەتىر),
						'one' => q({0} كيلومەتىر),
						'other' => q({0} كيلومەتىر),
						'per' => q({0}/كيلومەتىر),
					},
					# Long Unit Identifier
					'length-light-year' => {
						'name' => q(جارىق جىلى),
						'one' => q({0} جارىق جىلى),
						'other' => q({0} جارىق جىلى),
					},
					# Core Unit Identifier
					'light-year' => {
						'name' => q(جارىق جىلى),
						'one' => q({0} جارىق جىلى),
						'other' => q({0} جارىق جىلى),
					},
					# Long Unit Identifier
					'length-meter' => {
						'name' => q(مەتىر),
						'one' => q({0}/مەتىر),
						'other' => q({0}/مەتىر),
						'per' => q({0}/مەتىر),
					},
					# Core Unit Identifier
					'meter' => {
						'name' => q(مەتىر),
						'one' => q({0}/مەتىر),
						'other' => q({0}/مەتىر),
						'per' => q({0}/مەتىر),
					},
					# Long Unit Identifier
					'length-micrometer' => {
						'name' => q(ميكرومەتىر),
						'one' => q({0} ميكرومەتىر),
						'other' => q({0} ميكرومەتىر),
					},
					# Core Unit Identifier
					'micrometer' => {
						'name' => q(ميكرومەتىر),
						'one' => q({0} ميكرومەتىر),
						'other' => q({0} ميكرومەتىر),
					},
					# Long Unit Identifier
					'length-mile' => {
						'name' => q(ميل),
						'one' => q({0} ميل),
						'other' => q({0} ميل),
					},
					# Core Unit Identifier
					'mile' => {
						'name' => q(ميل),
						'one' => q({0} ميل),
						'other' => q({0} ميل),
					},
					# Long Unit Identifier
					'length-mile-scandinavian' => {
						'name' => q(سكانديناۆيالىق ميل),
						'one' => q({0} سكانديناۆيالىق ميلى),
						'other' => q({0} سكانديناۆيالىق ميلى),
					},
					# Core Unit Identifier
					'mile-scandinavian' => {
						'name' => q(سكانديناۆيالىق ميل),
						'one' => q({0} سكانديناۆيالىق ميلى),
						'other' => q({0} سكانديناۆيالىق ميلى),
					},
					# Long Unit Identifier
					'length-millimeter' => {
						'name' => q(ميليمەتىر),
						'one' => q({0} ميليمەتىر),
						'other' => q({0} ميليمەتىر),
					},
					# Core Unit Identifier
					'millimeter' => {
						'name' => q(ميليمەتىر),
						'one' => q({0} ميليمەتىر),
						'other' => q({0} ميليمەتىر),
					},
					# Long Unit Identifier
					'length-nanometer' => {
						'name' => q(نانومەتىر),
						'one' => q({0} نانومەتىر),
						'other' => q({0} نانومەتىر),
					},
					# Core Unit Identifier
					'nanometer' => {
						'name' => q(نانومەتىر),
						'one' => q({0} نانومەتىر),
						'other' => q({0} نانومەتىر),
					},
					# Long Unit Identifier
					'length-nautical-mile' => {
						'name' => q(تەڭىز ميلى),
						'one' => q({0} تەڭىز ميلى),
						'other' => q({0} تەڭىز ميلى),
					},
					# Core Unit Identifier
					'nautical-mile' => {
						'name' => q(تەڭىز ميلى),
						'one' => q({0} تەڭىز ميلى),
						'other' => q({0} تەڭىز ميلى),
					},
					# Long Unit Identifier
					'length-parsec' => {
						'name' => q(پارسەك),
						'one' => q({0} پارسەك),
						'other' => q({0} پارسەك),
					},
					# Core Unit Identifier
					'parsec' => {
						'name' => q(پارسەك),
						'one' => q({0} پارسەك),
						'other' => q({0} پارسەك),
					},
					# Long Unit Identifier
					'length-picometer' => {
						'name' => q(پيكومەتىر),
						'one' => q({0} پيكومەتىر),
						'other' => q({0} پيكومەتىر),
					},
					# Core Unit Identifier
					'picometer' => {
						'name' => q(پيكومەتىر),
						'one' => q({0} پيكومەتىر),
						'other' => q({0} پيكومەتىر),
					},
					# Long Unit Identifier
					'length-point' => {
						'name' => q(پۋنكت),
						'one' => q({0} پۋنكت),
						'other' => q({0} پۋنكت),
					},
					# Core Unit Identifier
					'point' => {
						'name' => q(پۋنكت),
						'one' => q({0} پۋنكت),
						'other' => q({0} پۋنكت),
					},
					# Long Unit Identifier
					'length-solar-radius' => {
						'name' => q(كۇن راديۋسى),
						'one' => q({0} كۇن راديۋسى),
						'other' => q({0} كۇن راديۋسى),
					},
					# Core Unit Identifier
					'solar-radius' => {
						'name' => q(كۇن راديۋسى),
						'one' => q({0} كۇن راديۋسى),
						'other' => q({0} كۇن راديۋسى),
					},
					# Long Unit Identifier
					'length-yard' => {
						'name' => q(يارد),
						'one' => q({0} يارد),
						'other' => q({0} يارد),
					},
					# Core Unit Identifier
					'yard' => {
						'name' => q(يارد),
						'one' => q({0} يارد),
						'other' => q({0} يارد),
					},
					# Long Unit Identifier
					'light-candela' => {
						'name' => q(كاندەلا),
					},
					# Core Unit Identifier
					'candela' => {
						'name' => q(كاندەلا),
					},
					# Long Unit Identifier
					'light-lumen' => {
						'name' => q(ليۋمەن),
					},
					# Core Unit Identifier
					'lumen' => {
						'name' => q(ليۋمەن),
					},
					# Long Unit Identifier
					'light-lux' => {
						'name' => q(ليۋكس),
					},
					# Core Unit Identifier
					'lux' => {
						'name' => q(ليۋكس),
					},
					# Long Unit Identifier
					'light-solar-luminosity' => {
						'name' => q(كۇن جارىقتىعى),
						'one' => q({0} كۇن جارىقتىعى),
						'other' => q({0} كۇن جارىقتىعى),
					},
					# Core Unit Identifier
					'solar-luminosity' => {
						'name' => q(كۇن جارىقتىعى),
						'one' => q({0} كۇن جارىقتىعى),
						'other' => q({0} كۇن جارىقتىعى),
					},
					# Long Unit Identifier
					'mass-carat' => {
						'name' => q(كارات),
						'one' => q({0} كارات),
						'other' => q({0} كارات),
					},
					# Core Unit Identifier
					'carat' => {
						'name' => q(كارات),
						'one' => q({0} كارات),
						'other' => q({0} كارات),
					},
					# Long Unit Identifier
					'mass-dalton' => {
						'name' => q(دالتون),
						'one' => q({0} دالتون),
						'other' => q({0} دالتون),
					},
					# Core Unit Identifier
					'dalton' => {
						'name' => q(دالتون),
						'one' => q({0} دالتون),
						'other' => q({0} دالتون),
					},
					# Long Unit Identifier
					'mass-earth-mass' => {
						'name' => q(جەر ماسساسى),
						'one' => q({0} جەر ماسساسى),
						'other' => q({0} جەر ماسساسى),
					},
					# Core Unit Identifier
					'earth-mass' => {
						'name' => q(جەر ماسساسى),
						'one' => q({0} جەر ماسساسى),
						'other' => q({0} جەر ماسساسى),
					},
					# Long Unit Identifier
					'mass-grain' => {
						'name' => q(گران),
						'one' => q({0} گران),
						'other' => q({0} گران),
					},
					# Core Unit Identifier
					'grain' => {
						'name' => q(گران),
						'one' => q({0} گران),
						'other' => q({0} گران),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'name' => q(گرام),
						'one' => q({0} گرام),
						'other' => q({0} گرام),
						'per' => q({0}/گرام),
					},
					# Core Unit Identifier
					'gram' => {
						'name' => q(گرام),
						'one' => q({0} گرام),
						'other' => q({0} گرام),
						'per' => q({0}/گرام),
					},
					# Long Unit Identifier
					'mass-kilogram' => {
						'name' => q(كيلوگرام),
						'one' => q({0} كيلوگرام),
						'other' => q({0} كيلوگرام),
						'per' => q({0}/كيلوگرام),
					},
					# Core Unit Identifier
					'kilogram' => {
						'name' => q(كيلوگرام),
						'one' => q({0} كيلوگرام),
						'other' => q({0} كيلوگرام),
						'per' => q({0}/كيلوگرام),
					},
					# Long Unit Identifier
					'mass-microgram' => {
						'name' => q(ميكروگرام),
						'one' => q({0} ميكروگرام),
						'other' => q({0} ميكروگرام),
					},
					# Core Unit Identifier
					'microgram' => {
						'name' => q(ميكروگرام),
						'one' => q({0} ميكروگرام),
						'other' => q({0} ميكروگرام),
					},
					# Long Unit Identifier
					'mass-milligram' => {
						'name' => q(ميليگرام),
						'one' => q({0} ميليگرام),
						'other' => q({0} ميليگرام),
					},
					# Core Unit Identifier
					'milligram' => {
						'name' => q(ميليگرام),
						'one' => q({0} ميليگرام),
						'other' => q({0} ميليگرام),
					},
					# Long Unit Identifier
					'mass-ounce' => {
						'name' => q(ۋنسيا),
						'one' => q({0} ۋنسيا),
						'other' => q({0} ۋنسيا),
						'per' => q({0}/ۋنسيا),
					},
					# Core Unit Identifier
					'ounce' => {
						'name' => q(ۋنسيا),
						'one' => q({0} ۋنسيا),
						'other' => q({0} ۋنسيا),
						'per' => q({0}/ۋنسيا),
					},
					# Long Unit Identifier
					'mass-ounce-troy' => {
						'name' => q(تروي ۋنسياسى),
						'one' => q({0} تروۋ ۋنسياسى),
						'other' => q({0} تروۋ ۋنسياسى),
					},
					# Core Unit Identifier
					'ounce-troy' => {
						'name' => q(تروي ۋنسياسى),
						'one' => q({0} تروۋ ۋنسياسى),
						'other' => q({0} تروۋ ۋنسياسى),
					},
					# Long Unit Identifier
					'mass-pound' => {
						'name' => q(فۋنت),
						'one' => q({0} فۋنت),
						'other' => q({0} فۋنت),
						'per' => q({0}/فۋنت),
					},
					# Core Unit Identifier
					'pound' => {
						'name' => q(فۋنت),
						'one' => q({0} فۋنت),
						'other' => q({0} فۋنت),
						'per' => q({0}/فۋنت),
					},
					# Long Unit Identifier
					'mass-solar-mass' => {
						'name' => q(كۇن ماسساسى),
						'one' => q({0} كۇن ماسساسى),
						'other' => q({0} كۇن ماسساسى),
					},
					# Core Unit Identifier
					'solar-mass' => {
						'name' => q(كۇن ماسساسى),
						'one' => q({0} كۇن ماسساسى),
						'other' => q({0} كۇن ماسساسى),
					},
					# Long Unit Identifier
					'mass-stone' => {
						'name' => q(ستوۋن),
						'one' => q({0} ستوۋن),
						'other' => q({0} ستوۋن),
					},
					# Core Unit Identifier
					'stone' => {
						'name' => q(ستوۋن),
						'one' => q({0} ستوۋن),
						'other' => q({0} ستوۋن),
					},
					# Long Unit Identifier
					'mass-ton' => {
						'name' => q(توننا),
						'one' => q({0} توننا),
						'other' => q({0} توننا),
					},
					# Core Unit Identifier
					'ton' => {
						'name' => q(توننا),
						'one' => q({0} توننا),
						'other' => q({0} توننا),
					},
					# Long Unit Identifier
					'mass-tonne' => {
						'name' => q(مەتىرلىك توننا),
						'one' => q({0} توننا),
						'other' => q({0} توننا),
					},
					# Core Unit Identifier
					'tonne' => {
						'name' => q(مەتىرلىك توننا),
						'one' => q({0} توننا),
						'other' => q({0} توننا),
					},
					# Long Unit Identifier
					'power-gigawatt' => {
						'name' => q(گيگاۆات),
						'one' => q({0} گيگاۆات),
						'other' => q({0} گيگاۆات),
					},
					# Core Unit Identifier
					'gigawatt' => {
						'name' => q(گيگاۆات),
						'one' => q({0} گيگاۆات),
						'other' => q({0} گيگاۆات),
					},
					# Long Unit Identifier
					'power-horsepower' => {
						'name' => q(ات كۇشى),
						'one' => q({0} ات كۇشى),
						'other' => q({0} ات كۇشى),
					},
					# Core Unit Identifier
					'horsepower' => {
						'name' => q(ات كۇشى),
						'one' => q({0} ات كۇشى),
						'other' => q({0} ات كۇشى),
					},
					# Long Unit Identifier
					'power-kilowatt' => {
						'name' => q(كيلوۆات),
						'one' => q({0} كيلوۆات),
						'other' => q({0} كيلوۆات),
					},
					# Core Unit Identifier
					'kilowatt' => {
						'name' => q(كيلوۆات),
						'one' => q({0} كيلوۆات),
						'other' => q({0} كيلوۆات),
					},
					# Long Unit Identifier
					'power-megawatt' => {
						'name' => q(مەگاۆات),
						'one' => q({0} مەگاۆات),
						'other' => q({0} مەگاۆات),
					},
					# Core Unit Identifier
					'megawatt' => {
						'name' => q(مەگاۆات),
						'one' => q({0} مەگاۆات),
						'other' => q({0} مەگاۆات),
					},
					# Long Unit Identifier
					'power-milliwatt' => {
						'name' => q(ميليۆات),
						'one' => q({0} ميليۆات),
						'other' => q({0} ميليۆات),
					},
					# Core Unit Identifier
					'milliwatt' => {
						'name' => q(ميليۆات),
						'one' => q({0} ميليۆات),
						'other' => q({0} ميليۆات),
					},
					# Long Unit Identifier
					'power-watt' => {
						'name' => q(ۆات),
						'one' => q({0} ۆات),
						'other' => q({0} ۆات),
					},
					# Core Unit Identifier
					'watt' => {
						'name' => q(ۆات),
						'one' => q({0} ۆات),
						'other' => q({0} ۆات),
					},
					# Long Unit Identifier
					'pressure-atmosphere' => {
						'name' => q(اتموسفەرا),
						'one' => q({0} اتموسفەرا),
						'other' => q({0} اتموسفەرا),
					},
					# Core Unit Identifier
					'atmosphere' => {
						'name' => q(اتموسفەرا),
						'one' => q({0} اتموسفەرا),
						'other' => q({0} اتموسفەرا),
					},
					# Long Unit Identifier
					'pressure-bar' => {
						'name' => q(بار),
						'one' => q({0} بار),
						'other' => q({0} بار),
					},
					# Core Unit Identifier
					'bar' => {
						'name' => q(بار),
						'one' => q({0} بار),
						'other' => q({0} بار),
					},
					# Long Unit Identifier
					'pressure-hectopascal' => {
						'name' => q(گەكتوپاسكال),
						'one' => q({0} گەكتوپاسكال),
						'other' => q({0} گەكتوپاسكال),
					},
					# Core Unit Identifier
					'hectopascal' => {
						'name' => q(گەكتوپاسكال),
						'one' => q({0} گەكتوپاسكال),
						'other' => q({0} گەكتوپاسكال),
					},
					# Long Unit Identifier
					'pressure-inch-ofhg' => {
						'name' => q(ديۋيم سىناپ باعاناسى),
						'one' => q({0} ديۋيم سىناپ باعاناسى),
						'other' => q({0} ديۋيم سىناپ باعاناسى),
					},
					# Core Unit Identifier
					'inch-ofhg' => {
						'name' => q(ديۋيم سىناپ باعاناسى),
						'one' => q({0} ديۋيم سىناپ باعاناسى),
						'other' => q({0} ديۋيم سىناپ باعاناسى),
					},
					# Long Unit Identifier
					'pressure-kilopascal' => {
						'name' => q(كيلوپاسكال),
						'one' => q({0} كيلوپاسكال),
						'other' => q({0} كيلوپاسكال),
					},
					# Core Unit Identifier
					'kilopascal' => {
						'name' => q(كيلوپاسكال),
						'one' => q({0} كيلوپاسكال),
						'other' => q({0} كيلوپاسكال),
					},
					# Long Unit Identifier
					'pressure-megapascal' => {
						'name' => q(مەگاپاسكال),
						'one' => q({0} مەگاپاسكال),
						'other' => q({0} مەگاپاسكال),
					},
					# Core Unit Identifier
					'megapascal' => {
						'name' => q(مەگاپاسكال),
						'one' => q({0} مەگاپاسكال),
						'other' => q({0} مەگاپاسكال),
					},
					# Long Unit Identifier
					'pressure-millibar' => {
						'name' => q(ميليبار),
						'one' => q({0} ميليبار),
						'other' => q({0} ميليبار),
					},
					# Core Unit Identifier
					'millibar' => {
						'name' => q(ميليبار),
						'one' => q({0} ميليبار),
						'other' => q({0} ميليبار),
					},
					# Long Unit Identifier
					'pressure-millimeter-ofhg' => {
						'name' => q(ميليمەتىر سىناپ باعاناسى),
						'one' => q({0} ميليمەتىر سىناپ باعاناسى),
						'other' => q({0} ميليمەتىر سىناپ باعاناسى),
					},
					# Core Unit Identifier
					'millimeter-ofhg' => {
						'name' => q(ميليمەتىر سىناپ باعاناسى),
						'one' => q({0} ميليمەتىر سىناپ باعاناسى),
						'other' => q({0} ميليمەتىر سىناپ باعاناسى),
					},
					# Long Unit Identifier
					'pressure-pascal' => {
						'name' => q(پاسكال),
						'one' => q({0} پاسكال),
						'other' => q({0} پاسكال),
					},
					# Core Unit Identifier
					'pascal' => {
						'name' => q(پاسكال),
						'one' => q({0} پاسكال),
						'other' => q({0} پاسكال),
					},
					# Long Unit Identifier
					'pressure-pound-force-per-square-inch' => {
						'name' => q(فۋنت-كۇش/شارشى ديۋيم),
						'one' => q({0} فۋنت-كۇش/شارشى ديۋيم),
						'other' => q({0} فۋنت-كۇش/شارشى ديۋيم),
					},
					# Core Unit Identifier
					'pound-force-per-square-inch' => {
						'name' => q(فۋنت-كۇش/شارشى ديۋيم),
						'one' => q({0} فۋنت-كۇش/شارشى ديۋيم),
						'other' => q({0} فۋنت-كۇش/شارشى ديۋيم),
					},
					# Long Unit Identifier
					'speed-beaufort' => {
						'name' => q(بوفورت),
						'one' => q({0} بوفورت),
						'other' => q({0} بوفورت),
					},
					# Core Unit Identifier
					'beaufort' => {
						'name' => q(بوفورت),
						'one' => q({0} بوفورت),
						'other' => q({0} بوفورت),
					},
					# Long Unit Identifier
					'speed-kilometer-per-hour' => {
						'name' => q(كيلومەتىر/ساعات),
						'one' => q({0} كيلومەتىر/ساعات),
						'other' => q({0} كيلومەتىر/ساعات),
					},
					# Core Unit Identifier
					'kilometer-per-hour' => {
						'name' => q(كيلومەتىر/ساعات),
						'one' => q({0} كيلومەتىر/ساعات),
						'other' => q({0} كيلومەتىر/ساعات),
					},
					# Long Unit Identifier
					'speed-knot' => {
						'name' => q(ءتۇيىن),
						'one' => q({0} ءتۇيىن),
						'other' => q({0} ءتۇيىن),
					},
					# Core Unit Identifier
					'knot' => {
						'name' => q(ءتۇيىن),
						'one' => q({0} ءتۇيىن),
						'other' => q({0} ءتۇيىن),
					},
					# Long Unit Identifier
					'speed-light-speed' => {
						'name' => q(جارىق),
						'one' => q({0} جارىق),
						'other' => q({0} جارىق),
					},
					# Core Unit Identifier
					'light-speed' => {
						'name' => q(جارىق),
						'one' => q({0} جارىق),
						'other' => q({0} جارىق),
					},
					# Long Unit Identifier
					'speed-meter-per-second' => {
						'name' => q(مەتىر/سەكۋند),
						'one' => q({0} مەتىر/سەكۋند),
						'other' => q({0} مەتىر/سەكۋند),
					},
					# Core Unit Identifier
					'meter-per-second' => {
						'name' => q(مەتىر/سەكۋند),
						'one' => q({0} مەتىر/سەكۋند),
						'other' => q({0} مەتىر/سەكۋند),
					},
					# Long Unit Identifier
					'speed-mile-per-hour' => {
						'name' => q(ميل/ساعات),
						'one' => q({0} ميل/ساعات),
						'other' => q({0} ميل/ساعات),
					},
					# Core Unit Identifier
					'mile-per-hour' => {
						'name' => q(ميل/ساعات),
						'one' => q({0} ميل/ساعات),
						'other' => q({0} ميل/ساعات),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'name' => q(سەلسي گرادۋسى),
					},
					# Core Unit Identifier
					'celsius' => {
						'name' => q(سەلسي گرادۋسى),
					},
					# Long Unit Identifier
					'temperature-fahrenheit' => {
						'name' => q(فارانگەيت گرادۋسى),
					},
					# Core Unit Identifier
					'fahrenheit' => {
						'name' => q(فارانگەيت گرادۋسى),
					},
					# Long Unit Identifier
					'temperature-kelvin' => {
						'name' => q(كەلۆين),
					},
					# Core Unit Identifier
					'kelvin' => {
						'name' => q(كەلۆين),
					},
					# Long Unit Identifier
					'torque-newton-meter' => {
						'name' => q(نيۋتون-مەتىر),
					},
					# Core Unit Identifier
					'newton-meter' => {
						'name' => q(نيۋتون-مەتىر),
					},
					# Long Unit Identifier
					'torque-pound-force-foot' => {
						'name' => q(فۋنت-كۇش-فۋت),
						'one' => q({0} فۋنت-كۇش-فۋت),
						'other' => q({0} فۋنت-كۇش-فۋت),
					},
					# Core Unit Identifier
					'pound-force-foot' => {
						'name' => q(فۋنت-كۇش-فۋت),
						'one' => q({0} فۋنت-كۇش-فۋت),
						'other' => q({0} فۋنت-كۇش-فۋت),
					},
					# Long Unit Identifier
					'volume-acre-foot' => {
						'name' => q(اكر-فۋت),
						'one' => q({0} اكر-فۋت),
						'other' => q({0} اكر-فۋت),
					},
					# Core Unit Identifier
					'acre-foot' => {
						'name' => q(اكر-فۋت),
						'one' => q({0} اكر-فۋت),
						'other' => q({0} اكر-فۋت),
					},
					# Long Unit Identifier
					'volume-barrel' => {
						'name' => q(باررەل),
						'one' => q({0} باررەل),
						'other' => q({0} باررەل),
					},
					# Core Unit Identifier
					'barrel' => {
						'name' => q(باررەل),
						'one' => q({0} باررەل),
						'other' => q({0} باررەل),
					},
					# Long Unit Identifier
					'volume-bushel' => {
						'name' => q(بۋشەل),
						'one' => q({0} بۋشەل),
						'other' => q({0} بۋشەل),
					},
					# Core Unit Identifier
					'bushel' => {
						'name' => q(بۋشەل),
						'one' => q({0} بۋشەل),
						'other' => q({0} بۋشەل),
					},
					# Long Unit Identifier
					'volume-centiliter' => {
						'name' => q(سانتيليتىر),
						'one' => q({0} سانتيليتىر),
						'other' => q({0} سانتيليتىر),
					},
					# Core Unit Identifier
					'centiliter' => {
						'name' => q(سانتيليتىر),
						'one' => q({0} سانتيليتىر),
						'other' => q({0} سانتيليتىر),
					},
					# Long Unit Identifier
					'volume-cubic-centimeter' => {
						'name' => q(تەكشە سانتيمەتىر),
						'one' => q({0} تەكشە سانتيمەتىر),
						'other' => q({0} تەكشە سانتيمەتىر),
						'per' => q({0}/تەكشە سانتيمەتىر),
					},
					# Core Unit Identifier
					'cubic-centimeter' => {
						'name' => q(تەكشە سانتيمەتىر),
						'one' => q({0} تەكشە سانتيمەتىر),
						'other' => q({0} تەكشە سانتيمەتىر),
						'per' => q({0}/تەكشە سانتيمەتىر),
					},
					# Long Unit Identifier
					'volume-cubic-foot' => {
						'name' => q(تەكشە فۋت),
						'one' => q({0} تەكشە فۋت),
						'other' => q({0} تەكشە فۋت),
					},
					# Core Unit Identifier
					'cubic-foot' => {
						'name' => q(تەكشە فۋت),
						'one' => q({0} تەكشە فۋت),
						'other' => q({0} تەكشە فۋت),
					},
					# Long Unit Identifier
					'volume-cubic-inch' => {
						'name' => q(تەكشە ديۋيم),
						'one' => q({0} تەكشە ديۋيم),
						'other' => q({0} تەكشە ديۋيم),
					},
					# Core Unit Identifier
					'cubic-inch' => {
						'name' => q(تەكشە ديۋيم),
						'one' => q({0} تەكشە ديۋيم),
						'other' => q({0} تەكشە ديۋيم),
					},
					# Long Unit Identifier
					'volume-cubic-kilometer' => {
						'name' => q(تەكشە كيلومەتىر),
						'one' => q({0} تەكشە كيلومەتىر),
						'other' => q({0} تەكشە كيلومەتىر),
					},
					# Core Unit Identifier
					'cubic-kilometer' => {
						'name' => q(تەكشە كيلومەتىر),
						'one' => q({0} تەكشە كيلومەتىر),
						'other' => q({0} تەكشە كيلومەتىر),
					},
					# Long Unit Identifier
					'volume-cubic-meter' => {
						'name' => q(تەكشە مەتىر),
						'one' => q({0} تەكشە مەتىر),
						'other' => q({0} تەكشە مەتىر),
						'per' => q({0}/تەكشە مەتىر),
					},
					# Core Unit Identifier
					'cubic-meter' => {
						'name' => q(تەكشە مەتىر),
						'one' => q({0} تەكشە مەتىر),
						'other' => q({0} تەكشە مەتىر),
						'per' => q({0}/تەكشە مەتىر),
					},
					# Long Unit Identifier
					'volume-cubic-mile' => {
						'name' => q(تەكشە ميل),
						'one' => q({0} تەكشە ميل),
						'other' => q({0} تەكشە ميل),
					},
					# Core Unit Identifier
					'cubic-mile' => {
						'name' => q(تەكشە ميل),
						'one' => q({0} تەكشە ميل),
						'other' => q({0} تەكشە ميل),
					},
					# Long Unit Identifier
					'volume-cubic-yard' => {
						'name' => q(تەكشە يارد),
						'one' => q({0} تەكشە يارد),
						'other' => q({0} تەكشە يارد),
					},
					# Core Unit Identifier
					'cubic-yard' => {
						'name' => q(تەكشە يارد),
						'one' => q({0} تەكشە يارد),
						'other' => q({0} تەكشە يارد),
					},
					# Long Unit Identifier
					'volume-cup' => {
						'name' => q(كەسە),
						'one' => q({0} كەسە),
						'other' => q({0} كەسە),
					},
					# Core Unit Identifier
					'cup' => {
						'name' => q(كەسە),
						'one' => q({0} كەسە),
						'other' => q({0} كەسە),
					},
					# Long Unit Identifier
					'volume-cup-metric' => {
						'name' => q(مەتىرلىك كەسە),
						'one' => q({0} مەتىرلىك كەسە),
						'other' => q({0} مەتىرلىك كەسە),
					},
					# Core Unit Identifier
					'cup-metric' => {
						'name' => q(مەتىرلىك كەسە),
						'one' => q({0} مەتىرلىك كەسە),
						'other' => q({0} مەتىرلىك كەسە),
					},
					# Long Unit Identifier
					'volume-deciliter' => {
						'name' => q(دەسيليتىر),
						'one' => q({0} دەسيليتىر),
						'other' => q({0} دەسيليتىر),
					},
					# Core Unit Identifier
					'deciliter' => {
						'name' => q(دەسيليتىر),
						'one' => q({0} دەسيليتىر),
						'other' => q({0} دەسيليتىر),
					},
					# Long Unit Identifier
					'volume-dessert-spoon' => {
						'name' => q(دەسەرت قاسىعى),
						'one' => q({0} دەسەرت قاسىعى),
						'other' => q({0} دەسەرت قاسىعى),
					},
					# Core Unit Identifier
					'dessert-spoon' => {
						'name' => q(دەسەرت قاسىعى),
						'one' => q({0} دەسەرت قاسىعى),
						'other' => q({0} دەسەرت قاسىعى),
					},
					# Long Unit Identifier
					'volume-dessert-spoon-imperial' => {
						'name' => q(يمپ دەسەرت قاسىعى),
						'one' => q({0} يمپ دەسەرت قاسىعى),
						'other' => q({0} يمپ دەسەرت قاسىعى),
					},
					# Core Unit Identifier
					'dessert-spoon-imperial' => {
						'name' => q(يمپ دەسەرت قاسىعى),
						'one' => q({0} يمپ دەسەرت قاسىعى),
						'other' => q({0} يمپ دەسەرت قاسىعى),
					},
					# Long Unit Identifier
					'volume-dram' => {
						'name' => q(دراحما),
						'one' => q({0} دراحما),
						'other' => q({0} دراحما),
					},
					# Core Unit Identifier
					'dram' => {
						'name' => q(دراحما),
						'one' => q({0} دراحما),
						'other' => q({0} دراحما),
					},
					# Long Unit Identifier
					'volume-drop' => {
						'name' => q(تامشى),
						'one' => q({0} تامشى),
						'other' => q({0} تامشى),
					},
					# Core Unit Identifier
					'drop' => {
						'name' => q(تامشى),
						'one' => q({0} تامشى),
						'other' => q({0} تامشى),
					},
					# Long Unit Identifier
					'volume-fluid-ounce' => {
						'name' => q(سۇيىق ۋنسيا),
						'one' => q({0} سۇيىق ۋنسيا),
						'other' => q({0} سۇيىق ۋنسيا),
					},
					# Core Unit Identifier
					'fluid-ounce' => {
						'name' => q(سۇيىق ۋنسيا),
						'one' => q({0} سۇيىق ۋنسيا),
						'other' => q({0} سۇيىق ۋنسيا),
					},
					# Long Unit Identifier
					'volume-fluid-ounce-imperial' => {
						'name' => q(يمپ سۇيىق ۋنسيا),
						'one' => q({0} يمپ سۇيىق ۋنسيا),
						'other' => q({0} يمپ سۇيىق ۋنسيا),
					},
					# Core Unit Identifier
					'fluid-ounce-imperial' => {
						'name' => q(يمپ سۇيىق ۋنسيا),
						'one' => q({0} يمپ سۇيىق ۋنسيا),
						'other' => q({0} يمپ سۇيىق ۋنسيا),
					},
					# Long Unit Identifier
					'volume-gallon' => {
						'name' => q(گاللون),
						'one' => q({0} گاللون),
						'other' => q({0} گاللون),
						'per' => q({0}/گاللون),
					},
					# Core Unit Identifier
					'gallon' => {
						'name' => q(گاللون),
						'one' => q({0} گاللون),
						'other' => q({0} گاللون),
						'per' => q({0}/گاللون),
					},
					# Long Unit Identifier
					'volume-gallon-imperial' => {
						'name' => q(يمپ گاللون),
						'one' => q({0} يمپ گاللون),
						'other' => q({0} يمپ گاللون),
						'per' => q({0} يمپ گاللون),
					},
					# Core Unit Identifier
					'gallon-imperial' => {
						'name' => q(يمپ گاللون),
						'one' => q({0} يمپ گاللون),
						'other' => q({0} يمپ گاللون),
						'per' => q({0} يمپ گاللون),
					},
					# Long Unit Identifier
					'volume-hectoliter' => {
						'name' => q(گەكتوليتىر),
						'one' => q({0} گەكتوليرىر),
						'other' => q({0} گەكتوليرىر),
					},
					# Core Unit Identifier
					'hectoliter' => {
						'name' => q(گەكتوليتىر),
						'one' => q({0} گەكتوليرىر),
						'other' => q({0} گەكتوليرىر),
					},
					# Long Unit Identifier
					'volume-jigger' => {
						'name' => q(جيگگەر),
						'one' => q({0} جيگگەر),
						'other' => q({0} جيگگەر),
					},
					# Core Unit Identifier
					'jigger' => {
						'name' => q(جيگگەر),
						'one' => q({0} جيگگەر),
						'other' => q({0} جيگگەر),
					},
					# Long Unit Identifier
					'volume-liter' => {
						'name' => q(ليتىر),
						'one' => q({0} ليتىر),
						'other' => q({0} ليتىر),
						'per' => q({0}/ليتىر),
					},
					# Core Unit Identifier
					'liter' => {
						'name' => q(ليتىر),
						'one' => q({0} ليتىر),
						'other' => q({0} ليتىر),
						'per' => q({0}/ليتىر),
					},
					# Long Unit Identifier
					'volume-megaliter' => {
						'name' => q(مەگاليتر),
						'one' => q({0} مەگاليتر),
						'other' => q({0} مەگاليتر),
					},
					# Core Unit Identifier
					'megaliter' => {
						'name' => q(مەگاليتر),
						'one' => q({0} مەگاليتر),
						'other' => q({0} مەگاليتر),
					},
					# Long Unit Identifier
					'volume-milliliter' => {
						'name' => q(ميليليتىر),
						'one' => q({0} ميليليتىر),
						'other' => q({0} ميليليتىر),
					},
					# Core Unit Identifier
					'milliliter' => {
						'name' => q(ميليليتىر),
						'one' => q({0} ميليليتىر),
						'other' => q({0} ميليليتىر),
					},
					# Long Unit Identifier
					'volume-pinch' => {
						'name' => q(شوكىم),
						'one' => q({0} شوكىم),
						'other' => q({0} شوكىم),
					},
					# Core Unit Identifier
					'pinch' => {
						'name' => q(شوكىم),
						'one' => q({0} شوكىم),
						'other' => q({0} شوكىم),
					},
					# Long Unit Identifier
					'volume-pint' => {
						'name' => q(پينتا),
						'one' => q({0} پينتا),
						'other' => q({0} پينتا),
					},
					# Core Unit Identifier
					'pint' => {
						'name' => q(پينتا),
						'one' => q({0} پينتا),
						'other' => q({0} پينتا),
					},
					# Long Unit Identifier
					'volume-pint-metric' => {
						'name' => q(مەتىرلىك پينتا),
						'one' => q({0} مەتىرلىك پينتا),
						'other' => q({0} مەتىرلىك پينتا),
					},
					# Core Unit Identifier
					'pint-metric' => {
						'name' => q(مەتىرلىك پينتا),
						'one' => q({0} مەتىرلىك پينتا),
						'other' => q({0} مەتىرلىك پينتا),
					},
					# Long Unit Identifier
					'volume-quart' => {
						'name' => q(كۆارتا),
						'one' => q({0} كۆارتا),
						'other' => q({0} كۆارتا),
					},
					# Core Unit Identifier
					'quart' => {
						'name' => q(كۆارتا),
						'one' => q({0} كۆارتا),
						'other' => q({0} كۆارتا),
					},
					# Long Unit Identifier
					'volume-quart-imperial' => {
						'name' => q(يمپ كۆارتا),
						'one' => q({0} يمپ كۆارتا),
						'other' => q({0} يمپ كۆارتا),
					},
					# Core Unit Identifier
					'quart-imperial' => {
						'name' => q(يمپ كۆارتا),
						'one' => q({0} يمپ كۆارتا),
						'other' => q({0} يمپ كۆارتا),
					},
					# Long Unit Identifier
					'volume-tablespoon' => {
						'name' => q(اس قاسىق),
						'one' => q({0} اس قاسىق),
						'other' => q({0} اس قاسىق),
					},
					# Core Unit Identifier
					'tablespoon' => {
						'name' => q(اس قاسىق),
						'one' => q({0} اس قاسىق),
						'other' => q({0} اس قاسىق),
					},
					# Long Unit Identifier
					'volume-teaspoon' => {
						'name' => q(شاي قاسىق),
						'one' => q({0} شاي قاسىق),
						'other' => q({0} شاي قاسىق),
					},
					# Core Unit Identifier
					'teaspoon' => {
						'name' => q(شاي قاسىق),
						'one' => q({0} شاي قاسىق),
						'other' => q({0} شاي قاسىق),
					},
				},
				'short' => {
					# Long Unit Identifier
					'' => {
						'name' => q(باعىت),
					},
					# Core Unit Identifier
					'' => {
						'name' => q(باعىت),
					},
					# Long Unit Identifier
					'1024p1' => {
						'1' => q(كي{0}),
					},
					# Core Unit Identifier
					'1024p1' => {
						'1' => q(كي{0}),
					},
					# Long Unit Identifier
					'1024p2' => {
						'1' => q(مب{0}),
					},
					# Core Unit Identifier
					'1024p2' => {
						'1' => q(مب{0}),
					},
					# Long Unit Identifier
					'1024p3' => {
						'1' => q(گي{0}),
					},
					# Core Unit Identifier
					'1024p3' => {
						'1' => q(گي{0}),
					},
					# Long Unit Identifier
					'1024p4' => {
						'1' => q(تب{0}),
					},
					# Core Unit Identifier
					'1024p4' => {
						'1' => q(تب{0}),
					},
					# Long Unit Identifier
					'1024p5' => {
						'1' => q(پب{0}),
					},
					# Core Unit Identifier
					'1024p5' => {
						'1' => q(پب{0}),
					},
					# Long Unit Identifier
					'1024p6' => {
						'1' => q(ەب{0}),
					},
					# Core Unit Identifier
					'1024p6' => {
						'1' => q(ەب{0}),
					},
					# Long Unit Identifier
					'1024p7' => {
						'1' => q(زب{0}),
					},
					# Core Unit Identifier
					'1024p7' => {
						'1' => q(زب{0}),
					},
					# Long Unit Identifier
					'1024p8' => {
						'1' => q(يب{0}),
					},
					# Core Unit Identifier
					'1024p8' => {
						'1' => q(يب{0}),
					},
					# Long Unit Identifier
					'10p-1' => {
						'1' => q(د{0}),
					},
					# Core Unit Identifier
					'1' => {
						'1' => q(د{0}),
					},
					# Long Unit Identifier
					'10p-12' => {
						'1' => q(پ{0}),
					},
					# Core Unit Identifier
					'12' => {
						'1' => q(پ{0}),
					},
					# Long Unit Identifier
					'10p-15' => {
						'1' => q(ف{0}),
					},
					# Core Unit Identifier
					'15' => {
						'1' => q(ف{0}),
					},
					# Long Unit Identifier
					'10p-18' => {
						'1' => q(ا{0}),
					},
					# Core Unit Identifier
					'18' => {
						'1' => q(ا{0}),
					},
					# Long Unit Identifier
					'10p-2' => {
						'1' => q(س{0}),
					},
					# Core Unit Identifier
					'2' => {
						'1' => q(س{0}),
					},
					# Long Unit Identifier
					'10p-21' => {
						'1' => q(ز{0}),
					},
					# Core Unit Identifier
					'21' => {
						'1' => q(ز{0}),
					},
					# Long Unit Identifier
					'10p-24' => {
						'1' => q(ي{0}),
					},
					# Core Unit Identifier
					'24' => {
						'1' => q(ي{0}),
					},
					# Long Unit Identifier
					'10p-27' => {
						'1' => q(ر{0}),
					},
					# Core Unit Identifier
					'27' => {
						'1' => q(ر{0}),
					},
					# Long Unit Identifier
					'10p-3' => {
						'1' => q(مل{0}),
					},
					# Core Unit Identifier
					'3' => {
						'1' => q(مل{0}),
					},
					# Long Unit Identifier
					'10p-30' => {
						'1' => q(ك{0}),
					},
					# Core Unit Identifier
					'30' => {
						'1' => q(ك{0}),
					},
					# Long Unit Identifier
					'10p-6' => {
						'1' => q(مك{0}),
					},
					# Core Unit Identifier
					'6' => {
						'1' => q(مك{0}),
					},
					# Long Unit Identifier
					'10p-9' => {
						'1' => q(ن{0}),
					},
					# Core Unit Identifier
					'9' => {
						'1' => q(ن{0}),
					},
					# Long Unit Identifier
					'10p1' => {
						'1' => q(دا{0}),
					},
					# Core Unit Identifier
					'10p1' => {
						'1' => q(دا{0}),
					},
					# Long Unit Identifier
					'10p12' => {
						'1' => q(ت{0}),
					},
					# Core Unit Identifier
					'10p12' => {
						'1' => q(ت{0}),
					},
					# Long Unit Identifier
					'10p15' => {
						'1' => q(پت{0}),
					},
					# Core Unit Identifier
					'10p15' => {
						'1' => q(پت{0}),
					},
					# Long Unit Identifier
					'10p18' => {
						'1' => q(ە{0}),
					},
					# Core Unit Identifier
					'10p18' => {
						'1' => q(ە{0}),
					},
					# Long Unit Identifier
					'10p2' => {
						'1' => q(گ{0}),
					},
					# Core Unit Identifier
					'10p2' => {
						'1' => q(گ{0}),
					},
					# Long Unit Identifier
					'10p21' => {
						'1' => q(زت{0}),
					},
					# Core Unit Identifier
					'10p21' => {
						'1' => q(زت{0}),
					},
					# Long Unit Identifier
					'10p24' => {
						'1' => q(يت{0}),
					},
					# Core Unit Identifier
					'10p24' => {
						'1' => q(يت{0}),
					},
					# Long Unit Identifier
					'10p27' => {
						'1' => q(رن{0}),
					},
					# Core Unit Identifier
					'10p27' => {
						'1' => q(رن{0}),
					},
					# Long Unit Identifier
					'10p3' => {
						'1' => q(كل{0}),
					},
					# Core Unit Identifier
					'10p3' => {
						'1' => q(كل{0}),
					},
					# Long Unit Identifier
					'10p30' => {
						'1' => q(كت{0}),
					},
					# Core Unit Identifier
					'10p30' => {
						'1' => q(كت{0}),
					},
					# Long Unit Identifier
					'10p6' => {
						'1' => q(مگ{0}),
					},
					# Core Unit Identifier
					'10p6' => {
						'1' => q(مگ{0}),
					},
					# Long Unit Identifier
					'10p9' => {
						'1' => q(گگ{0}),
					},
					# Core Unit Identifier
					'10p9' => {
						'1' => q(گگ{0}),
					},
					# Long Unit Identifier
					'acceleration-g-force' => {
						'name' => q(تارتىلىس كۇشى),
						'one' => q({0} تارتىلىس كۇشى),
						'other' => q({0} تارتىلىس كۇشى),
					},
					# Core Unit Identifier
					'g-force' => {
						'name' => q(تارتىلىس كۇشى),
						'one' => q({0} تارتىلىس كۇشى),
						'other' => q({0} تارتىلىس كۇشى),
					},
					# Long Unit Identifier
					'acceleration-meter-per-square-second' => {
						'name' => q(مەتىر/شارشى سەكۋند),
						'one' => q({0} مەتىر/شارشى سەكۋند),
						'other' => q({0} مەتىر/شارشى سەكۋند),
					},
					# Core Unit Identifier
					'meter-per-square-second' => {
						'name' => q(مەتىر/شارشى سەكۋند),
						'one' => q({0} مەتىر/شارشى سەكۋند),
						'other' => q({0} مەتىر/شارشى سەكۋند),
					},
					# Long Unit Identifier
					'angle-arc-minute' => {
						'name' => q(اركمينۋت),
						'one' => q({0} اركمينۋت),
						'other' => q({0} اركمينۋت),
					},
					# Core Unit Identifier
					'arc-minute' => {
						'name' => q(اركمينۋت),
						'one' => q({0} اركمينۋت),
						'other' => q({0} اركمينۋت),
					},
					# Long Unit Identifier
					'angle-arc-second' => {
						'name' => q(اركسەكۋند),
						'one' => q({0} اركسەكۋند),
						'other' => q({0} اركسەكۋند),
					},
					# Core Unit Identifier
					'arc-second' => {
						'name' => q(اركسەكۋند),
						'one' => q({0} اركسەكۋند),
						'other' => q({0} اركسەكۋند),
					},
					# Long Unit Identifier
					'angle-degree' => {
						'name' => q(گرادۋس),
						'one' => q({0} گرادۋس),
						'other' => q({0} گرادۋس),
					},
					# Core Unit Identifier
					'degree' => {
						'name' => q(گرادۋس),
						'one' => q({0} گرادۋس),
						'other' => q({0} گرادۋس),
					},
					# Long Unit Identifier
					'angle-radian' => {
						'name' => q(راديان),
						'one' => q({0} راديان),
						'other' => q({0} راديان),
					},
					# Core Unit Identifier
					'radian' => {
						'name' => q(راديان),
						'one' => q({0} راديان),
						'other' => q({0} راديان),
					},
					# Long Unit Identifier
					'angle-revolution' => {
						'name' => q(اينالىم),
						'one' => q({0} اينالىم),
						'other' => q({0} اينالىم),
					},
					# Core Unit Identifier
					'revolution' => {
						'name' => q(اينالىم),
						'one' => q({0} اينالىم),
						'other' => q({0} اينالىم),
					},
					# Long Unit Identifier
					'area-acre' => {
						'name' => q(اكر),
						'one' => q({0} اكر),
						'other' => q({0} اكر),
					},
					# Core Unit Identifier
					'acre' => {
						'name' => q(اكر),
						'one' => q({0} اكر),
						'other' => q({0} اكر),
					},
					# Long Unit Identifier
					'area-dunam' => {
						'name' => q(دۋنام),
						'one' => q({0} دۋنام),
						'other' => q({0} دۋنام),
					},
					# Core Unit Identifier
					'dunam' => {
						'name' => q(دۋنام),
						'one' => q({0} دۋنام),
						'other' => q({0} دۋنام),
					},
					# Long Unit Identifier
					'area-hectare' => {
						'name' => q(گەكتار),
						'one' => q({0} گەكتار),
						'other' => q({0} گەكتار),
					},
					# Core Unit Identifier
					'hectare' => {
						'name' => q(گەكتار),
						'one' => q({0} گەكتار),
						'other' => q({0} گەكتار),
					},
					# Long Unit Identifier
					'area-square-centimeter' => {
						'name' => q(شارشى سانتيمەتىر),
						'one' => q({0} شارشى سانتيمەتىر),
						'other' => q({0} شارشى سانتيمەتىر),
						'per' => q({0}/شارشى سانتيمەتىر),
					},
					# Core Unit Identifier
					'square-centimeter' => {
						'name' => q(شارشى سانتيمەتىر),
						'one' => q({0} شارشى سانتيمەتىر),
						'other' => q({0} شارشى سانتيمەتىر),
						'per' => q({0}/شارشى سانتيمەتىر),
					},
					# Long Unit Identifier
					'area-square-foot' => {
						'name' => q(شارشى فۋت),
						'one' => q({0} شارشى فۋت),
						'other' => q({0} شارشى فۋت),
					},
					# Core Unit Identifier
					'square-foot' => {
						'name' => q(شارشى فۋت),
						'one' => q({0} شارشى فۋت),
						'other' => q({0} شارشى فۋت),
					},
					# Long Unit Identifier
					'area-square-inch' => {
						'name' => q(شارشى ديۋيم),
						'one' => q({0} شارشى ديۋيم),
						'other' => q({0} شارشى ديۋيم),
						'per' => q({0} شارشى ديۋيم),
					},
					# Core Unit Identifier
					'square-inch' => {
						'name' => q(شارشى ديۋيم),
						'one' => q({0} شارشى ديۋيم),
						'other' => q({0} شارشى ديۋيم),
						'per' => q({0} شارشى ديۋيم),
					},
					# Long Unit Identifier
					'area-square-kilometer' => {
						'name' => q(شارشى كيلومەتىر),
						'one' => q({0}/شارشى كيلومەتىر),
						'other' => q({0}/شارشى كيلومەتىر),
						'per' => q({0}/شارشى كيلومەتىر),
					},
					# Core Unit Identifier
					'square-kilometer' => {
						'name' => q(شارشى كيلومەتىر),
						'one' => q({0}/شارشى كيلومەتىر),
						'other' => q({0}/شارشى كيلومەتىر),
						'per' => q({0}/شارشى كيلومەتىر),
					},
					# Long Unit Identifier
					'area-square-meter' => {
						'name' => q(شارشى مەتىر),
						'one' => q({0} شارشى مەتىر),
						'other' => q({0} شارشى مەتىر),
						'per' => q({0}/شارشى مەتىر),
					},
					# Core Unit Identifier
					'square-meter' => {
						'name' => q(شارشى مەتىر),
						'one' => q({0} شارشى مەتىر),
						'other' => q({0} شارشى مەتىر),
						'per' => q({0}/شارشى مەتىر),
					},
					# Long Unit Identifier
					'area-square-mile' => {
						'name' => q(شارشى ميل),
						'one' => q({0} شارشى ميل),
						'other' => q({0} شارشى ميل),
						'per' => q({0}/شارشى ميل),
					},
					# Core Unit Identifier
					'square-mile' => {
						'name' => q(شارشى ميل),
						'one' => q({0} شارشى ميل),
						'other' => q({0} شارشى ميل),
						'per' => q({0}/شارشى ميل),
					},
					# Long Unit Identifier
					'area-square-yard' => {
						'name' => q(شارشى يارد),
						'one' => q({0} شارشى يارد),
						'other' => q({0} شارشى يارد),
					},
					# Core Unit Identifier
					'square-yard' => {
						'name' => q(شارشى يارد),
						'one' => q({0} شارشى يارد),
						'other' => q({0} شارشى يارد),
					},
					# Long Unit Identifier
					'concentr-item' => {
						'name' => q(ەلەمەنت),
						'one' => q({0} ەلەمەنت),
						'other' => q({0} ەلەمەنت),
					},
					# Core Unit Identifier
					'item' => {
						'name' => q(ەلەمەنت),
						'one' => q({0} ەلەمەنت),
						'other' => q({0} ەلەمەنت),
					},
					# Long Unit Identifier
					'concentr-karat' => {
						'name' => q(كارات),
						'one' => q({0} كارات),
						'other' => q({0} كارات),
					},
					# Core Unit Identifier
					'karat' => {
						'name' => q(كارات),
						'one' => q({0} كارات),
						'other' => q({0} كارات),
					},
					# Long Unit Identifier
					'concentr-milligram-ofglucose-per-deciliter' => {
						'name' => q(ميليگرام/دەسيليتىر),
					},
					# Core Unit Identifier
					'milligram-ofglucose-per-deciliter' => {
						'name' => q(ميليگرام/دەسيليتىر),
					},
					# Long Unit Identifier
					'concentr-millimole-per-liter' => {
						'name' => q(ميليمول/ليتىر),
					},
					# Core Unit Identifier
					'millimole-per-liter' => {
						'name' => q(ميليمول/ليتىر),
					},
					# Long Unit Identifier
					'concentr-mole' => {
						'name' => q(مول),
						'one' => q({0} مول),
						'other' => q({0} مول),
					},
					# Core Unit Identifier
					'mole' => {
						'name' => q(مول),
						'one' => q({0} مول),
						'other' => q({0} مول),
					},
					# Long Unit Identifier
					'concentr-percent' => {
						'name' => q(پايىز),
					},
					# Core Unit Identifier
					'percent' => {
						'name' => q(پايىز),
					},
					# Long Unit Identifier
					'concentr-permille' => {
						'name' => q(پروميللە),
					},
					# Core Unit Identifier
					'permille' => {
						'name' => q(پروميللە),
					},
					# Long Unit Identifier
					'concentr-permillion' => {
						'name' => q(ميلليوندىق ۇلەس),
					},
					# Core Unit Identifier
					'permillion' => {
						'name' => q(ميلليوندىق ۇلەس),
					},
					# Long Unit Identifier
					'concentr-permyriad' => {
						'name' => q(پروميرياد),
					},
					# Core Unit Identifier
					'permyriad' => {
						'name' => q(پروميرياد),
					},
					# Long Unit Identifier
					'concentr-portion-per-1e9' => {
						'name' => q(ميللياردتىق ۇلەس),
					},
					# Core Unit Identifier
					'portion-per-1e9' => {
						'name' => q(ميللياردتىق ۇلەس),
					},
					# Long Unit Identifier
					'consumption-liter-per-100-kilometer' => {
						'name' => q(ليتىر/100 كيلومەتىر),
					},
					# Core Unit Identifier
					'liter-per-100-kilometer' => {
						'name' => q(ليتىر/100 كيلومەتىر),
					},
					# Long Unit Identifier
					'consumption-liter-per-kilometer' => {
						'name' => q(ليتىر/كيلومەتىر),
					},
					# Core Unit Identifier
					'liter-per-kilometer' => {
						'name' => q(ليتىر/كيلومەتىر),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon' => {
						'name' => q(ميل/گاللون),
						'one' => q({0} ميل/گاللون),
						'other' => q({0} ميل/گاللون),
					},
					# Core Unit Identifier
					'mile-per-gallon' => {
						'name' => q(ميل/گاللون),
						'one' => q({0} ميل/گاللون),
						'other' => q({0} ميل/گاللون),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon-imperial' => {
						'name' => q(ميل/يمپ گاللون),
						'one' => q({0} ميل/يمپ گاللون),
						'other' => q({0} ميل/يمپ گاللون),
					},
					# Core Unit Identifier
					'mile-per-gallon-imperial' => {
						'name' => q(ميل/يمپ گاللون),
						'one' => q({0} ميل/يمپ گاللون),
						'other' => q({0} ميل/يمپ گاللون),
					},
					# Long Unit Identifier
					'coordinate' => {
						'east' => q({0} ش),
						'north' => q({0} س),
						'south' => q({0} و),
						'west' => q({0} ب),
					},
					# Core Unit Identifier
					'coordinate' => {
						'east' => q({0} ش),
						'north' => q({0} س),
						'south' => q({0} و),
						'west' => q({0} ب),
					},
					# Long Unit Identifier
					'digital-bit' => {
						'name' => q(بيت),
					},
					# Core Unit Identifier
					'bit' => {
						'name' => q(بيت),
					},
					# Long Unit Identifier
					'digital-byte' => {
						'name' => q(بايت),
					},
					# Core Unit Identifier
					'byte' => {
						'name' => q(بايت),
					},
					# Long Unit Identifier
					'digital-gigabit' => {
						'name' => q(گيگابيت),
					},
					# Core Unit Identifier
					'gigabit' => {
						'name' => q(گيگابيت),
					},
					# Long Unit Identifier
					'digital-gigabyte' => {
						'name' => q(گيگابايت),
					},
					# Core Unit Identifier
					'gigabyte' => {
						'name' => q(گيگابايت),
					},
					# Long Unit Identifier
					'digital-kilobit' => {
						'name' => q(كيلوبيت),
					},
					# Core Unit Identifier
					'kilobit' => {
						'name' => q(كيلوبيت),
					},
					# Long Unit Identifier
					'digital-kilobyte' => {
						'name' => q(كيلوبايت),
					},
					# Core Unit Identifier
					'kilobyte' => {
						'name' => q(كيلوبايت),
					},
					# Long Unit Identifier
					'digital-megabit' => {
						'name' => q(مەگابيت),
					},
					# Core Unit Identifier
					'megabit' => {
						'name' => q(مەگابيت),
					},
					# Long Unit Identifier
					'digital-megabyte' => {
						'name' => q(مەگابايت),
					},
					# Core Unit Identifier
					'megabyte' => {
						'name' => q(مەگابايت),
					},
					# Long Unit Identifier
					'digital-petabyte' => {
						'name' => q(پەتابايت),
					},
					# Core Unit Identifier
					'petabyte' => {
						'name' => q(پەتابايت),
					},
					# Long Unit Identifier
					'digital-terabit' => {
						'name' => q(تەرابيت),
					},
					# Core Unit Identifier
					'terabit' => {
						'name' => q(تەرابيت),
					},
					# Long Unit Identifier
					'digital-terabyte' => {
						'name' => q(تەرابايت),
					},
					# Core Unit Identifier
					'terabyte' => {
						'name' => q(تەرابايت),
					},
					# Long Unit Identifier
					'duration-century' => {
						'name' => q(عاسىر),
						'one' => q({0} عاسىر),
						'other' => q({0} عاسىر),
					},
					# Core Unit Identifier
					'century' => {
						'name' => q(عاسىر),
						'one' => q({0} عاسىر),
						'other' => q({0} عاسىر),
					},
					# Long Unit Identifier
					'duration-day' => {
						'name' => q(كۇن),
						'one' => q({0} كۇن),
						'other' => q({0} كۇن),
						'per' => q({0}/كۇن),
					},
					# Core Unit Identifier
					'day' => {
						'name' => q(كۇن),
						'one' => q({0} كۇن),
						'other' => q({0} كۇن),
						'per' => q({0}/كۇن),
					},
					# Long Unit Identifier
					'duration-decade' => {
						'name' => q(ون جىلدىق),
						'one' => q({0} ون جىلدىق),
						'other' => q({0} ون جىلدىق),
					},
					# Core Unit Identifier
					'decade' => {
						'name' => q(ون جىلدىق),
						'one' => q({0} ون جىلدىق),
						'other' => q({0} ون جىلدىق),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'name' => q(ساعات),
						'one' => q({0} ساعات),
						'other' => q({0} ساعات),
						'per' => q({0}/ساعات),
					},
					# Core Unit Identifier
					'hour' => {
						'name' => q(ساعات),
						'one' => q({0} ساعات),
						'other' => q({0} ساعات),
						'per' => q({0}/ساعات),
					},
					# Long Unit Identifier
					'duration-microsecond' => {
						'name' => q(ميكروسەكۋند),
						'one' => q({0} ميكروسەكۋند),
						'other' => q({0} ميكروسەكۋند),
					},
					# Core Unit Identifier
					'microsecond' => {
						'name' => q(ميكروسەكۋند),
						'one' => q({0} ميكروسەكۋند),
						'other' => q({0} ميكروسەكۋند),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'name' => q(ميليسەكۋند),
						'one' => q({0} ميليسەكۋند),
						'other' => q({0} ميليسەكۋند),
					},
					# Core Unit Identifier
					'millisecond' => {
						'name' => q(ميليسەكۋند),
						'one' => q({0} ميليسەكۋند),
						'other' => q({0} ميليسەكۋند),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'name' => q(مينۋت),
						'one' => q({0} مينۋت),
						'other' => q({0} مينۋت),
						'per' => q({0}/مينۋت),
					},
					# Core Unit Identifier
					'minute' => {
						'name' => q(مينۋت),
						'one' => q({0} مينۋت),
						'other' => q({0} مينۋت),
						'per' => q({0}/مينۋت),
					},
					# Long Unit Identifier
					'duration-month' => {
						'name' => q(اي),
						'one' => q({0} اي),
						'other' => q({0} اي),
						'per' => q({0}/اي),
					},
					# Core Unit Identifier
					'month' => {
						'name' => q(اي),
						'one' => q({0} اي),
						'other' => q({0} اي),
						'per' => q({0}/اي),
					},
					# Long Unit Identifier
					'duration-nanosecond' => {
						'name' => q(نانوسەكۋند),
						'one' => q({0} نانوسەكۋند),
						'other' => q({0} نانوسەكۋند),
					},
					# Core Unit Identifier
					'nanosecond' => {
						'name' => q(نانوسەكۋند),
						'one' => q({0} نانوسەكۋند),
						'other' => q({0} نانوسەكۋند),
					},
					# Long Unit Identifier
					'duration-night' => {
						'name' => q(ءتۇن),
						'one' => q({0} ءتۇن),
						'other' => q({0} ءتۇن),
						'per' => q({0}/ءتۇن),
					},
					# Core Unit Identifier
					'night' => {
						'name' => q(ءتۇن),
						'one' => q({0} ءتۇن),
						'other' => q({0} ءتۇن),
						'per' => q({0}/ءتۇن),
					},
					# Long Unit Identifier
					'duration-quarter' => {
						'name' => q(توقسان),
						'one' => q({0} توقسان),
						'other' => q({0} توقسان),
						'per' => q({0}/توقسان),
					},
					# Core Unit Identifier
					'quarter' => {
						'name' => q(توقسان),
						'one' => q({0} توقسان),
						'other' => q({0} توقسان),
						'per' => q({0}/توقسان),
					},
					# Long Unit Identifier
					'duration-second' => {
						'name' => q(سەكۋند),
						'one' => q({0} سەكۋند),
						'other' => q({0} سەكۋند),
						'per' => q({0}/سەكۋند),
					},
					# Core Unit Identifier
					'second' => {
						'name' => q(سەكۋند),
						'one' => q({0} سەكۋند),
						'other' => q({0} سەكۋند),
						'per' => q({0}/سەكۋند),
					},
					# Long Unit Identifier
					'duration-week' => {
						'name' => q(اپتا),
						'one' => q({0} اپتا),
						'other' => q({0} اپتا),
						'per' => q({0}/اپتا),
					},
					# Core Unit Identifier
					'week' => {
						'name' => q(اپتا),
						'one' => q({0} اپتا),
						'other' => q({0} اپتا),
						'per' => q({0}/اپتا),
					},
					# Long Unit Identifier
					'duration-year' => {
						'name' => q(جىل),
						'one' => q({0} جىل),
						'other' => q({0} جىل),
						'per' => q(جىلىنا {0}),
					},
					# Core Unit Identifier
					'year' => {
						'name' => q(جىل),
						'one' => q({0} جىل),
						'other' => q({0} جىل),
						'per' => q(جىلىنا {0}),
					},
					# Long Unit Identifier
					'electric-ampere' => {
						'name' => q(امپەر),
						'one' => q({0} امپەر),
						'other' => q({0} امپەر),
					},
					# Core Unit Identifier
					'ampere' => {
						'name' => q(امپەر),
						'one' => q({0} امپەر),
						'other' => q({0} امپەر),
					},
					# Long Unit Identifier
					'electric-milliampere' => {
						'name' => q(ميليامپەر),
						'one' => q({0} ميليامپەر),
						'other' => q({0} ميليامپەر),
					},
					# Core Unit Identifier
					'milliampere' => {
						'name' => q(ميليامپەر),
						'one' => q({0} ميليامپەر),
						'other' => q({0} ميليامپەر),
					},
					# Long Unit Identifier
					'electric-ohm' => {
						'name' => q(وم),
						'one' => q({0} وم),
						'other' => q({0} وم),
					},
					# Core Unit Identifier
					'ohm' => {
						'name' => q(وم),
						'one' => q({0} وم),
						'other' => q({0} وم),
					},
					# Long Unit Identifier
					'electric-volt' => {
						'name' => q(ۆولت),
						'one' => q({0} ۆولت),
						'other' => q({0} ۆولت),
					},
					# Core Unit Identifier
					'volt' => {
						'name' => q(ۆولت),
						'one' => q({0} ۆولت),
						'other' => q({0} ۆولت),
					},
					# Long Unit Identifier
					'energy-british-thermal-unit' => {
						'name' => q(بريتاندىق جىلۋ بىرلىگى),
						'one' => q({0} بريتاندىق جىلۋ بىرلىگى),
						'other' => q({0} بريتاندىق جىلۋ بىرلىگى),
					},
					# Core Unit Identifier
					'british-thermal-unit' => {
						'name' => q(بريتاندىق جىلۋ بىرلىگى),
						'one' => q({0} بريتاندىق جىلۋ بىرلىگى),
						'other' => q({0} بريتاندىق جىلۋ بىرلىگى),
					},
					# Long Unit Identifier
					'energy-calorie' => {
						'name' => q(كالوريا),
						'one' => q({0} كالوريا),
						'other' => q({0} كالوريا),
					},
					# Core Unit Identifier
					'calorie' => {
						'name' => q(كالوريا),
						'one' => q({0} كالوريا),
						'other' => q({0} كالوريا),
					},
					# Long Unit Identifier
					'energy-electronvolt' => {
						'name' => q(ەلەكتونۆولت),
						'one' => q({0} ەلەكترونۆولت),
						'other' => q({0} ەلەكترونۆولت),
					},
					# Core Unit Identifier
					'electronvolt' => {
						'name' => q(ەلەكتونۆولت),
						'one' => q({0} ەلەكترونۆولت),
						'other' => q({0} ەلەكترونۆولت),
					},
					# Long Unit Identifier
					'energy-joule' => {
						'name' => q(جوۋل),
						'one' => q({0} جوۋل),
						'other' => q({0} جوۋل),
					},
					# Core Unit Identifier
					'joule' => {
						'name' => q(جوۋل),
						'one' => q({0} جوۋل),
						'other' => q({0} جوۋل),
					},
					# Long Unit Identifier
					'energy-kilocalorie' => {
						'name' => q(كيلوكالوريا),
						'one' => q({0} كيلوكالوريا),
						'other' => q({0} كيلوكالوريا),
					},
					# Core Unit Identifier
					'kilocalorie' => {
						'name' => q(كيلوكالوريا),
						'one' => q({0} كيلوكالوريا),
						'other' => q({0} كيلوكالوريا),
					},
					# Long Unit Identifier
					'energy-kilojoule' => {
						'name' => q(كيلوجوۋل),
						'one' => q({0} كىلوجوۋل),
						'other' => q({0} كىلوجوۋل),
					},
					# Core Unit Identifier
					'kilojoule' => {
						'name' => q(كيلوجوۋل),
						'one' => q({0} كىلوجوۋل),
						'other' => q({0} كىلوجوۋل),
					},
					# Long Unit Identifier
					'energy-kilowatt-hour' => {
						'name' => q(كيلوۆات-ساعات),
						'one' => q({0} كيلوۆات-ساعات),
						'other' => q({0} كيلوۆات-ساعات),
					},
					# Core Unit Identifier
					'kilowatt-hour' => {
						'name' => q(كيلوۆات-ساعات),
						'one' => q({0} كيلوۆات-ساعات),
						'other' => q({0} كيلوۆات-ساعات),
					},
					# Long Unit Identifier
					'energy-therm-us' => {
						'name' => q(ا ق ش تەرمى),
						'one' => q({0} ا ق ش تەرمى),
						'other' => q({0} ا ق ش تەرمى),
					},
					# Core Unit Identifier
					'therm-us' => {
						'name' => q(ا ق ش تەرمى),
						'one' => q({0} ا ق ش تەرمى),
						'other' => q({0} ا ق ش تەرمى),
					},
					# Long Unit Identifier
					'force-kilowatt-hour-per-100-kilometer' => {
						'name' => q(كيلوۆات-ساعات/100 كيلومەتىر),
					},
					# Core Unit Identifier
					'kilowatt-hour-per-100-kilometer' => {
						'name' => q(كيلوۆات-ساعات/100 كيلومەتىر),
					},
					# Long Unit Identifier
					'force-newton' => {
						'name' => q(نيۋتون),
					},
					# Core Unit Identifier
					'newton' => {
						'name' => q(نيۋتون),
					},
					# Long Unit Identifier
					'force-pound-force' => {
						'name' => q(فۋنت-كۇش),
						'one' => q({0} فۋنت-كۇش),
						'other' => q({0} فۋنت-كۇش),
					},
					# Core Unit Identifier
					'pound-force' => {
						'name' => q(فۋنت-كۇش),
						'one' => q({0} فۋنت-كۇش),
						'other' => q({0} فۋنت-كۇش),
					},
					# Long Unit Identifier
					'frequency-gigahertz' => {
						'name' => q(گيگاگەرس),
						'one' => q({0} گيگاگەرس),
						'other' => q({0} گيگاگەرس),
					},
					# Core Unit Identifier
					'gigahertz' => {
						'name' => q(گيگاگەرس),
						'one' => q({0} گيگاگەرس),
						'other' => q({0} گيگاگەرس),
					},
					# Long Unit Identifier
					'frequency-hertz' => {
						'name' => q(گەرس),
						'one' => q({0} گەرس),
						'other' => q({0} گەرس),
					},
					# Core Unit Identifier
					'hertz' => {
						'name' => q(گەرس),
						'one' => q({0} گەرس),
						'other' => q({0} گەرس),
					},
					# Long Unit Identifier
					'frequency-kilohertz' => {
						'name' => q(كيلوگەرس),
						'one' => q({0} كيلوگەرس),
						'other' => q({0} كيلوگەرس),
					},
					# Core Unit Identifier
					'kilohertz' => {
						'name' => q(كيلوگەرس),
						'one' => q({0} كيلوگەرس),
						'other' => q({0} كيلوگەرس),
					},
					# Long Unit Identifier
					'frequency-megahertz' => {
						'name' => q(مەگاگەرس),
						'one' => q({0} مەگاگەرس),
						'other' => q({0} مەگاگەرس),
					},
					# Core Unit Identifier
					'megahertz' => {
						'name' => q(مەگاگەرس),
						'one' => q({0} مەگاگەرس),
						'other' => q({0} مەگاگەرس),
					},
					# Long Unit Identifier
					'length-astronomical-unit' => {
						'name' => q(استرونوميالىق بىرلىك),
						'one' => q({0} استرونوميالىق بىرلىك),
						'other' => q({0} استرونوميالىق بىرلىك),
					},
					# Core Unit Identifier
					'astronomical-unit' => {
						'name' => q(استرونوميالىق بىرلىك),
						'one' => q({0} استرونوميالىق بىرلىك),
						'other' => q({0} استرونوميالىق بىرلىك),
					},
					# Long Unit Identifier
					'length-centimeter' => {
						'name' => q(سانتيمەتىر),
						'one' => q({0}/سانتيمەتىر),
						'other' => q({0}/سانتيمەتىر),
						'per' => q({0}/سانتيمەتىر),
					},
					# Core Unit Identifier
					'centimeter' => {
						'name' => q(سانتيمەتىر),
						'one' => q({0}/سانتيمەتىر),
						'other' => q({0}/سانتيمەتىر),
						'per' => q({0}/سانتيمەتىر),
					},
					# Long Unit Identifier
					'length-decimeter' => {
						'name' => q(دەسيمەتىر),
						'one' => q({0}/دەسيمەتىر),
						'other' => q({0}/دەسيمەتىر),
					},
					# Core Unit Identifier
					'decimeter' => {
						'name' => q(دەسيمەتىر),
						'one' => q({0}/دەسيمەتىر),
						'other' => q({0}/دەسيمەتىر),
					},
					# Long Unit Identifier
					'length-earth-radius' => {
						'name' => q(جەر راديۋسى),
						'one' => q({0} جەر راديۋسى),
						'other' => q({0} جەر راديۋسى),
					},
					# Core Unit Identifier
					'earth-radius' => {
						'name' => q(جەر راديۋسى),
						'one' => q({0} جەر راديۋسى),
						'other' => q({0} جەر راديۋسى),
					},
					# Long Unit Identifier
					'length-fathom' => {
						'name' => q(فاتوم),
						'one' => q({0} فاتوم),
						'other' => q({0} فاتوم),
					},
					# Core Unit Identifier
					'fathom' => {
						'name' => q(فاتوم),
						'one' => q({0} فاتوم),
						'other' => q({0} فاتوم),
					},
					# Long Unit Identifier
					'length-foot' => {
						'name' => q(فۋت),
						'one' => q({0}/فۋت),
						'other' => q({0}/فۋت),
						'per' => q({0}/فۋت),
					},
					# Core Unit Identifier
					'foot' => {
						'name' => q(فۋت),
						'one' => q({0}/فۋت),
						'other' => q({0}/فۋت),
						'per' => q({0}/فۋت),
					},
					# Long Unit Identifier
					'length-furlong' => {
						'name' => q(فۋرلوڭ),
						'one' => q({0} فۋرلوڭ),
						'other' => q({0} فۋرلوڭ),
					},
					# Core Unit Identifier
					'furlong' => {
						'name' => q(فۋرلوڭ),
						'one' => q({0} فۋرلوڭ),
						'other' => q({0} فۋرلوڭ),
					},
					# Long Unit Identifier
					'length-inch' => {
						'name' => q(ديۋيم),
						'one' => q({0} ديۋيم),
						'other' => q({0} ديۋيم),
						'per' => q({0}/ديۋيم),
					},
					# Core Unit Identifier
					'inch' => {
						'name' => q(ديۋيم),
						'one' => q({0} ديۋيم),
						'other' => q({0} ديۋيم),
						'per' => q({0}/ديۋيم),
					},
					# Long Unit Identifier
					'length-kilometer' => {
						'name' => q(كيلومەتىر),
						'one' => q({0} كيلومەتىر),
						'other' => q({0} كيلومەتىر),
						'per' => q({0}/كيلومەتىر),
					},
					# Core Unit Identifier
					'kilometer' => {
						'name' => q(كيلومەتىر),
						'one' => q({0} كيلومەتىر),
						'other' => q({0} كيلومەتىر),
						'per' => q({0}/كيلومەتىر),
					},
					# Long Unit Identifier
					'length-light-year' => {
						'name' => q(جارىق جىلى),
						'one' => q({0} جارىق جىلى),
						'other' => q({0} جارىق جىلى),
					},
					# Core Unit Identifier
					'light-year' => {
						'name' => q(جارىق جىلى),
						'one' => q({0} جارىق جىلى),
						'other' => q({0} جارىق جىلى),
					},
					# Long Unit Identifier
					'length-meter' => {
						'name' => q(مەتىر),
						'one' => q({0}/مەتىر),
						'other' => q({0}/مەتىر),
						'per' => q({0}/مەتىر),
					},
					# Core Unit Identifier
					'meter' => {
						'name' => q(مەتىر),
						'one' => q({0}/مەتىر),
						'other' => q({0}/مەتىر),
						'per' => q({0}/مەتىر),
					},
					# Long Unit Identifier
					'length-micrometer' => {
						'name' => q(ميكرومەتىر),
						'one' => q({0} ميكرومەتىر),
						'other' => q({0} ميكرومەتىر),
					},
					# Core Unit Identifier
					'micrometer' => {
						'name' => q(ميكرومەتىر),
						'one' => q({0} ميكرومەتىر),
						'other' => q({0} ميكرومەتىر),
					},
					# Long Unit Identifier
					'length-mile' => {
						'name' => q(ميل),
						'one' => q({0} ميل),
						'other' => q({0} ميل),
					},
					# Core Unit Identifier
					'mile' => {
						'name' => q(ميل),
						'one' => q({0} ميل),
						'other' => q({0} ميل),
					},
					# Long Unit Identifier
					'length-mile-scandinavian' => {
						'name' => q(سكانديناۆيالىق ميل),
						'one' => q({0} سكانديناۆيالىق ميلى),
						'other' => q({0} سكانديناۆيالىق ميلى),
					},
					# Core Unit Identifier
					'mile-scandinavian' => {
						'name' => q(سكانديناۆيالىق ميل),
						'one' => q({0} سكانديناۆيالىق ميلى),
						'other' => q({0} سكانديناۆيالىق ميلى),
					},
					# Long Unit Identifier
					'length-millimeter' => {
						'name' => q(ميليمەتىر),
						'one' => q({0} ميليمەتىر),
						'other' => q({0} ميليمەتىر),
					},
					# Core Unit Identifier
					'millimeter' => {
						'name' => q(ميليمەتىر),
						'one' => q({0} ميليمەتىر),
						'other' => q({0} ميليمەتىر),
					},
					# Long Unit Identifier
					'length-nanometer' => {
						'name' => q(نانومەتىر),
						'one' => q({0} نانومەتىر),
						'other' => q({0} نانومەتىر),
					},
					# Core Unit Identifier
					'nanometer' => {
						'name' => q(نانومەتىر),
						'one' => q({0} نانومەتىر),
						'other' => q({0} نانومەتىر),
					},
					# Long Unit Identifier
					'length-nautical-mile' => {
						'name' => q(تەڭىز ميلى),
						'one' => q({0} تەڭىز ميلى),
						'other' => q({0} تەڭىز ميلى),
					},
					# Core Unit Identifier
					'nautical-mile' => {
						'name' => q(تەڭىز ميلى),
						'one' => q({0} تەڭىز ميلى),
						'other' => q({0} تەڭىز ميلى),
					},
					# Long Unit Identifier
					'length-parsec' => {
						'name' => q(پارسەك),
						'one' => q({0} پارسەك),
						'other' => q({0} پارسەك),
					},
					# Core Unit Identifier
					'parsec' => {
						'name' => q(پارسەك),
						'one' => q({0} پارسەك),
						'other' => q({0} پارسەك),
					},
					# Long Unit Identifier
					'length-picometer' => {
						'name' => q(پيكومەتىر),
						'one' => q({0} پيكومەتىر),
						'other' => q({0} پيكومەتىر),
					},
					# Core Unit Identifier
					'picometer' => {
						'name' => q(پيكومەتىر),
						'one' => q({0} پيكومەتىر),
						'other' => q({0} پيكومەتىر),
					},
					# Long Unit Identifier
					'length-point' => {
						'name' => q(پۋنكت),
						'one' => q({0} پۋنكت),
						'other' => q({0} پۋنكت),
					},
					# Core Unit Identifier
					'point' => {
						'name' => q(پۋنكت),
						'one' => q({0} پۋنكت),
						'other' => q({0} پۋنكت),
					},
					# Long Unit Identifier
					'length-solar-radius' => {
						'name' => q(كۇن راديۋسى),
						'one' => q({0} كۇن راديۋسى),
						'other' => q({0} كۇن راديۋسى),
					},
					# Core Unit Identifier
					'solar-radius' => {
						'name' => q(كۇن راديۋسى),
						'one' => q({0} كۇن راديۋسى),
						'other' => q({0} كۇن راديۋسى),
					},
					# Long Unit Identifier
					'length-yard' => {
						'name' => q(يارد),
						'one' => q({0} يارد),
						'other' => q({0} يارد),
					},
					# Core Unit Identifier
					'yard' => {
						'name' => q(يارد),
						'one' => q({0} يارد),
						'other' => q({0} يارد),
					},
					# Long Unit Identifier
					'light-candela' => {
						'name' => q(كاندەلا),
					},
					# Core Unit Identifier
					'candela' => {
						'name' => q(كاندەلا),
					},
					# Long Unit Identifier
					'light-lumen' => {
						'name' => q(ليۋمەن),
					},
					# Core Unit Identifier
					'lumen' => {
						'name' => q(ليۋمەن),
					},
					# Long Unit Identifier
					'light-lux' => {
						'name' => q(ليۋكس),
					},
					# Core Unit Identifier
					'lux' => {
						'name' => q(ليۋكس),
					},
					# Long Unit Identifier
					'light-solar-luminosity' => {
						'name' => q(كۇن جارىقتىعى),
						'one' => q({0} كۇن جارىقتىعى),
						'other' => q({0} كۇن جارىقتىعى),
					},
					# Core Unit Identifier
					'solar-luminosity' => {
						'name' => q(كۇن جارىقتىعى),
						'one' => q({0} كۇن جارىقتىعى),
						'other' => q({0} كۇن جارىقتىعى),
					},
					# Long Unit Identifier
					'mass-carat' => {
						'name' => q(كارات),
						'one' => q({0} كارات),
						'other' => q({0} كارات),
					},
					# Core Unit Identifier
					'carat' => {
						'name' => q(كارات),
						'one' => q({0} كارات),
						'other' => q({0} كارات),
					},
					# Long Unit Identifier
					'mass-dalton' => {
						'name' => q(دالتون),
						'one' => q({0} دالتون),
						'other' => q({0} دالتون),
					},
					# Core Unit Identifier
					'dalton' => {
						'name' => q(دالتون),
						'one' => q({0} دالتون),
						'other' => q({0} دالتون),
					},
					# Long Unit Identifier
					'mass-earth-mass' => {
						'name' => q(جەر ماسساسى),
						'one' => q({0} جەر ماسساسى),
						'other' => q({0} جەر ماسساسى),
					},
					# Core Unit Identifier
					'earth-mass' => {
						'name' => q(جەر ماسساسى),
						'one' => q({0} جەر ماسساسى),
						'other' => q({0} جەر ماسساسى),
					},
					# Long Unit Identifier
					'mass-grain' => {
						'name' => q(گران),
						'one' => q({0} گران),
						'other' => q({0} گران),
					},
					# Core Unit Identifier
					'grain' => {
						'name' => q(گران),
						'one' => q({0} گران),
						'other' => q({0} گران),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'name' => q(گرام),
						'one' => q({0} گرام),
						'other' => q({0} گرام),
						'per' => q({0}/گرام),
					},
					# Core Unit Identifier
					'gram' => {
						'name' => q(گرام),
						'one' => q({0} گرام),
						'other' => q({0} گرام),
						'per' => q({0}/گرام),
					},
					# Long Unit Identifier
					'mass-kilogram' => {
						'name' => q(كيلوگرام),
						'one' => q({0} كيلوگرام),
						'other' => q({0} كيلوگرام),
						'per' => q({0}/كيلوگرام),
					},
					# Core Unit Identifier
					'kilogram' => {
						'name' => q(كيلوگرام),
						'one' => q({0} كيلوگرام),
						'other' => q({0} كيلوگرام),
						'per' => q({0}/كيلوگرام),
					},
					# Long Unit Identifier
					'mass-microgram' => {
						'name' => q(ميكروگرام),
						'one' => q({0} ميكروگرام),
						'other' => q({0} ميكروگرام),
					},
					# Core Unit Identifier
					'microgram' => {
						'name' => q(ميكروگرام),
						'one' => q({0} ميكروگرام),
						'other' => q({0} ميكروگرام),
					},
					# Long Unit Identifier
					'mass-milligram' => {
						'name' => q(ميليگرام),
						'one' => q({0} ميليگرام),
						'other' => q({0} ميليگرام),
					},
					# Core Unit Identifier
					'milligram' => {
						'name' => q(ميليگرام),
						'one' => q({0} ميليگرام),
						'other' => q({0} ميليگرام),
					},
					# Long Unit Identifier
					'mass-ounce' => {
						'name' => q(ۋنسيا),
						'one' => q({0} ۋنسيا),
						'other' => q({0} ۋنسيا),
						'per' => q({0}/ۋنسيا),
					},
					# Core Unit Identifier
					'ounce' => {
						'name' => q(ۋنسيا),
						'one' => q({0} ۋنسيا),
						'other' => q({0} ۋنسيا),
						'per' => q({0}/ۋنسيا),
					},
					# Long Unit Identifier
					'mass-ounce-troy' => {
						'name' => q(تروي ۋنسياسى),
						'one' => q({0} تروۋ ۋنسياسى),
						'other' => q({0} تروۋ ۋنسياسى),
					},
					# Core Unit Identifier
					'ounce-troy' => {
						'name' => q(تروي ۋنسياسى),
						'one' => q({0} تروۋ ۋنسياسى),
						'other' => q({0} تروۋ ۋنسياسى),
					},
					# Long Unit Identifier
					'mass-pound' => {
						'name' => q(فۋنت),
						'one' => q({0} فۋنت),
						'other' => q({0} فۋنت),
						'per' => q({0}/فۋنت),
					},
					# Core Unit Identifier
					'pound' => {
						'name' => q(فۋنت),
						'one' => q({0} فۋنت),
						'other' => q({0} فۋنت),
						'per' => q({0}/فۋنت),
					},
					# Long Unit Identifier
					'mass-solar-mass' => {
						'name' => q(كۇن ماسساسى),
						'one' => q({0} كۇن ماسساسى),
						'other' => q({0} كۇن ماسساسى),
					},
					# Core Unit Identifier
					'solar-mass' => {
						'name' => q(كۇن ماسساسى),
						'one' => q({0} كۇن ماسساسى),
						'other' => q({0} كۇن ماسساسى),
					},
					# Long Unit Identifier
					'mass-stone' => {
						'name' => q(ستوۋن),
						'one' => q({0} ستوۋن),
						'other' => q({0} ستوۋن),
					},
					# Core Unit Identifier
					'stone' => {
						'name' => q(ستوۋن),
						'one' => q({0} ستوۋن),
						'other' => q({0} ستوۋن),
					},
					# Long Unit Identifier
					'mass-ton' => {
						'name' => q(توننا),
						'one' => q({0} تن),
						'other' => q({0} تن),
					},
					# Core Unit Identifier
					'ton' => {
						'name' => q(توننا),
						'one' => q({0} تن),
						'other' => q({0} تن),
					},
					# Long Unit Identifier
					'mass-tonne' => {
						'name' => q(مەتىرلىك توننا),
						'one' => q({0} توننا),
						'other' => q({0} توننا),
					},
					# Core Unit Identifier
					'tonne' => {
						'name' => q(مەتىرلىك توننا),
						'one' => q({0} توننا),
						'other' => q({0} توننا),
					},
					# Long Unit Identifier
					'power-gigawatt' => {
						'name' => q(گيگاۆات),
						'one' => q({0} گيگاۆات),
						'other' => q({0} گيگاۆات),
					},
					# Core Unit Identifier
					'gigawatt' => {
						'name' => q(گيگاۆات),
						'one' => q({0} گيگاۆات),
						'other' => q({0} گيگاۆات),
					},
					# Long Unit Identifier
					'power-horsepower' => {
						'name' => q(ات كۇشى),
						'one' => q({0} ات كۇشى),
						'other' => q({0} ات كۇشى),
					},
					# Core Unit Identifier
					'horsepower' => {
						'name' => q(ات كۇشى),
						'one' => q({0} ات كۇشى),
						'other' => q({0} ات كۇشى),
					},
					# Long Unit Identifier
					'power-kilowatt' => {
						'name' => q(كيلوۆات),
						'one' => q({0} كيلوۆات),
						'other' => q({0} كيلوۆات),
					},
					# Core Unit Identifier
					'kilowatt' => {
						'name' => q(كيلوۆات),
						'one' => q({0} كيلوۆات),
						'other' => q({0} كيلوۆات),
					},
					# Long Unit Identifier
					'power-megawatt' => {
						'name' => q(مەگاۆات),
						'one' => q({0} مەگاۆات),
						'other' => q({0} مەگاۆات),
					},
					# Core Unit Identifier
					'megawatt' => {
						'name' => q(مەگاۆات),
						'one' => q({0} مەگاۆات),
						'other' => q({0} مەگاۆات),
					},
					# Long Unit Identifier
					'power-milliwatt' => {
						'name' => q(ميليۆات),
						'one' => q({0} ميليۆات),
						'other' => q({0} ميليۆات),
					},
					# Core Unit Identifier
					'milliwatt' => {
						'name' => q(ميليۆات),
						'one' => q({0} ميليۆات),
						'other' => q({0} ميليۆات),
					},
					# Long Unit Identifier
					'power-watt' => {
						'name' => q(ۆات),
						'one' => q({0} ۆات),
						'other' => q({0} ۆات),
					},
					# Core Unit Identifier
					'watt' => {
						'name' => q(ۆات),
						'one' => q({0} ۆات),
						'other' => q({0} ۆات),
					},
					# Long Unit Identifier
					'pressure-atmosphere' => {
						'name' => q(اتموسفەرا),
						'one' => q({0} اتموسفەرا),
						'other' => q({0} اتموسفەرا),
					},
					# Core Unit Identifier
					'atmosphere' => {
						'name' => q(اتموسفەرا),
						'one' => q({0} اتموسفەرا),
						'other' => q({0} اتموسفەرا),
					},
					# Long Unit Identifier
					'pressure-bar' => {
						'name' => q(بار),
						'one' => q({0} بار),
						'other' => q({0} بار),
					},
					# Core Unit Identifier
					'bar' => {
						'name' => q(بار),
						'one' => q({0} بار),
						'other' => q({0} بار),
					},
					# Long Unit Identifier
					'pressure-hectopascal' => {
						'name' => q(گەكتوپاسكال),
						'one' => q({0} گەكتوپاسكال),
						'other' => q({0} گەكتوپاسكال),
					},
					# Core Unit Identifier
					'hectopascal' => {
						'name' => q(گەكتوپاسكال),
						'one' => q({0} گەكتوپاسكال),
						'other' => q({0} گەكتوپاسكال),
					},
					# Long Unit Identifier
					'pressure-inch-ofhg' => {
						'name' => q(ديۋيم سىناپ باعاناسى),
						'one' => q({0} ديۋيم سىناپ باعاناسى),
						'other' => q({0} ديۋيم سىناپ باعاناسى),
					},
					# Core Unit Identifier
					'inch-ofhg' => {
						'name' => q(ديۋيم سىناپ باعاناسى),
						'one' => q({0} ديۋيم سىناپ باعاناسى),
						'other' => q({0} ديۋيم سىناپ باعاناسى),
					},
					# Long Unit Identifier
					'pressure-kilopascal' => {
						'name' => q(كيلوپاسكال),
						'one' => q({0} كيلوپاسكال),
						'other' => q({0} كيلوپاسكال),
					},
					# Core Unit Identifier
					'kilopascal' => {
						'name' => q(كيلوپاسكال),
						'one' => q({0} كيلوپاسكال),
						'other' => q({0} كيلوپاسكال),
					},
					# Long Unit Identifier
					'pressure-megapascal' => {
						'name' => q(مەگاپاسكال),
						'one' => q({0} مەگاپاسكال),
						'other' => q({0} مەگاپاسكال),
					},
					# Core Unit Identifier
					'megapascal' => {
						'name' => q(مەگاپاسكال),
						'one' => q({0} مەگاپاسكال),
						'other' => q({0} مەگاپاسكال),
					},
					# Long Unit Identifier
					'pressure-millibar' => {
						'name' => q(ميليبار),
						'one' => q({0} ميليبار),
						'other' => q({0} ميليبار),
					},
					# Core Unit Identifier
					'millibar' => {
						'name' => q(ميليبار),
						'one' => q({0} ميليبار),
						'other' => q({0} ميليبار),
					},
					# Long Unit Identifier
					'pressure-millimeter-ofhg' => {
						'name' => q(ميليمەتىر سىناپ باعاناسى),
						'one' => q({0} ميليمەتىر سىناپ باعاناسى),
						'other' => q({0} ميليمەتىر سىناپ باعاناسى),
					},
					# Core Unit Identifier
					'millimeter-ofhg' => {
						'name' => q(ميليمەتىر سىناپ باعاناسى),
						'one' => q({0} ميليمەتىر سىناپ باعاناسى),
						'other' => q({0} ميليمەتىر سىناپ باعاناسى),
					},
					# Long Unit Identifier
					'pressure-pascal' => {
						'name' => q(پاسكال),
						'one' => q({0} پاسكال),
						'other' => q({0} پاسكال),
					},
					# Core Unit Identifier
					'pascal' => {
						'name' => q(پاسكال),
						'one' => q({0} پاسكال),
						'other' => q({0} پاسكال),
					},
					# Long Unit Identifier
					'pressure-pound-force-per-square-inch' => {
						'name' => q(فۋنت-كۇش/شارشى ديۋيم),
						'one' => q({0} فۋنت-كۇش/شارشى ديۋيم),
						'other' => q({0} فۋنت-كۇش/شارشى ديۋيم),
					},
					# Core Unit Identifier
					'pound-force-per-square-inch' => {
						'name' => q(فۋنت-كۇش/شارشى ديۋيم),
						'one' => q({0} فۋنت-كۇش/شارشى ديۋيم),
						'other' => q({0} فۋنت-كۇش/شارشى ديۋيم),
					},
					# Long Unit Identifier
					'speed-beaufort' => {
						'name' => q(بوفورت),
						'one' => q({0} بوفورت),
						'other' => q({0} بوفورت),
					},
					# Core Unit Identifier
					'beaufort' => {
						'name' => q(بوفورت),
						'one' => q({0} بوفورت),
						'other' => q({0} بوفورت),
					},
					# Long Unit Identifier
					'speed-kilometer-per-hour' => {
						'name' => q(كيلومەتىر/ساعات),
						'one' => q({0} كيلومەتىر/ساعات),
						'other' => q({0} كيلومەتىر/ساعات),
					},
					# Core Unit Identifier
					'kilometer-per-hour' => {
						'name' => q(كيلومەتىر/ساعات),
						'one' => q({0} كيلومەتىر/ساعات),
						'other' => q({0} كيلومەتىر/ساعات),
					},
					# Long Unit Identifier
					'speed-knot' => {
						'name' => q(ءتۇيىن),
						'one' => q({0} ءتۇيىن),
						'other' => q({0} ءتۇيىن),
					},
					# Core Unit Identifier
					'knot' => {
						'name' => q(ءتۇيىن),
						'one' => q({0} ءتۇيىن),
						'other' => q({0} ءتۇيىن),
					},
					# Long Unit Identifier
					'speed-light-speed' => {
						'name' => q(جارىق),
						'one' => q({0} جارىق),
						'other' => q({0} جارىق),
					},
					# Core Unit Identifier
					'light-speed' => {
						'name' => q(جارىق),
						'one' => q({0} جارىق),
						'other' => q({0} جارىق),
					},
					# Long Unit Identifier
					'speed-meter-per-second' => {
						'name' => q(مەتىر/سەكۋند),
						'one' => q({0} مەتىر/سەكۋند),
						'other' => q({0} مەتىر/سەكۋند),
					},
					# Core Unit Identifier
					'meter-per-second' => {
						'name' => q(مەتىر/سەكۋند),
						'one' => q({0} مەتىر/سەكۋند),
						'other' => q({0} مەتىر/سەكۋند),
					},
					# Long Unit Identifier
					'speed-mile-per-hour' => {
						'name' => q(ميل/ساعات),
						'one' => q({0} ميل/ساعات),
						'other' => q({0} ميل/ساعات),
					},
					# Core Unit Identifier
					'mile-per-hour' => {
						'name' => q(ميل/ساعات),
						'one' => q({0} ميل/ساعات),
						'other' => q({0} ميل/ساعات),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'name' => q(سەلسي گرادۋسى),
					},
					# Core Unit Identifier
					'celsius' => {
						'name' => q(سەلسي گرادۋسى),
					},
					# Long Unit Identifier
					'temperature-fahrenheit' => {
						'name' => q(فارانگەيت گرادۋسى),
					},
					# Core Unit Identifier
					'fahrenheit' => {
						'name' => q(فارانگەيت گرادۋسى),
					},
					# Long Unit Identifier
					'temperature-kelvin' => {
						'name' => q(كەلۆين),
					},
					# Core Unit Identifier
					'kelvin' => {
						'name' => q(كەلۆين),
					},
					# Long Unit Identifier
					'torque-newton-meter' => {
						'name' => q(نيۋتون-مەتىر),
					},
					# Core Unit Identifier
					'newton-meter' => {
						'name' => q(نيۋتون-مەتىر),
					},
					# Long Unit Identifier
					'torque-pound-force-foot' => {
						'name' => q(فۋنت-كۇش-فۋت),
						'one' => q({0} فۋنت-كۇش-فۋت),
						'other' => q({0} فۋنت-كۇش-فۋت),
					},
					# Core Unit Identifier
					'pound-force-foot' => {
						'name' => q(فۋنت-كۇش-فۋت),
						'one' => q({0} فۋنت-كۇش-فۋت),
						'other' => q({0} فۋنت-كۇش-فۋت),
					},
					# Long Unit Identifier
					'volume-acre-foot' => {
						'name' => q(اكر-فۋت),
						'one' => q({0} اكر-فۋت),
						'other' => q({0} اكر-فۋت),
					},
					# Core Unit Identifier
					'acre-foot' => {
						'name' => q(اكر-فۋت),
						'one' => q({0} اكر-فۋت),
						'other' => q({0} اكر-فۋت),
					},
					# Long Unit Identifier
					'volume-barrel' => {
						'name' => q(باررەل),
						'one' => q({0} باررەل),
						'other' => q({0} باررەل),
					},
					# Core Unit Identifier
					'barrel' => {
						'name' => q(باررەل),
						'one' => q({0} باررەل),
						'other' => q({0} باررەل),
					},
					# Long Unit Identifier
					'volume-bushel' => {
						'name' => q(بۋشەل),
						'one' => q({0} بۋشەل),
						'other' => q({0} بۋشەل),
					},
					# Core Unit Identifier
					'bushel' => {
						'name' => q(بۋشەل),
						'one' => q({0} بۋشەل),
						'other' => q({0} بۋشەل),
					},
					# Long Unit Identifier
					'volume-centiliter' => {
						'name' => q(سانتيليتىر),
						'one' => q({0} سانتيليتىر),
						'other' => q({0} سانتيليتىر),
					},
					# Core Unit Identifier
					'centiliter' => {
						'name' => q(سانتيليتىر),
						'one' => q({0} سانتيليتىر),
						'other' => q({0} سانتيليتىر),
					},
					# Long Unit Identifier
					'volume-cubic-centimeter' => {
						'name' => q(تەكشە سانتيمەتىر),
						'one' => q({0} تەكشە سانتيمەتىر),
						'other' => q({0} تەكشە سانتيمەتىر),
						'per' => q({0}/تەكشە سانتيمەتىر),
					},
					# Core Unit Identifier
					'cubic-centimeter' => {
						'name' => q(تەكشە سانتيمەتىر),
						'one' => q({0} تەكشە سانتيمەتىر),
						'other' => q({0} تەكشە سانتيمەتىر),
						'per' => q({0}/تەكشە سانتيمەتىر),
					},
					# Long Unit Identifier
					'volume-cubic-foot' => {
						'name' => q(تەكشە فۋت),
						'one' => q({0} تەكشە فۋت),
						'other' => q({0} تەكشە فۋت),
					},
					# Core Unit Identifier
					'cubic-foot' => {
						'name' => q(تەكشە فۋت),
						'one' => q({0} تەكشە فۋت),
						'other' => q({0} تەكشە فۋت),
					},
					# Long Unit Identifier
					'volume-cubic-inch' => {
						'name' => q(تەكشە ديۋيم),
						'one' => q({0} تەكشە ديۋيم),
						'other' => q({0} تەكشە ديۋيم),
					},
					# Core Unit Identifier
					'cubic-inch' => {
						'name' => q(تەكشە ديۋيم),
						'one' => q({0} تەكشە ديۋيم),
						'other' => q({0} تەكشە ديۋيم),
					},
					# Long Unit Identifier
					'volume-cubic-kilometer' => {
						'name' => q(تەكشە كيلومەتىر),
						'one' => q({0} تەكشە كيلومەتىر),
						'other' => q({0} تەكشە كيلومەتىر),
					},
					# Core Unit Identifier
					'cubic-kilometer' => {
						'name' => q(تەكشە كيلومەتىر),
						'one' => q({0} تەكشە كيلومەتىر),
						'other' => q({0} تەكشە كيلومەتىر),
					},
					# Long Unit Identifier
					'volume-cubic-meter' => {
						'name' => q(تەكشە مەتىر),
						'one' => q({0} تەكشە مەتىر),
						'other' => q({0} تەكشە مەتىر),
						'per' => q({0}/تەكشە مەتىر),
					},
					# Core Unit Identifier
					'cubic-meter' => {
						'name' => q(تەكشە مەتىر),
						'one' => q({0} تەكشە مەتىر),
						'other' => q({0} تەكشە مەتىر),
						'per' => q({0}/تەكشە مەتىر),
					},
					# Long Unit Identifier
					'volume-cubic-mile' => {
						'name' => q(تەكشە ميل),
						'one' => q({0} تەكشە ميل),
						'other' => q({0} تەكشە ميل),
					},
					# Core Unit Identifier
					'cubic-mile' => {
						'name' => q(تەكشە ميل),
						'one' => q({0} تەكشە ميل),
						'other' => q({0} تەكشە ميل),
					},
					# Long Unit Identifier
					'volume-cubic-yard' => {
						'name' => q(تەكشە يارد),
						'one' => q({0} تەكشە يارد),
						'other' => q({0} تەكشە يارد),
					},
					# Core Unit Identifier
					'cubic-yard' => {
						'name' => q(تەكشە يارد),
						'one' => q({0} تەكشە يارد),
						'other' => q({0} تەكشە يارد),
					},
					# Long Unit Identifier
					'volume-cup' => {
						'name' => q(كەسە),
						'one' => q({0} كەسە),
						'other' => q({0} كەسە),
					},
					# Core Unit Identifier
					'cup' => {
						'name' => q(كەسە),
						'one' => q({0} كەسە),
						'other' => q({0} كەسە),
					},
					# Long Unit Identifier
					'volume-cup-metric' => {
						'name' => q(مەتىرلىك كەسە),
						'one' => q({0} مەتىرلىك كەسە),
						'other' => q({0} مەتىرلىك كەسە),
					},
					# Core Unit Identifier
					'cup-metric' => {
						'name' => q(مەتىرلىك كەسە),
						'one' => q({0} مەتىرلىك كەسە),
						'other' => q({0} مەتىرلىك كەسە),
					},
					# Long Unit Identifier
					'volume-deciliter' => {
						'name' => q(دەسيليتىر),
						'one' => q({0} دەسيليتىر),
						'other' => q({0} دەسيليتىر),
					},
					# Core Unit Identifier
					'deciliter' => {
						'name' => q(دەسيليتىر),
						'one' => q({0} دەسيليتىر),
						'other' => q({0} دەسيليتىر),
					},
					# Long Unit Identifier
					'volume-dessert-spoon' => {
						'name' => q(دەسەرت قاسىعى),
						'one' => q({0} دەسەرت قاسىعى),
						'other' => q({0} دەسەرت قاسىعى),
					},
					# Core Unit Identifier
					'dessert-spoon' => {
						'name' => q(دەسەرت قاسىعى),
						'one' => q({0} دەسەرت قاسىعى),
						'other' => q({0} دەسەرت قاسىعى),
					},
					# Long Unit Identifier
					'volume-dessert-spoon-imperial' => {
						'name' => q(يمپ دەسەرت قاسىعى),
						'one' => q({0} يمپ دەسەرت قاسىعى),
						'other' => q({0} يمپ دەسەرت قاسىعى),
					},
					# Core Unit Identifier
					'dessert-spoon-imperial' => {
						'name' => q(يمپ دەسەرت قاسىعى),
						'one' => q({0} يمپ دەسەرت قاسىعى),
						'other' => q({0} يمپ دەسەرت قاسىعى),
					},
					# Long Unit Identifier
					'volume-dram' => {
						'name' => q(دراحما),
						'one' => q({0} دراحما),
						'other' => q({0} دراحما),
					},
					# Core Unit Identifier
					'dram' => {
						'name' => q(دراحما),
						'one' => q({0} دراحما),
						'other' => q({0} دراحما),
					},
					# Long Unit Identifier
					'volume-drop' => {
						'name' => q(تامشى),
						'one' => q({0} تامشى),
						'other' => q({0} تامشى),
					},
					# Core Unit Identifier
					'drop' => {
						'name' => q(تامشى),
						'one' => q({0} تامشى),
						'other' => q({0} تامشى),
					},
					# Long Unit Identifier
					'volume-fluid-ounce' => {
						'name' => q(سۇيىق ۋنسيا),
						'one' => q({0} سۇيىق ۋنسيا),
						'other' => q({0} سۇيىق ۋنسيا),
					},
					# Core Unit Identifier
					'fluid-ounce' => {
						'name' => q(سۇيىق ۋنسيا),
						'one' => q({0} سۇيىق ۋنسيا),
						'other' => q({0} سۇيىق ۋنسيا),
					},
					# Long Unit Identifier
					'volume-fluid-ounce-imperial' => {
						'name' => q(يمپ سۇيىق ۋنسيا),
						'one' => q({0} يمپ سۇيىق ۋنسيا),
						'other' => q({0} يمپ سۇيىق ۋنسيا),
					},
					# Core Unit Identifier
					'fluid-ounce-imperial' => {
						'name' => q(يمپ سۇيىق ۋنسيا),
						'one' => q({0} يمپ سۇيىق ۋنسيا),
						'other' => q({0} يمپ سۇيىق ۋنسيا),
					},
					# Long Unit Identifier
					'volume-gallon' => {
						'name' => q(گاللون),
						'one' => q({0} گاللون),
						'other' => q({0} گاللون),
						'per' => q({0}/گاللون),
					},
					# Core Unit Identifier
					'gallon' => {
						'name' => q(گاللون),
						'one' => q({0} گاللون),
						'other' => q({0} گاللون),
						'per' => q({0}/گاللون),
					},
					# Long Unit Identifier
					'volume-gallon-imperial' => {
						'name' => q(يمپ گاللون),
						'one' => q({0} يمپ گاللون),
						'other' => q({0} يمپ گاللون),
						'per' => q({0} يمپ گاللون),
					},
					# Core Unit Identifier
					'gallon-imperial' => {
						'name' => q(يمپ گاللون),
						'one' => q({0} يمپ گاللون),
						'other' => q({0} يمپ گاللون),
						'per' => q({0} يمپ گاللون),
					},
					# Long Unit Identifier
					'volume-hectoliter' => {
						'name' => q(گەكتوليتىر),
						'one' => q({0} گەكتوليرىر),
						'other' => q({0} گەكتوليرىر),
					},
					# Core Unit Identifier
					'hectoliter' => {
						'name' => q(گەكتوليتىر),
						'one' => q({0} گەكتوليرىر),
						'other' => q({0} گەكتوليرىر),
					},
					# Long Unit Identifier
					'volume-jigger' => {
						'name' => q(جيگگەر),
						'one' => q({0} جيگگەر),
						'other' => q({0} جيگگەر),
					},
					# Core Unit Identifier
					'jigger' => {
						'name' => q(جيگگەر),
						'one' => q({0} جيگگەر),
						'other' => q({0} جيگگەر),
					},
					# Long Unit Identifier
					'volume-liter' => {
						'name' => q(ليتىر),
						'one' => q({0} ليتىر),
						'other' => q({0} ليتىر),
						'per' => q({0}/ليتىر),
					},
					# Core Unit Identifier
					'liter' => {
						'name' => q(ليتىر),
						'one' => q({0} ليتىر),
						'other' => q({0} ليتىر),
						'per' => q({0}/ليتىر),
					},
					# Long Unit Identifier
					'volume-megaliter' => {
						'name' => q(مەگاليتر),
						'one' => q({0} مەگاليتر),
						'other' => q({0} مەگاليتر),
					},
					# Core Unit Identifier
					'megaliter' => {
						'name' => q(مەگاليتر),
						'one' => q({0} مەگاليتر),
						'other' => q({0} مەگاليتر),
					},
					# Long Unit Identifier
					'volume-milliliter' => {
						'name' => q(ميليليتىر),
						'one' => q({0} ميليليتىر),
						'other' => q({0} ميليليتىر),
					},
					# Core Unit Identifier
					'milliliter' => {
						'name' => q(ميليليتىر),
						'one' => q({0} ميليليتىر),
						'other' => q({0} ميليليتىر),
					},
					# Long Unit Identifier
					'volume-pinch' => {
						'name' => q(شوكىم),
						'one' => q({0} شوكىم),
						'other' => q({0} شوكىم),
					},
					# Core Unit Identifier
					'pinch' => {
						'name' => q(شوكىم),
						'one' => q({0} شوكىم),
						'other' => q({0} شوكىم),
					},
					# Long Unit Identifier
					'volume-pint' => {
						'name' => q(پينتا),
						'one' => q({0} پينتا),
						'other' => q({0} پينتا),
					},
					# Core Unit Identifier
					'pint' => {
						'name' => q(پينتا),
						'one' => q({0} پينتا),
						'other' => q({0} پينتا),
					},
					# Long Unit Identifier
					'volume-pint-metric' => {
						'name' => q(مەتىرلىك پينتا),
						'one' => q({0} مەتىرلىك پينتا),
						'other' => q({0} مەتىرلىك پينتا),
					},
					# Core Unit Identifier
					'pint-metric' => {
						'name' => q(مەتىرلىك پينتا),
						'one' => q({0} مەتىرلىك پينتا),
						'other' => q({0} مەتىرلىك پينتا),
					},
					# Long Unit Identifier
					'volume-quart' => {
						'name' => q(كۆارتا),
						'one' => q({0} كۆارتا),
						'other' => q({0} كۆارتا),
					},
					# Core Unit Identifier
					'quart' => {
						'name' => q(كۆارتا),
						'one' => q({0} كۆارتا),
						'other' => q({0} كۆارتا),
					},
					# Long Unit Identifier
					'volume-quart-imperial' => {
						'name' => q(يمپ كۆارتا),
						'one' => q({0} يمپ كۆارتا),
						'other' => q({0} يمپ كۆارتا),
					},
					# Core Unit Identifier
					'quart-imperial' => {
						'name' => q(يمپ كۆارتا),
						'one' => q({0} يمپ كۆارتا),
						'other' => q({0} يمپ كۆارتا),
					},
					# Long Unit Identifier
					'volume-tablespoon' => {
						'name' => q(اس قاسىق),
						'one' => q({0} اس قاسىق),
						'other' => q({0} اس قاسىق),
					},
					# Core Unit Identifier
					'tablespoon' => {
						'name' => q(اس قاسىق),
						'one' => q({0} اس قاسىق),
						'other' => q({0} اس قاسىق),
					},
					# Long Unit Identifier
					'volume-teaspoon' => {
						'name' => q(شاي قاسىق),
						'one' => q({0} شاي قاسىق),
						'other' => q({0} شاي قاسىق),
					},
					# Core Unit Identifier
					'teaspoon' => {
						'name' => q(شاي قاسىق),
						'one' => q({0} شاي قاسىق),
						'other' => q({0} شاي قاسىق),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:ءيا|ءيا|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:جوق|جوق|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
				start => q({0}، {1}),
				middle => q({0}، {1}),
				end => q({0} جانە {1}),
				2 => q({0} جانە {1}),
		} }
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'nan' => q(سان ەمەس),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'long' => {
				'1000' => {
					'one' => '0 مىڭ',
					'other' => '0 مىڭ',
				},
				'10000' => {
					'one' => '00 مىڭ',
					'other' => '00 مىڭ',
				},
				'100000' => {
					'one' => '000 مىڭ',
					'other' => '000 مىڭ',
				},
				'1000000' => {
					'one' => '0 ميلليون',
					'other' => '0 ميلليون',
				},
				'10000000' => {
					'one' => '00 ميلليون',
					'other' => '00 ميلليون',
				},
				'100000000' => {
					'one' => '000 ميلليون',
					'other' => '000 ميلليون',
				},
				'1000000000' => {
					'one' => '0 ميلليارد',
					'other' => '0 ميلليارد',
				},
				'10000000000' => {
					'one' => '00 ميلليارد',
					'other' => '00 ميلليارد',
				},
				'100000000000' => {
					'one' => '000 ميلليارد',
					'other' => '000 ميلليارد',
				},
				'1000000000000' => {
					'one' => '0 تريلليون',
					'other' => '0 تريلليون',
				},
				'10000000000000' => {
					'one' => '00 تريلليون',
					'other' => '00 تريلليون',
				},
				'100000000000000' => {
					'one' => '000 تريلليون',
					'other' => '000 تريلليون',
				},
			},
			'short' => {
				'1000' => {
					'one' => '0 مىڭ',
					'other' => '0 مىڭ',
				},
				'10000' => {
					'one' => '00 مىڭ',
					'other' => '00 مىڭ',
				},
				'100000' => {
					'one' => '000 مىڭ',
					'other' => '000 مىڭ',
				},
				'1000000' => {
					'one' => '0 ميلليون',
					'other' => '0 ميلليون',
				},
				'10000000' => {
					'one' => '00 ميلليون',
					'other' => '00 ميلليون',
				},
				'100000000' => {
					'one' => '000 ملن',
					'other' => '000 ملن',
				},
				'1000000000' => {
					'one' => '0 ميلليارد',
					'other' => '0 ميلليارد',
				},
				'10000000000' => {
					'one' => '00 ملرد',
					'other' => '00 ملرد',
				},
				'100000000000' => {
					'one' => '000 ملرد',
					'other' => '000 ملرد',
				},
				'1000000000000' => {
					'one' => '0 تريلليون',
					'other' => '0 تريلليون',
				},
				'10000000000000' => {
					'one' => '00 ترلن',
					'other' => '00 ترلن',
				},
				'100000000000000' => {
					'one' => '000 ترلن',
					'other' => '000 ترلن',
				},
			},
		},
} },
);

has 'currencies' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'AED' => {
			display_name => {
				'currency' => q(بىرىككەن اراب امىرلىكتەرىنىڭ ديرحامى),
				'one' => q(ب ا ءا ديرحامى),
				'other' => q(ب ا ءا ديرحامى),
			},
		},
		'AFN' => {
			display_name => {
				'currency' => q(اۋعانستان افگانيى),
				'one' => q(اۋعانستان افگانيى),
				'other' => q(اۋعانستان افگانيى),
			},
		},
		'ALL' => {
			display_name => {
				'currency' => q(البانيا لەگى),
				'one' => q(البانيا لەگى),
				'other' => q(البانيا لەگى),
			},
		},
		'AMD' => {
			display_name => {
				'currency' => q(ارمەنيا درامى),
				'one' => q(ارمەنيا درامى),
				'other' => q(ارمەنيا درامى),
			},
		},
		'ANG' => {
			display_name => {
				'currency' => q(نيدەرلاند انتيل گۋلدەنى),
				'one' => q(نيدەرلاند انتيل گۋلدەنى),
				'other' => q(نيدەرلاند انتيل گۋلدەنى),
			},
		},
		'AOA' => {
			display_name => {
				'currency' => q(انگولا كۆانزاسى),
				'one' => q(انگولا كۆانزاسى),
				'other' => q(انگولا كۆانزاسى),
			},
		},
		'ARS' => {
			display_name => {
				'currency' => q(ارگەنتينا پەسوسى),
				'one' => q(ارگەنتينا پەسوسى),
				'other' => q(ارگەنتينا پەسوسى),
			},
		},
		'AUD' => {
			display_name => {
				'currency' => q(اۋستراليا دوللارى),
				'one' => q(اۋستراليا دوللارى),
				'other' => q(اۋستراليا دوللارى),
			},
		},
		'AWG' => {
			display_name => {
				'currency' => q(ارۋبا فلورينى),
				'one' => q(ارۋبا فلورينى),
				'other' => q(ارۋبا فلورينى),
			},
		},
		'AZN' => {
			display_name => {
				'currency' => q(ءازىربايجان ماناتى),
				'one' => q(ءازىربايجان ماناتى),
				'other' => q(ءازىربايجان ماناتى),
			},
		},
		'BAM' => {
			display_name => {
				'currency' => q(بوسنيا جانە گەرتسەگوۆينا ايىرباستالمالى ماركاسى),
				'one' => q(بوسنيا جانە گەرتسەگوۆينا ايىرباستالمالى ماركاسى),
				'other' => q(بوسنيا جانە گەرتسەگوۆينا ايىرباستالمالى ماركاسى),
			},
		},
		'BBD' => {
			display_name => {
				'currency' => q(باربادوس دوللارى),
				'one' => q(باربادوس دوللارى),
				'other' => q(باربادوس دوللارى),
			},
		},
		'BDT' => {
			display_name => {
				'currency' => q(بانگلادەش تاكاسى),
				'one' => q(بانگلادەش تاكاسى),
				'other' => q(بانگلادەش تاكاسى),
			},
		},
		'BGN' => {
			display_name => {
				'currency' => q(ڭولگاريا لەۆى),
				'one' => q(ڭولگاريا لەۆى),
				'other' => q(ڭولگاريا لەۆى),
			},
		},
		'BHD' => {
			display_name => {
				'currency' => q(باحرەين دينارى),
				'one' => q(باحرەين دينارى),
				'other' => q(باحرەين دينارى),
			},
		},
		'BIF' => {
			display_name => {
				'currency' => q(بۋرۋندي فرانكى),
				'one' => q(بۋرۋندي فرانكى),
				'other' => q(بۋرۋندي فرانكى),
			},
		},
		'BMD' => {
			display_name => {
				'currency' => q(بەرمۋد دوللارى),
				'one' => q(بەرمۋد دوللارى),
				'other' => q(بەرمۋد دوللارى),
			},
		},
		'BND' => {
			display_name => {
				'currency' => q(برۋنەي دوللارى),
				'one' => q(برۋنەي دوللارى),
				'other' => q(برۋنەي دوللارى),
			},
		},
		'BOB' => {
			display_name => {
				'currency' => q(بوليۆيا بوليۆيانوسى),
				'one' => q(بوليۆيا بوليۆيانوسى),
				'other' => q(بوليۆيا بوليۆيانوسى),
			},
		},
		'BRL' => {
			display_name => {
				'currency' => q(برازيليا رەالى),
				'one' => q(برازيليا رەالى),
				'other' => q(برازيليا رەالى),
			},
		},
		'BSD' => {
			display_name => {
				'currency' => q(باگام دوللارى),
				'one' => q(باگام دوللارى),
				'other' => q(باگام دوللارى),
			},
		},
		'BTN' => {
			display_name => {
				'currency' => q(بۋتان نگۋلترۋمى),
				'one' => q(بۋتان نگۋلترۋمى),
				'other' => q(بۋتان نگۋلترۋمى),
			},
		},
		'BWP' => {
			display_name => {
				'currency' => q(بوتسۆانا پۋلاسى),
				'one' => q(بوتسۆانا پۋلاسى),
				'other' => q(بوتسۆانا پۋلاسى),
			},
		},
		'BYN' => {
			display_name => {
				'currency' => q(بەلارۋس رۋبىلى),
				'one' => q(بەلارۋس رۋبىلى),
				'other' => q(بەلارۋس رۋبىلى),
			},
		},
		'BZD' => {
			display_name => {
				'currency' => q(بەليز دوللارى),
				'one' => q(بەليز دوللارى),
				'other' => q(بەليز دوللارى),
			},
		},
		'CAD' => {
			display_name => {
				'currency' => q(كانادا دوللارى),
				'one' => q(كانادا دوللارى),
				'other' => q(كانادا دوللارى),
			},
		},
		'CDF' => {
			display_name => {
				'currency' => q(كونگو فرانكى),
				'one' => q(كونگو فرانكى),
				'other' => q(كونگو فرانكى),
			},
		},
		'CHF' => {
			display_name => {
				'currency' => q(شۆەيساريا فرانكى),
				'one' => q(شۆەيساريا فرانكى),
				'other' => q(شۆەيساريا فرانكى),
			},
		},
		'CLP' => {
			display_name => {
				'currency' => q(چيلي پەسوسى),
				'one' => q(چيلي پەسوسى),
				'other' => q(چيلي پەسوسى),
			},
		},
		'CNH' => {
			display_name => {
				'currency' => q(قىتاي يۋانى \(وفشور\)),
				'one' => q(قىتاي يۋانى \(وفشور\)),
				'other' => q(قىتاي يۋانى \(وفشور\)),
			},
		},
		'CNY' => {
			display_name => {
				'currency' => q(قىتاي يۋانى),
				'one' => q(قىتاي يۋانى),
				'other' => q(قىتاي يۋانى),
			},
		},
		'COP' => {
			display_name => {
				'currency' => q(كولۋمبيا پەسوسى),
				'one' => q(كولۋمبيا پەسوسى),
				'other' => q(كولۋمبيا پەسوسى),
			},
		},
		'CRC' => {
			display_name => {
				'currency' => q(كوستا-ريكا كولونى),
				'one' => q(كوستا-ريكا كولونى),
				'other' => q(كوستا-ريكا كولونى),
			},
		},
		'CUC' => {
			display_name => {
				'currency' => q(كۋبا ايىرباستالمالى پەسوسى),
				'one' => q(كۋبا ايىرباستالمالى پەسوسى),
				'other' => q(كۋبا ايىرباستالمالى پەسوسى),
			},
		},
		'CUP' => {
			display_name => {
				'currency' => q(كۋبا پەسوسى),
				'one' => q(كۋبا پەسوسى),
				'other' => q(كۋبا پەسوسى),
			},
		},
		'CVE' => {
			display_name => {
				'currency' => q(كابو-ۆەردە ەسكۋدوسى),
				'one' => q(كابو-ۆەردە ەسكۋدوسى),
				'other' => q(كابو-ۆەردە ەسكۋدوسى),
			},
		},
		'CZK' => {
			display_name => {
				'currency' => q(چەح كرونى),
				'one' => q(چەح كرونى),
				'other' => q(چەح كرونى),
			},
		},
		'DJF' => {
			display_name => {
				'currency' => q(جيبۋتي فرانكى),
				'one' => q(جيبۋتي فرانكى),
				'other' => q(جيبۋتي فرانكى),
			},
		},
		'DKK' => {
			display_name => {
				'currency' => q(دار كرونى),
				'one' => q(دار كرونى),
				'other' => q(دار كرونى),
			},
		},
		'DOP' => {
			display_name => {
				'currency' => q(دومينيكان پەسوسى),
				'one' => q(دومينيكان پەسوسى),
				'other' => q(دومينيكان پەسوسى),
			},
		},
		'DZD' => {
			display_name => {
				'currency' => q(الجير دينارى),
				'one' => q(الجير دينارى),
				'other' => q(الجير دينارى),
			},
		},
		'EGP' => {
			display_name => {
				'currency' => q(مىسىر فۋنتى),
				'one' => q(مىسىر فۋنتى),
				'other' => q(مىسىر فۋنتى),
			},
		},
		'ERN' => {
			display_name => {
				'currency' => q(ەريترەيا ناكفاس),
				'one' => q(ەريترەيا ناكفاس),
				'other' => q(ەريترەيا ناكفاس),
			},
		},
		'ETB' => {
			display_name => {
				'currency' => q(ەفيوپيا بىرى),
				'one' => q(ەفيوپيا بىرى),
				'other' => q(ەفيوپيا بىرى),
			},
		},
		'EUR' => {
			display_name => {
				'currency' => q(ەۋرو),
				'one' => q(ەۋرو),
				'other' => q(ەۋرو),
			},
		},
		'FJD' => {
			display_name => {
				'currency' => q(فيجي دوللارى),
				'one' => q(فيجي دوللارى),
				'other' => q(فيجي دوللارى),
			},
		},
		'FKP' => {
			display_name => {
				'currency' => q(فولكلەند ارالدارىنىڭ فۋنتى),
				'one' => q(فولكلەند ارالدارىنىڭ فۋنتى),
				'other' => q(فولكلەند ارالدارىنىڭ فۋنتى),
			},
		},
		'GBP' => {
			display_name => {
				'currency' => q(بريتاندىق فۋنت),
				'one' => q(بريتاندىق فۋنت),
				'other' => q(بريتاندىق فۋنت),
			},
		},
		'GEL' => {
			display_name => {
				'currency' => q(گرۋزيا لاريى),
				'one' => q(گرۋزيا لاريى),
				'other' => q(گرۋزيا لاريى),
			},
		},
		'GHS' => {
			display_name => {
				'currency' => q(گانا سەديى),
				'one' => q(گانا سەديى),
				'other' => q(گانا سەديى),
			},
		},
		'GIP' => {
			display_name => {
				'currency' => q(گيبراتال فۋنتى),
				'one' => q(گيبراتال فۋنتى),
				'other' => q(گيبراتال فۋنتى),
			},
		},
		'GMD' => {
			display_name => {
				'currency' => q(گامبيا دالاسيى),
				'one' => q(گامبيا دالاسيى),
				'other' => q(گامبيا دالاسيى),
			},
		},
		'GNF' => {
			display_name => {
				'currency' => q(گۆينەيا فرانكى),
				'one' => q(گۆينەيا فرانكى),
				'other' => q(گۆينەيا فرانكى),
			},
		},
		'GTQ' => {
			display_name => {
				'currency' => q(گۆاتەمالا كەتسالى),
				'one' => q(گۆاتەمالا كەتسالى),
				'other' => q(گۆاتەمالا كەتسالى),
			},
		},
		'GYD' => {
			display_name => {
				'currency' => q(گايانا دوللارى),
				'one' => q(گايانا دوللارى),
				'other' => q(گايانا دوللارى),
			},
		},
		'HKD' => {
			display_name => {
				'currency' => q(حوڭكوڭ دوللارى),
				'one' => q(حوڭكوڭ دوللارى),
				'other' => q(حوڭكوڭ دوللارى),
			},
		},
		'HNL' => {
			display_name => {
				'currency' => q(گوندۋراس ليمپيراسى),
				'one' => q(گوندۋراس ليمپيراسى),
				'other' => q(گوندۋراس ليمپيراسى),
			},
		},
		'HRK' => {
			display_name => {
				'currency' => q(حورۆاتيا كۋناسى),
				'one' => q(حورۆاتيا كۋناسى),
				'other' => q(حورۆاتيا كۋناسى),
			},
		},
		'HTG' => {
			display_name => {
				'currency' => q(گايتي گۋردى),
				'one' => q(گايتي گۋردى),
				'other' => q(گايتي گۋردى),
			},
		},
		'HUF' => {
			display_name => {
				'currency' => q(ماجار فورينتى),
				'one' => q(ماجار فورينتى),
				'other' => q(ماجار فورينتى),
			},
		},
		'IDR' => {
			display_name => {
				'currency' => q(يندونەزيا رۋپياسى),
				'one' => q(يندونەزيا رۋپياسى),
				'other' => q(يندونەزيا رۋپياسى),
			},
		},
		'ILS' => {
			display_name => {
				'currency' => q(يزرايل جاڭا شەكەلى),
				'one' => q(يزرايل جاڭا شەكەلى),
				'other' => q(يزرايل جاڭا شەكەلى),
			},
		},
		'INR' => {
			display_name => {
				'currency' => q(ءۇندىستان رۋپياسى),
				'one' => q(ءۇندىستان رۋپياسى),
				'other' => q(ءۇندىستان رۋپياسى),
			},
		},
		'IQD' => {
			display_name => {
				'currency' => q(يراك دينارى),
				'one' => q(يراك دينارى),
				'other' => q(يراك دينارى),
			},
		},
		'IRR' => {
			display_name => {
				'currency' => q(يران ريالى),
				'one' => q(يران ريالى),
				'other' => q(يران ريالى),
			},
		},
		'ISK' => {
			display_name => {
				'currency' => q(يسلانديا كروناسى),
				'one' => q(يسلانديا كروناسى),
				'other' => q(يسلانديا كروناسى),
			},
		},
		'JMD' => {
			display_name => {
				'currency' => q(يامايكا دوللارى),
				'one' => q(يامايكا دوللارى),
				'other' => q(يامايكا دوللارى),
			},
		},
		'JOD' => {
			display_name => {
				'currency' => q(يوردانيا دينارى),
				'one' => q(يوردانيا دينارى),
				'other' => q(يوردانيا دينارى),
			},
		},
		'JPY' => {
			display_name => {
				'currency' => q(جاپون يەناسى),
				'one' => q(جاپون يەناسى),
				'other' => q(جاپون يەناسى),
			},
		},
		'KES' => {
			display_name => {
				'currency' => q(Vote كەنيا شيللينگى),
				'one' => q(Vote كەنيا شيللينگى),
				'other' => q(Vote كەنيا شيللينگى),
			},
		},
		'KGS' => {
			display_name => {
				'currency' => q(قىرعىس سومى),
				'one' => q(قىرعىس سومى),
				'other' => q(قىرعىس سومى),
			},
		},
		'KHR' => {
			display_name => {
				'currency' => q(كامبودجا ريەلى),
				'one' => q(كامبودجا ريەلى),
				'other' => q(كامبودجا ريەلى),
			},
		},
		'KMF' => {
			display_name => {
				'currency' => q(كومور ارالدارى فرانكى),
				'one' => q(كومور ارالدارى فرانكى),
				'other' => q(كومور ارالدارى فرانكى),
			},
		},
		'KPW' => {
			display_name => {
				'currency' => q(سولتۇستىك كورەيا ۆونى),
				'one' => q(سولتۇستىك كورەيا ۆونى),
				'other' => q(سولتۇستىك كورەيا ۆونى),
			},
		},
		'KRW' => {
			display_name => {
				'currency' => q(وڭتۇستىك كورەيا ۆونى),
				'one' => q(وڭتۇستىك كورەيا ۆونى),
				'other' => q(وڭتۇستىك كورەيا ۆونى),
			},
		},
		'KWD' => {
			display_name => {
				'currency' => q(كۋۆەيت دينارى),
				'one' => q(كۋۆەيت دينارى),
				'other' => q(كۋۆەيت دينارى),
			},
		},
		'KYD' => {
			display_name => {
				'currency' => q(كايمان ارالدارى دوللارى),
				'one' => q(كايمان ارالدارى دوللارى),
				'other' => q(كايمان ارالدارى دوللارى),
			},
		},
		'KZT' => {
			symbol => '₸',
			display_name => {
				'currency' => q(قازاق تەڭگەسى),
				'one' => q(قازاق تەڭگەسى),
				'other' => q(قازاق تەڭگەسى),
			},
		},
		'LAK' => {
			display_name => {
				'currency' => q(لاوس كيپى),
				'one' => q(لاوس كيپى),
				'other' => q(لاوس كيپى),
			},
		},
		'LBP' => {
			display_name => {
				'currency' => q(ليۆان فۋنتى),
				'one' => q(ليۆان فۋنتى),
				'other' => q(ليۆان فۋنتى),
			},
		},
		'LKR' => {
			display_name => {
				'currency' => q(شري-لانكا رۋپياسى),
				'one' => q(شري-لانكا رۋپياسى),
				'other' => q(شري-لانكا رۋپياسى),
			},
		},
		'LRD' => {
			display_name => {
				'currency' => q(ليبەريا دوللارى),
				'one' => q(ليبەريا دوللارى),
				'other' => q(ليبەريا دوللارى),
			},
		},
		'LSL' => {
			display_name => {
				'currency' => q(لەسوتو ءلوتيى),
				'one' => q(لەسوتو ءلوتيى),
				'other' => q(لەسوتو ءلوتيى),
			},
		},
		'LYD' => {
			display_name => {
				'currency' => q(ليۆيا دينارى),
				'one' => q(ليۆيا دينارى),
				'other' => q(ليۆيا دينارى),
			},
		},
		'MAD' => {
			display_name => {
				'currency' => q(ماروككو دينارى),
				'one' => q(ماروككو دينارى),
				'other' => q(ماروككو دينارى),
			},
		},
		'MDL' => {
			display_name => {
				'currency' => q(مولدوۆا لەيى),
				'one' => q(مولدوۆا لەيى),
				'other' => q(مولدوۆا لەيى),
			},
		},
		'MGA' => {
			display_name => {
				'currency' => q(مالاگاسي ءارياريى),
				'one' => q(مالاگاسي ءارياريى),
				'other' => q(مالاگاسي ءارياريى),
			},
		},
		'MKD' => {
			display_name => {
				'currency' => q(ماكەدونيا دينارى),
				'one' => q(ماكەدونيا دينارى),
				'other' => q(ماكەدونيا دينارى),
			},
		},
		'MMK' => {
			display_name => {
				'currency' => q(ميانما كياتى),
				'one' => q(ميانما كياتى),
				'other' => q(ميانما كياتى),
			},
		},
		'MNT' => {
			display_name => {
				'currency' => q(موڭعوليا تۋگريكى),
				'one' => q(موڭعوليا تۋگريكى),
				'other' => q(موڭعوليا تۋگريكى),
			},
		},
		'MOP' => {
			display_name => {
				'currency' => q(ماكاو پاتاكاسى),
				'one' => q(ماكاو پاتاكاسى),
				'other' => q(ماكاو پاتاكاسى),
			},
		},
		'MRU' => {
			display_name => {
				'currency' => q(ماۆريتانيا ۋگياسى),
				'one' => q(ماۆريتانيا ۋگياسى),
				'other' => q(ماۆريتانيا ۋگياسى),
			},
		},
		'MUR' => {
			display_name => {
				'currency' => q(ماۆريكيي رۋپياسى),
				'one' => q(ماۆريكيي رۋپياسى),
				'other' => q(ماۆريكيي رۋپياسى),
			},
		},
		'MVR' => {
			display_name => {
				'currency' => q(مالديۆ رۋفياسى),
				'one' => q(مالديۆ رۋفياسى),
				'other' => q(مالديۆ رۋفياسى),
			},
		},
		'MWK' => {
			display_name => {
				'currency' => q(مالاۆي كۆاچاسى),
				'one' => q(مالاۆي كۆاچاسى),
				'other' => q(مالاۆي كۆاچاسى),
			},
		},
		'MXN' => {
			display_name => {
				'currency' => q(مەكسيكا پەسوسى),
				'one' => q(مەكسيكا پەسوسى),
				'other' => q(مەكسيكا پەسوسى),
			},
		},
		'MYR' => {
			display_name => {
				'currency' => q(مالايزيا رينگگيتى),
				'one' => q(مالايزيا رينگگيتى),
				'other' => q(مالايزيا رينگگيتى),
			},
		},
		'MZN' => {
			display_name => {
				'currency' => q(موزامبيك مەتيكالى),
				'one' => q(موزامبيك مەتيكالى),
				'other' => q(موزامبيك مەتيكالى),
			},
		},
		'NAD' => {
			display_name => {
				'currency' => q(ناميبيا دوللارى),
				'one' => q(ناميبيا دوللارى),
				'other' => q(ناميبيا دوللارى),
			},
		},
		'NGN' => {
			display_name => {
				'currency' => q(نيگەريا نايراسى),
				'one' => q(نيگەريا نايراسى),
				'other' => q(نيگەريا نايراسى),
			},
		},
		'NIO' => {
			display_name => {
				'currency' => q(نيكاراگۋا كوردوباسى),
				'one' => q(نيكاراگۋا كوردوباسى),
				'other' => q(نيكاراگۋا كوردوباسى),
			},
		},
		'NOK' => {
			display_name => {
				'currency' => q(نورۆەگيا كرونى),
				'one' => q(نورۆەگيا كرونى),
				'other' => q(نورۆەگيا كرونى),
			},
		},
		'NPR' => {
			display_name => {
				'currency' => q(نەپال رۋپياسى),
				'one' => q(نەپال رۋپياسى),
				'other' => q(نەپال رۋپياسى),
			},
		},
		'NZD' => {
			display_name => {
				'currency' => q(جاڭا زەلانديا دوللارى),
				'one' => q(جاڭا زەلانديا دوللارى),
				'other' => q(جاڭا زەلانديا دوللارى),
			},
		},
		'OMR' => {
			display_name => {
				'currency' => q(ومان ريالى),
				'one' => q(ومان ريالى),
				'other' => q(ومان ريالى),
			},
		},
		'PAB' => {
			display_name => {
				'currency' => q(پاناما بالبواسى),
				'one' => q(پاناما بالبواسى),
				'other' => q(پاناما بالبواسى),
			},
		},
		'PEN' => {
			display_name => {
				'currency' => q(پەرۋ سولى),
				'one' => q(پەرۋ سولى),
				'other' => q(پەرۋ سولى),
			},
		},
		'PGK' => {
			display_name => {
				'currency' => q(پاپۋا - جاڭا گۆينەيا كيناسى),
				'one' => q(پاپۋا - جاڭا گۆينەيا كيناسى),
				'other' => q(پاپۋا - جاڭا گۆينەيا كيناسى),
			},
		},
		'PHP' => {
			display_name => {
				'currency' => q(فيليپپين پەسوسى),
				'one' => q(فيليپپين پەسوسى),
				'other' => q(فيليپپين پەسوسى),
			},
		},
		'PKR' => {
			display_name => {
				'currency' => q(پاكىستان رۋپياسى),
				'one' => q(پاكىستان رۋپياسى),
				'other' => q(پاكىستان رۋپياسى),
			},
		},
		'PLN' => {
			display_name => {
				'currency' => q(پولشا زلوتىسى),
				'one' => q(پولشا زلوتىسى),
				'other' => q(پولشا زلوتىسى),
			},
		},
		'PYG' => {
			display_name => {
				'currency' => q(پاراگۆاي گۋارانيى),
				'one' => q(پاراگۆاي گۋارانيى),
				'other' => q(پاراگۆاي گۋارانيى),
			},
		},
		'QAR' => {
			display_name => {
				'currency' => q(كاتار ريالى),
				'one' => q(كاتار ريالى),
				'other' => q(كاتار ريالى),
			},
		},
		'RON' => {
			display_name => {
				'currency' => q(رۋمىنيا لەيى),
				'one' => q(رۋمىنيا لەيى),
				'other' => q(رۋمىنيا لەيى),
			},
		},
		'RSD' => {
			display_name => {
				'currency' => q(سەربيا دينارى),
				'one' => q(سەربيا دينارى),
				'other' => q(سەربيا دينارى),
			},
		},
		'RUB' => {
			display_name => {
				'currency' => q(رەسەي رۋبىلى),
				'one' => q(رەسەي رۋبىلى),
				'other' => q(رەسەي رۋبىلى),
			},
		},
		'RWF' => {
			display_name => {
				'currency' => q(رۋاندا فرانكى),
				'one' => q(رۋاندا فرانكى),
				'other' => q(رۋاندا فرانكى),
			},
		},
		'SAR' => {
			display_name => {
				'currency' => q(ساۋد ارابياسىنىڭ ريالى),
				'one' => q(ساۋد ارابياسىنىڭ ريالى),
				'other' => q(ساۋد ارابياسىنىڭ ريالى),
			},
		},
		'SBD' => {
			display_name => {
				'currency' => q(سولومون ارالدارى دوللارى),
				'one' => q(سولومون ارالدارى دوللارى),
				'other' => q(سولومون ارالدارى دوللارى),
			},
		},
		'SCR' => {
			display_name => {
				'currency' => q(سەيشەل رۋپياسى),
				'one' => q(سەيشەل رۋپياسى),
				'other' => q(سەيشەل رۋپياسى),
			},
		},
		'SDG' => {
			display_name => {
				'currency' => q(سۋدان فۋنتى),
				'one' => q(سۋدان فۋنتى),
				'other' => q(سۋدان فۋنتى),
			},
		},
		'SEK' => {
			display_name => {
				'currency' => q(شۆەسيا كرونى),
				'one' => q(شۆەسيا كرونى),
				'other' => q(شۆەسيا كرونى),
			},
		},
		'SGD' => {
			display_name => {
				'currency' => q(سينگاپۋر دوللارى),
				'one' => q(سينگاپۋر دوللارى),
				'other' => q(سينگاپۋر دوللارى),
			},
		},
		'SHP' => {
			display_name => {
				'currency' => q(اۋليە ەلەنا ارالى فۋنتى),
				'one' => q(اۋليە ەلەنا ارالى فۋنتى),
				'other' => q(اۋليە ەلەنا ارالى فۋنتى),
			},
		},
		'SLE' => {
			display_name => {
				'currency' => q(سەررا-لەونە لەونەسى),
				'one' => q(سەررا-لەونە لەونەسى),
				'other' => q(سەررا-لەونە لەونەسى),
			},
		},
		'SLL' => {
			display_name => {
				'currency' => q(سەررا-لەونە لەونەسى \(1964—2022\)),
				'one' => q(سەررا-لەونە لەونەسى \(1964—2022\)),
				'other' => q(سەررا-لەونە لەونەسى \(1964—2022\)),
			},
		},
		'SOS' => {
			display_name => {
				'currency' => q(سومالي شيللينگى),
				'one' => q(سومالي شيللينگى),
				'other' => q(سومالي شيللينگى),
			},
		},
		'SRD' => {
			display_name => {
				'currency' => q(سۋرينام دوللارى),
				'one' => q(سۋرينام دوللارى),
				'other' => q(سۋرينام دوللارى),
			},
		},
		'SSP' => {
			display_name => {
				'currency' => q(وڭتۇستىك سۋدان فۋنتى),
				'one' => q(وڭتۇستىك سۋدان فۋنتى),
				'other' => q(وڭتۇستىك سۋدان فۋنتى),
			},
		},
		'STN' => {
			display_name => {
				'currency' => q(سانت-تومە مەن پرينسيپي دوبراسى),
				'one' => q(سانت-تومە مەن پرينسيپي دوبراسى),
				'other' => q(سانت-تومە مەن پرينسيپي دوبراسى),
			},
		},
		'SYP' => {
			display_name => {
				'currency' => q(سيريا فۋنتى),
				'one' => q(سيريا فۋنتى),
				'other' => q(سيريا فۋنتى),
			},
		},
		'SZL' => {
			display_name => {
				'currency' => q(سۆازيلەند ليلانگەنيى),
				'one' => q(سۆازيلەند ليلانگەنيى),
				'other' => q(سۆازيلەند ليلانگەنيى),
			},
		},
		'THB' => {
			display_name => {
				'currency' => q(تاي باتى),
				'one' => q(تاي باتى),
				'other' => q(تاي باتى),
			},
		},
		'TJS' => {
			display_name => {
				'currency' => q(تاجىك سومونيى),
				'one' => q(تاجىك سومونيى),
				'other' => q(تاجىك سومونيى),
			},
		},
		'TMT' => {
			display_name => {
				'currency' => q(تۇىكمەن ماناتى),
				'one' => q(تۇىكمەن ماناتى),
				'other' => q(تۇىكمەن ماناتى),
			},
		},
		'TND' => {
			display_name => {
				'currency' => q(تۋنيس دينارى),
				'one' => q(تۋنيس دينارى),
				'other' => q(تۋنيس دينارى),
			},
		},
		'TOP' => {
			display_name => {
				'currency' => q(تونگا پاانگاسى),
				'one' => q(تونگا پاانگاسى),
				'other' => q(تونگا پاانگاسى),
			},
		},
		'TRY' => {
			display_name => {
				'currency' => q(تۇرىك ليراسى),
				'one' => q(تۇرىك ليراسى),
				'other' => q(تۇرىك ليراسى),
			},
		},
		'TTD' => {
			display_name => {
				'currency' => q(ترينيداد جانە توباگو دوللارى),
				'one' => q(ترينيداد جانە توباگو دوللارى),
				'other' => q(ترينيداد جانە توباگو دوللارى),
			},
		},
		'TWD' => {
			display_name => {
				'currency' => q(جاڭا تايبەي دوللارى),
				'one' => q(جاڭا تايبەي دوللارى),
				'other' => q(جاڭا تايبەي دوللارى),
			},
		},
		'TZS' => {
			display_name => {
				'currency' => q(تانزانيا شيللينگى),
				'one' => q(تانزانيا شيللينگى),
				'other' => q(تانزانيا شيللينگى),
			},
		},
		'UAH' => {
			display_name => {
				'currency' => q(ۋكراينا گريۆناسى),
				'one' => q(ۋكراينا گريۆناسى),
				'other' => q(ۋكراينا گريۆناسى),
			},
		},
		'UGX' => {
			display_name => {
				'currency' => q(ۋگاندا شيللينگى),
				'one' => q(ۋگاندا شيللينگى),
				'other' => q(ۋگاندا شيللينگى),
			},
		},
		'USD' => {
			display_name => {
				'currency' => q(ا ق ش دوللارى),
				'one' => q(ا ق ش دوللارى),
				'other' => q(ا ق ش دوللارى),
			},
		},
		'UYU' => {
			display_name => {
				'currency' => q(ۋرۋگۆاي پەسوسى),
				'one' => q(ۋرۋگۆاي پەسوسى),
				'other' => q(ۋرۋگۆاي پەسوسى),
			},
		},
		'UZS' => {
			display_name => {
				'currency' => q(وزبەك سومى),
				'one' => q(وزبەك سومى),
				'other' => q(وزبەك سومى),
			},
		},
		'VES' => {
			display_name => {
				'currency' => q(ۆەنەسۋەلا بوليۆارى),
				'one' => q(ۆەنەسۋەلا بوليۆارى),
				'other' => q(ۆەنەسۋەلا بوليۆارى),
			},
		},
		'VND' => {
			display_name => {
				'currency' => q(ۆەتنام دونگى),
				'one' => q(ۆەتنام دونگى),
				'other' => q(ۆەتنام دونگى),
			},
		},
		'VUV' => {
			display_name => {
				'currency' => q(ۆانۋاتۋ ۆاتۋى),
				'one' => q(ۆانۋاتۋ ۆاتۋى),
				'other' => q(ۆانۋاتۋ ۆاتۋى),
			},
		},
		'WST' => {
			display_name => {
				'currency' => q(ساموا تالاسى),
				'one' => q(ساموا تالاسى),
				'other' => q(ساموا تالاسى),
			},
		},
		'XAF' => {
			display_name => {
				'currency' => q(ورتالىق افريكانىڭ فرانكى),
				'one' => q(ورتالىق افريكانىڭ فرانكى),
				'other' => q(ورتالىق افريكانىڭ فرانكى),
			},
		},
		'XCD' => {
			display_name => {
				'currency' => q(شىعىس كاريب دوللارى),
				'one' => q(شىعىس كاريب دوللارى),
				'other' => q(شىعىس كاريب دوللارى),
			},
		},
		'XOF' => {
			display_name => {
				'currency' => q(باتىس افريكانىڭ فرانكى),
				'one' => q(باتىس افريكانىڭ فرانكى),
				'other' => q(باتىس افريكانىڭ فرانكى),
			},
		},
		'XPF' => {
			display_name => {
				'currency' => q(فرانسۋز پولينەزيا فرانكى),
				'one' => q(فرانسۋز پولينەزيا فرانكى),
				'other' => q(فرانسۋز پولينەزيا فرانكى),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(بەلگىسىز اقشا),
				'one' => q(\(بەلگىسىز اقشا بىرلىگى\)),
				'other' => q(\(بەلگىسىز اقشا\)),
			},
		},
		'YER' => {
			display_name => {
				'currency' => q(يەمەن ريالى),
				'one' => q(يەمەن ريالى),
				'other' => q(يەمەن ريالى),
			},
		},
		'ZAR' => {
			display_name => {
				'currency' => q(وڭتۇستىك افريكا ءرەندى),
				'one' => q(وڭتۇستىك افريكا ءرەندى),
				'other' => q(وڭتۇستىك افريكا ءرەندى),
			},
		},
		'ZMW' => {
			display_name => {
				'currency' => q(زامبيا كۆاچاسى),
				'one' => q(زامبيا كۆاچاسى),
				'other' => q(زامبيا كۆاچاسى),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'chinese' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'قاڭ',
							'اقپ',
							'ناۋ',
							'ساۋ',
							'مام',
							'ماۋ',
							'شىل',
							'تام',
							'قىر',
							'قاز',
							'قار',
							'جەل'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'قاڭتار',
							'اقپان',
							'ناۋرىز',
							'ءساۋىر',
							'مامىر',
							'ماۋسىم',
							'شىلدە',
							'تامىز',
							'قىركۇيەك',
							'قازان',
							'قاراشا',
							'جەلتوقسان'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'قاڭ',
							'اقپ',
							'ناۋ',
							'ساۋ',
							'مام',
							'ماۋ',
							'شىل',
							'تام',
							'قىر',
							'قاز',
							'قار',
							'جەل'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'قاڭتار',
							'اقپان',
							'ناۋرىز',
							'ءساۋىر',
							'مامىر',
							'ماۋسىم',
							'شىلدە',
							'تامىز',
							'قىركۇيەك',
							'قازان',
							'قاراشا',
							'جەلتوقسان'
						],
						leap => [
							
						],
					},
				},
			},
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'قاڭتار',
							'اقپان',
							'ناۋرىز',
							'ءساۋىر',
							'مامىر',
							'ماۋسىم',
							'شىلدە',
							'تامىز',
							'قىركۇيەك',
							'قازان',
							'قاراشا',
							'جەلتوقسان'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'قاڭتار',
							'اقپان',
							'ناۋرىز',
							'ءساۋىر',
							'مامىر',
							'ماۋسىم',
							'شىلدە',
							'تامىز',
							'قىركۇيەك',
							'قازان',
							'قاراشا',
							'جەلتوقسان'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'قاڭتار',
							'اقپان',
							'ناۋرىز',
							'ءساۋىر',
							'مامىر',
							'ماۋسىم',
							'شىلدە',
							'تامىز',
							'قىركۇيەك',
							'قازان',
							'قاراشا',
							'جەلتوقسان'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'قاڭتار',
							'اقپان',
							'ناۋرىز',
							'ءساۋىر',
							'مامىر',
							'ماۋسىم',
							'شىلدە',
							'تامىز',
							'قىركۇيەك',
							'قازان',
							'قاراشا',
							'جەلتوقسان'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'دۇي',
						tue => 'سەي',
						wed => 'سار',
						thu => 'بەي',
						fri => 'جۇم',
						sat => 'سەن',
						sun => 'جەك'
					},
					narrow => {
						mon => 'د',
						tue => 'س',
						wed => 'س',
						thu => 'ب',
						fri => 'ج',
						sat => 'س',
						sun => 'ج'
					},
					short => {
						mon => 'دۇ',
						tue => 'سە',
						wed => 'سا',
						thu => 'بە',
						fri => 'جۇ',
						sat => 'سن',
						sun => 'جە'
					},
					wide => {
						mon => 'دۇيسەنبى',
						tue => 'سەيسەنبى',
						wed => 'سارسەنبى',
						thu => 'بەيسەنبى',
						fri => 'جۇما',
						sat => 'سەنبى',
						sun => 'جەكسەنبى'
					},
				},
				'stand-alone' => {
					abbreviated => {
						mon => 'دۇي',
						tue => 'سەي',
						wed => 'سار',
						thu => 'بەي',
						fri => 'جۇم',
						sat => 'سەن',
						sun => 'جەك'
					},
					narrow => {
						mon => 'د',
						tue => 'س',
						wed => 'س',
						thu => 'ب',
						fri => 'ج',
						sat => 'س',
						sun => 'ج'
					},
					short => {
						mon => 'دۇ',
						tue => 'سە',
						wed => 'سا',
						thu => 'بە',
						fri => 'جۇ',
						sat => 'سن',
						sun => 'جە'
					},
					wide => {
						mon => 'دۇيسەنبى',
						tue => 'سەيسەنبى',
						wed => 'سارسەنبى',
						thu => 'بەيسەنبى',
						fri => 'جۇما',
						sat => 'سەنبى',
						sun => 'جەكسەنبى'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => '1-توقسان',
						1 => '2-توقسان',
						2 => '3-توقسان',
						3 => '4-توقسان'
					},
					wide => {0 => 'ءبىرىنشى توقسان',
						1 => 'ەكىنشى توقسان',
						2 => 'ءۇشىنشى توقسان',
						3 => 'ءتورتىنشى توقسان'
					},
				},
				'stand-alone' => {
					abbreviated => {0 => '1-توقسان',
						1 => '2-توقسان',
						2 => '3-توقسان',
						3 => '4-توقسان'
					},
					wide => {0 => 'ءبىرىنشى توقسان',
						1 => 'ەكىنشى توقسان',
						2 => 'ءۇشىنشى توقسان',
						3 => 'ءتورتىنشى توقسان'
					},
				},
			},
	} },
);

has 'day_period_data' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub { sub {
		# Time in hhmm format
		my ($self, $type, $time, $day_period_type) = @_;
		$day_period_type //= 'default';
		SWITCH:
		for ($type) {
			if ($_ eq 'chinese') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				last SWITCH;
				}
			if ($_ eq 'generic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				last SWITCH;
				}
			if ($_ eq 'gregorian') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				last SWITCH;
				}
		}
	} },
);

around day_period_data => sub {
    my ($orig, $self) = @_;
    return $self->$orig;
};

has 'day_periods' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'abbreviated' => {
					'afternoon1' => q{تۇستەن كەيىنگى},
					'am' => q{ت د},
					'evening1' => q{كەش},
					'midnight' => q{ءتۇن جارىمى},
					'morning1' => q{تاڭعى},
					'night1' => q{تۇنگى},
					'noon' => q{تۇسكى},
					'pm' => q{ت ك},
				},
				'narrow' => {
					'afternoon1' => q{تۇستەن كەيىنگى},
					'am' => q{ت د},
					'evening1' => q{كەشكى},
					'midnight' => q{تۇنگى},
					'morning1' => q{تاڭعى},
					'night1' => q{تۇنگى},
					'noon' => q{تۇسكى},
					'pm' => q{ت ك},
				},
				'wide' => {
					'afternoon1' => q{تۇستەن كەيىنگى},
					'am' => q{ت د},
					'evening1' => q{كەشى},
					'midnight' => q{ءتۇن جارىمى},
					'morning1' => q{تاڭعى},
					'night1' => q{تۇنگى},
					'noon' => q{تۇسكى},
					'pm' => q{ت ك},
				},
			},
			'stand-alone' => {
				'abbreviated' => {
					'afternoon1' => q{تۇستەن كەيىن},
					'am' => q{ت د},
					'evening1' => q{كەش},
					'midnight' => q{ءتۇن جارىمى},
					'morning1' => q{تاڭ},
					'night1' => q{ءتۇن},
					'noon' => q{ءتالتۇس},
					'pm' => q{ت ك},
				},
				'narrow' => {
					'afternoon1' => q{تۇستەن كەيىن},
					'am' => q{ت د},
					'evening1' => q{كەش},
					'midnight' => q{ءتۇن جارىمى},
					'morning1' => q{تاڭ},
					'night1' => q{ءتۇن},
					'noon' => q{تال ءتۇس},
					'pm' => q{ت ك},
				},
				'wide' => {
					'afternoon1' => q{تۇستەن كەيىن},
					'am' => q{ت د},
					'evening1' => q{كەش},
					'midnight' => q{ءتۇن جارىمى},
					'morning1' => q{تاڭ},
					'night1' => q{ءتۇن},
					'noon' => q{تال ءتۇس},
					'pm' => q{ت ك},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'chinese' => {
		},
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'ب ز د',
				'1' => 'ب ز'
			},
			narrow => {
				'0' => 'ب ز د',
				'1' => 'ب ز'
			},
			wide => {
				'0' => 'ءبىزدىڭ زامانىمىزعا دەيىن',
				'1' => 'ءبىزدىڭ زامانىمىز'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'chinese' => {
			'full' => q{EEEE، MMMM d، r(U)},
			'long' => q{MMMM d، r(U)},
			'medium' => q{MMM d، r},
			'short' => q{M/d/yy},
		},
		'generic' => {
			'full' => q{EEEE، MMMM d، y G},
			'long' => q{MMMM d، y G},
			'medium' => q{MMM d، y G},
			'short' => q{M/d/y GGGGG},
		},
		'gregorian' => {
			'full' => q{y d-MMMM، EEEE},
			'long' => q{d-MMMM، y},
			'medium' => q{d-MMM، y},
			'short' => q{dd-MM-y},
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'chinese' => {
		},
		'generic' => {
		},
		'gregorian' => {
			'full' => q{HH:mm:ss zzzz},
			'long' => q{HH:mm:ss z},
			'medium' => q{HH:mm:ss},
			'short' => q{HH:mm},
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'chinese' => {
		},
		'generic' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1}، {0}},
			'short' => q{{1}، {0}},
		},
		'gregorian' => {
			'full' => q{{1}، {0}},
			'long' => q{{1}، {0}},
			'medium' => q{{1}, {0}},
			'short' => q{{1}, {0}},
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			Ed => q{d E},
			Gy => q{y G},
			GyMMM => q{MMM y G},
			GyMMMEd => q{E، MMM d، y G},
			GyMMMd => q{MMM d، y G},
			GyMd => q{M/d/y GGGGG},
			MEd => q{E، M/d},
			MMMEd => q{E، MMM d},
			Md => q{M/d},
			y => q{y G},
			yyyy => q{y G},
			yyyyM => q{M/y GGGGG},
			yyyyMEd => q{E، M/d/y GGGGG},
			yyyyMMM => q{MMM y G},
			yyyyMMMEd => q{E، MMM d، y G},
			yyyyMMMM => q{MMMM y G},
			yyyyMMMd => q{MMM d، y G},
			yyyyMd => q{M/d/y GGGGG},
			yyyyQQQ => q{QQQ y G},
			yyyyQQQQ => q{QQQQ y G},
		},
		'gregorian' => {
			Ed => q{d E},
			Gy => q{y G},
			GyMMM => q{y MMM G},
			GyMMMEd => q{y d-MMM، E G},
			GyMMMd => q{y d-MMM G},
			GyMd => q{G d-M-y},
			MEd => q{d-M، E},
			MMMEd => q{d-MMM، E},
			MMMMW => q{اپتاسى-W ايىنىڭ MMMM},
			MMMMd => q{d-MMMM},
			MMMd => q{d-MMM},
			Md => q{d-M},
			yM => q{M-y},
			yMEd => q{y-d-M، E},
			yMMMEd => q{y d-MMM، E},
			yMMMd => q{y d-MMM},
			yMd => q{y-d-M},
			yw => q{اپتاسى-w جىلدىڭ Y},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			Gy => {
				G => q{y G – y G},
				y => q{y – y G},
			},
			GyM => {
				G => q{M/y GGGGG – M/y GGGGG},
				M => q{M/y – M/y GGGGG},
				y => q{M/y – M/y GGGGG},
			},
			GyMEd => {
				G => q{E، M/d/y GGGGG – E، M/d/y GGGGG},
				M => q{E، M/d/y – E، M/d/y GGGGG},
				d => q{E، M/d/y – E، M/d/y GGGGG},
				y => q{E، M/d/y – E، M/d/y GGGGG},
			},
			GyMMM => {
				G => q{MMM y G – MMM y G},
				M => q{MMM – MMM y G},
				y => q{MMM y – MMM y G},
			},
			GyMMMEd => {
				G => q{E، MMM d، y G – E، MMM d، y G},
				M => q{E، MMM d – E، MMM d، y G},
				d => q{E، MMM d – E، MMM d، y G},
				y => q{E، MMM d، y – E، MMM d، y G},
			},
			GyMMMd => {
				G => q{MMM d، y G – MMM d، y G},
				M => q{MMM d – MMM d، y G},
				d => q{MMM d – d، y G},
				y => q{MMM d، y – MMM d، y G},
			},
			GyMd => {
				G => q{M/d/y GGGGG – M/d/y GGGGG},
				M => q{M/d/y – M/d/y GGGGG},
				d => q{M/d/y – M/d/y GGGGG},
				y => q{M/d/y – M/d/y GGGGG},
			},
			M => {
				M => q{M – M},
			},
			MEd => {
				M => q{E، M/d – E، M/d},
				d => q{E، M/d – E، M/d},
			},
			MMM => {
				M => q{MMM – MMM},
			},
			MMMEd => {
				M => q{E، MMM d – E، MMM d},
				d => q{E، MMM d – E، MMM d},
			},
			MMMd => {
				d => q{MMM d – d},
			},
			Md => {
				M => q{M/d – M/d},
				d => q{M/d – M/d},
			},
			y => {
				y => q{y – y G},
			},
			yM => {
				M => q{M/y – M/y GGGGG},
				y => q{M/y – M/y GGGGG},
			},
			yMEd => {
				M => q{E، M/d/y – E، M/d/y GGGGG},
				d => q{E، M/d/y – E، M/d/y GGGGG},
				y => q{E، M/d/y – E، M/d/y GGGGG},
			},
			yMMM => {
				M => q{MMM – MMM y G},
				y => q{MMM y – MMM y G},
			},
			yMMMEd => {
				M => q{E، MMM d – E، MMM d، y G},
				d => q{E، MMM d – E، MMM d، y G},
				y => q{E، MMM d، y – E، MMM d، y G},
			},
			yMMMM => {
				M => q{MMMM – MMMM y G},
				y => q{MMMM y – MMMM y G},
			},
			yMMMd => {
				M => q{MMM d – MMM d، y G},
				d => q{MMM d – d، y G},
				y => q{MMM d، y – MMM d، y G},
			},
			yMd => {
				M => q{M/d/y – M/d/y GGGGG},
				d => q{M/d/y – M/d/y GGGGG},
				y => q{M/d/y – M/d/y GGGGG},
			},
		},
		'gregorian' => {
			GyM => {
				G => q{G y-M – G y-M},
				M => q{G y-M – y-M},
				y => q{G y-M – y-M},
			},
			GyMEd => {
				G => q{G y-M-d، E – G y-M-d، E},
				M => q{G y-M-d، E – y-M-d، E},
				d => q{G y-M-d، E – y-M-d، E},
				y => q{G y-M-d، E – y-M-d، E},
			},
			GyMMMEd => {
				G => q{G y، d MMM، E – G y، d MMM، E},
				M => q{G y، d MMM، E – d MMM، E},
				d => q{G y، d MMM، E – d MMM، E},
				y => q{G y، d MMM، E – y d MMM، E},
			},
			GyMMMd => {
				G => q{G y، MMM d – G y، MMM d},
				M => q{G y، MMM d – MMM d},
				d => q{G y، MMM d–d},
				y => q{G y، MMM d – y، MMM d},
			},
			GyMd => {
				G => q{G y-M-d – G y-M-d},
				M => q{G y-M-d – y-M-d},
				d => q{G y-M-d – y-M-d},
				y => q{G y-M-d – y-M-d},
			},
			M => {
				M => q{M – M},
			},
			MEd => {
				M => q{M-d، E – M-d، E},
				d => q{M-d، E – M-d، E},
			},
			MMM => {
				M => q{MMM–MMM},
			},
			MMMEd => {
				M => q{MMM d، E – MMM d، E},
				d => q{MMM d، E – MMM d، E},
			},
			Md => {
				M => q{M-d – M-d},
				d => q{M-d – M-d},
			},
			yM => {
				M => q{y-M – y-M},
				y => q{y-M – y-M},
			},
			yMEd => {
				M => q{y-M-d، E – y-M-d، E},
				d => q{y-M-d، E – y-M-d، E},
				y => q{y-M-d، E – y-M-d، E},
			},
			yMMMEd => {
				M => q{y MMM d، E – MMM d، E},
				d => q{y MMM d، E – MMM d، E},
				y => q{y MMM d، E – y MMM d، E},
			},
			yMMMd => {
				M => q{y، MMM d – MMM d},
				d => q{y، MMM d–d},
				y => q{y، MMM d – y، MMM d},
			},
			yMd => {
				M => q{y-M-d – y-M-d},
				d => q{y-M-d – y-M-d},
				y => q{y-M-d – y-M-d},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default	=> sub { {
		regionFormat => q({0} ۋاقىتى),
		regionFormat => q({0} جازعى ۋاقىتى),
		regionFormat => q({0} ستاندارتتى ۋاقىتى),
		'Afghanistan' => {
			long => {
				'standard' => q#اۋعانستان ۋاقىتى#,
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#ابيدجان#,
		},
		'Africa/Accra' => {
			exemplarCity => q#اككرا#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#ادديس-ابەبا#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#الجير#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#اسمارا#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#باماكو#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#بانگي#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#بانجۋل#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#بيساۋ#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#بلانتاير#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#براززاۆيل#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#بۋجۋمبۋرا#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#كاير#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#كاسابلانكا#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#سەۋتا#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#كوناكري#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#داكار#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#دار-ەس-سالام#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#جيبۋتي#,
		},
		'Africa/Douala' => {
			exemplarCity => q#دۋالا#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#ەل-ايۋن#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#فريتاۋن#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#گابورونە#,
		},
		'Africa/Harare' => {
			exemplarCity => q#حارارە#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#يوحاننەسبۋرگ#,
		},
		'Africa/Juba' => {
			exemplarCity => q#جۋبا#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#كامپالا#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#حارتۋم#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#كيگالي#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#كينشاسا#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#لاگوس#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#ليبرەۆيل#,
		},
		'Africa/Lome' => {
			exemplarCity => q#لومە#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#لۋاندا#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#لۋبۋمباشي#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#لۋساكا#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#مالابو#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#ماپۋتۋ#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#ماسەرۋ#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#مبابەنە#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#موگاديشۋ#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#مونروۆيا#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#نايروبي#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#ندجامەنا#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#نيامەي#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#نۋاكشوت#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#ۋاگادۋگۋ#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#پورتو-نوۆو#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#سان-تومە#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#تريپولي#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#تۋنيس#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#ۆيندحۋك#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q#ورتالىق افريكا ۋاقىتى#,
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q#شىعىس افريكا ۋاقىتى#,
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q#وڭتۇستىك افريكا ستاندارتتى ۋاقىتى#,
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q#باتىس افريكا جازعى ۋاقىتى#,
				'generic' => q#باتىس افريكا ۋاقىتى#,
				'standard' => q#باتىس افريكا ستاندارتتى ۋاقىتى#,
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q#الاسكا جازعى ۋاقىتى#,
				'generic' => q#الاسكا ۋاقىتى#,
				'standard' => q#الاسكا ستاندارتتى ۋاقىتى#,
			},
		},
		'Almaty' => {
			long => {
				'daylight' => q#الماتى جازعى ۋاقىتى#,
				'generic' => q#الماتى ۋاقىتى#,
				'standard' => q#الماتى ستاندارتتى ۋاقىتى#,
			},
			short => {
				'daylight' => q#الماتى قالاسى#,
				'generic' => q#الماتى#,
				'standard' => q#الماتى#,
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q#امازون جازعى ۋاقىتى#,
				'generic' => q#امازون ۋاقىتى#,
				'standard' => q#امازون ستاندارتتى ۋاقىتى#,
			},
		},
		'America/Adak' => {
			exemplarCity => q#اداك#,
		},
		'America/Anchorage' => {
			exemplarCity => q#انكوريج#,
		},
		'America/Anguilla' => {
			exemplarCity => q#انگيليا#,
		},
		'America/Antigua' => {
			exemplarCity => q#انتيگۋا#,
		},
		'America/Araguaina' => {
			exemplarCity => q#اراگۋاينا#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#لا-ريوحا#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#ريو-گالەگوس#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#سالتا#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#سان-حۋان#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#سان-لۋيس#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#تۋكۋمان#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#ۋشۋايا#,
		},
		'America/Aruba' => {
			exemplarCity => q#ارۋبا#,
		},
		'America/Asuncion' => {
			exemplarCity => q#اسۋنسيون#,
		},
		'America/Bahia' => {
			exemplarCity => q#بايا#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#بايا-دە-باندەراس#,
		},
		'America/Barbados' => {
			exemplarCity => q#باربادوس#,
		},
		'America/Belem' => {
			exemplarCity => q#بەلەم#,
		},
		'America/Belize' => {
			exemplarCity => q#بەليز#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#بلانك-سابلون#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#باو-ۆيستا#,
		},
		'America/Bogota' => {
			exemplarCity => q#بوگوتا#,
		},
		'America/Boise' => {
			exemplarCity => q#بويسە#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#بۋەنوس-ايروس#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#كەمبريج-بەي#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#كامپۋ-گراندە#,
		},
		'America/Cancun' => {
			exemplarCity => q#كانكۋن#,
		},
		'America/Caracas' => {
			exemplarCity => q#كاراكاس#,
		},
		'America/Catamarca' => {
			exemplarCity => q#كاتاماركا#,
		},
		'America/Cayenne' => {
			exemplarCity => q#كايەننا#,
		},
		'America/Cayman' => {
			exemplarCity => q#كايمان ارالدارى#,
		},
		'America/Chicago' => {
			exemplarCity => q#چيكاگو#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#چيۋاۋا#,
		},
		'America/Ciudad_Juarez' => {
			exemplarCity => q#سيۋداد-حۋارەس#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#اتيكوكان#,
		},
		'America/Cordoba' => {
			exemplarCity => q#كوردوبا#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#كوستا-ريكا#,
		},
		'America/Creston' => {
			exemplarCity => q#كرەستون#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#كۋيابا#,
		},
		'America/Curacao' => {
			exemplarCity => q#كيۋراساو#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#دانماركسحاۆن#,
		},
		'America/Dawson' => {
			exemplarCity => q#دوۋسون#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#دوۋسون-كريك#,
		},
		'America/Denver' => {
			exemplarCity => q#دەنۆەر#,
		},
		'America/Detroit' => {
			exemplarCity => q#دەترويد#,
		},
		'America/Dominica' => {
			exemplarCity => q#دومينيكا#,
		},
		'America/Edmonton' => {
			exemplarCity => q#ەدمونتون#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#ەيرۋنەپە#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#سالۆادور#,
		},
		'America/Fort_Nelson' => {
			exemplarCity => q#فورت-نەلسون#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#فورتالەزا#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#گلەيس-بەي#,
		},
		'America/Godthab' => {
			exemplarCity => q#نۋۋك#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#گۋس-بەي#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#گراند-تەرك#,
		},
		'America/Grenada' => {
			exemplarCity => q#گرەنادا#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#گۆادەلۇپا#,
		},
		'America/Guatemala' => {
			exemplarCity => q#گۆاتەمالا#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#گۋاياكيل#,
		},
		'America/Guyana' => {
			exemplarCity => q#گايانا#,
		},
		'America/Halifax' => {
			exemplarCity => q#گاليفاكس#,
		},
		'America/Havana' => {
			exemplarCity => q#گاۆانا#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#ەرموسيلو#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#نوكس، ينديانا#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#مارەنگو، ينديانا#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#پيتەرسبەرگ، ينديانا#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#تەلل-سيتي، ينديانا#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#ۆيۆەي، ينديانا#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#ۆينسەننەس، ينديانا#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#ۋيناماك، ينديانا#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#يندياناپوليس#,
		},
		'America/Inuvik' => {
			exemplarCity => q#ينۋۆيك#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#يكالۋيت#,
		},
		'America/Jamaica' => {
			exemplarCity => q#يامايكا#,
		},
		'America/Jujuy' => {
			exemplarCity => q#جۋجۋي#,
		},
		'America/Juneau' => {
			exemplarCity => q#جۋنو#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#مونتيسەللو، كەنتۋككي#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#كرالەندەيك#,
		},
		'America/La_Paz' => {
			exemplarCity => q#لا-پاس#,
		},
		'America/Lima' => {
			exemplarCity => q#ليما#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#لوس-انجەلەس#,
		},
		'America/Louisville' => {
			exemplarCity => q#لۋيسۆيل#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#لوۋەر-پرينس-كۋوتەر#,
		},
		'America/Maceio' => {
			exemplarCity => q#ماسەيو#,
		},
		'America/Managua' => {
			exemplarCity => q#ماناگۋا#,
		},
		'America/Manaus' => {
			exemplarCity => q#ماناۋس#,
		},
		'America/Marigot' => {
			exemplarCity => q#ماريگو#,
		},
		'America/Martinique' => {
			exemplarCity => q#مارتينيكا#,
		},
		'America/Matamoros' => {
			exemplarCity => q#ماتاموروس#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#ماساتلان#,
		},
		'America/Mendoza' => {
			exemplarCity => q#مەندوزا#,
		},
		'America/Menominee' => {
			exemplarCity => q#مەنوميني#,
		},
		'America/Merida' => {
			exemplarCity => q#مەريدا#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#مەتلاكاتلا#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#مەحيكو#,
		},
		'America/Miquelon' => {
			exemplarCity => q#ميكەلون#,
		},
		'America/Moncton' => {
			exemplarCity => q#مونكتون#,
		},
		'America/Monterrey' => {
			exemplarCity => q#مونتەررەي#,
		},
		'America/Montevideo' => {
			exemplarCity => q#مونتەۆيدەو#,
		},
		'America/Montserrat' => {
			exemplarCity => q#مونتسەررات#,
		},
		'America/Nassau' => {
			exemplarCity => q#ناسساۋ#,
		},
		'America/New_York' => {
			exemplarCity => q#نيۋ-يورك#,
		},
		'America/Nome' => {
			exemplarCity => q#نوم#,
		},
		'America/Noronha' => {
			exemplarCity => q#نورونيا#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#بويلا، سولتۇستىك داكوتا#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#سەنتەر، سولتۇستىك داكوتا#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#نيۋ-سەيلەم، سولتۇستىك داكوتا#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#وحيناگا#,
		},
		'America/Panama' => {
			exemplarCity => q#پاناما#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#پاراماريبو#,
		},
		'America/Phoenix' => {
			exemplarCity => q#فينيكس#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#پورت-وف-پرەنس#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#پورت-وف-سپاين#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#پورتو-ۆەليۋ#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#پۋەرتو-ريكو#,
		},
		'America/Punta_Arenas' => {
			exemplarCity => q#پۋنتا-ارەناس#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#رانكين-ينلەت#,
		},
		'America/Recife' => {
			exemplarCity => q#رەسيفي#,
		},
		'America/Regina' => {
			exemplarCity => q#رەجاينا#,
		},
		'America/Resolute' => {
			exemplarCity => q#رەزوليۋت#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#ريۋ-برانكۋ#,
		},
		'America/Santarem' => {
			exemplarCity => q#سانتارەن#,
		},
		'America/Santiago' => {
			exemplarCity => q#سانتياگو#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#سانتو-دومينگو#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#سان-پۋالۋ#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#يللوككورتوورميۋت#,
		},
		'America/Sitka' => {
			exemplarCity => q#سيتكا#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#سەن-بارتەلەمي#,
		},
		'America/St_Johns' => {
			exemplarCity => q#سەنت-جونس#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#سەنت-كيتس#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#سەنت-ليۋسيا#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#سەنت-توماس#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#سەنت-ۆينسەنت#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#سۋيات-كاررەنت#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#تەگۋسيگالپا#,
		},
		'America/Thule' => {
			exemplarCity => q#تۋلە#,
		},
		'America/Tijuana' => {
			exemplarCity => q#تيحۋانا#,
		},
		'America/Toronto' => {
			exemplarCity => q#تورونتو#,
		},
		'America/Tortola' => {
			exemplarCity => q#تورتولا#,
		},
		'America/Vancouver' => {
			exemplarCity => q#ۆانكۋۆەر#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#ۋايتحورس#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#ۆيننيپەگ#,
		},
		'America/Yakutat' => {
			exemplarCity => q#ياكۋتات#,
		},
		'America_Central' => {
			long => {
				'daylight' => q#ولتۇستىك امەريكا جازعى ورتالىق ۋاقىتى#,
				'generic' => q#سولتۇستىك امەريكا ورتالىق ۋاقىتى#,
				'standard' => q#سولتۇستىك امەريكا ستاندارتتى ورتالىق ۋاقىتى#,
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q#سولتۇستىك امەريكا جازعى شىعىس ۋاقىتى#,
				'generic' => q#سولتۇستىك امەريكا شىعىس ۋاقىتى#,
				'standard' => q#سولتۇستىك امەريكا ستاندارتتى شىعىس ۋاقىتى#,
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q#سولتۇستىك امەريكا جازعى تاۋ ۋاقىتى#,
				'generic' => q#سولتۇستىك امەريكا تاۋ ۋاقىتى#,
				'standard' => q#سولتۇستىك امەريكا ستاندارتتى تاۋ ۋاقىتى#,
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q#سولتۇستىك امەريكا جازعى تىنىق مۇحيتى ۋاقىتى#,
				'generic' => q#سولتۇستىك امەريكا تىنىق مۇحيتى ۋاقىتى#,
				'standard' => q#سولتۇستىك امەريكا ستاندارتتى تىنىق مۇحيتى ۋاقىتى#,
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#كەيسي#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#دەيۆيس#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#ديۋمون-ديۋرۆيل#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#ماككۋوري#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#موۋسون#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#ماك-مەردو#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#پالمەر#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#روتەرا#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#سەۆا#,
		},
		'Antarctica/Troll' => {
			exemplarCity => q#ترول#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#ۆوستوك#,
		},
		'Apia' => {
			long => {
				'daylight' => q#اپيا جازعى ۋاقىتى#,
				'generic' => q#اپيا ۋاقىتى#,
				'standard' => q#اپيا ستاندارتتى ۋاقىتى#,
			},
		},
		'Aqtau' => {
			long => {
				'daylight' => q#اقتاۋ جازعى ۋاقىتى#,
				'generic' => q#اقتاۋ ۋاقىتى#,
				'standard' => q#اقتاۋ ستاندارتتى ۋاقىتى#,
			},
			short => {
				'daylight' => q#اقتاۋ قالاسى#,
				'generic' => q#اقتاۋ#,
				'standard' => q#اقتاۋ#,
			},
		},
		'Aqtobe' => {
			long => {
				'daylight' => q#اقتوبە جازعى ۋاقىتى#,
				'generic' => q#اقتوبە ۋاقىتى#,
				'standard' => q#اقتوبە ستاندارتتى ۋاقىتى#,
			},
			short => {
				'daylight' => q#اقتوبە قالاسى#,
				'generic' => q#اقتوبە#,
				'standard' => q#اقتوبە#,
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q#ساۋد ارابياسى جازعى ۋاقىتى#,
				'generic' => q#ساۋد ارابياسى ۋاقىتى#,
				'standard' => q#ساۋد ارابياسى ستاندارتتى ۋاقىتى#,
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#لونگير#,
		},
		'Argentina' => {
			long => {
				'daylight' => q#ارگەنتينا جازعى ۋاقىتى#,
				'generic' => q#ارگەنتينا ۋاقىتى#,
				'standard' => q#ارگەنتينا ستاندارتتى ۋاقىتى#,
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q#باتىس ارگەنتينا جازعى ۋاقىتى#,
				'generic' => q#باتىس ارگەنتينا ۋاقىتى#,
				'standard' => q#باتىس ارگەنتينا ستاندارتتى ۋاقىتى#,
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q#ارمەنيا جازعى ۋاقىتى#,
				'generic' => q#ارمەنيا ۋاقىتى#,
				'standard' => q#ارمەنيا ستاندارتتى ۋاقىتى#,
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#ادەن#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#الماتى#,
		},
		'Asia/Amman' => {
			exemplarCity => q#اممان#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#انادىر#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#اقتاۋ#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#اقتوبە#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#اشحابات#,
		},
		'Asia/Atyrau' => {
			exemplarCity => q#اتىراۋ#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#باگدات#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#باحرەين#,
		},
		'Asia/Baku' => {
			exemplarCity => q#باكۋ#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#باڭكوك#,
		},
		'Asia/Barnaul' => {
			exemplarCity => q#بارناۋىل#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#بەيرۋت#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#بىشكەك#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#برۋنەي#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#كالكۋتا#,
		},
		'Asia/Chita' => {
			exemplarCity => q#چيتا#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#كولومبو#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#داماسك#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#داككا#,
		},
		'Asia/Dili' => {
			exemplarCity => q#ديلي#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#دۋباي#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#دۋشانبە#,
		},
		'Asia/Famagusta' => {
			exemplarCity => q#فاماگۋستا#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#گازا#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#حەۆرون#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#حوڭكوڭ#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#حوۆد#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#يركۋتسك#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#جاكارتا#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#جاياپۋرا#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#يەرۋساليم#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#كابۋل#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#كامچاتكا#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#كاراچا#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#كاتماندۋ#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#حاندىگا#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#كراسنويارسك#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#كۋالا-لۋمپۋر#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#كۋچيڭ#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#كۋۆەيت#,
		},
		'Asia/Macau' => {
			exemplarCity => q#ماكاو#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#ماگادان#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#ماكاسار#,
		},
		'Asia/Manila' => {
			exemplarCity => q#مانيلا#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#ماسكات#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#نيكوسيا#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#نوۆوكۋزنەتسك#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#جاڭاسىبىر#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#ومبى#,
		},
		'Asia/Oral' => {
			exemplarCity => q#ورال#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#پنومپەن#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#پونتياناك#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#پحەنيان#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#كاتار#,
		},
		'Asia/Qostanay' => {
			exemplarCity => q#قوستاناي#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#قىزىلوردا#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#يانگون#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#ەر-رياد#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#حوشيمين#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#ساحالين#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#سامارقاند#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#سەۋل#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#شانحاي#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#سينگاپۋر#,
		},
		'Asia/Srednekolymsk' => {
			exemplarCity => q#سرەدنەكولىمسك#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#تايبەي#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#تاشكەنت#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#تبيليسي#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#تەگەران#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#تحيمپحۋ#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#توكيو#,
		},
		'Asia/Tomsk' => {
			exemplarCity => q#تۋمەن#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#ۇلانباتىر#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#ءۇرىمشى#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#ۋست-نەرا#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#ۆەنتيان#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#ۆلاديۆاستوك#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#ياكۋتسك#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#ەكاتەرينبۋرگ#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#يەرەۆان#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q#اتلانتيكا جازعى ۋاقىتى#,
				'generic' => q#اتلانتيكا ۋاقىتى#,
				'standard' => q#اتلانتيكا ستاندارتتى ۋاقىتى#,
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#ازور ارالدارى#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#بەرمۋد ارالدارى#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#كانار ارالدارى#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#كابو-ۆەردە#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#فارەر ارالدارى#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#مادەيرا#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#رەيكياۆيك#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#وڭتۇستىك گەورگيا#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#اۋليە ەلەنا ارالى#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#ستەنلي#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#ادەلايدا#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#بريسبەن#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#بروكەن-حيل#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#دارۆين#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#يۋكلا#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#حوبارت#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#ليندەمان#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#لورد-حاۋ#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#مەلبۋرن#,
		},
		'Australia/Perth' => {
			exemplarCity => q#پەرت#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#سيدنەي#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q#اۋستراليا جازعى ورتالىق ۋاقىتى#,
				'generic' => q#ورتالىق اۋستراليا ۋاقىتى#,
				'standard' => q#اۋستراليا ستاندارتتى ورتالىق ۋاقىتى#,
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q#اۋستراليا جازعى ورتالىق-باتىس ۋاقىتى#,
				'generic' => q#اۋستراليا ورتالىق-باتىس ۋاقىتى#,
				'standard' => q#اۋستراليا ستاندارتتى ورتالىق-باتىس ۋاقىتى#,
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q#اۋستراليا جازعى شىعىس ۋاقىتى#,
				'generic' => q#شىعىس اۋستراليا ۋاقىتى#,
				'standard' => q#اۋستراليا ستاندارتتى شىعىس ۋاقىتى#,
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q#اۋستراليا جازعى باتىس ۋاقىتى#,
				'generic' => q#باتىس اۋستراليا ۋاقىتى#,
				'standard' => q#اۋستراليا ستاندارتتى باتىس ۋاقىتى#,
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q#ءازىربايجان جازعى ۋاقىتى#,
				'generic' => q#ءازىربايجان ۋاقىتى#,
				'standard' => q#ءازىربايجان ستاندارتتى ۋاقىتى#,
			},
		},
		'Azores' => {
			long => {
				'daylight' => q#ازور ارالدارى جازعى ۋاقىتى#,
				'generic' => q#ازور ارالدارى ۋاقىتى#,
				'standard' => q#ازور ارالدارى ستاندارتتى ۋاقىتى#,
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q#بانگلادەش جازعى ۋاقىتى#,
				'generic' => q#بانگلادەش ۋاقىتى#,
				'standard' => q#بانگلادەش ستاندارتتى ۋاقىتى#,
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q#بۋتان ۋاقىتى#,
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q#بوليۆيا ۋاقىتى#,
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q#برازيليا جازعى ۋاقىتى#,
				'generic' => q#برازيليا ۋاقىتى#,
				'standard' => q#برازيليا ستاندارتتى ۋاقىتى#,
			},
		},
		'Brunei' => {
			long => {
				'standard' => q#برۋنەي-دارۋسسالام ۋاقىتى#,
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q#كابو-ۆەردە جازعى ۋاقىتى#,
				'generic' => q#كابو-ۆەردە ۋاقىتى#,
				'standard' => q#كابو-ۆەردە ستاندارتتى ۋاقىتى#,
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q#چاموررو ستاندارتتى ۋاقىتى#,
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q#چاتەم جازعى ۋاقىتى#,
				'generic' => q#چاتەم ۋاقىتى#,
				'standard' => q#چاتەم ستاندارتتى ۋاقىتى#,
			},
		},
		'Chile' => {
			long => {
				'daylight' => q#چيلي جازعى ۋاقىتى#,
				'generic' => q#چيلي ۋاقىتى#,
				'standard' => q#چيلي ستاندارتتى ۋاقىتى#,
			},
		},
		'China' => {
			long => {
				'daylight' => q#قىتاي جازعى ۋاقىتى#,
				'generic' => q#قىتاي ۋاقىتى#,
				'standard' => q#قىتاي ستاندارتتى ۋاقىتى#,
			},
		},
		'Christmas' => {
			long => {
				'standard' => q#كريستماس ارالىنىڭ ۋاقىتى#,
			},
		},
		'Cocos' => {
			long => {
				'standard' => q#كوكوس ارالدارىنىڭ ۋاقىتى#,
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q#كولۋمبيا جازعى ۋاقىتى#,
				'generic' => q#كولۋمبيا ۋاقىتى#,
				'standard' => q#كولۋمبيا ستاندارتتى ۋاقىتى#,
			},
		},
		'Cook' => {
			long => {
				'daylight' => q#كۋك ارالدارىنىڭ جازعى ۋاقىتى#,
				'generic' => q#كۋك ارالدارىنىڭ ۋاقىتى#,
				'standard' => q#كۋك ارالدارىنىڭ ستاندارتتى ۋاقىتى#,
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q#كۋبا جازعى ۋاقىتى#,
				'generic' => q#كۋبا ۋاقىتى#,
				'standard' => q#كۋبا ستاندارتتى ۋاقىتى#,
			},
		},
		'Davis' => {
			long => {
				'standard' => q#دەيۆيس ۋاقىتى#,
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q#ديۋمون-ديۋرۆيل ۋاقىتى#,
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q#شىعىس تيمور ۋاقىتى#,
			},
		},
		'Easter' => {
			long => {
				'daylight' => q#پاسحا ارالى جازعى ۋاقىتى#,
				'generic' => q#پاسحا ارالى ۋاقىتى#,
				'standard' => q#پاسحا ارالى ستاندارتتى ۋاقىتى#,
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q#ەكۆادور ۋاقىتى#,
			},
		},
		'Etc/UTC' => {
			long => {
				'standard' => q#دۇنيەجۇزىلىك ۇيلەستىرىلگەن ۋاقىت#,
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#بەلگىسىز قالا#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#امستەردام#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#اندوررا#,
		},
		'Europe/Astrakhan' => {
			exemplarCity => q#استراحان#,
		},
		'Europe/Athens' => {
			exemplarCity => q#افينا#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#بەلگراد#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#بەرلين#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#براتيسلاۆا#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#بريۋسەل#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#بۋحارەست#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#بۋداپەشت#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#بيۋزينگەن#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#كيشينەۆ#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#كوپەنگاگەن#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#دۋبلين#,
			long => {
				'daylight' => q#يرلانديا ستاندارتتى ۋاقىتى#,
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#گيبرالتال#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#گەرنسي#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#حەلسينكي#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#مەن ارالى#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#ستامبۇل#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#جەرسەي#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#كالينينگراد#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#كيەۆ#,
		},
		'Europe/Kirov' => {
			exemplarCity => q#كيروۆ#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#ليسابون#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#ليۋبليانا#,
		},
		'Europe/London' => {
			exemplarCity => q#لوندون#,
			long => {
				'daylight' => q#ۇلىبريتانيا جازعى ۋاقىتى#,
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#ليۋكسەمبۋرگ#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#مادريد#,
		},
		'Europe/Malta' => {
			exemplarCity => q#مالتا#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#ماريەحامن#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#مينسك#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#موناكو#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#ماسكەۋ#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#وسلو#,
		},
		'Europe/Paris' => {
			exemplarCity => q#پاريج#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#پودگوريسا#,
		},
		'Europe/Prague' => {
			exemplarCity => q#پراگا#,
		},
		'Europe/Riga' => {
			exemplarCity => q#ريگا#,
		},
		'Europe/Rome' => {
			exemplarCity => q#ريم#,
		},
		'Europe/Samara' => {
			exemplarCity => q#سامارا#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#سان-مارينو#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#ساراەۆو#,
		},
		'Europe/Saratov' => {
			exemplarCity => q#سارىتاۋ#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#سيمفەرول#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#سكوپيە#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#سوفيا#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#ستوكگولىم#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#تاللين#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#تيرانا#,
		},
		'Europe/Ulyanovsk' => {
			exemplarCity => q#ۋليانوۆسك#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#ۆادۋس#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#ۆاتيكان#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#ۆەنا#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#ۆينيۋس#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#ۆولگوگراد#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#ۆارشاۆا#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#زاگرەب#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#سيۋريح#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q#ورتالىق ەۋروپا جازعى ۋاقىتى#,
				'generic' => q#ورتالىق ەۋروپا ۋاقىتى#,
				'standard' => q#ورتالىق ەۋروپا ستاندارتتى ۋاقىتى#,
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q#شىعىس ەۋروپا جازعى ۋاقىتى#,
				'generic' => q#شىعىس ەۋروپا ۋاقىتى#,
				'standard' => q#شىعىس ەۋروپا ستاندارتتى ۋاقىتى#,
			},
		},
		'Europe_Further_Eastern' => {
			long => {
				'standard' => q#قيىر شىعىس ەۋروپا ۋاقىتى#,
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q#باتىس ەۋروپا جازعى ۋاقىتى#,
				'generic' => q#باتىس ەۋروپا ۋاقىتى#,
				'standard' => q#باتىس ەۋروپا ستاندارتتى ۋاقىتى#,
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q#فولكلەند ارالدارى جازعى ۋاقىتى#,
				'generic' => q#فولكلەند ارالدارى ۋاقىتى#,
				'standard' => q#فولكلەند ارالدارى ستاندارتتى ۋاقىتى#,
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q#فيجي جازعى ۋاقىتى#,
				'generic' => q#فيجي ۋاقىتى#,
				'standard' => q#فيجي ستاندارتتى ۋاقىتى#,
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q#فرانتسۋز گۆياناسى ۋاقىتى#,
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q#فرانتسيانىڭ وڭتۇستىك ايماعى جانە انتاركتيكا ۋاقىتى#,
			},
		},
		'GMT' => {
			long => {
				'standard' => q#گرينۆيچ ۋاقىتى#,
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q#گالاپاگوس ۋاقىتى#,
			},
		},
		'Gambier' => {
			long => {
				'standard' => q#گامبە ۋاقىتى#,
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q#گرۋزيا جازعى ۋاقىتى#,
				'generic' => q#گرۋزيا ۋاقىتى#,
				'standard' => q#گرۋزيا ستاندارتتى ۋاقىتى#,
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q#گيلبەرت ارالدارىنىڭ ۋاقىتى#,
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q#شىعىس گرەنلانديا جازعى ۋاقىتى#,
				'generic' => q#شىعىس گرەنلانديا ۋاقىتى#,
				'standard' => q#شىعىس گرەنلانديا ستاندارتتى ۋاقىتى#,
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q#باتىس گرەنلانديا جازعى ۋاقىتى#,
				'generic' => q#باتىس گرەنلانديا ۋاقىتى#,
				'standard' => q#باتىس گرەنلانديا ستاندارتتى ۋاقىتى#,
			},
		},
		'Gulf' => {
			long => {
				'standard' => q#پارسى شىعاناعى ستاندارتتى ۋاقىتى#,
			},
		},
		'Guyana' => {
			long => {
				'standard' => q#گايانا ۋاقىتى#,
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q#گاۆاي جانە الەۋت ارالدارى جازعى ۋاقىتى#,
				'generic' => q#گاۆاي جانە الەۋت ارالدارى ۋاقىتى#,
				'standard' => q#گاۆاي جانە الەۋت ارالدارى ستاندارتتى ۋاقىتى#,
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q#حوڭكوڭ جازعى ۋاقىتى#,
				'generic' => q#حوڭكوڭ ۋاقىتى#,
				'standard' => q#حوڭكوڭ ستاندارتتى ۋاقىتى#,
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q#حوۆد جازعى ۋاقىتى#,
				'generic' => q#حوۆد ۋاقىتى#,
				'standard' => q#حوۆد ستاندارتتى ۋاقىتى#,
			},
		},
		'India' => {
			long => {
				'standard' => q#ءۇندىستان ستاندارتتى ۋاقىتى#,
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#انتاناناريۆۋ#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#چاگوس#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#كريستماس ارالدارى#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#كوكوس ارالدارى#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#كومور ارالدارى#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#كەرگەلەن#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#ماە#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#مالديۆ ارالدارى#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#ماۆريكي#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#مايوتتا#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#رەيۋنيون#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q#ءۇندى مۇحيتى ۋاقىتى#,
			},
		},
		'Indochina' => {
			long => {
				'standard' => q#ءۇندى-قىتاي ۋاقىتى#,
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q#ورتالىق يندونەزيا ۋاقىتى#,
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q#شىعىس يندونەزيا ۋاقىتى#,
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q#باتىس يندونەزيا ۋاقىتى#,
			},
		},
		'Iran' => {
			long => {
				'daylight' => q#يران جازعى ۋاقىتى#,
				'generic' => q#يران ۋاقىتى#,
				'standard' => q#يران ستاندارتتى ۋاقىتى#,
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q#يركۋتسك جازعى ۋاقىتى#,
				'generic' => q#يركۋتسك ۋاقىتى#,
				'standard' => q#يركۋتسك ستاندارتتى ۋاقىتى#,
			},
		},
		'Israel' => {
			long => {
				'daylight' => q#يزرايل جازعى ۋاقىتى#,
				'generic' => q#يزرايل ۋاقىتى#,
				'standard' => q#يزرايل ستاندارتتى ۋاقىتى#,
			},
		},
		'Japan' => {
			long => {
				'daylight' => q#جاپونيا جازعى ۋاقىتى#,
				'generic' => q#جاپونيا ۋاقىتى#,
				'standard' => q#جاپونيا ستاندارتتى ۋاقىتى#,
			},
		},
		'Kazakhstan' => {
			long => {
				'standard' => q#قازاق ەلى ۋاقىتى#,
			},
			short => {
				'standard' => q#قازاق ەلى#,
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q#شىعىس قازاق ەلى ۋاقىتى#,
			},
			short => {
				'standard' => q#شىعىش قازاق ەلى#,
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q#باتىس قازاق ەلى ۋاقىتى#,
			},
			short => {
				'standard' => q#باتىس قازاق ەلى#,
			},
		},
		'Korea' => {
			long => {
				'daylight' => q#كورەيا جازعى ۋاقىتى#,
				'generic' => q#كورەيا ۋاقىتى#,
				'standard' => q#كورەيا ستاندارتتى ۋاقىتى#,
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q#كۋسايە ۋاقىتى#,
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q#كراسنويارسك جازعى ۋاقىتى#,
				'generic' => q#كراسنويارسك ۋاقىتى#,
				'standard' => q#كراسنويارسك ستاندارتتى ۋاقىتى#,
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q#قىرعىزستان ۋاقىتى#,
			},
			short => {
				'standard' => q#قىرعىزستان#,
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q#لاين ارالدارى ۋاقىتى#,
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q#لورد-حاۋ جازعى ۋاقىتى#,
				'generic' => q#لورد-حاۋ ۋاقىتى#,
				'standard' => q#لورد-حاۋ ستاندارتتى ۋاقىتى#,
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q#ماگادان جازعى ۋاقىتى#,
				'generic' => q#ماگادان ۋاقىتى#,
				'standard' => q#ماگادان ستاندارتتى ۋاقىتى#,
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q#مالايزيا ۋاقىتى#,
			},
		},
		'Maldives' => {
			long => {
				'standard' => q#مالديۆ ارالدارى ۋاقىتى#,
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q#ماركيز ارالدارى ۋاقىتى#,
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q#مارشال ارالدارى ۋاقىتى#,
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q#ماۆريكيي جازعى ۋاقىتى#,
				'generic' => q#ماۆريكيي ۋاقىتى#,
				'standard' => q#ماۆريكيي ستاندارتتى ۋاقىتى#,
			},
		},
		'Mawson' => {
			long => {
				'standard' => q#موۋسون ۋاقىتى#,
			},
		},
		'Mexico_Pacific' => {
			long => {
				'daylight' => q#مەكسيكا جازعى تىنىق مۇحيت ۋاقىتى#,
				'generic' => q#مەكسيكا تىنىق مۇحيت ۋاقىتى#,
				'standard' => q#مەكسيكا ستاندارتتى تىنىق مۇحيت ۋاقىتى#,
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q#ۇلانباتىر جازعى ۋاقىتى#,
				'generic' => q#ۇلانباتىر ۋاقىتى#,
				'standard' => q#ۇلانباتىر ستاندارتتى ۋاقىتى#,
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q#ماسكەۋ جازعى ۋاقىتى#,
				'generic' => q#ماسكەۋ ۋاقىتى#,
				'standard' => q#ماسكەۋ ستاندارتتى ۋاقىتى#,
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q#ميانما ۋاقىتى#,
			},
		},
		'Nauru' => {
			long => {
				'standard' => q#ناۋرۋ ۋاقىتى#,
			},
		},
		'Nepal' => {
			long => {
				'standard' => q#نەپال ۋاقىتى#,
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q#جاڭا كالەدونيا جازعى ۋاقىتى#,
				'generic' => q#جاڭا كالەدونيا ۋاقىتى#,
				'standard' => q#جاڭا كالەدونيا ستاندارتتى ۋاقىتى#,
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q#جاڭا زەلانديا جازعى ۋاقىتى#,
				'generic' => q#جاڭا زەلانديا ۋاقىتى#,
				'standard' => q#جاڭا زەلانديا ستاندارتتى ۋاقىتى#,
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q#نيۋفاۋندلەند جازعى ۋاقىتى#,
				'generic' => q#نيۋفاۋندلەند ۋاقىتى#,
				'standard' => q#نيۋفاۋندلەند ستاندارتتى ۋاقىتى#,
			},
		},
		'Niue' => {
			long => {
				'standard' => q#نيۋە ۋاقىتى#,
			},
		},
		'Norfolk' => {
			long => {
				'daylight' => q#نورفولك ارالى جازعى ۋاقىتى#,
				'generic' => q#نورفولك ارالى ۋاقىتى#,
				'standard' => q#نورفولك ارالى ستاندارتتى ۋاقىتى#,
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q#فەرناندۋ-دي-نورونيا جازعى ۋاقىتى#,
				'generic' => q#فەرناندۋ-دي-نورونيا ۋاقىتى#,
				'standard' => q#فەرناندۋ-دي-نورونيا ستاندارتتى ۋاقىتى#,
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q#جاڭاسىبىر جازعى ۋاقىتى#,
				'generic' => q#جاڭاسىبىر ۋاقىتى#,
				'standard' => q#جاڭاسىبىر ستاندارتتى ۋاقىتى#,
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q#ومبى جازعى ۋاقىتى#,
				'generic' => q#ومبى ۋاقىتى#,
				'standard' => q#ومبى ستاندارتتى ۋاقىتى#,
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#اپيا#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#وكلەند#,
		},
		'Pacific/Bougainville' => {
			exemplarCity => q#بۋگەنۆيل#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#چاتەم#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#پاسحا ارالى#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#ەفاتە#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#فاكاوفو#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#فيجي#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#فۋنافۋتي#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#گالاپاگوس#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#گامبيە#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#گۋادالكانال#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#گۋام#,
		},
		'Pacific/Kanton' => {
			exemplarCity => q#كانتون#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#كيريتيماتي#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#كۋسايە#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#كۆاجالەيىن#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#ماجۋرو#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#ماركيز ارالدارى#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#ميدۋەي#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#ناۋرۋ#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#نيۋە#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#نورفولك#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#نۋمەا#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#پاگو-پاگو#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#پالاۋ#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#پيتكەرن#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#پوناپە#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#پورت-مورسبي#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#راروتونگا#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#سايپان#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#تايتي#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#تاراۋا#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#تونگاتاپۋ#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#ترۋك#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#ۋەيك#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#ۋولليس#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q#پاكىستان جازعى ۋاقىتى#,
				'generic' => q#پاكىستان ۋاقىتى#,
				'standard' => q#پاكىستان ستاندارتتى ۋاقىتى#,
			},
		},
		'Palau' => {
			long => {
				'standard' => q#پالاۋ ۋاقىتى#,
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q#پاپۋا – جاڭا گۆينەيا ۋاقىتى#,
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q#پاراگۆاي جازعى ۋاقىتى#,
				'generic' => q#پاراگۆاي ۋاقىتى#,
				'standard' => q#پاراگۆاي ستاندارتتى ۋاقىتى#,
			},
		},
		'Peru' => {
			long => {
				'daylight' => q#پەرۋ جازعى ۋاقىتى#,
				'generic' => q#پەرۋ ۋاقىتى#,
				'standard' => q#پەرۋ ستاندارتتى ۋاقىتى#,
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q#فيليپين ارالدارى جازعى ۋاقىتى#,
				'generic' => q#فيليپين ارالدارى ۋاقىتى#,
				'standard' => q#فيليپين ارالدارى ستاندارتتى ۋاقىتى#,
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q#فەنيكس ارالدارى ۋاقىتى#,
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q#سەن-پەر جانە ميكەلون جازعى ۋاقىتى#,
				'generic' => q#سەن-پەر جانە ميكەلون ۋاقىتى#,
				'standard' => q#سەن-پەر جانە ميكەلون ستاندارتتى ۋاقىتى#,
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q#پيتكەرن ۋاقىتى#,
			},
		},
		'Ponape' => {
			long => {
				'standard' => q#پونپەي ۋاقىتى#,
			},
		},
		'Pyongyang' => {
			long => {
				'standard' => q#پحەنيان ۋاقىتى#,
			},
		},
		'Qyzylorda' => {
			long => {
				'daylight' => q#قىزىلوردا جازعى ۋاقىتى#,
				'generic' => q#قىزىلوردا ۋاقىتى#,
				'standard' => q#قىزىلوردا ستاندارتتى ۋاقىتى#,
			},
			short => {
				'daylight' => q#قىزىلوردا قالاسى#,
				'generic' => q#قىزىلوردا#,
				'standard' => q#قىزىلوردا#,
			},
		},
		'Reunion' => {
			long => {
				'standard' => q#رەيۋنون ۋاقىتى#,
			},
		},
		'Rothera' => {
			long => {
				'standard' => q#روتەرا ۋقىتى#,
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q#ساحالين جازعى ۋاقىتى#,
				'generic' => q#ساحالين ۋاقىتى#,
				'standard' => q#ساحالين ستاندارتتى ۋاقىتى#,
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q#ساموا جازعى ۋاقىتى#,
				'generic' => q#ساموا ۋاقىتى#,
				'standard' => q#ساموا ستاندارتتى ۋاقىتى#,
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q#سەيشەل ارالدارى ۋاقىتى#,
			},
		},
		'Singapore' => {
			long => {
				'standard' => q#سينگاپۋر ستاندارتتى ۋاقىتى#,
			},
		},
		'Solomon' => {
			long => {
				'standard' => q#سولومون ارالدارى ۋاقىتى#,
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q#وڭتۇستىك گەورگيا ۋاقىتى#,
			},
		},
		'Suriname' => {
			long => {
				'standard' => q#سۋرينام ۋاقىتى#,
			},
		},
		'Syowa' => {
			long => {
				'standard' => q#سەۆا ۋاقىتى#,
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q#تايتي ۋاقىتى#,
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q#تايبەي جازعى ۋاقىتى#,
				'generic' => q#تايبەي ۋاقىتى#,
				'standard' => q#تايبەي ستاندارتتى ۋاقىتى#,
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q#تاجىكستان ۋاقىتى#,
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q#توكەلاۋ ۋاقىتى#,
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q#تونگا كازعى ۋاقىتى#,
				'generic' => q#تونگا ۋاقىتى#,
				'standard' => q#تونگا ستاندارتتى ۋاقىتى#,
			},
		},
		'Truk' => {
			long => {
				'standard' => q#ترۋك ۋاقىتى#,
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q#تۇرىكمەنستان جازعى ۋاقىتى#,
				'generic' => q#تۇرىكمەنستان ۋاقىتى#,
				'standard' => q#تۇرىكمەنستان ستاندارتتى ۋاقىتى#,
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q#تۋۆالۋ ۋاقىتى#,
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q#ۋرۋگۆاي جازعى ۋاقىتى#,
				'generic' => q#ۋرۋگۆاي ۋاقىتى#,
				'standard' => q#ۋرۋگۆاي ستاندارتتى ۋاقىتى#,
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q#وزبەكستان جازعى ۋاقىتى#,
				'generic' => q#وزبەكستان ۋاقىتى#,
				'standard' => q#وزبەكستان ستاندارتتى ۋاقىتى#,
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q#ۆانۋاتۋ جازعى ۋاقىتى#,
				'generic' => q#ۆانۋاتۋ ۋاقىتى#,
				'standard' => q#ۆانۋاتۋ ستاندارتتى ۋاقىتى#,
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q#ۆەنەسۋەلا ۋاقىتى#,
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q#ۆلاديۆوستوك جازعى ۋاقىتى#,
				'generic' => q#ۆلاديۆوستوك ۋاقىتى#,
				'standard' => q#ۆلاديۆوستوك ستاندارتتى ۋاقىتى#,
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q#ۆولگوگراد جازعى ۋاقىتى#,
				'generic' => q#ۆولگوگراد ۋاقىتى#,
				'standard' => q#ۆولگوگراد ستاندارتتى ۋاقىتى#,
			},
		},
		'Vostok' => {
			long => {
				'standard' => q#ۆوستوك ۋاقىتى#,
			},
		},
		'Wake' => {
			long => {
				'standard' => q#ۋەيك ارالى ۋاقىتى#,
			},
		},
		'Wallis' => {
			long => {
				'standard' => q#ۋولليس جانە فۋتۋنا ۋاقىتى#,
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q#ياكۋتسك جازعى ۋاقىتى#,
				'generic' => q#ياكۋتسك ۋاقىتى#,
				'standard' => q#ياكۋتسك ستاندارتتى ۋاقىتى#,
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q#ەكاتەرينبۋرگ جازعى ۋاقىتى#,
				'generic' => q#ەكاتەرينبۋرگ ۋاقىتى#,
				'standard' => q#ەكاتەرينبۋرگ ستاندارتتى ۋاقىتى#,
			},
		},
		'Yukon' => {
			long => {
				'standard' => q#يۋكون ۋاقىتى#,
			},
		},
	 } }
);
no Moo;

1;

# vim: tabstop=4
