# Generated by default/object.tt
package Paws::ApplicationMigration::SourceProperties;
  use Moose;
  has Cpus => (is => 'ro', isa => 'ArrayRef[Paws::ApplicationMigration::CPU]', request_name => 'cpus', traits => ['NameInRequest']);
  has Disks => (is => 'ro', isa => 'ArrayRef[Paws::ApplicationMigration::Disk]', request_name => 'disks', traits => ['NameInRequest']);
  has IdentificationHints => (is => 'ro', isa => 'Paws::ApplicationMigration::IdentificationHints', request_name => 'identificationHints', traits => ['NameInRequest']);
  has LastUpdatedDateTime => (is => 'ro', isa => 'Str', request_name => 'lastUpdatedDateTime', traits => ['NameInRequest']);
  has NetworkInterfaces => (is => 'ro', isa => 'ArrayRef[Paws::ApplicationMigration::NetworkInterface]', request_name => 'networkInterfaces', traits => ['NameInRequest']);
  has Os => (is => 'ro', isa => 'Paws::ApplicationMigration::OS', request_name => 'os', traits => ['NameInRequest']);
  has RamBytes => (is => 'ro', isa => 'Int', request_name => 'ramBytes', traits => ['NameInRequest']);
  has RecommendedInstanceType => (is => 'ro', isa => 'Str', request_name => 'recommendedInstanceType', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::ApplicationMigration::SourceProperties

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ApplicationMigration::SourceProperties object:

  $service_obj->Method(Att1 => { Cpus => $value, ..., RecommendedInstanceType => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ApplicationMigration::SourceProperties object:

  $result = $service_obj->Method(...);
  $result->Att1->Cpus

=head1 DESCRIPTION

Source server properties.

=head1 ATTRIBUTES


=head2 Cpus => ArrayRef[L<Paws::ApplicationMigration::CPU>]

Source Server CPUs.


=head2 Disks => ArrayRef[L<Paws::ApplicationMigration::Disk>]

Source Server disks.


=head2 IdentificationHints => L<Paws::ApplicationMigration::IdentificationHints>

Source server identification hints.


=head2 LastUpdatedDateTime => Str

Source server last update date and time.


=head2 NetworkInterfaces => ArrayRef[L<Paws::ApplicationMigration::NetworkInterface>]

Source server network interfaces.


=head2 Os => L<Paws::ApplicationMigration::OS>

Source server OS.


=head2 RamBytes => Int

Source server RAM in bytes.


=head2 RecommendedInstanceType => Str

Source server recommended instance type.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ApplicationMigration>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

