package Net::Amazon::EMR::EbsBlockDeviceConfig;
use Moose;
with 'Net::Amazon::EMR::Role::AttrHash';
use Net::Amazon::EMR::Coercions;

has 'VolumeSpecification' => ( is => 'ro',
                               isa => 'Net::Amazon::EMR::Type::VolumeSpecification',
                               coerce => 1,
                               required => 1,
                           );

has 'VolumesPerInstance' => ( is => 'ro', 
                              isa => 'Int' );


__PACKAGE__->meta->make_immutable();

1;

__END__

=head1 NAME

Net::Amazon::EMR::EbsBlockDeviceConfig

=head1 DESCRIPTION

Implements the EbsBlockDeviceConfig data type described at L<http://docs.amazonwebservices.com/ElasticMapReduce/latest/APIReference/API_EbsBlockDeviceConfig.html>.

=head1 AUTHOR

Jon Schutz 

L<http://notes.jschutz.net>

=head1 DOCUMENTATION, LICENSE AND COPYRIGHT

See L<Net::Amazon::EMR>.

=cut
