# Generated by default/object.tt
package Paws::Budgets::Definition;
  use Moose;
  has IamActionDefinition => (is => 'ro', isa => 'Paws::Budgets::IamActionDefinition');
  has ScpActionDefinition => (is => 'ro', isa => 'Paws::Budgets::ScpActionDefinition');
  has SsmActionDefinition => (is => 'ro', isa => 'Paws::Budgets::SsmActionDefinition');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Budgets::Definition

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Budgets::Definition object:

  $service_obj->Method(Att1 => { IamActionDefinition => $value, ..., SsmActionDefinition => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Budgets::Definition object:

  $result = $service_obj->Method(...);
  $result->Att1->IamActionDefinition

=head1 DESCRIPTION

Specifies all of the type-specific parameters.

=head1 ATTRIBUTES


=head2 IamActionDefinition => L<Paws::Budgets::IamActionDefinition>

The AWS Identity and Access Management (IAM) action definition details.


=head2 ScpActionDefinition => L<Paws::Budgets::ScpActionDefinition>

The service control policies (SCPs) action definition details.


=head2 SsmActionDefinition => L<Paws::Budgets::SsmActionDefinition>

The AWS Systems Manager (SSM) action definition details.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Budgets>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

