/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common;

public final class BitArray {
    public int[] bits;
    public int size;

    public BitArray() {
        this.size = 0;
        this.bits = new int[1];
    }

    public BitArray(int n) {
        this.size = n;
        this.bits = BitArray.makeArray(n);
    }

    public int getSize() {
        return this.size;
    }

    public int getSizeInBytes() {
        return this.size + 7 >> 3;
    }

    private void ensureCapacity(int n) {
        if (n > this.bits.length << 5) {
            int[] nArray = BitArray.makeArray(n);
            System.arraycopy(this.bits, 0, nArray, 0, this.bits.length);
            this.bits = nArray;
        }
    }

    public boolean get(int n) {
        return (this.bits[n >> 5] & 1 << (n & 0x1F)) != 0;
    }

    public void set(int n) {
        int n2 = n >> 5;
        this.bits[n2] = this.bits[n2] | 1 << (n & 0x1F);
    }

    public void flip(int n) {
        int n2 = n >> 5;
        this.bits[n2] = this.bits[n2] ^ 1 << (n & 0x1F);
    }

    public void setBulk(int n, int n2) {
        this.bits[n >> 5] = n2;
    }

    public void clear() {
        int n = this.bits.length;
        for (int i = 0; i < n; ++i) {
            this.bits[i] = 0;
        }
    }

    public boolean isRange(int n, int n2, boolean bl) {
        if (n2 < n) {
            throw new IllegalArgumentException();
        }
        if (n2 == n) {
            return true;
        }
        int n3 = n >> 5;
        int n4 = --n2 >> 5;
        for (int i = n3; i <= n4; ++i) {
            int n5;
            int n6;
            int n7 = i > n3 ? 0 : n & 0x1F;
            int n8 = n6 = i < n4 ? 31 : n2 & 0x1F;
            if (n7 == 0 && n6 == 31) {
                n5 = -1;
            } else {
                n5 = 0;
                for (int j = n7; j <= n6; ++j) {
                    n5 |= 1 << j;
                }
            }
            if ((this.bits[i] & n5) == (bl ? n5 : 0)) continue;
            return false;
        }
        return true;
    }

    public void appendBit(boolean bl) {
        this.ensureCapacity(this.size + 1);
        if (bl) {
            int n = this.size >> 5;
            this.bits[n] = this.bits[n] | 1 << (this.size & 0x1F);
        }
        ++this.size;
    }

    public void appendBits(int n, int n2) {
        if (n2 < 0 || n2 > 32) {
            throw new IllegalArgumentException("Num bits must be between 0 and 32");
        }
        this.ensureCapacity(this.size + n2);
        for (int i = n2; i > 0; --i) {
            this.appendBit((n >> i - 1 & 1) == 1);
        }
    }

    public void appendBitArray(BitArray bitArray) {
        int n = bitArray.getSize();
        this.ensureCapacity(this.size + n);
        for (int i = 0; i < n; ++i) {
            this.appendBit(bitArray.get(i));
        }
    }

    public void xor(BitArray bitArray) {
        if (this.bits.length != bitArray.bits.length) {
            throw new IllegalArgumentException("Sizes don't match");
        }
        for (int i = 0; i < this.bits.length; ++i) {
            int n = i;
            this.bits[n] = this.bits[n] ^ bitArray.bits[i];
        }
    }

    public void toBytes(int n, byte[] byArray, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            int n4 = 0;
            for (int j = 0; j < 8; ++j) {
                if (this.get(n)) {
                    n4 |= 1 << 7 - j;
                }
                ++n;
            }
            byArray[n2 + i] = (byte)n4;
        }
    }

    public int[] getBitArray() {
        return this.bits;
    }

    public void reverse() {
        int[] nArray = new int[this.bits.length];
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            if (!this.get(n - i - 1)) continue;
            int n2 = i >> 5;
            nArray[n2] = nArray[n2] | 1 << (i & 0x1F);
        }
        this.bits = nArray;
    }

    private static int[] makeArray(int n) {
        return new int[n + 31 >> 5];
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.size);
        for (int i = 0; i < this.size; ++i) {
            if ((i & 7) == 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(this.get(i) ? (char)'X' : '.');
        }
        return stringBuffer.toString();
    }
}

