use strict;
use Test::More;
use Vector::QRCode::EPS;

can_ok 'Vector::QRCode::EPS', 'generate';

my $data = Vector::QRCode::EPS->generate(
    text => 'This is a test',
    qrcode_options => {
        margin  => 4,
        version => 5,
        levelt  => 'H',
    },
);
isa_ok $data, 'PostScript::Easy';

my $expect = do {local $/; <DATA>};
like $data->get, qr/$expect/, 'expected data';

done_testing;

__DATA__
1 1 1 setrgbcolor
0 ux 0 uy 10 ux 10 uy box fill
0.0392156862745098 0.0392156862745098 0.0392156862745098 setrgbcolor
0 ux 0 uy 0.27027027027027 ux 0.27027027027027 uy box fill
0.27027027027027 ux 0 uy 0.540540540540541 ux 0.27027027027027 uy box fill
0.540540540540541 ux 0 uy 0.810810810810811 ux 0.27027027027027 uy box fill
0.810810810810811 ux 0 uy 1.08108108108108 ux 0.27027027027027 uy box fill
1.08108108108108 ux 0 uy 1.35135135135135 ux 0.27027027027027 uy box fill
1.35135135135135 ux 0 uy 1.62162162162162 ux 0.27027027027027 uy box fill
1.62162162162162 ux 0 uy 1.89189189189189 ux 0.27027027027027 uy box fill
2.16216216216216 ux 0 uy 2.43243243243243 ux 0.27027027027027 uy box fill
2.97297297297297 ux 0 uy 3.24324324324324 ux 0.27027027027027 uy box fill
3.24324324324324 ux 0 uy 3.51351351351351 ux 0.27027027027027 uy box fill
3.51351351351351 ux 0 uy 3.78378378378378 ux 0.27027027027027 uy box fill
4.05405405405405 ux 0 uy 4.32432432432432 ux 0.27027027027027 uy box fill
4.32432432432432 ux 0 uy 4.59459459459459 ux 0.27027027027027 uy box fill
4.59459459459459 ux 0 uy 4.86486486486486 ux 0.27027027027027 uy box fill
5.13513513513514 ux 0 uy 5.40540540540541 ux 0.27027027027027 uy box fill
5.40540540540541 ux 0 uy 5.67567567567568 ux 0.27027027027027 uy box fill
5.67567567567568 ux 0 uy 5.94594594594595 ux 0.27027027027027 uy box fill
6.21621621621622 ux 0 uy 6.48648648648649 ux 0.27027027027027 uy box fill
6.48648648648649 ux 0 uy 6.75675675675676 ux 0.27027027027027 uy box fill
6.75675675675676 ux 0 uy 7.02702702702703 ux 0.27027027027027 uy box fill
7.2972972972973 ux 0 uy 7.56756756756757 ux 0.27027027027027 uy box fill
7.56756756756757 ux 0 uy 7.83783783783784 ux 0.27027027027027 uy box fill
8.10810810810811 ux 0 uy 8.37837837837838 ux 0.27027027027027 uy box fill
8.37837837837838 ux 0 uy 8.64864864864865 ux 0.27027027027027 uy box fill
8.64864864864865 ux 0 uy 8.91891891891892 ux 0.27027027027027 uy box fill
9.72972972972973 ux 0 uy 10 ux 0.27027027027027 uy box fill
0 ux 0.27027027027027 uy 0.27027027027027 ux 0.540540540540541 uy box fill
1.62162162162162 ux 0.27027027027027 uy 1.89189189189189 ux 0.540540540540541 uy box fill
2.16216216216216 ux 0.27027027027027 uy 2.43243243243243 ux 0.540540540540541 uy box fill
2.43243243243243 ux 0.27027027027027 uy 2.7027027027027 ux 0.540540540540541 uy box fill
2.7027027027027 ux 0.27027027027027 uy 2.97297297297297 ux 0.540540540540541 uy box fill
3.51351351351351 ux 0.27027027027027 uy 3.78378378378378 ux 0.540540540540541 uy box fill
4.59459459459459 ux 0.27027027027027 uy 4.86486486486486 ux 0.540540540540541 uy box fill
5.67567567567568 ux 0.27027027027027 uy 5.94594594594595 ux 0.540540540540541 uy box fill
6.75675675675676 ux 0.27027027027027 uy 7.02702702702703 ux 0.540540540540541 uy box fill
7.2972972972973 ux 0.27027027027027 uy 7.56756756756757 ux 0.540540540540541 uy box fill
8.37837837837838 ux 0.27027027027027 uy 8.64864864864865 ux 0.540540540540541 uy box fill
8.64864864864865 ux 0.27027027027027 uy 8.91891891891892 ux 0.540540540540541 uy box fill
8.91891891891892 ux 0.27027027027027 uy 9.18918918918919 ux 0.540540540540541 uy box fill
0 ux 0.540540540540541 uy 0.27027027027027 ux 0.810810810810811 uy box fill
0.540540540540541 ux 0.540540540540541 uy 0.810810810810811 ux 0.810810810810811 uy box fill
0.810810810810811 ux 0.540540540540541 uy 1.08108108108108 ux 0.810810810810811 uy box fill
1.08108108108108 ux 0.540540540540541 uy 1.35135135135135 ux 0.810810810810811 uy box fill
1.62162162162162 ux 0.540540540540541 uy 1.89189189189189 ux 0.810810810810811 uy box fill
2.16216216216216 ux 0.540540540540541 uy 2.43243243243243 ux 0.810810810810811 uy box fill
2.43243243243243 ux 0.540540540540541 uy 2.7027027027027 ux 0.810810810810811 uy box fill
2.7027027027027 ux 0.540540540540541 uy 2.97297297297297 ux 0.810810810810811 uy box fill
2.97297297297297 ux 0.540540540540541 uy 3.24324324324324 ux 0.810810810810811 uy box fill
4.05405405405405 ux 0.540540540540541 uy 4.32432432432432 ux 0.810810810810811 uy box fill
5.13513513513514 ux 0.540540540540541 uy 5.40540540540541 ux 0.810810810810811 uy box fill
6.21621621621622 ux 0.540540540540541 uy 6.48648648648649 ux 0.810810810810811 uy box fill
7.83783783783784 ux 0.540540540540541 uy 8.10810810810811 ux 0.810810810810811 uy box fill
8.10810810810811 ux 0.540540540540541 uy 8.37837837837838 ux 0.810810810810811 uy box fill
8.64864864864865 ux 0.540540540540541 uy 8.91891891891892 ux 0.810810810810811 uy box fill
9.18918918918919 ux 0.540540540540541 uy 9.45945945945946 ux 0.810810810810811 uy box fill
9.45945945945946 ux 0.540540540540541 uy 9.72972972972973 ux 0.810810810810811 uy box fill
9.72972972972973 ux 0.540540540540541 uy 10 ux 0.810810810810811 uy box fill
0 ux 0.810810810810811 uy 0.27027027027027 ux 1.08108108108108 uy box fill
0.540540540540541 ux 0.810810810810811 uy 0.810810810810811 ux 1.08108108108108 uy box fill
0.810810810810811 ux 0.810810810810811 uy 1.08108108108108 ux 1.08108108108108 uy box fill
1.08108108108108 ux 0.810810810810811 uy 1.35135135135135 ux 1.08108108108108 uy box fill
1.62162162162162 ux 0.810810810810811 uy 1.89189189189189 ux 1.08108108108108 uy box fill
3.51351351351351 ux 0.810810810810811 uy 3.78378378378378 ux 1.08108108108108 uy box fill
3.78378378378378 ux 0.810810810810811 uy 4.05405405405405 ux 1.08108108108108 uy box fill
4.59459459459459 ux 0.810810810810811 uy 4.86486486486486 ux 1.08108108108108 uy box fill
4.86486486486486 ux 0.810810810810811 uy 5.13513513513514 ux 1.08108108108108 uy box fill
5.67567567567568 ux 0.810810810810811 uy 5.94594594594595 ux 1.08108108108108 uy box fill
5.94594594594595 ux 0.810810810810811 uy 6.21621621621622 ux 1.08108108108108 uy box fill
6.75675675675676 ux 0.810810810810811 uy 7.02702702702703 ux 1.08108108108108 uy box fill
7.02702702702703 ux 0.810810810810811 uy 7.2972972972973 ux 1.08108108108108 uy box fill
7.56756756756757 ux 0.810810810810811 uy 7.83783783783784 ux 1.08108108108108 uy box fill
7.83783783783784 ux 0.810810810810811 uy 8.10810810810811 ux 1.08108108108108 uy box fill
8.10810810810811 ux 0.810810810810811 uy 8.37837837837838 ux 1.08108108108108 uy box fill
8.37837837837838 ux 0.810810810810811 uy 8.64864864864865 ux 1.08108108108108 uy box fill
8.64864864864865 ux 0.810810810810811 uy 8.91891891891892 ux 1.08108108108108 uy box fill
8.91891891891892 ux 0.810810810810811 uy 9.18918918918919 ux 1.08108108108108 uy box fill
0 ux 1.08108108108108 uy 0.27027027027027 ux 1.35135135135135 uy box fill
0.540540540540541 ux 1.08108108108108 uy 0.810810810810811 ux 1.35135135135135 uy box fill
0.810810810810811 ux 1.08108108108108 uy 1.08108108108108 ux 1.35135135135135 uy box fill
1.08108108108108 ux 1.08108108108108 uy 1.35135135135135 ux 1.35135135135135 uy box fill
1.62162162162162 ux 1.08108108108108 uy 1.89189189189189 ux 1.35135135135135 uy box fill
2.43243243243243 ux 1.08108108108108 uy 2.7027027027027 ux 1.35135135135135 uy box fill
2.7027027027027 ux 1.08108108108108 uy 2.97297297297297 ux 1.35135135135135 uy box fill
3.51351351351351 ux 1.08108108108108 uy 3.78378378378378 ux 1.35135135135135 uy box fill
3.78378378378378 ux 1.08108108108108 uy 4.05405405405405 ux 1.35135135135135 uy box fill
4.59459459459459 ux 1.08108108108108 uy 4.86486486486486 ux 1.35135135135135 uy box fill
4.86486486486486 ux 1.08108108108108 uy 5.13513513513514 ux 1.35135135135135 uy box fill
5.67567567567568 ux 1.08108108108108 uy 5.94594594594595 ux 1.35135135135135 uy box fill
5.94594594594595 ux 1.08108108108108 uy 6.21621621621622 ux 1.35135135135135 uy box fill
6.75675675675676 ux 1.08108108108108 uy 7.02702702702703 ux 1.35135135135135 uy box fill
7.02702702702703 ux 1.08108108108108 uy 7.2972972972973 ux 1.35135135135135 uy box fill
7.56756756756757 ux 1.08108108108108 uy 7.83783783783784 ux 1.35135135135135 uy box fill
7.83783783783784 ux 1.08108108108108 uy 8.10810810810811 ux 1.35135135135135 uy box fill
8.10810810810811 ux 1.08108108108108 uy 8.37837837837838 ux 1.35135135135135 uy box fill
8.37837837837838 ux 1.08108108108108 uy 8.64864864864865 ux 1.35135135135135 uy box fill
8.64864864864865 ux 1.08108108108108 uy 8.91891891891892 ux 1.35135135135135 uy box fill
8.91891891891892 ux 1.08108108108108 uy 9.18918918918919 ux 1.35135135135135 uy box fill
0 ux 1.35135135135135 uy 0.27027027027027 ux 1.62162162162162 uy box fill
1.62162162162162 ux 1.35135135135135 uy 1.89189189189189 ux 1.62162162162162 uy box fill
2.16216216216216 ux 1.35135135135135 uy 2.43243243243243 ux 1.62162162162162 uy box fill
2.43243243243243 ux 1.35135135135135 uy 2.7027027027027 ux 1.62162162162162 uy box fill
2.7027027027027 ux 1.35135135135135 uy 2.97297297297297 ux 1.62162162162162 uy box fill
2.97297297297297 ux 1.35135135135135 uy 3.24324324324324 ux 1.62162162162162 uy box fill
3.24324324324324 ux 1.35135135135135 uy 3.51351351351351 ux 1.62162162162162 uy box fill
3.78378378378378 ux 1.35135135135135 uy 4.05405405405405 ux 1.62162162162162 uy box fill
4.05405405405405 ux 1.35135135135135 uy 4.32432432432432 ux 1.62162162162162 uy box fill
4.32432432432432 ux 1.35135135135135 uy 4.59459459459459 ux 1.62162162162162 uy box fill
4.86486486486486 ux 1.35135135135135 uy 5.13513513513514 ux 1.62162162162162 uy box fill
5.13513513513514 ux 1.35135135135135 uy 5.40540540540541 ux 1.62162162162162 uy box fill
5.40540540540541 ux 1.35135135135135 uy 5.67567567567568 ux 1.62162162162162 uy box fill
5.94594594594595 ux 1.35135135135135 uy 6.21621621621622 ux 1.62162162162162 uy box fill
6.21621621621622 ux 1.35135135135135 uy 6.48648648648649 ux 1.62162162162162 uy box fill
6.48648648648649 ux 1.35135135135135 uy 6.75675675675676 ux 1.62162162162162 uy box fill
7.02702702702703 ux 1.35135135135135 uy 7.2972972972973 ux 1.62162162162162 uy box fill
7.2972972972973 ux 1.35135135135135 uy 7.56756756756757 ux 1.62162162162162 uy box fill
7.56756756756757 ux 1.35135135135135 uy 7.83783783783784 ux 1.62162162162162 uy box fill
8.64864864864865 ux 1.35135135135135 uy 8.91891891891892 ux 1.62162162162162 uy box fill
8.91891891891892 ux 1.35135135135135 uy 9.18918918918919 ux 1.62162162162162 uy box fill
9.72972972972973 ux 1.35135135135135 uy 10 ux 1.62162162162162 uy box fill
0 ux 1.62162162162162 uy 0.27027027027027 ux 1.89189189189189 uy box fill
0.27027027027027 ux 1.62162162162162 uy 0.540540540540541 ux 1.89189189189189 uy box fill
0.540540540540541 ux 1.62162162162162 uy 0.810810810810811 ux 1.89189189189189 uy box fill
0.810810810810811 ux 1.62162162162162 uy 1.08108108108108 ux 1.89189189189189 uy box fill
1.08108108108108 ux 1.62162162162162 uy 1.35135135135135 ux 1.89189189189189 uy box fill
1.35135135135135 ux 1.62162162162162 uy 1.62162162162162 ux 1.89189189189189 uy box fill
1.62162162162162 ux 1.62162162162162 uy 1.89189189189189 ux 1.89189189189189 uy box fill
3.24324324324324 ux 1.62162162162162 uy 3.51351351351351 ux 1.89189189189189 uy box fill
3.51351351351351 ux 1.62162162162162 uy 3.78378378378378 ux 1.89189189189189 uy box fill
3.78378378378378 ux 1.62162162162162 uy 4.05405405405405 ux 1.89189189189189 uy box fill
4.32432432432432 ux 1.62162162162162 uy 4.59459459459459 ux 1.89189189189189 uy box fill
4.59459459459459 ux 1.62162162162162 uy 4.86486486486486 ux 1.89189189189189 uy box fill
4.86486486486486 ux 1.62162162162162 uy 5.13513513513514 ux 1.89189189189189 uy box fill
5.40540540540541 ux 1.62162162162162 uy 5.67567567567568 ux 1.89189189189189 uy box fill
5.67567567567568 ux 1.62162162162162 uy 5.94594594594595 ux 1.89189189189189 uy box fill
5.94594594594595 ux 1.62162162162162 uy 6.21621621621622 ux 1.89189189189189 uy box fill
6.48648648648649 ux 1.62162162162162 uy 6.75675675675676 ux 1.89189189189189 uy box fill
6.75675675675676 ux 1.62162162162162 uy 7.02702702702703 ux 1.89189189189189 uy box fill
7.02702702702703 ux 1.62162162162162 uy 7.2972972972973 ux 1.89189189189189 uy box fill
7.2972972972973 ux 1.62162162162162 uy 7.56756756756757 ux 1.89189189189189 uy box fill
7.56756756756757 ux 1.62162162162162 uy 7.83783783783784 ux 1.89189189189189 uy box fill
8.10810810810811 ux 1.62162162162162 uy 8.37837837837838 ux 1.89189189189189 uy box fill
8.64864864864865 ux 1.62162162162162 uy 8.91891891891892 ux 1.89189189189189 uy box fill
8.91891891891892 ux 1.62162162162162 uy 9.18918918918919 ux 1.89189189189189 uy box fill
9.18918918918919 ux 1.62162162162162 uy 9.45945945945946 ux 1.89189189189189 uy box fill
9.72972972972973 ux 1.62162162162162 uy 10 ux 1.89189189189189 uy box fill
2.16216216216216 ux 1.89189189189189 uy 2.43243243243243 ux 2.16216216216216 uy box fill
2.43243243243243 ux 1.89189189189189 uy 2.7027027027027 ux 2.16216216216216 uy box fill
3.24324324324324 ux 1.89189189189189 uy 3.51351351351351 ux 2.16216216216216 uy box fill
4.32432432432432 ux 1.89189189189189 uy 4.59459459459459 ux 2.16216216216216 uy box fill
5.40540540540541 ux 1.89189189189189 uy 5.67567567567568 ux 2.16216216216216 uy box fill
6.48648648648649 ux 1.89189189189189 uy 6.75675675675676 ux 2.16216216216216 uy box fill
7.56756756756757 ux 1.89189189189189 uy 7.83783783783784 ux 2.16216216216216 uy box fill
8.64864864864865 ux 1.89189189189189 uy 8.91891891891892 ux 2.16216216216216 uy box fill
8.91891891891892 ux 1.89189189189189 uy 9.18918918918919 ux 2.16216216216216 uy box fill
9.45945945945946 ux 1.89189189189189 uy 9.72972972972973 ux 2.16216216216216 uy box fill
0 ux 2.16216216216216 uy 0.27027027027027 ux 2.43243243243243 uy box fill
0.27027027027027 ux 2.16216216216216 uy 0.540540540540541 ux 2.43243243243243 uy box fill
0.540540540540541 ux 2.16216216216216 uy 0.810810810810811 ux 2.43243243243243 uy box fill
0.810810810810811 ux 2.16216216216216 uy 1.08108108108108 ux 2.43243243243243 uy box fill
1.35135135135135 ux 2.16216216216216 uy 1.62162162162162 ux 2.43243243243243 uy box fill
1.62162162162162 ux 2.16216216216216 uy 1.89189189189189 ux 2.43243243243243 uy box fill
2.16216216216216 ux 2.16216216216216 uy 2.43243243243243 ux 2.43243243243243 uy box fill
2.7027027027027 ux 2.16216216216216 uy 2.97297297297297 ux 2.43243243243243 uy box fill
2.97297297297297 ux 2.16216216216216 uy 3.24324324324324 ux 2.43243243243243 uy box fill
3.24324324324324 ux 2.16216216216216 uy 3.51351351351351 ux 2.43243243243243 uy box fill
3.51351351351351 ux 2.16216216216216 uy 3.78378378378378 ux 2.43243243243243 uy box fill
4.05405405405405 ux 2.16216216216216 uy 4.32432432432432 ux 2.43243243243243 uy box fill
4.32432432432432 ux 2.16216216216216 uy 4.59459459459459 ux 2.43243243243243 uy box fill
4.59459459459459 ux 2.16216216216216 uy 4.86486486486486 ux 2.43243243243243 uy box fill
5.13513513513514 ux 2.16216216216216 uy 5.40540540540541 ux 2.43243243243243 uy box fill
5.40540540540541 ux 2.16216216216216 uy 5.67567567567568 ux 2.43243243243243 uy box fill
5.67567567567568 ux 2.16216216216216 uy 5.94594594594595 ux 2.43243243243243 uy box fill
6.21621621621622 ux 2.16216216216216 uy 6.48648648648649 ux 2.43243243243243 uy box fill
6.48648648648649 ux 2.16216216216216 uy 6.75675675675676 ux 2.43243243243243 uy box fill
6.75675675675676 ux 2.16216216216216 uy 7.02702702702703 ux 2.43243243243243 uy box fill
7.2972972972973 ux 2.16216216216216 uy 7.56756756756757 ux 2.43243243243243 uy box fill
7.56756756756757 ux 2.16216216216216 uy 7.83783783783784 ux 2.43243243243243 uy box fill
7.83783783783784 ux 2.16216216216216 uy 8.10810810810811 ux 2.43243243243243 uy box fill
8.10810810810811 ux 2.16216216216216 uy 8.37837837837838 ux 2.43243243243243 uy box fill
8.37837837837838 ux 2.16216216216216 uy 8.64864864864865 ux 2.43243243243243 uy box fill
8.64864864864865 ux 2.16216216216216 uy 8.91891891891892 ux 2.43243243243243 uy box fill
9.72972972972973 ux 2.16216216216216 uy 10 ux 2.43243243243243 uy box fill
1.89189189189189 ux 2.43243243243243 uy 2.16216216216216 ux 2.7027027027027 uy box fill
2.16216216216216 ux 2.43243243243243 uy 2.43243243243243 ux 2.7027027027027 uy box fill
2.7027027027027 ux 2.43243243243243 uy 2.97297297297297 ux 2.7027027027027 uy box fill
3.51351351351351 ux 2.43243243243243 uy 3.78378378378378 ux 2.7027027027027 uy box fill
4.59459459459459 ux 2.43243243243243 uy 4.86486486486486 ux 2.7027027027027 uy box fill
5.67567567567568 ux 2.43243243243243 uy 5.94594594594595 ux 2.7027027027027 uy box fill
6.75675675675676 ux 2.43243243243243 uy 7.02702702702703 ux 2.7027027027027 uy box fill
8.10810810810811 ux 2.43243243243243 uy 8.37837837837838 ux 2.7027027027027 uy box fill
8.37837837837838 ux 2.43243243243243 uy 8.64864864864865 ux 2.7027027027027 uy box fill
8.91891891891892 ux 2.43243243243243 uy 9.18918918918919 ux 2.7027027027027 uy box fill
0 ux 2.7027027027027 uy 0.27027027027027 ux 2.97297297297297 uy box fill
0.27027027027027 ux 2.7027027027027 uy 0.540540540540541 ux 2.97297297297297 uy box fill
0.540540540540541 ux 2.7027027027027 uy 0.810810810810811 ux 2.97297297297297 uy box fill
0.810810810810811 ux 2.7027027027027 uy 1.08108108108108 ux 2.97297297297297 uy box fill
1.35135135135135 ux 2.7027027027027 uy 1.62162162162162 ux 2.97297297297297 uy box fill
1.62162162162162 ux 2.7027027027027 uy 1.89189189189189 ux 2.97297297297297 uy box fill
1.89189189189189 ux 2.7027027027027 uy 2.16216216216216 ux 2.97297297297297 uy box fill
2.16216216216216 ux 2.7027027027027 uy 2.43243243243243 ux 2.97297297297297 uy box fill
2.43243243243243 ux 2.7027027027027 uy 2.7027027027027 ux 2.97297297297297 uy box fill
2.97297297297297 ux 2.7027027027027 uy 3.24324324324324 ux 2.97297297297297 uy box fill
4.05405405405405 ux 2.7027027027027 uy 4.32432432432432 ux 2.97297297297297 uy box fill
5.13513513513514 ux 2.7027027027027 uy 5.40540540540541 ux 2.97297297297297 uy box fill
6.21621621621622 ux 2.7027027027027 uy 6.48648648648649 ux 2.97297297297297 uy box fill
7.2972972972973 ux 2.7027027027027 uy 7.56756756756757 ux 2.97297297297297 uy box fill
8.37837837837838 ux 2.7027027027027 uy 8.64864864864865 ux 2.97297297297297 uy box fill
8.64864864864865 ux 2.7027027027027 uy 8.91891891891892 ux 2.97297297297297 uy box fill
8.91891891891892 ux 2.7027027027027 uy 9.18918918918919 ux 2.97297297297297 uy box fill
9.18918918918919 ux 2.7027027027027 uy 9.45945945945946 ux 2.97297297297297 uy box fill
9.72972972972973 ux 2.7027027027027 uy 10 ux 2.97297297297297 uy box fill
0.27027027027027 ux 2.97297297297297 uy 0.540540540540541 ux 3.24324324324324 uy box fill
1.08108108108108 ux 2.97297297297297 uy 1.35135135135135 ux 3.24324324324324 uy box fill
1.35135135135135 ux 2.97297297297297 uy 1.62162162162162 ux 3.24324324324324 uy box fill
2.16216216216216 ux 2.97297297297297 uy 2.43243243243243 ux 3.24324324324324 uy box fill
2.7027027027027 ux 2.97297297297297 uy 2.97297297297297 ux 3.24324324324324 uy box fill
3.51351351351351 ux 2.97297297297297 uy 3.78378378378378 ux 3.24324324324324 uy box fill
3.78378378378378 ux 2.97297297297297 uy 4.05405405405405 ux 3.24324324324324 uy box fill
4.59459459459459 ux 2.97297297297297 uy 4.86486486486486 ux 3.24324324324324 uy box fill
4.86486486486486 ux 2.97297297297297 uy 5.13513513513514 ux 3.24324324324324 uy box fill
5.67567567567568 ux 2.97297297297297 uy 5.94594594594595 ux 3.24324324324324 uy box fill
5.94594594594595 ux 2.97297297297297 uy 6.21621621621622 ux 3.24324324324324 uy box fill
6.75675675675676 ux 2.97297297297297 uy 7.02702702702703 ux 3.24324324324324 uy box fill
7.02702702702703 ux 2.97297297297297 uy 7.2972972972973 ux 3.24324324324324 uy box fill
7.83783783783784 ux 2.97297297297297 uy 8.10810810810811 ux 3.24324324324324 uy box fill
9.72972972972973 ux 2.97297297297297 uy 10 ux 3.24324324324324 uy box fill
0.540540540540541 ux 3.24324324324324 uy 0.810810810810811 ux 3.51351351351351 uy box fill
1.08108108108108 ux 3.24324324324324 uy 1.35135135135135 ux 3.51351351351351 uy box fill
1.35135135135135 ux 3.24324324324324 uy 1.62162162162162 ux 3.51351351351351 uy box fill
1.62162162162162 ux 3.24324324324324 uy 1.89189189189189 ux 3.51351351351351 uy box fill
1.89189189189189 ux 3.24324324324324 uy 2.16216216216216 ux 3.51351351351351 uy box fill
2.16216216216216 ux 3.24324324324324 uy 2.43243243243243 ux 3.51351351351351 uy box fill
3.51351351351351 ux 3.24324324324324 uy 3.78378378378378 ux 3.51351351351351 uy box fill
3.78378378378378 ux 3.24324324324324 uy 4.05405405405405 ux 3.51351351351351 uy box fill
4.59459459459459 ux 3.24324324324324 uy 4.86486486486486 ux 3.51351351351351 uy box fill
4.86486486486486 ux 3.24324324324324 uy 5.13513513513514 ux 3.51351351351351 uy box fill
5.67567567567568 ux 3.24324324324324 uy 5.94594594594595 ux 3.51351351351351 uy box fill
5.94594594594595 ux 3.24324324324324 uy 6.21621621621622 ux 3.51351351351351 uy box fill
6.75675675675676 ux 3.24324324324324 uy 7.02702702702703 ux 3.51351351351351 uy box fill
7.02702702702703 ux 3.24324324324324 uy 7.2972972972973 ux 3.51351351351351 uy box fill
7.83783783783784 ux 3.24324324324324 uy 8.10810810810811 ux 3.51351351351351 uy box fill
8.10810810810811 ux 3.24324324324324 uy 8.37837837837838 ux 3.51351351351351 uy box fill
8.37837837837838 ux 3.24324324324324 uy 8.64864864864865 ux 3.51351351351351 uy box fill
8.64864864864865 ux 3.24324324324324 uy 8.91891891891892 ux 3.51351351351351 uy box fill
8.91891891891892 ux 3.24324324324324 uy 9.18918918918919 ux 3.51351351351351 uy box fill
9.45945945945946 ux 3.24324324324324 uy 9.72972972972973 ux 3.51351351351351 uy box fill
0 ux 3.51351351351351 uy 0.27027027027027 ux 3.78378378378378 uy box fill
0.27027027027027 ux 3.51351351351351 uy 0.540540540540541 ux 3.78378378378378 uy box fill
0.540540540540541 ux 3.51351351351351 uy 0.810810810810811 ux 3.78378378378378 uy box fill
0.810810810810811 ux 3.51351351351351 uy 1.08108108108108 ux 3.78378378378378 uy box fill
1.35135135135135 ux 3.51351351351351 uy 1.62162162162162 ux 3.78378378378378 uy box fill
2.16216216216216 ux 3.51351351351351 uy 2.43243243243243 ux 3.78378378378378 uy box fill
2.7027027027027 ux 3.51351351351351 uy 2.97297297297297 ux 3.78378378378378 uy box fill
2.97297297297297 ux 3.51351351351351 uy 3.24324324324324 ux 3.78378378378378 uy box fill
3.24324324324324 ux 3.51351351351351 uy 3.51351351351351 ux 3.78378378378378 uy box fill
3.78378378378378 ux 3.51351351351351 uy 4.05405405405405 ux 3.78378378378378 uy box fill
4.05405405405405 ux 3.51351351351351 uy 4.32432432432432 ux 3.78378378378378 uy box fill
4.32432432432432 ux 3.51351351351351 uy 4.59459459459459 ux 3.78378378378378 uy box fill
4.86486486486486 ux 3.51351351351351 uy 5.13513513513514 ux 3.78378378378378 uy box fill
5.13513513513514 ux 3.51351351351351 uy 5.40540540540541 ux 3.78378378378378 uy box fill
5.40540540540541 ux 3.51351351351351 uy 5.67567567567568 ux 3.78378378378378 uy box fill
5.94594594594595 ux 3.51351351351351 uy 6.21621621621622 ux 3.78378378378378 uy box fill
6.21621621621622 ux 3.51351351351351 uy 6.48648648648649 ux 3.78378378378378 uy box fill
6.48648648648649 ux 3.51351351351351 uy 6.75675675675676 ux 3.78378378378378 uy box fill
7.02702702702703 ux 3.51351351351351 uy 7.2972972972973 ux 3.78378378378378 uy box fill
7.2972972972973 ux 3.51351351351351 uy 7.56756756756757 ux 3.78378378378378 uy box fill
7.56756756756757 ux 3.51351351351351 uy 7.83783783783784 ux 3.78378378378378 uy box fill
7.83783783783784 ux 3.51351351351351 uy 8.10810810810811 ux 3.78378378378378 uy box fill
8.37837837837838 ux 3.51351351351351 uy 8.64864864864865 ux 3.78378378378378 uy box fill
8.64864864864865 ux 3.51351351351351 uy 8.91891891891892 ux 3.78378378378378 uy box fill
0 ux 3.78378378378378 uy 0.27027027027027 ux 4.05405405405405 uy box fill
1.08108108108108 ux 3.78378378378378 uy 1.35135135135135 ux 4.05405405405405 uy box fill
1.62162162162162 ux 3.78378378378378 uy 1.89189189189189 ux 4.05405405405405 uy box fill
2.16216216216216 ux 3.78378378378378 uy 2.43243243243243 ux 4.05405405405405 uy box fill
2.43243243243243 ux 3.78378378378378 uy 2.7027027027027 ux 4.05405405405405 uy box fill
3.24324324324324 ux 3.78378378378378 uy 3.51351351351351 ux 4.05405405405405 uy box fill
3.51351351351351 ux 3.78378378378378 uy 3.78378378378378 ux 4.05405405405405 uy box fill
3.78378378378378 ux 3.78378378378378 uy 4.05405405405405 ux 4.05405405405405 uy box fill
4.32432432432432 ux 3.78378378378378 uy 4.59459459459459 ux 4.05405405405405 uy box fill
4.59459459459459 ux 3.78378378378378 uy 4.86486486486486 ux 4.05405405405405 uy box fill
4.86486486486486 ux 3.78378378378378 uy 5.13513513513514 ux 4.05405405405405 uy box fill
5.40540540540541 ux 3.78378378378378 uy 5.67567567567568 ux 4.05405405405405 uy box fill
5.67567567567568 ux 3.78378378378378 uy 5.94594594594595 ux 4.05405405405405 uy box fill
5.94594594594595 ux 3.78378378378378 uy 6.21621621621622 ux 4.05405405405405 uy box fill
6.48648648648649 ux 3.78378378378378 uy 6.75675675675676 ux 4.05405405405405 uy box fill
6.75675675675676 ux 3.78378378378378 uy 7.02702702702703 ux 4.05405405405405 uy box fill
7.02702702702703 ux 3.78378378378378 uy 7.2972972972973 ux 4.05405405405405 uy box fill
7.56756756756757 ux 3.78378378378378 uy 7.83783783783784 ux 4.05405405405405 uy box fill
7.83783783783784 ux 3.78378378378378 uy 8.10810810810811 ux 4.05405405405405 uy box fill
8.10810810810811 ux 3.78378378378378 uy 8.37837837837838 ux 4.05405405405405 uy box fill
8.37837837837838 ux 3.78378378378378 uy 8.64864864864865 ux 4.05405405405405 uy box fill
9.18918918918919 ux 3.78378378378378 uy 9.45945945945946 ux 4.05405405405405 uy box fill
9.72972972972973 ux 3.78378378378378 uy 10 ux 4.05405405405405 uy box fill
0 ux 4.05405405405405 uy 0.27027027027027 ux 4.32432432432432 uy box fill
0.27027027027027 ux 4.05405405405405 uy 0.540540540540541 ux 4.32432432432432 uy box fill
1.89189189189189 ux 4.05405405405405 uy 2.16216216216216 ux 4.32432432432432 uy box fill
2.16216216216216 ux 4.05405405405405 uy 2.43243243243243 ux 4.32432432432432 uy box fill
3.24324324324324 ux 4.05405405405405 uy 3.51351351351351 ux 4.32432432432432 uy box fill
4.32432432432432 ux 4.05405405405405 uy 4.59459459459459 ux 4.32432432432432 uy box fill
5.40540540540541 ux 4.05405405405405 uy 5.67567567567568 ux 4.32432432432432 uy box fill
6.48648648648649 ux 4.05405405405405 uy 6.75675675675676 ux 4.32432432432432 uy box fill
7.56756756756757 ux 4.05405405405405 uy 7.83783783783784 ux 4.32432432432432 uy box fill
8.37837837837838 ux 4.05405405405405 uy 8.64864864864865 ux 4.32432432432432 uy box fill
8.64864864864865 ux 4.05405405405405 uy 8.91891891891892 ux 4.32432432432432 uy box fill
9.72972972972973 ux 4.05405405405405 uy 10 ux 4.32432432432432 uy box fill
0 ux 4.32432432432432 uy 0.27027027027027 ux 4.59459459459459 uy box fill
0.540540540540541 ux 4.32432432432432 uy 0.810810810810811 ux 4.59459459459459 uy box fill
0.810810810810811 ux 4.32432432432432 uy 1.08108108108108 ux 4.59459459459459 uy box fill
1.62162162162162 ux 4.32432432432432 uy 1.89189189189189 ux 4.59459459459459 uy box fill
1.89189189189189 ux 4.32432432432432 uy 2.16216216216216 ux 4.59459459459459 uy box fill
2.97297297297297 ux 4.32432432432432 uy 3.24324324324324 ux 4.59459459459459 uy box fill
3.24324324324324 ux 4.32432432432432 uy 3.51351351351351 ux 4.59459459459459 uy box fill
3.51351351351351 ux 4.32432432432432 uy 3.78378378378378 ux 4.59459459459459 uy box fill
4.05405405405405 ux 4.32432432432432 uy 4.32432432432432 ux 4.59459459459459 uy box fill
4.32432432432432 ux 4.32432432432432 uy 4.59459459459459 ux 4.59459459459459 uy box fill
4.59459459459459 ux 4.32432432432432 uy 4.86486486486486 ux 4.59459459459459 uy box fill
5.13513513513514 ux 4.32432432432432 uy 5.40540540540541 ux 4.59459459459459 uy box fill
5.40540540540541 ux 4.32432432432432 uy 5.67567567567568 ux 4.59459459459459 uy box fill
5.67567567567568 ux 4.32432432432432 uy 5.94594594594595 ux 4.59459459459459 uy box fill
6.21621621621622 ux 4.32432432432432 uy 6.48648648648649 ux 4.59459459459459 uy box fill
6.48648648648649 ux 4.32432432432432 uy 6.75675675675676 ux 4.59459459459459 uy box fill
6.75675675675676 ux 4.32432432432432 uy 7.02702702702703 ux 4.59459459459459 uy box fill
7.2972972972973 ux 4.32432432432432 uy 7.56756756756757 ux 4.59459459459459 uy box fill
7.56756756756757 ux 4.32432432432432 uy 7.83783783783784 ux 4.59459459459459 uy box fill
8.37837837837838 ux 4.32432432432432 uy 8.64864864864865 ux 4.59459459459459 uy box fill
8.64864864864865 ux 4.32432432432432 uy 8.91891891891892 ux 4.59459459459459 uy box fill
8.91891891891892 ux 4.32432432432432 uy 9.18918918918919 ux 4.59459459459459 uy box fill
9.45945945945946 ux 4.32432432432432 uy 9.72972972972973 ux 4.59459459459459 uy box fill
0.810810810810811 ux 4.59459459459459 uy 1.08108108108108 ux 4.86486486486486 uy box fill
1.08108108108108 ux 4.59459459459459 uy 1.35135135135135 ux 4.86486486486486 uy box fill
2.16216216216216 ux 4.59459459459459 uy 2.43243243243243 ux 4.86486486486486 uy box fill
2.43243243243243 ux 4.59459459459459 uy 2.7027027027027 ux 4.86486486486486 uy box fill
3.51351351351351 ux 4.59459459459459 uy 3.78378378378378 ux 4.86486486486486 uy box fill
4.59459459459459 ux 4.59459459459459 uy 4.86486486486486 ux 4.86486486486486 uy box fill
5.67567567567568 ux 4.59459459459459 uy 5.94594594594595 ux 4.86486486486486 uy box fill
6.75675675675676 ux 4.59459459459459 uy 7.02702702702703 ux 4.86486486486486 uy box fill
8.10810810810811 ux 4.59459459459459 uy 8.37837837837838 ux 4.86486486486486 uy box fill
8.91891891891892 ux 4.59459459459459 uy 9.18918918918919 ux 4.86486486486486 uy box fill
9.45945945945946 ux 4.59459459459459 uy 9.72972972972973 ux 4.86486486486486 uy box fill
1.08108108108108 ux 4.86486486486486 uy 1.35135135135135 ux 5.13513513513514 uy box fill
1.35135135135135 ux 4.86486486486486 uy 1.62162162162162 ux 5.13513513513514 uy box fill
1.62162162162162 ux 4.86486486486486 uy 1.89189189189189 ux 5.13513513513514 uy box fill
1.89189189189189 ux 4.86486486486486 uy 2.16216216216216 ux 5.13513513513514 uy box fill
2.16216216216216 ux 4.86486486486486 uy 2.43243243243243 ux 5.13513513513514 uy box fill
2.43243243243243 ux 4.86486486486486 uy 2.7027027027027 ux 5.13513513513514 uy box fill
2.97297297297297 ux 4.86486486486486 uy 3.24324324324324 ux 5.13513513513514 uy box fill
4.05405405405405 ux 4.86486486486486 uy 4.32432432432432 ux 5.13513513513514 uy box fill
5.13513513513514 ux 4.86486486486486 uy 5.40540540540541 ux 5.13513513513514 uy box fill
6.21621621621622 ux 4.86486486486486 uy 6.48648648648649 ux 5.13513513513514 uy box fill
7.2972972972973 ux 4.86486486486486 uy 7.56756756756757 ux 5.13513513513514 uy box fill
8.64864864864865 ux 4.86486486486486 uy 8.91891891891892 ux 5.13513513513514 uy box fill
8.91891891891892 ux 4.86486486486486 uy 9.18918918918919 ux 5.13513513513514 uy box fill
9.18918918918919 ux 4.86486486486486 uy 9.45945945945946 ux 5.13513513513514 uy box fill
9.72972972972973 ux 4.86486486486486 uy 10 ux 5.13513513513514 uy box fill
0 ux 5.13513513513514 uy 0.27027027027027 ux 5.40540540540541 uy box fill
0.27027027027027 ux 5.13513513513514 uy 0.540540540540541 ux 5.40540540540541 uy box fill
1.08108108108108 ux 5.13513513513514 uy 1.35135135135135 ux 5.40540540540541 uy box fill
2.16216216216216 ux 5.13513513513514 uy 2.43243243243243 ux 5.40540540540541 uy box fill
3.51351351351351 ux 5.13513513513514 uy 3.78378378378378 ux 5.40540540540541 uy box fill
3.78378378378378 ux 5.13513513513514 uy 4.05405405405405 ux 5.40540540540541 uy box fill
4.59459459459459 ux 5.13513513513514 uy 4.86486486486486 ux 5.40540540540541 uy box fill
4.86486486486486 ux 5.13513513513514 uy 5.13513513513514 ux 5.40540540540541 uy box fill
5.67567567567568 ux 5.13513513513514 uy 5.94594594594595 ux 5.40540540540541 uy box fill
5.94594594594595 ux 5.13513513513514 uy 6.21621621621622 ux 5.40540540540541 uy box fill
6.75675675675676 ux 5.13513513513514 uy 7.02702702702703 ux 5.40540540540541 uy box fill
7.02702702702703 ux 5.13513513513514 uy 7.2972972972973 ux 5.40540540540541 uy box fill
7.83783783783784 ux 5.13513513513514 uy 8.10810810810811 ux 5.40540540540541 uy box fill
9.45945945945946 ux 5.13513513513514 uy 9.72972972972973 ux 5.40540540540541 uy box fill
9.72972972972973 ux 5.13513513513514 uy 10 ux 5.40540540540541 uy box fill
0 ux 5.40540540540541 uy 0.27027027027027 ux 5.67567567567568 uy box fill
0.27027027027027 ux 5.40540540540541 uy 0.540540540540541 ux 5.67567567567568 uy box fill
0.540540540540541 ux 5.40540540540541 uy 0.810810810810811 ux 5.67567567567568 uy box fill
0.810810810810811 ux 5.40540540540541 uy 1.08108108108108 ux 5.67567567567568 uy box fill
1.08108108108108 ux 5.40540540540541 uy 1.35135135135135 ux 5.67567567567568 uy box fill
1.62162162162162 ux 5.40540540540541 uy 1.89189189189189 ux 5.67567567567568 uy box fill
1.89189189189189 ux 5.40540540540541 uy 2.16216216216216 ux 5.67567567567568 uy box fill
2.43243243243243 ux 5.40540540540541 uy 2.7027027027027 ux 5.67567567567568 uy box fill
2.7027027027027 ux 5.40540540540541 uy 2.97297297297297 ux 5.67567567567568 uy box fill
3.51351351351351 ux 5.40540540540541 uy 3.78378378378378 ux 5.67567567567568 uy box fill
3.78378378378378 ux 5.40540540540541 uy 4.05405405405405 ux 5.67567567567568 uy box fill
4.59459459459459 ux 5.40540540540541 uy 4.86486486486486 ux 5.67567567567568 uy box fill
4.86486486486486 ux 5.40540540540541 uy 5.13513513513514 ux 5.67567567567568 uy box fill
5.67567567567568 ux 5.40540540540541 uy 5.94594594594595 ux 5.67567567567568 uy box fill
5.94594594594595 ux 5.40540540540541 uy 6.21621621621622 ux 5.67567567567568 uy box fill
6.75675675675676 ux 5.40540540540541 uy 7.02702702702703 ux 5.67567567567568 uy box fill
7.02702702702703 ux 5.40540540540541 uy 7.2972972972973 ux 5.67567567567568 uy box fill
7.83783783783784 ux 5.40540540540541 uy 8.10810810810811 ux 5.67567567567568 uy box fill
8.10810810810811 ux 5.40540540540541 uy 8.37837837837838 ux 5.67567567567568 uy box fill
8.64864864864865 ux 5.40540540540541 uy 8.91891891891892 ux 5.67567567567568 uy box fill
8.91891891891892 ux 5.40540540540541 uy 9.18918918918919 ux 5.67567567567568 uy box fill
9.45945945945946 ux 5.40540540540541 uy 9.72972972972973 ux 5.67567567567568 uy box fill
9.72972972972973 ux 5.40540540540541 uy 10 ux 5.67567567567568 uy box fill
0.27027027027027 ux 5.67567567567568 uy 0.540540540540541 ux 5.94594594594595 uy box fill
0.540540540540541 ux 5.67567567567568 uy 0.810810810810811 ux 5.94594594594595 uy box fill
0.810810810810811 ux 5.67567567567568 uy 1.08108108108108 ux 5.94594594594595 uy box fill
1.08108108108108 ux 5.67567567567568 uy 1.35135135135135 ux 5.94594594594595 uy box fill
1.35135135135135 ux 5.67567567567568 uy 1.62162162162162 ux 5.94594594594595 uy box fill
1.89189189189189 ux 5.67567567567568 uy 2.16216216216216 ux 5.94594594594595 uy box fill
2.16216216216216 ux 5.67567567567568 uy 2.43243243243243 ux 5.94594594594595 uy box fill
2.7027027027027 ux 5.67567567567568 uy 2.97297297297297 ux 5.94594594594595 uy box fill
2.97297297297297 ux 5.67567567567568 uy 3.24324324324324 ux 5.94594594594595 uy box fill
3.24324324324324 ux 5.67567567567568 uy 3.51351351351351 ux 5.94594594594595 uy box fill
3.78378378378378 ux 5.67567567567568 uy 4.05405405405405 ux 5.94594594594595 uy box fill
4.05405405405405 ux 5.67567567567568 uy 4.32432432432432 ux 5.94594594594595 uy box fill
4.32432432432432 ux 5.67567567567568 uy 4.59459459459459 ux 5.94594594594595 uy box fill
4.86486486486486 ux 5.67567567567568 uy 5.13513513513514 ux 5.94594594594595 uy box fill
5.13513513513514 ux 5.67567567567568 uy 5.40540540540541 ux 5.94594594594595 uy box fill
5.40540540540541 ux 5.67567567567568 uy 5.67567567567568 ux 5.94594594594595 uy box fill
5.94594594594595 ux 5.67567567567568 uy 6.21621621621622 ux 5.94594594594595 uy box fill
6.21621621621622 ux 5.67567567567568 uy 6.48648648648649 ux 5.94594594594595 uy box fill
6.48648648648649 ux 5.67567567567568 uy 6.75675675675676 ux 5.94594594594595 uy box fill
7.02702702702703 ux 5.67567567567568 uy 7.2972972972973 ux 5.94594594594595 uy box fill
7.2972972972973 ux 5.67567567567568 uy 7.56756756756757 ux 5.94594594594595 uy box fill
7.56756756756757 ux 5.67567567567568 uy 7.83783783783784 ux 5.94594594594595 uy box fill
7.83783783783784 ux 5.67567567567568 uy 8.10810810810811 ux 5.94594594594595 uy box fill
8.37837837837838 ux 5.67567567567568 uy 8.64864864864865 ux 5.94594594594595 uy box fill
8.64864864864865 ux 5.67567567567568 uy 8.91891891891892 ux 5.94594594594595 uy box fill
9.45945945945946 ux 5.67567567567568 uy 9.72972972972973 ux 5.94594594594595 uy box fill
9.72972972972973 ux 5.67567567567568 uy 10 ux 5.94594594594595 uy box fill
0 ux 5.94594594594595 uy 0.27027027027027 ux 6.21621621621622 uy box fill
0.27027027027027 ux 5.94594594594595 uy 0.540540540540541 ux 6.21621621621622 uy box fill
1.08108108108108 ux 5.94594594594595 uy 1.35135135135135 ux 6.21621621621622 uy box fill
1.35135135135135 ux 5.94594594594595 uy 1.62162162162162 ux 6.21621621621622 uy box fill
1.62162162162162 ux 5.94594594594595 uy 1.89189189189189 ux 6.21621621621622 uy box fill
1.89189189189189 ux 5.94594594594595 uy 2.16216216216216 ux 6.21621621621622 uy box fill
2.7027027027027 ux 5.94594594594595 uy 2.97297297297297 ux 6.21621621621622 uy box fill
3.24324324324324 ux 5.94594594594595 uy 3.51351351351351 ux 6.21621621621622 uy box fill
3.51351351351351 ux 5.94594594594595 uy 3.78378378378378 ux 6.21621621621622 uy box fill
3.78378378378378 ux 5.94594594594595 uy 4.05405405405405 ux 6.21621621621622 uy box fill
4.32432432432432 ux 5.94594594594595 uy 4.59459459459459 ux 6.21621621621622 uy box fill
4.59459459459459 ux 5.94594594594595 uy 4.86486486486486 ux 6.21621621621622 uy box fill
4.86486486486486 ux 5.94594594594595 uy 5.13513513513514 ux 6.21621621621622 uy box fill
5.40540540540541 ux 5.94594594594595 uy 5.67567567567568 ux 6.21621621621622 uy box fill
5.67567567567568 ux 5.94594594594595 uy 5.94594594594595 ux 6.21621621621622 uy box fill
5.94594594594595 ux 5.94594594594595 uy 6.21621621621622 ux 6.21621621621622 uy box fill
6.48648648648649 ux 5.94594594594595 uy 6.75675675675676 ux 6.21621621621622 uy box fill
6.75675675675676 ux 5.94594594594595 uy 7.02702702702703 ux 6.21621621621622 uy box fill
7.02702702702703 ux 5.94594594594595 uy 7.2972972972973 ux 6.21621621621622 uy box fill
7.56756756756757 ux 5.94594594594595 uy 7.83783783783784 ux 6.21621621621622 uy box fill
7.83783783783784 ux 5.94594594594595 uy 8.10810810810811 ux 6.21621621621622 uy box fill
8.10810810810811 ux 5.94594594594595 uy 8.37837837837838 ux 6.21621621621622 uy box fill
8.37837837837838 ux 5.94594594594595 uy 8.64864864864865 ux 6.21621621621622 uy box fill
9.45945945945946 ux 5.94594594594595 uy 9.72972972972973 ux 6.21621621621622 uy box fill
9.72972972972973 ux 5.94594594594595 uy 10 ux 6.21621621621622 uy box fill
0 ux 6.21621621621622 uy 0.27027027027027 ux 6.48648648648649 uy box fill
0.540540540540541 ux 6.21621621621622 uy 0.810810810810811 ux 6.48648648648649 uy box fill
1.35135135135135 ux 6.21621621621622 uy 1.62162162162162 ux 6.48648648648649 uy box fill
2.7027027027027 ux 6.21621621621622 uy 2.97297297297297 ux 6.48648648648649 uy box fill
3.24324324324324 ux 6.21621621621622 uy 3.51351351351351 ux 6.48648648648649 uy box fill
4.32432432432432 ux 6.21621621621622 uy 4.59459459459459 ux 6.48648648648649 uy box fill
5.40540540540541 ux 6.21621621621622 uy 5.67567567567568 ux 6.48648648648649 uy box fill
6.48648648648649 ux 6.21621621621622 uy 6.75675675675676 ux 6.48648648648649 uy box fill
7.56756756756757 ux 6.21621621621622 uy 7.83783783783784 ux 6.48648648648649 uy box fill
8.37837837837838 ux 6.21621621621622 uy 8.64864864864865 ux 6.48648648648649 uy box fill
8.64864864864865 ux 6.21621621621622 uy 8.91891891891892 ux 6.48648648648649 uy box fill
9.72972972972973 ux 6.21621621621622 uy 10 ux 6.48648648648649 uy box fill
0 ux 6.48648648648649 uy 0.27027027027027 ux 6.75675675675676 uy box fill
0.27027027027027 ux 6.48648648648649 uy 0.540540540540541 ux 6.75675675675676 uy box fill
0.540540540540541 ux 6.48648648648649 uy 0.810810810810811 ux 6.75675675675676 uy box fill
1.35135135135135 ux 6.48648648648649 uy 1.62162162162162 ux 6.75675675675676 uy box fill
1.62162162162162 ux 6.48648648648649 uy 1.89189189189189 ux 6.75675675675676 uy box fill
1.89189189189189 ux 6.48648648648649 uy 2.16216216216216 ux 6.75675675675676 uy box fill
2.97297297297297 ux 6.48648648648649 uy 3.24324324324324 ux 6.75675675675676 uy box fill
3.24324324324324 ux 6.48648648648649 uy 3.51351351351351 ux 6.75675675675676 uy box fill
3.51351351351351 ux 6.48648648648649 uy 3.78378378378378 ux 6.75675675675676 uy box fill
4.05405405405405 ux 6.48648648648649 uy 4.32432432432432 ux 6.75675675675676 uy box fill
4.32432432432432 ux 6.48648648648649 uy 4.59459459459459 ux 6.75675675675676 uy box fill
4.59459459459459 ux 6.48648648648649 uy 4.86486486486486 ux 6.75675675675676 uy box fill
5.13513513513514 ux 6.48648648648649 uy 5.40540540540541 ux 6.75675675675676 uy box fill
5.40540540540541 ux 6.48648648648649 uy 5.67567567567568 ux 6.75675675675676 uy box fill
5.67567567567568 ux 6.48648648648649 uy 5.94594594594595 ux 6.75675675675676 uy box fill
6.21621621621622 ux 6.48648648648649 uy 6.48648648648649 ux 6.75675675675676 uy box fill
6.48648648648649 ux 6.48648648648649 uy 6.75675675675676 ux 6.75675675675676 uy box fill
6.75675675675676 ux 6.48648648648649 uy 7.02702702702703 ux 6.75675675675676 uy box fill
7.2972972972973 ux 6.48648648648649 uy 7.56756756756757 ux 6.75675675675676 uy box fill
7.56756756756757 ux 6.48648648648649 uy 7.83783783783784 ux 6.75675675675676 uy box fill
8.37837837837838 ux 6.48648648648649 uy 8.64864864864865 ux 6.75675675675676 uy box fill
8.64864864864865 ux 6.48648648648649 uy 8.91891891891892 ux 6.75675675675676 uy box fill
9.45945945945946 ux 6.48648648648649 uy 9.72972972972973 ux 6.75675675675676 uy box fill
9.72972972972973 ux 6.48648648648649 uy 10 ux 6.75675675675676 uy box fill
0.27027027027027 ux 6.75675675675676 uy 0.540540540540541 ux 7.02702702702703 uy box fill
0.540540540540541 ux 6.75675675675676 uy 0.810810810810811 ux 7.02702702702703 uy box fill
0.810810810810811 ux 6.75675675675676 uy 1.08108108108108 ux 7.02702702702703 uy box fill
1.08108108108108 ux 6.75675675675676 uy 1.35135135135135 ux 7.02702702702703 uy box fill
1.89189189189189 ux 6.75675675675676 uy 2.16216216216216 ux 7.02702702702703 uy box fill
2.16216216216216 ux 6.75675675675676 uy 2.43243243243243 ux 7.02702702702703 uy box fill
2.43243243243243 ux 6.75675675675676 uy 2.7027027027027 ux 7.02702702702703 uy box fill
3.51351351351351 ux 6.75675675675676 uy 3.78378378378378 ux 7.02702702702703 uy box fill
4.59459459459459 ux 6.75675675675676 uy 4.86486486486486 ux 7.02702702702703 uy box fill
5.67567567567568 ux 6.75675675675676 uy 5.94594594594595 ux 7.02702702702703 uy box fill
6.75675675675676 ux 6.75675675675676 uy 7.02702702702703 ux 7.02702702702703 uy box fill
8.10810810810811 ux 6.75675675675676 uy 8.37837837837838 ux 7.02702702702703 uy box fill
8.91891891891892 ux 6.75675675675676 uy 9.18918918918919 ux 7.02702702702703 uy box fill
0.27027027027027 ux 7.02702702702703 uy 0.540540540540541 ux 7.2972972972973 uy box fill
1.08108108108108 ux 7.02702702702703 uy 1.35135135135135 ux 7.2972972972973 uy box fill
1.35135135135135 ux 7.02702702702703 uy 1.62162162162162 ux 7.2972972972973 uy box fill
1.62162162162162 ux 7.02702702702703 uy 1.89189189189189 ux 7.2972972972973 uy box fill
2.16216216216216 ux 7.02702702702703 uy 2.43243243243243 ux 7.2972972972973 uy box fill
2.7027027027027 ux 7.02702702702703 uy 2.97297297297297 ux 7.2972972972973 uy box fill
2.97297297297297 ux 7.02702702702703 uy 3.24324324324324 ux 7.2972972972973 uy box fill
4.05405405405405 ux 7.02702702702703 uy 4.32432432432432 ux 7.2972972972973 uy box fill
5.13513513513514 ux 7.02702702702703 uy 5.40540540540541 ux 7.2972972972973 uy box fill
6.21621621621622 ux 7.02702702702703 uy 6.48648648648649 ux 7.2972972972973 uy box fill
7.2972972972973 ux 7.02702702702703 uy 7.56756756756757 ux 7.2972972972973 uy box fill
8.64864864864865 ux 7.02702702702703 uy 8.91891891891892 ux 7.2972972972973 uy box fill
9.18918918918919 ux 7.02702702702703 uy 9.45945945945946 ux 7.2972972972973 uy box fill
9.72972972972973 ux 7.02702702702703 uy 10 ux 7.2972972972973 uy box fill
0.27027027027027 ux 7.2972972972973 uy 0.540540540540541 ux 7.56756756756757 uy box fill
1.08108108108108 ux 7.2972972972973 uy 1.35135135135135 ux 7.56756756756757 uy box fill
1.35135135135135 ux 7.2972972972973 uy 1.62162162162162 ux 7.56756756756757 uy box fill
2.7027027027027 ux 7.2972972972973 uy 2.97297297297297 ux 7.56756756756757 uy box fill
3.51351351351351 ux 7.2972972972973 uy 3.78378378378378 ux 7.56756756756757 uy box fill
3.78378378378378 ux 7.2972972972973 uy 4.05405405405405 ux 7.56756756756757 uy box fill
4.59459459459459 ux 7.2972972972973 uy 4.86486486486486 ux 7.56756756756757 uy box fill
4.86486486486486 ux 7.2972972972973 uy 5.13513513513514 ux 7.56756756756757 uy box fill
5.67567567567568 ux 7.2972972972973 uy 5.94594594594595 ux 7.56756756756757 uy box fill
5.94594594594595 ux 7.2972972972973 uy 6.21621621621622 ux 7.56756756756757 uy box fill
6.75675675675676 ux 7.2972972972973 uy 7.02702702702703 ux 7.56756756756757 uy box fill
7.02702702702703 ux 7.2972972972973 uy 7.2972972972973 ux 7.56756756756757 uy box fill
7.83783783783784 ux 7.2972972972973 uy 8.10810810810811 ux 7.56756756756757 uy box fill
9.18918918918919 ux 7.2972972972973 uy 9.45945945945946 ux 7.56756756756757 uy box fill
9.72972972972973 ux 7.2972972972973 uy 10 ux 7.56756756756757 uy box fill
0 ux 7.56756756756757 uy 0.27027027027027 ux 7.83783783783784 uy box fill
0.27027027027027 ux 7.56756756756757 uy 0.540540540540541 ux 7.83783783783784 uy box fill
0.540540540540541 ux 7.56756756756757 uy 0.810810810810811 ux 7.83783783783784 uy box fill
1.35135135135135 ux 7.56756756756757 uy 1.62162162162162 ux 7.83783783783784 uy box fill
1.62162162162162 ux 7.56756756756757 uy 1.89189189189189 ux 7.83783783783784 uy box fill
2.16216216216216 ux 7.56756756756757 uy 2.43243243243243 ux 7.83783783783784 uy box fill
2.43243243243243 ux 7.56756756756757 uy 2.7027027027027 ux 7.83783783783784 uy box fill
2.7027027027027 ux 7.56756756756757 uy 2.97297297297297 ux 7.83783783783784 uy box fill
3.51351351351351 ux 7.56756756756757 uy 3.78378378378378 ux 7.83783783783784 uy box fill
3.78378378378378 ux 7.56756756756757 uy 4.05405405405405 ux 7.83783783783784 uy box fill
4.59459459459459 ux 7.56756756756757 uy 4.86486486486486 ux 7.83783783783784 uy box fill
4.86486486486486 ux 7.56756756756757 uy 5.13513513513514 ux 7.83783783783784 uy box fill
5.67567567567568 ux 7.56756756756757 uy 5.94594594594595 ux 7.83783783783784 uy box fill
5.94594594594595 ux 7.56756756756757 uy 6.21621621621622 ux 7.83783783783784 uy box fill
6.75675675675676 ux 7.56756756756757 uy 7.02702702702703 ux 7.83783783783784 uy box fill
7.02702702702703 ux 7.56756756756757 uy 7.2972972972973 ux 7.83783783783784 uy box fill
7.83783783783784 ux 7.56756756756757 uy 8.10810810810811 ux 7.83783783783784 uy box fill
8.10810810810811 ux 7.56756756756757 uy 8.37837837837838 ux 7.83783783783784 uy box fill
8.37837837837838 ux 7.56756756756757 uy 8.64864864864865 ux 7.83783783783784 uy box fill
8.64864864864865 ux 7.56756756756757 uy 8.91891891891892 ux 7.83783783783784 uy box fill
9.45945945945946 ux 7.56756756756757 uy 9.72972972972973 ux 7.83783783783784 uy box fill
9.72972972972973 ux 7.56756756756757 uy 10 ux 7.83783783783784 uy box fill
2.16216216216216 ux 7.83783783783784 uy 2.43243243243243 ux 8.10810810810811 uy box fill
2.7027027027027 ux 7.83783783783784 uy 2.97297297297297 ux 8.10810810810811 uy box fill
2.97297297297297 ux 7.83783783783784 uy 3.24324324324324 ux 8.10810810810811 uy box fill
3.24324324324324 ux 7.83783783783784 uy 3.51351351351351 ux 8.10810810810811 uy box fill
3.78378378378378 ux 7.83783783783784 uy 4.05405405405405 ux 8.10810810810811 uy box fill
4.05405405405405 ux 7.83783783783784 uy 4.32432432432432 ux 8.10810810810811 uy box fill
4.32432432432432 ux 7.83783783783784 uy 4.59459459459459 ux 8.10810810810811 uy box fill
4.86486486486486 ux 7.83783783783784 uy 5.13513513513514 ux 8.10810810810811 uy box fill
5.13513513513514 ux 7.83783783783784 uy 5.40540540540541 ux 8.10810810810811 uy box fill
5.40540540540541 ux 7.83783783783784 uy 5.67567567567568 ux 8.10810810810811 uy box fill
5.94594594594595 ux 7.83783783783784 uy 6.21621621621622 ux 8.10810810810811 uy box fill
6.21621621621622 ux 7.83783783783784 uy 6.48648648648649 ux 8.10810810810811 uy box fill
6.48648648648649 ux 7.83783783783784 uy 6.75675675675676 ux 8.10810810810811 uy box fill
7.02702702702703 ux 7.83783783783784 uy 7.2972972972973 ux 8.10810810810811 uy box fill
7.2972972972973 ux 7.83783783783784 uy 7.56756756756757 ux 8.10810810810811 uy box fill
7.56756756756757 ux 7.83783783783784 uy 7.83783783783784 ux 8.10810810810811 uy box fill
0 ux 8.10810810810811 uy 0.27027027027027 ux 8.37837837837838 uy box fill
0.27027027027027 ux 8.10810810810811 uy 0.540540540540541 ux 8.37837837837838 uy box fill
0.540540540540541 ux 8.10810810810811 uy 0.810810810810811 ux 8.37837837837838 uy box fill
0.810810810810811 ux 8.10810810810811 uy 1.08108108108108 ux 8.37837837837838 uy box fill
1.08108108108108 ux 8.10810810810811 uy 1.35135135135135 ux 8.37837837837838 uy box fill
1.35135135135135 ux 8.10810810810811 uy 1.62162162162162 ux 8.37837837837838 uy box fill
1.62162162162162 ux 8.10810810810811 uy 1.89189189189189 ux 8.37837837837838 uy box fill
2.16216216216216 ux 8.10810810810811 uy 2.43243243243243 ux 8.37837837837838 uy box fill
2.7027027027027 ux 8.10810810810811 uy 2.97297297297297 ux 8.37837837837838 uy box fill
3.24324324324324 ux 8.10810810810811 uy 3.51351351351351 ux 8.37837837837838 uy box fill
3.78378378378378 ux 8.10810810810811 uy 4.05405405405405 ux 8.37837837837838 uy box fill
4.32432432432432 ux 8.10810810810811 uy 4.59459459459459 ux 8.37837837837838 uy box fill
4.86486486486486 ux 8.10810810810811 uy 5.13513513513514 ux 8.37837837837838 uy box fill
5.40540540540541 ux 8.10810810810811 uy 5.67567567567568 ux 8.37837837837838 uy box fill
5.94594594594595 ux 8.10810810810811 uy 6.21621621621622 ux 8.37837837837838 uy box fill
6.48648648648649 ux 8.10810810810811 uy 6.75675675675676 ux 8.37837837837838 uy box fill
7.02702702702703 ux 8.10810810810811 uy 7.2972972972973 ux 8.37837837837838 uy box fill
7.56756756756757 ux 8.10810810810811 uy 7.83783783783784 ux 8.37837837837838 uy box fill
8.10810810810811 ux 8.10810810810811 uy 8.37837837837838 ux 8.37837837837838 uy box fill
8.37837837837838 ux 8.10810810810811 uy 8.64864864864865 ux 8.37837837837838 uy box fill
8.64864864864865 ux 8.10810810810811 uy 8.91891891891892 ux 8.37837837837838 uy box fill
8.91891891891892 ux 8.10810810810811 uy 9.18918918918919 ux 8.37837837837838 uy box fill
9.18918918918919 ux 8.10810810810811 uy 9.45945945945946 ux 8.37837837837838 uy box fill
9.45945945945946 ux 8.10810810810811 uy 9.72972972972973 ux 8.37837837837838 uy box fill
9.72972972972973 ux 8.10810810810811 uy 10 ux 8.37837837837838 uy box fill
0 ux 8.37837837837838 uy 0.27027027027027 ux 8.64864864864865 uy box fill
1.62162162162162 ux 8.37837837837838 uy 1.89189189189189 ux 8.64864864864865 uy box fill
2.16216216216216 ux 8.37837837837838 uy 2.43243243243243 ux 8.64864864864865 uy box fill
2.97297297297297 ux 8.37837837837838 uy 3.24324324324324 ux 8.64864864864865 uy box fill
4.05405405405405 ux 8.37837837837838 uy 4.32432432432432 ux 8.64864864864865 uy box fill
5.13513513513514 ux 8.37837837837838 uy 5.40540540540541 ux 8.64864864864865 uy box fill
6.21621621621622 ux 8.37837837837838 uy 6.48648648648649 ux 8.64864864864865 uy box fill
7.2972972972973 ux 8.37837837837838 uy 7.56756756756757 ux 8.64864864864865 uy box fill
8.10810810810811 ux 8.37837837837838 uy 8.37837837837838 ux 8.64864864864865 uy box fill
9.72972972972973 ux 8.37837837837838 uy 10 ux 8.64864864864865 uy box fill
0 ux 8.64864864864865 uy 0.27027027027027 ux 8.91891891891892 uy box fill
0.540540540540541 ux 8.64864864864865 uy 0.810810810810811 ux 8.91891891891892 uy box fill
0.810810810810811 ux 8.64864864864865 uy 1.08108108108108 ux 8.91891891891892 uy box fill
1.08108108108108 ux 8.64864864864865 uy 1.35135135135135 ux 8.91891891891892 uy box fill
1.62162162162162 ux 8.64864864864865 uy 1.89189189189189 ux 8.91891891891892 uy box fill
2.16216216216216 ux 8.64864864864865 uy 2.43243243243243 ux 8.91891891891892 uy box fill
2.43243243243243 ux 8.64864864864865 uy 2.7027027027027 ux 8.91891891891892 uy box fill
2.7027027027027 ux 8.64864864864865 uy 2.97297297297297 ux 8.91891891891892 uy box fill
2.97297297297297 ux 8.64864864864865 uy 3.24324324324324 ux 8.91891891891892 uy box fill
3.51351351351351 ux 8.64864864864865 uy 3.78378378378378 ux 8.91891891891892 uy box fill
3.78378378378378 ux 8.64864864864865 uy 4.05405405405405 ux 8.91891891891892 uy box fill
4.05405405405405 ux 8.64864864864865 uy 4.32432432432432 ux 8.91891891891892 uy box fill
4.59459459459459 ux 8.64864864864865 uy 4.86486486486486 ux 8.91891891891892 uy box fill
4.86486486486486 ux 8.64864864864865 uy 5.13513513513514 ux 8.91891891891892 uy box fill
5.13513513513514 ux 8.64864864864865 uy 5.40540540540541 ux 8.91891891891892 uy box fill
5.67567567567568 ux 8.64864864864865 uy 5.94594594594595 ux 8.91891891891892 uy box fill
5.94594594594595 ux 8.64864864864865 uy 6.21621621621622 ux 8.91891891891892 uy box fill
6.21621621621622 ux 8.64864864864865 uy 6.48648648648649 ux 8.91891891891892 uy box fill
6.75675675675676 ux 8.64864864864865 uy 7.02702702702703 ux 8.91891891891892 uy box fill
7.02702702702703 ux 8.64864864864865 uy 7.2972972972973 ux 8.91891891891892 uy box fill
7.2972972972973 ux 8.64864864864865 uy 7.56756756756757 ux 8.91891891891892 uy box fill
8.10810810810811 ux 8.64864864864865 uy 8.37837837837838 ux 8.91891891891892 uy box fill
8.64864864864865 ux 8.64864864864865 uy 8.91891891891892 ux 8.91891891891892 uy box fill
8.91891891891892 ux 8.64864864864865 uy 9.18918918918919 ux 8.91891891891892 uy box fill
9.18918918918919 ux 8.64864864864865 uy 9.45945945945946 ux 8.91891891891892 uy box fill
9.72972972972973 ux 8.64864864864865 uy 10 ux 8.91891891891892 uy box fill
0 ux 8.91891891891892 uy 0.27027027027027 ux 9.18918918918919 uy box fill
0.540540540540541 ux 8.91891891891892 uy 0.810810810810811 ux 9.18918918918919 uy box fill
0.810810810810811 ux 8.91891891891892 uy 1.08108108108108 ux 9.18918918918919 uy box fill
1.08108108108108 ux 8.91891891891892 uy 1.35135135135135 ux 9.18918918918919 uy box fill
1.62162162162162 ux 8.91891891891892 uy 1.89189189189189 ux 9.18918918918919 uy box fill
2.7027027027027 ux 8.91891891891892 uy 2.97297297297297 ux 9.18918918918919 uy box fill
3.78378378378378 ux 8.91891891891892 uy 4.05405405405405 ux 9.18918918918919 uy box fill
4.86486486486486 ux 8.91891891891892 uy 5.13513513513514 ux 9.18918918918919 uy box fill
5.94594594594595 ux 8.91891891891892 uy 6.21621621621622 ux 9.18918918918919 uy box fill
7.02702702702703 ux 8.91891891891892 uy 7.2972972972973 ux 9.18918918918919 uy box fill
8.10810810810811 ux 8.91891891891892 uy 8.37837837837838 ux 9.18918918918919 uy box fill
8.64864864864865 ux 8.91891891891892 uy 8.91891891891892 ux 9.18918918918919 uy box fill
8.91891891891892 ux 8.91891891891892 uy 9.18918918918919 ux 9.18918918918919 uy box fill
9.18918918918919 ux 8.91891891891892 uy 9.45945945945946 ux 9.18918918918919 uy box fill
9.72972972972973 ux 8.91891891891892 uy 10 ux 9.18918918918919 uy box fill
0 ux 9.18918918918919 uy 0.27027027027027 ux 9.45945945945946 uy box fill
0.540540540540541 ux 9.18918918918919 uy 0.810810810810811 ux 9.45945945945946 uy box fill
0.810810810810811 ux 9.18918918918919 uy 1.08108108108108 ux 9.45945945945946 uy box fill
1.08108108108108 ux 9.18918918918919 uy 1.35135135135135 ux 9.45945945945946 uy box fill
1.62162162162162 ux 9.18918918918919 uy 1.89189189189189 ux 9.45945945945946 uy box fill
2.7027027027027 ux 9.18918918918919 uy 2.97297297297297 ux 9.45945945945946 uy box fill
2.97297297297297 ux 9.18918918918919 uy 3.24324324324324 ux 9.45945945945946 uy box fill
3.24324324324324 ux 9.18918918918919 uy 3.51351351351351 ux 9.45945945945946 uy box fill
3.78378378378378 ux 9.18918918918919 uy 4.05405405405405 ux 9.45945945945946 uy box fill
4.05405405405405 ux 9.18918918918919 uy 4.32432432432432 ux 9.45945945945946 uy box fill
4.32432432432432 ux 9.18918918918919 uy 4.59459459459459 ux 9.45945945945946 uy box fill
4.86486486486486 ux 9.18918918918919 uy 5.13513513513514 ux 9.45945945945946 uy box fill
5.13513513513514 ux 9.18918918918919 uy 5.40540540540541 ux 9.45945945945946 uy box fill
5.40540540540541 ux 9.18918918918919 uy 5.67567567567568 ux 9.45945945945946 uy box fill
5.94594594594595 ux 9.18918918918919 uy 6.21621621621622 ux 9.45945945945946 uy box fill
6.21621621621622 ux 9.18918918918919 uy 6.48648648648649 ux 9.45945945945946 uy box fill
6.48648648648649 ux 9.18918918918919 uy 6.75675675675676 ux 9.45945945945946 uy box fill
7.02702702702703 ux 9.18918918918919 uy 7.2972972972973 ux 9.45945945945946 uy box fill
7.2972972972973 ux 9.18918918918919 uy 7.56756756756757 ux 9.45945945945946 uy box fill
7.56756756756757 ux 9.18918918918919 uy 7.83783783783784 ux 9.45945945945946 uy box fill
8.10810810810811 ux 9.18918918918919 uy 8.37837837837838 ux 9.45945945945946 uy box fill
8.64864864864865 ux 9.18918918918919 uy 8.91891891891892 ux 9.45945945945946 uy box fill
8.91891891891892 ux 9.18918918918919 uy 9.18918918918919 ux 9.45945945945946 uy box fill
9.18918918918919 ux 9.18918918918919 uy 9.45945945945946 ux 9.45945945945946 uy box fill
9.72972972972973 ux 9.18918918918919 uy 10 ux 9.45945945945946 uy box fill
0 ux 9.45945945945946 uy 0.27027027027027 ux 9.72972972972973 uy box fill
1.62162162162162 ux 9.45945945945946 uy 1.89189189189189 ux 9.72972972972973 uy box fill
2.16216216216216 ux 9.45945945945946 uy 2.43243243243243 ux 9.72972972972973 uy box fill
2.43243243243243 ux 9.45945945945946 uy 2.7027027027027 ux 9.72972972972973 uy box fill
2.7027027027027 ux 9.45945945945946 uy 2.97297297297297 ux 9.72972972972973 uy box fill
3.24324324324324 ux 9.45945945945946 uy 3.51351351351351 ux 9.72972972972973 uy box fill
3.51351351351351 ux 9.45945945945946 uy 3.78378378378378 ux 9.72972972972973 uy box fill
3.78378378378378 ux 9.45945945945946 uy 4.05405405405405 ux 9.72972972972973 uy box fill
4.32432432432432 ux 9.45945945945946 uy 4.59459459459459 ux 9.72972972972973 uy box fill
4.59459459459459 ux 9.45945945945946 uy 4.86486486486486 ux 9.72972972972973 uy box fill
4.86486486486486 ux 9.45945945945946 uy 5.13513513513514 ux 9.72972972972973 uy box fill
5.40540540540541 ux 9.45945945945946 uy 5.67567567567568 ux 9.72972972972973 uy box fill
5.67567567567568 ux 9.45945945945946 uy 5.94594594594595 ux 9.72972972972973 uy box fill
5.94594594594595 ux 9.45945945945946 uy 6.21621621621622 ux 9.72972972972973 uy box fill
6.48648648648649 ux 9.45945945945946 uy 6.75675675675676 ux 9.72972972972973 uy box fill
6.75675675675676 ux 9.45945945945946 uy 7.02702702702703 ux 9.72972972972973 uy box fill
7.02702702702703 ux 9.45945945945946 uy 7.2972972972973 ux 9.72972972972973 uy box fill
7.56756756756757 ux 9.45945945945946 uy 7.83783783783784 ux 9.72972972972973 uy box fill
8.10810810810811 ux 9.45945945945946 uy 8.37837837837838 ux 9.72972972972973 uy box fill
9.72972972972973 ux 9.45945945945946 uy 10 ux 9.72972972972973 uy box fill
0 ux 9.72972972972973 uy 0.27027027027027 ux 10 uy box fill
0.27027027027027 ux 9.72972972972973 uy 0.540540540540541 ux 10 uy box fill
0.540540540540541 ux 9.72972972972973 uy 0.810810810810811 ux 10 uy box fill
0.810810810810811 ux 9.72972972972973 uy 1.08108108108108 ux 10 uy box fill
1.08108108108108 ux 9.72972972972973 uy 1.35135135135135 ux 10 uy box fill
1.35135135135135 ux 9.72972972972973 uy 1.62162162162162 ux 10 uy box fill
1.62162162162162 ux 9.72972972972973 uy 1.89189189189189 ux 10 uy box fill
2.16216216216216 ux 9.72972972972973 uy 2.43243243243243 ux 10 uy box fill
2.97297297297297 ux 9.72972972972973 uy 3.24324324324324 ux 10 uy box fill
3.24324324324324 ux 9.72972972972973 uy 3.51351351351351 ux 10 uy box fill
4.05405405405405 ux 9.72972972972973 uy 4.32432432432432 ux 10 uy box fill
4.32432432432432 ux 9.72972972972973 uy 4.59459459459459 ux 10 uy box fill
5.13513513513514 ux 9.72972972972973 uy 5.40540540540541 ux 10 uy box fill
5.40540540540541 ux 9.72972972972973 uy 5.67567567567568 ux 10 uy box fill
6.21621621621622 ux 9.72972972972973 uy 6.48648648648649 ux 10 uy box fill
6.48648648648649 ux 9.72972972972973 uy 6.75675675675676 ux 10 uy box fill
7.2972972972973 ux 9.72972972972973 uy 7.56756756756757 ux 10 uy box fill
7.56756756756757 ux 9.72972972972973 uy 7.83783783783784 ux 10 uy box fill
8.10810810810811 ux 9.72972972972973 uy 8.37837837837838 ux 10 uy box fill
8.37837837837838 ux 9.72972972972973 uy 8.64864864864865 ux 10 uy box fill
8.64864864864865 ux 9.72972972972973 uy 8.91891891891892 ux 10 uy box fill
8.91891891891892 ux 9.72972972972973 uy 9.18918918918919 ux 10 uy box fill
9.18918918918919 ux 9.72972972972973 uy 9.45945945945946 ux 10 uy box fill
9.45945945945946 ux 9.72972972972973 uy 9.72972972972973 ux 10 uy box fill
9.72972972972973 ux 9.72972972972973 uy 10 ux 10 uy box fill
%%EOF
