#!/bin/bash

# Try various corruptions on libsafezone-sw-fips.so.
# Intented to be mainly used with CL built with CFLAGS_CLC=-DCLC_VERIFY.

if [ "X$1" = "X--all" ];then
try_cryptoOpen()
{   
    echo -n Default:" "
    ./cryptoOpen
    ret=$?
    if [ X$ret != X0 ];
    then
        echo "[Return value: $ret]"
    fi
    echo -n FL:" "
    ./cryptoOpen fl
    ret=$?
    if [ X$ret != X0 ];
    then
        echo "[Return value: $ret]"
    fi
    echo -n SL:" "
    ./cryptoOpen sl
    ret=$?
    if [ X$ret != X0 ];
    then
        echo "[Return value: $ret]"
    fi
}
elif [ "X$1" = "X" ];then
    try_cryptoOpen()
    {   
        ./cryptoOpen
        ret=$?
        if [ X$ret != X0 ];
        then
            echo "[Return value: $ret]"
        fi
    }
else
    echo "Usage: $0 [--all]" >&2
    exit 1
fi

unset NO_SAFEZONE_FIPS

echo "*** TEST CASE #1: FL File does not exist"
unset LD_LIBRARY_PATH
try_cryptoOpen

echo "*** TEST CASE #2: Empty LD_LIBRARY_PATH"
export LD_LIBRARY_PATH=
try_cryptoOpen

rm -rf /tmp/x86-64-libs
mkdir  /tmp/x86-64-libs \
       /tmp/x86-64-libs/{nocheck,pad,corrupt1,corrupt2,corrupt_chk,wrong_chk,check}

echo "*** TEST CASE #3: No checksum"
LIBDIR=/tmp/x86-64-libs/nocheck
LIBFILE=$LIBDIR/libsafezone-sw-fips.so
export LD_LIBRARY_PATH=$LIBDIR
cp -r ../../../FIPSLib11/lib/x86_64-linux-gnu/libsafezone-sw-fips.so $LIBFILE
try_cryptoOpen

echo "*** TEST CASE #4: Extraneous data in library file."
LIBDIR=/tmp/x86-64-libs/pad
LIBFILE=$LIBDIR/libsafezone-sw-fips.so
export LD_LIBRARY_PATH=$LIBDIR
cp -r ../../../FIPSLib11/lib/x86_64-linux-gnu/libsafezone-sw-fips.so $LIBFILE
../check-lib/create-check-lib.sh $LIBFILE >/dev/null 2>/dev/null
head -c 1024 /dev/zero >>$LIBFILE # Append block of zero bytes
try_cryptoOpen

echo "*** TEST CASE #5: Corrupt FIPS Library .so file"
LIBDIR=/tmp/x86-64-libs/corrupt1
LIBFILE=$LIBDIR/libsafezone-sw-fips.so
export LD_LIBRARY_PATH=$LIBDIR
cp -r ../../../FIPSLib11/lib/x86_64-linux-gnu/libsafezone-sw-fips.so $LIBFILE
../check-lib/create-check-lib.sh $LIBFILE >/dev/null 2>/dev/null
dd if=/dev/zero of=$LIBFILE oflag=seek_bytes seek=4096 bs=1M count=1 # Alter large block of file.
try_cryptoOpen

echo "*** TEST CASE #6: Corrupt [bus error] FIPS Library .so file"
LIBDIR=/tmp/x86-64-libs/corrupt2
LIBFILE=$LIBDIR/libsafezone-sw-fips.so
export LD_LIBRARY_PATH=$LIBDIR
cp -r ../../../FIPSLib11/lib/x86_64-linux-gnu/libsafezone-sw-fips.so $LIBFILE
../check-lib/create-check-lib.sh $LIBFILE >/dev/null 2>/dev/null
dd if=/dev/zero of=$LIBFILE oflag=seek_bytes seek=2251216 bs=2048 count=1 # Alter a block at critical part of file.
try_cryptoOpen

echo "*** TEST CASE #7: Corrupt checksum file"
LIBDIR=/tmp/x86-64-libs/corrupt_chk
LIBFILE=$LIBDIR/libsafezone-sw-fips.so
export LD_LIBRARY_PATH=$LIBDIR
cp -r ../../../FIPSLib11/lib/x86_64-linux-gnu/libsafezone-sw-fips.so $LIBFILE
../check-lib/create-check-lib.sh $LIBFILE >/dev/null 2>/dev/null
dd if=/dev/zero of="$LIBFILE".check bs=16 count=1
try_cryptoOpen

echo "*** TEST CASE #8: Wrong checksum file"
LIBDIR=/tmp/x86-64-libs/wrong_chk
LIBFILE=$LIBDIR/libsafezone-sw-fips.so
export LD_LIBRARY_PATH=$LIBDIR
cp -r ../../../FIPSLib11/lib/i686-linux-gnu/libsafezone-sw-fips.so $LIBFILE
../check-lib/create-check-lib.sh $LIBFILE >/dev/null 2>/dev/null
cp -r ../../../FIPSLib11/lib/x86_64-linux-gnu/libsafezone-sw-fips.so $LIBFILE
dd if=/dev/zero of="$LIBFILE".check bs=16 count=1
try_cryptoOpen

echo "*** TEST CASE #9: All ok test case."
LIBDIR=/tmp/x86-64-libs/check
LIBFILE=$LIBDIR/libsafezone-sw-fips.so
export LD_LIBRARY_PATH=$LIBDIR
cp -r ../../../FIPSLib11/lib/x86_64-linux-gnu/libsafezone-sw-fips.so $LIBFILE
../check-lib/create-check-lib.sh $LIBFILE >/dev/null 2>/dev/null
try_cryptoOpen
